/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.menu.controller;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.resource.ResourceVO;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.cache.DesignTimeSerializableCache;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.permission.PermissionUtil;
import cn.myapps.designtime.resource.service.ResourceDesignTimeService;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.menu.controller.ResourceUtil;
import cn.myapps.util.json.JsonTmpUtil;
import com.bcxin.components.TenantContext;
import com.bcxin.saas.core.Constants;
import com.bcxin.saas.core.enums.OrganizationLevel;
import com.bcxin.saas.core.exceptions.SaasRetryableException;
import com.bcxin.saas.core.exceptions.SaasUnAuthorizeException;
import com.bcxin.saas.core.utils.RetryUtil;
import com.bcxin.saas.domains.dtos.RbacQueryDTO;
import com.bcxin.saas.domains.readers.RbacDbReader;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u83dc\u5355\u6267\u884c\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/runtime/{applicationId}"}, produces={"application/json;charset=UTF-8"})
public class MenuController
extends AbstractRuntimeController {
    private static final Logger LOG = LoggerFactory.getLogger(MenuController.class);
    private ResourceDesignTimeService process;
    private RbacDbReader rbacDbReader;

    public MenuController() {
        try {
            this.process = DesignTimeServiceManager.resourceDesignTimeService();
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
    }

    @Autowired
    public void setRbacDbReader(RbacDbReader rbacDbReader) {
        this.rbacDbReader = rbacDbReader;
    }

    @GetMapping(path={"/menus"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u83dc\u5355", notes="\u83b7\u53d6\u83dc\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="isMobile", value="\u662f\u5426\u79fb\u52a8\u7aef", required=false, paramType="query", dataType="string")})
    public Resource menuOfApplication(@PathVariable String applicationId, @RequestParam(required=false) boolean isMobile, HttpServletResponse res) throws Exception {
        StringBuilder sb = new StringBuilder(String.format("\u4e8c\u7ea7\u7f13\u5b58\u60c5\u51b5:%s", DesignTimeSerializableCache.getIsEnabledRefreshCached()));
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("\u5f00\u59cb\u8ddf\u8e2a;\u83b7\u53d6\u7528\u6237\u4fe1\u606f");
        res.setCharacterEncoding("UTF-8");
        WebUser user = this.getUser();
        stopWatch.stop();
        sb.append(String.format("\u5f00\u59cb-\u7528\u6237:" + stopWatch.getTotalTimeMillis(), new Object[0]));
        boolean advancedLevel = false;
        TenantContext.EmployeeOrgBasicInfo userInfo = TenantContext.getInstance().getCurrentEmployee();
        if (userInfo == null) {
            throw new SaasUnAuthorizeException("\u7cfb\u7edf\u5f02\u5e38\uff0c\u5f53\u524d\u7528\u6237\u65e0\u6548");
        }
        advancedLevel = userInfo.getOrganizationLevels().contains(OrganizationLevel.Premium);
        stopWatch.start("\u5f00\u59cb\u83b7\u53d6\u83dc\u5355");
        List tempmenus = new ArrayList();
        tempmenus = isMobile ? this.process.list(applicationId, "mobilemenu", "mobilemenu", null) : this.process.menulist(applicationId);
        stopWatch.stop();
        sb.append(String.format("\u5b8c\u6210\u83dc\u5355\u83b7\u53d6: %s;advancedLevel=%s;applicationId=%s;isMobile=%s;menus=%s;", stopWatch.getTotalTimeMillis(), advancedLevel, applicationId, isMobile, CollectionUtils.isEmpty(tempmenus) ? "EMPTY" : tempmenus.stream().map(ii -> ii.getId()).collect(Collectors.joining(","))));
        ArrayList<ResourceVO> menus = new ArrayList<ResourceVO>();
        ViewDesignTimeService vProcess = DesignTimeServiceManager.viewDesignTimeService();
        stopWatch.start("\u5f00\u59cb\u8f6e\u8be2\u83dc\u5355");
        String[] userRoleIds = null;
        for (ResourceVO resourceVO : tempmenus) {
            AbstractView view;
            ResourceVO menu = ResourceVO.clone((ResourceVO)resourceVO);
            if (!menu.getIsMobile().equals(String.valueOf(isMobile)) || isMobile && "01".equals(menu.getLinkType()) && (view = vProcess.doView(menu.getActionContent())) != null && (view.getIntValue() == 20 || view.getIntValue() == 19) || 2 == menu.getShowType() || 0 == menu.getStatus()) continue;
            if (!(advancedLevel || user.isDomainAdmin() || "public".equals(menu.getPermissionType()))) {
                boolean permission;
                String id = menu.getId();
                if (userRoleIds == null) {
                    String userRole = user.getRolelist(applicationId);
                    String[] stringArray = userRoleIds = userRole == null ? null : userRole.split(",");
                }
                if (!(permission = PermissionUtil.check(userRoleIds, (String)id, (String)id, (int)1002))) continue;
            }
            if (!StringUtil.isBlank((String)menu.getLinkType()) && menu.getLinkType().equals("07")) {
                RetryUtil.execute(() -> this.lambda$menuOfApplication$1(applicationId, menu, (IUser)user), (int)10);
            }
            String multiLangTag = menu.getName();
            String multiLanguageLabel = menu.getMultiLanguageLabel();
            if (!StringUtil.isBlank((String)multiLanguageLabel)) {
                String labelHex = URLEncoder.encode(multiLanguageLabel);
                String nameHex = URLEncoder.encode(multiLangTag);
                multiLangTag = "{*[" + labelHex + "^" + nameHex + "^true]*}";
            }
            menu.setDescription(multiLangTag);
            menu.setNewIco(menu.getIco());
            if (!StringUtil.isBlank((String)menu.getShowtotalrow()) && Boolean.valueOf(menu.getShowtotalrow()).booleanValue()) {
                menu.setTotalRow(this.getTotalRowByResource(menu));
            }
            menus.add(menu);
        }
        stopWatch.stop();
        sb.append(String.format("\u5b8c\u6210\u83dc\u5355\u4fe1\u606f:" + stopWatch.getTotalTimeMillis(), new Object[0]));
        stopWatch.start("\u5f00\u59cb\u8f6e\u8be2\u83dc\u53552:");
        String totalRow = "";
        ResourceUtil resourceUtil = new ResourceUtil();
        ArrayList<ResourceVO> parentMenu = new ArrayList<ResourceVO>();
        for (ResourceVO menu : menus) {
            if (!StringUtil.isBlank((String)menu.getShowtotalrow()) && menu.getShowtotalrow().equals("true")) {
                int count = Integer.valueOf(resourceUtil.getTotalRowByResourceid(menu.getId(), this.request));
                totalRow = count > 99 ? "99+" : String.valueOf(count);
                menu.setTotalRow(totalRow);
            }
            if (!StringUtil.isBlank((String)menu.getSuperior())) continue;
            parentMenu.add(menu);
        }
        List<Object> treeMenus = this.getTreeMenus(parentMenu, menus, parentMenu);
        stopWatch.stop();
        sb.append(String.format("\u5b8c\u6210\u83dc\u5355\u4fe1\u606f2:%s;menus=%s;", stopWatch.getTotalTimeMillis(), CollectionUtils.isEmpty(menus) ? "EMPTY" : menus.stream().map(ix -> ix.getId()).collect(Collectors.joining(","))));
        if (Constants.getOaApplicationId().equals(applicationId) || Constants.getUserManagementApplicationId().equals(applicationId)) {
            treeMenus = advancedLevel ? treeMenus.stream().filter(ix -> !Arrays.asList(Constants.getPremiumOaAppMenusExclude()).contains(ix.getId())).collect(Collectors.toList()) : treeMenus.stream().filter(ix -> !Arrays.asList(Constants.getBasicOaAppMenusExclude()).contains(ix.getId())).collect(Collectors.toList());
        }
        if (advancedLevel) {
            RbacQueryDTO rbacQueryDTO = RbacQueryDTO.create((String)user.getId(), (String)user.getDomainid(), (boolean)user.isDomainAdmin(), (boolean)isMobile, (String)applicationId);
            Set permitOptions = this.rbacDbReader.getPermitOptions(rbacQueryDTO).getOptions();
            if (CollectionUtils.isEmpty((Collection)permitOptions)) {
                treeMenus.clear();
            } else {
                treeMenus = treeMenus.stream().filter(ix -> permitOptions.contains(ix.getId())).collect(Collectors.toList());
            }
        }
        Resource r = this.success("ok", treeMenus);
        r.setErrmsg(String.format("d:[%s]:%s", DesignTimeSerializableCache.getNodeLabel(), sb));
        return r;
    }

    private List<ResourceVO> getTreeMenus(List<ResourceVO> result, List<ResourceVO> menus, List<ResourceVO> parentMenus) {
        Iterator<ResourceVO> iterator = parentMenus.iterator();
        while (iterator.hasNext()) {
            ArrayList<ResourceVO> parentList = new ArrayList<ResourceVO>();
            ResourceVO parentMenu = iterator.next();
            for (ResourceVO childMenu : menus) {
                if (!parentMenu.getId().equals(childMenu.getSuperior())) continue;
                parentList.add(childMenu);
            }
            parentMenu.setChildren(parentList);
            if (parentList.isEmpty()) continue;
            this.getTreeMenus(result, menus, parentList);
        }
        return result;
    }

    private String getTotalRowByResource(ResourceVO resource) {
        try {
            if (resource.getLinkType().equals(ResourceVO.LinkType.VIEW.getCode())) {
                if (resource.getActionContent() == null || resource.getActionContent().equals("")) {
                    return "0";
                }
                ViewDesignTimeService viewProcess = DesignTimeServiceManager.viewDesignTimeService();
                AbstractView view = viewProcess.doView(resource.getActionContent());
                if (view != null) {
                    ParamsTable params = this.getParams();
                    String queryString = resource.getQueryString();
                    if (!StringUtil.isBlank((String)queryString)) {
                        JSONArray jsonArray = JsonTmpUtil.fromObject((Object)queryString);
                        for (Object obj : jsonArray) {
                            JSONObject jsonObject = (JSONObject)obj;
                            String paramKey = jsonObject.getString("paramKey");
                            String paramValue = jsonObject.getString("paramValue");
                            params.setParameter(paramKey, (Object)paramValue);
                        }
                    }
                    long count = view.getViewTypeImpl().countViewDatas(params, (IUser)this.getUser(), new Document());
                    return String.valueOf(count);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "0";
    }

    private /* synthetic */ Boolean lambda$menuOfApplication$1(String applicationId, ResourceVO menu, IUser user) throws Exception {
        ParamsTable paramsTable = this.getParams();
        paramsTable.setParameter("application", (Object)applicationId);
        String url = menu.toScriptUrl(new Document(), paramsTable, user);
        if (StringUtil.isBlank((String)url)) {
            LOG.error("\u5e94\u7528({})\u7684\u7ec4\u4ef6{}\u7684\u83dc\u5355\u5730\u5740\u6267\u884c\u5931\u8d25(result={})", new Object[]{applicationId, menu.getId(), url});
            throw new SaasRetryableException(String.format("\u5e94\u7528(%s)\u7684\u83dc\u5355(%s)\u4e0d\u5e94\u8be5\u4e3a\u7a7a", applicationId, menu.getId()));
        }
        menu.setActionContent(url);
        return true;
    }
}

