/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.macro.controller;

import cn.myapps.common.controller.Resource;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.runtime.macro.runner.DebugFrameInfo;
import cn.myapps.runtime.macro.runner.DebugGui;
import cn.myapps.util.http.CookieUtil;
import com.bcxin.saas.core.InjectResolverFactory;
import com.bcxin.saas.core.components.FeatureOptionChecker;
import com.bcxin.saas.core.components.SessionProvider;
import com.bcxin.saas.core.logs.SysLogProvider;
import com.bcxin.saas.core.utils.ExceptionUtils;
import com.bcxin.saas.logging.LoggerProviderImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"debug\u8c03\u8bd5\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/runtime"}, produces={"application/json;charset=UTF-8"})
public class MacroController
extends AbstractRuntimeController {
    @GetMapping(value={"/macro/log"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5b8f\u811a\u672c\u8f93\u51fa\u65e5\u5fd7\u6587\u4ef6", notes="\u5b8f\u811a\u672c\u8f93\u51fa\u65e5\u5fd7\u6587\u4ef6")
    public Resource doRunScript() {
        String sessionId = null;
        try {
            sessionId = this.getUser().getSessionid();
            String clear = this.request.getParameter("clear");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("status", "ok");
            StringBuilder sb = new StringBuilder();
            SessionProvider sessionProvider = (SessionProvider)InjectResolverFactory.resolve(SessionProvider.class);
            if ("true".equals(clear)) {
                sessionProvider.setAttribute("DEBUG_SESSION", new ArrayList());
                SysLogProvider.deleteMessages((String)sessionId);
            } else {
                Collection logMessages = (Collection)sessionProvider.getAttribute("DEBUG_SESSION");
                if (!CollectionUtils.isEmpty((Collection)logMessages)) {
                    logMessages.forEach(lm -> sb.append(String.format("%s</br>", lm.getMessage())));
                } else {
                    sb.append("\u6682\u65e0\u65e5\u5fd7\u4fe1\u606f...");
                }
            }
            map.put("data", sb.toString());
            map.put("session", sessionId);
            map.put("enableLogging", String.valueOf(FeatureOptionChecker.isEnable((String)LoggerProviderImpl.JDBC_APPENDER_ENABLED_PRINT_FLAG)));
            Cookie cookie = CookieUtil.getCookie((String)LoggerProviderImpl.JDBC_APPENDER_ENABLED_PRINT_FLAG, (HttpServletRequest)this.request);
            if (cookie != null) {
                map.put("cookie", cookie.getValue());
            } else {
                map.put("cookie", "NULL");
            }
            return this.success("ok", map);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, String.format("Session=%s;enableLogging=%s;detail=%s", sessionId, FeatureOptionChecker.isEnable((String)LoggerProviderImpl.JDBC_APPENDER_ENABLED_PRINT_FLAG), ExceptionUtils.getStackMessage((Throwable)e)), null);
        }
    }

    @GetMapping(value={"/macro/isdebug"})
    @ApiOperation(value="\u662f\u5426\u5f00\u542f\u8c03\u5f0f\u6a21\u5f0f", notes="\u662f\u5426\u5f00\u542f\u8c03\u5f0f\u6a21\u5f0f")
    public Resource isDebugModule() {
        try {
            boolean result = DebugGui.isDebugModule((String)this.getUser().getSessionid());
            return this.success("ok", result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(value={"/macro/debug"})
    @ApiOperation(value="\u8bbe\u7f6e\u662f\u5426\u5f00\u542f\u8c03\u5f0f\u6a21\u5f0f", notes="\u8bbe\u7f6e\u662f\u5426\u5f00\u542f\u8c03\u5f0f\u6a21\u5f0f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="isDebug", value="\u662f\u5426\u5f00\u542f", required=true, paramType="query", dataType="boolean")})
    public Resource setDebugModule(boolean isDebug) {
        try {
            DebugFrameInfo result = DebugGui.setDebugModule((boolean)isDebug, (String)this.getUser().getSessionid());
            return this.success("ok", result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(value={"/macro/refresh"})
    @ApiOperation(value="debug\u8c03\u5f0f\u6a21\u5f0f(\u5237\u65b0\u64cd\u4f5c)", notes="debug\u8c03\u5f0f\u6a21\u5f0f(\u5237\u65b0\u64cd\u4f5c)")
    public Resource viewDebugFrameInfo() {
        try {
            DebugFrameInfo result = DebugGui.viewDebugFrameInfo((String)"", (String)this.getUser().getSessionid());
            return this.success("ok", result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(value={"/macro/conduct"})
    @ApiOperation(value="debug\u8c03\u5f0f\u6a21\u5f0f(\u64cd\u4f5c)", notes="debug\u8c03\u5f0f\u6a21\u5f0f(\u64cd\u4f5c)")
    public Resource actionPerformed(String action) {
        try {
            DebugFrameInfo result = DebugGui.actionPerformed((String)action, (String)this.getUser().getSessionid());
            return this.success("ok", result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(value={"/macro/evalexpr"})
    @ApiOperation(value="debug\u8c03\u5f0f\u6a21\u5f0f(\u8fd0\u884c\u811a\u672c)", notes="debug\u8c03\u5f0f\u6a21\u5f0f(\u5237\u65b0\u64cd\u4f5c)")
    public Resource evalExpr(@RequestBody String script) {
        try {
            String result = DebugGui.evalExpr((String)script, (String)this.getUser().getId());
            return this.success("ok", result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }
}

