/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.login.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.support.sms.SMSMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginHelper {
    private static final Logger log = LoggerFactory.getLogger(LoginHelper.class);

    public Collection<String> getDomainNameList() {
        ArrayList<String> map = new ArrayList<String>();
        try {
            DomainProcess process = AuthTimeServiceManager.domainRuntimeService();
            Collection col = process.getDomainByStatus(1);
            for (DomainVO vo : col) {
                map.add(vo.getName());
            }
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return map;
        }
    }

    public static String getRequestIp(HttpServletRequest request) {
        String ip = null;
        ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static int sendSMSCheckCode(UserVO user, HttpServletRequest request) throws Exception {
        int timeout = 0;
        try {
            PropertyUtil.reload((String)"sso");
            timeout = Integer.parseInt(PropertyUtil.get((String)"sms.timeout"));
            String checkCode = LoginHelper.getRandomCode(5);
            String content = checkCode + "{\u9a8c\u8bc1\u7801}";
            request.getSession().setAttribute("smsCheckCode", (Object)checkCode);
            SMSMode sender = new SMSMode();
            sender.send("", 0, content, (IUser)user, null, (IUser)user);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return timeout;
    }

    public static String getRandomCode(int length) {
        StringBuffer code = new StringBuffer();
        String[] cos = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
        for (int i = 0; i < length; ++i) {
            code.append(cos[new Random().nextInt(9)]);
        }
        return code.toString();
    }
}

