/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.login.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.dao.DomainDAO;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.authtime.user.model.BaseUser;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.Environment;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.permission.Permission;
import cn.myapps.common.model.resource.ResourceVO;
import cn.myapps.common.model.role.Role;
import cn.myapps.common.util.Base64Util;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.Security;
import cn.myapps.common.util.StringUtil;
import cn.myapps.conf.LoginConfig;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.permission.PermissionUtil;
import cn.myapps.designtime.resource.service.ResourceDesignTimeService;
import cn.myapps.designtime.role.service.RoleDesignTimeService;
import cn.myapps.runtime.common.dao.DAOFactory;
import cn.myapps.runtime.logger.service.LogHelper;
import cn.myapps.support.dingding.service.DdApiService;
import cn.myapps.util.http.CookieUtil;
import cn.myapps.util.property.MultiLanguageProperty;
import cn.myapps.util.sequence.Sequence;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.runtime.apis.controllers.ControllerAbstract;
import com.bcxin.saas.core.utils.encrypt.PasswordUtils;
import com.bcxin.saas.domains.dtos.AjaxResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u767b\u5f55\u6a21\u5757"})
public class LoginController
extends ControllerAbstract {
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private HttpServletResponse response;
    private static int WIDTH = 60;
    private static int HEIGHT = 20;
    private String CheckCode_Session = "CheckCode";

    @GetMapping(value={"/"})
    @ApiOperation(value="\u8bbf\u95ee\u4e3b\u9875\u9762", notes="\u8bbf\u95ee\u4e3b\u9875\u9762")
    public void doIndexPage() throws Exception {
        String skin = PropertyUtil.get((String)"useSkin");
        String url = "signon/dispatcher.html?skin=" + skin;
        this.response.sendRedirect(url);
    }

    @GetMapping(value={"/api/login"})
    @ApiOperation(value="\u8bbf\u95ee\u767b\u5f55\u9875\u9762", notes="\u8bbf\u95ee\u767b\u5f55\u9875\u9762")
    public void doLoginPage() throws Exception {
        String url = "signon/login.html";
        this.response.sendRedirect(url);
    }

    @ResponseBody
    @PostMapping(path={"/api/runtime/login/getMultiLangWordList"})
    @ApiOperation(value="\u83b7\u53d6\u767b\u9646\u9875\u9762\u6240\u9700\u7684\u591a\u8bed\u8a00\u5b57\u6bb5", notes="\u83b7\u53d6\u767b\u9646\u9875\u9762\u6240\u9700\u7684\u591a\u8bed\u8a00\u5b57\u6bb5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="jsonObj", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public JSON getMultiLangWordList(@RequestBody JSONObject jsonObj, HttpServletRequest request) {
        String language = jsonObj.getString("language");
        try {
            Map MultiLangWordMap = this.getLoginMultiLangWordList(language);
            Cookie cookie = new Cookie("USERLANGUAGE", language);
            cookie.setPath("/");
            cookie.setMaxAge(7200);
            this.response.addCookie(cookie);
            return this.result("1", "\u6210\u529f", "multiLangWordList", MultiLangWordMap, null, null);
        }
        catch (Exception e) {
            return this.result("0", "\u5931\u8d25", "multiLangWordList", null, null, null);
        }
    }

    private Map getLoginMultiLangWordList(String language) throws Exception {
        HashMap<String, String> MultiLangWordMap = new HashMap<String, String>();
        String domains = MultiLanguageProperty.getProperty((String)language, (String)"Domains", (String)"");
        String pageLoginAccount = MultiLanguageProperty.getProperty((String)language, (String)"page.login.account", (String)"");
        String pageLoginPassword = MultiLanguageProperty.getProperty((String)language, (String)"page.login.password", (String)"");
        String pageLoginRememberLabel = MultiLanguageProperty.getProperty((String)language, (String)"page.login.remember.label", (String)"");
        String debug = MultiLanguageProperty.getProperty((String)language, (String)"Debug", (String)"");
        String login = MultiLanguageProperty.getProperty((String)language, (String)"Login", (String)"");
        String frontPageLoginCopyRight = MultiLanguageProperty.getProperty((String)language, (String)"front.page.login.copyright", (String)"");
        String smsCode = MultiLanguageProperty.getProperty((String)language, (String)"page.function.info.sms.code", (String)"");
        String userNoExist = MultiLanguageProperty.getProperty((String)language, (String)"core.user.notexist", (String)"");
        String imgCode = MultiLanguageProperty.getProperty((String)language, (String)"page.login.img.code", (String)"");
        String scanCode = MultiLanguageProperty.getProperty((String)language, (String)"page.login.scan.code", (String)"");
        String appScan = MultiLanguageProperty.getProperty((String)language, (String)"page.login.app.scan", (String)"");
        String wechatLogin = MultiLanguageProperty.getProperty((String)language, (String)"page.login.wechat", (String)"");
        String wechatScan = MultiLanguageProperty.getProperty((String)language, (String)"page.login.wechat.scan", (String)"");
        String dingdingLogin = MultiLanguageProperty.getProperty((String)language, (String)"page.login.dingding", (String)"");
        String dingdingScan = MultiLanguageProperty.getProperty((String)language, (String)"page.login.dingding.scan", (String)"");
        MultiLangWordMap.put("domains", domains);
        MultiLangWordMap.put("pageLoginAccount", pageLoginAccount);
        MultiLangWordMap.put("pageLoginPassword", pageLoginPassword);
        MultiLangWordMap.put("pageLoginRememberLabel", pageLoginRememberLabel);
        MultiLangWordMap.put("login", login);
        MultiLangWordMap.put("frontPageLoginCopyright", frontPageLoginCopyRight);
        MultiLangWordMap.put("smsCode", smsCode);
        MultiLangWordMap.put("userNoExist", userNoExist);
        MultiLangWordMap.put("imgCode", imgCode);
        MultiLangWordMap.put("scanCode", scanCode);
        MultiLangWordMap.put("appScan", appScan);
        MultiLangWordMap.put("wechatLogin", wechatLogin);
        MultiLangWordMap.put("wechatScan", wechatScan);
        MultiLangWordMap.put("dingdingLogin", dingdingLogin);
        MultiLangWordMap.put("dingdingScan", dingdingScan);
        return MultiLangWordMap;
    }

    @ResponseBody
    @PostMapping(path={"/api/runtime/login/changeCheckcodeImg"})
    @ApiOperation(value="\u6539\u53d8\u9a8c\u8bc1\u7801", notes="\u6539\u53d8\u9a8c\u8bc1\u7801")
    public JSON changeCheckcodeImg() throws Exception {
        String png_base64 = this.getCheckCodeImg();
        return this.result("1", "\u6539\u53d8\u6210\u529f", "checkcode", "data:image/jpg;base64," + png_base64, null, null);
    }

    @ResponseBody
    @PostMapping(path={"/api/runtime/login/getDomainList"})
    @ApiOperation(value="\u83b7\u53d6\u4f01\u4e1a\u57df\u5217\u8868", notes="\u83b7\u53d6\u4f01\u4e1a\u57df\u5217\u8868")
    public JSON getDomainList() throws Exception {
        try {
            Map<String, Object> hashMap = this.getAuthConfig();
            String path = PropertyUtil.getByPropName((String)"sso", (String)"login.background");
            ArrayList<String> arr = new ArrayList<String>();
            arr.add("xxxxxx1");
            hashMap.put("domainList", arr);
            hashMap.put("loginBackground", path);
            return this.result("1", "\u6210\u529f", "result", hashMap, null, null);
        }
        catch (Exception e) {
            return this.result("0", "\u5931\u8d25", "result", null, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getAuthConfig() {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        String freeTemplate = LoginConfig.getHomeTemplateBoradType();
        if (StringUtil.isBlank((String)freeTemplate)) {
            freeTemplate = "";
        }
        configMap.put("homeTemplateBoradType", freeTemplate);
        Properties props = new Properties();
        InputStream stream = null;
        String realpath = PropertyUtil.getPath();
        URL propsUrl = null;
        try {
            propsUrl = new URL("file", null, realpath + "/sso.properties");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        if (propsUrl == null) {
            throw new IllegalStateException("sso.properties missing");
        }
        try {
            stream = propsUrl.openStream();
            props.load(new InputStreamReader(stream, "UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                stream = null;
            }
        }
        configMap.put("loginBackground", props.getProperty("login.background"));
        configMap.put("loginLogo", props.getProperty("login.logo"));
        configMap.put("loginTitle", props.getProperty("login.title"));
        configMap.put("isRegister", props.getProperty("login.isRegister"));
        configMap.put("registerTitle", props.getProperty("register.title"));
        configMap.put("registerUrl", props.getProperty("register.url"));
        configMap.put("isSupervise", props.getProperty("site.supervise"));
        configMap.put("areaCode", props.getProperty("areaCode"));
        return configMap;
    }

    @ResponseBody
    @PostMapping(value={"/api/runtime/login/loginWithCiphertext2"})
    @ApiOperation(value="\u767b\u5f55", notes="\u767b\u5f55")
    @ApiImplicitParams(value={@ApiImplicitParam(name="jsonObj", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public JSON login(@RequestBody JSONObject jsonObj) throws Exception {
        String maxAge;
        String author;
        String code;
        String domainName = jsonObj.getString("domainName");
        String username = jsonObj.getString("username");
        String password = jsonObj.getString("password");
        String remember = jsonObj.getString("remember");
        String checkcode = jsonObj.getString("checkcode");
        String language = jsonObj.getString("language");
        String debug = jsonObj.getString("debug");
        if (domainName == null) {
            return this.result("0", "{*[cn.myapps.core.domain.label.name.illegal]*}", "returnUrl", "", "checkcodeImg", "");
        }
        DomainDAO domainDAO = (DomainDAO)DAOFactory.getDefaultDAO((String)DomainVO.class.getName());
        DomainVO domain = domainDAO.getDomainByName(domainName);
        if (domain == null || domain.getStatus() == 0) {
            return this.result("0", "{*[core.domain.notexist]*}", "returnUrl", "", "checkcodeImg", "");
        }
        Integer count = 0;
        UserProcess up = AuthTimeServiceManager.userRuntimeService();
        UserVO user = up.getUserByLoginnoAndDoaminName(username, domainName);
        if (user == null) {
            return this.result("0", "{*[core.user.notexist]*}", "returnUrl", "", "checkcodeImg", "");
        }
        count = user.getPwdErrorTimes();
        String png_base64 = "";
        if (count > 2 && (code = (String)this.request.getSession().getAttribute(this.CheckCode_Session)) != null && !code.equalsIgnoreCase(checkcode)) {
            png_base64 = "data:image/jpg;base64," + this.getCheckCodeImg();
            return this.result("0", "\u8f93\u5165\u5b57\u7b26\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u56fe\u7247\u4e2d\u51fa\u73b0\u76844\u4e2a\u5b57\u7b26", "returnUrl", "", "checkcodeImg", png_base64);
        }
        if (count >= 2) {
            png_base64 = "data:image/jpg;base64," + this.getCheckCodeImg();
        }
        if (user != null && user.getLockFlag() == 0) {
            return this.result("0", "\u8be5\u8d26\u53f7\u5df2\u9501\u5b9a", "returnUrl", "", "checkcodeImg", png_base64);
        }
        if (user != null && "0".equals(author = PropertyUtil.get((String)"ao.login.notice.author")) && (maxAge = PropertyUtil.get((String)"ao.login.password.maxage")) != null) {
            long overdueTime = Integer.valueOf(maxAge) * 24 * 60 * 60 * 1000;
            long oldTime = user.getLastModifyTime().getTime();
            long nowTime = new Date().getTime();
            if (nowTime - oldTime > overdueTime) {
                return this.result("0", "\u5bc6\u7801\u5df2\u8fc7\u671f", "returnUrl", "", "checkcodeImg", png_base64);
            }
        }
        if (password != null && password.length() > 2) {
            String lp = password.substring(0, password.length() - 2);
            String rp = password.substring(password.length() - 2, password.length());
            password = Security.decodeBASE64((String)(rp + lp));
        }
        String token = null;
        try {
            up.login(user.getLoginno(), password, user.getDomain().getName(), count.intValue());
            String encodedPassword = user.getLoginpwd();
            if (!PasswordUtils.isMatched((String)encodedPassword, (String)password)) {
                throw new Exception("\u767b\u9646\u9519\u8bef!");
            }
            token = Security.getToken((String)user.getId());
            Cookie cookie = new Cookie("accessToken", token);
            Cookie isFromLogin = new Cookie("isFromLogin", "1");
            cookie.setPath("/");
            cookie.setMaxAge(7200);
            isFromLogin.setPath("/");
            this.response.addCookie(cookie);
            this.response.addCookie(isFromLogin);
            if (this.isAgent((BaseUser)user)) {
                return this.result("1", "\u4ee3\u7406\u767b\u9646\u9875\u9762", "returnUrl", "../login/agent.html?id=" + user.getId(), "accessToken", token);
            }
        }
        catch (Exception e) {
            up.updateUserPwdErrorTimes(username, count + 1);
            return this.result("0", e.getMessage(), "returnUrl", "", "checkcodeImg", png_base64);
        }
        WebUser webUser = new WebUser((IUser)user);
        WebUser.setWebUser((WebUser)webUser, (HttpServletRequest)this.request);
        LogHelper.saveLogByDyAction((String)"\u767b\u5f55", (String)"\u767b\u5f55", (IUser)webUser, (HttpServletRequest)this.request);
        try {
            DomainProcess process = AuthTimeServiceManager.domainRuntimeService();
            process.doUpdate((AuthtimeValueObject)domain);
        }
        catch (Exception process) {
            // empty catch block
        }
        String skin = PropertyUtil.getByPropName((String)"skin", (String)"homePage");
        return this.result("1", "\u767b\u9646\u6210\u529f", "returnUrl", "../signon/dispatcher.html?skin=" + skin, "checkcodeImg", "", "accessToken", token);
    }

    @ResponseBody
    @GetMapping(path={"/api/runtime/dingding/authlogin"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="\u9489\u9489\u514d\u767b\u6388\u6743\u7801", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="domainId", value="\u4f01\u4e1a\u57dfid", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="appId", value="\u8f6f\u4ef6id", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="formId", value="\u8868\u5355id", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="isPc", value="\u662f\u5426\u6765\u81eapc", required=false, paramType="query", dataType="boolean")})
    public JSON dingdingAuthLogin(@RequestParam String code, @RequestParam String domainId, @RequestParam(required=false) String appId, @RequestParam(required=false) String formId, @RequestParam(required=false) String docId, @RequestParam(required=false, defaultValue="false") boolean isPc) throws Exception {
        String userId = DdApiService.getUserInfo((String)code, (String)domainId);
        DomainProcess process = AuthTimeServiceManager.domainRuntimeService();
        DomainVO domain = (DomainVO)process.doView(domainId);
        UserProcess up = AuthTimeServiceManager.userRuntimeService();
        UserVO user = (UserVO)up.doView(userId);
        if (user == null) {
            user = up.getUserByDdUserIdAndDoaminName(userId, domain.getName());
        }
        String token = null;
        if (user == null) {
            return this.result("0", "\u7528\u6237\u4e0d\u5b58\u5728,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u540c\u6b65", null, null, null, null);
        }
        token = Security.getToken((String)user.getId());
        Cookie cookie = new Cookie("accessToken", token);
        cookie.setPath("/");
        this.response.addCookie(cookie);
        String url = !(StringUtil.isBlank((String)formId) || formId.equals("null") || StringUtil.isBlank((String)docId) || docId.equals("null")) ? (isPc ? "portal/good/html/form.html?appId=" + appId + "&docid=" + docId + "&formId=" + formId + "&opentarget=detail&accessToken=" + token : "mobile/index.html#/open?linkType=00&actionContent=" + formId + "&docId=" + docId) : ("pm".equals(appId) ? "/pms/pm/wap/index.jsp?application=pm" : ("qmdt".equals(appId) ? "/qms/qm/wap/pendlist.jsp?application=qm" : ("qmcenter".equals(appId) ? "/qms/qm/wap/center.jsp?application=qm" : ("amsignin".equals(appId) ? "/attendance/sign.jsp?application=am&action=signin" : ("amsignout".equals(appId) ? "/attendance/sign.jsp?application=am&action=signout" : ("am".equals(appId) ? "/attendance/record.jsp?application=am" : ("cmfavoritecontacts".equals(appId) ? "contacts/index.html?application=cm&action=favoriteContacts" : ("cm".equals(appId) ? "contacts/index.html?application=cm" : ("km".equals(appId) ? "/kms/kmswap/asset/index.html" : (isPc ? "portal/good/index.html" : "mobile/index.html"))))))))));
        return this.result("1", "\u767b\u9646\u6210\u529f", "returnUrl", url, null, null);
    }

    public boolean isAgent(BaseUser user) throws Exception {
        for (UserVO userVO : this.get_proxyUsers(user)) {
            Date now;
            if (!(userVO.getStartProxyTime() != null && userVO.getEndProxyTime() != null ? (now = new Date()).after(userVO.getStartProxyTime()) && now.before(userVO.getEndProxyTime()) && user.getId().equals(userVO.getProxyUser().getId()) : user.getId().equals(userVO.getProxyUser().getId()))) continue;
            return true;
        }
        return false;
    }

    public Collection<UserVO> get_proxyUsers(BaseUser baseUser) throws Exception {
        ArrayList<UserVO> proxUser = new ArrayList<UserVO>();
        UserProcess process = AuthTimeServiceManager.userRuntimeService();
        Collection cols = process.queryByProxyUserId(baseUser.getId());
        if (cols != null && cols.size() > 0) {
            for (UserVO user : cols) {
                if (user.getStartProxyTime() != null && user.getEndProxyTime() != null) {
                    Date now = new Date();
                    if (!now.after(user.getStartProxyTime()) || !now.before(user.getEndProxyTime())) continue;
                    proxUser.add(user);
                    continue;
                }
                proxUser.add(user);
            }
        }
        return proxUser;
    }

    @ResponseBody
    @GetMapping(value={"/api/runtime/login/getProxyUsers/{userid}"})
    @ApiOperation(value="\u83b7\u53d6\u53ef\u4ee3\u7406\u767b\u5f55\u7528\u6237", notes="\u83b7\u53d6\u53ef\u4ee3\u7406\u767b\u5f55\u7528\u6237")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userid", value="\u7528\u6237id", required=true, paramType="path", dataType="string")})
    public JSON doGetProxyUsers(@PathVariable String userid) throws Exception {
        List<UserVO> proxyUsers = this.getProxyUsers(userid);
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        for (UserVO user : proxyUsers) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)user.getId());
            jsonObject.put("name", (Object)user.getLoginno());
            jsonObject.put("avatar", (Object)user.getAvatar());
            list.add(jsonObject);
        }
        return this.result("0", "", "returnUrl", "", "proxyUsers", list);
    }

    public List<UserVO> getProxyUsers(String userid) throws Exception {
        ArrayList<UserVO> users = new ArrayList<UserVO>();
        UserProcess process = AuthTimeServiceManager.userRuntimeService();
        Collection cols = process.queryByProxyUserId(userid);
        if (cols != null && cols.size() > 0) {
            for (UserVO user : cols) {
                if (user.getStartProxyTime() != null && user.getEndProxyTime() != null) {
                    Date now = new Date();
                    if (!now.after(user.getStartProxyTime()) || !now.before(user.getEndProxyTime())) continue;
                    users.add(user);
                    continue;
                }
                users.add(user);
            }
        }
        return users;
    }

    @ResponseBody
    @GetMapping(value={"/api/runtime/login/loginProxy/{userid}"})
    @ApiOperation(value="\u4ee3\u7406\u767b\u5f55", notes="\u4ee3\u7406\u767b\u5f55")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userid", value="\u7528\u6237id", required=true, paramType="path", dataType="string")})
    public JSON doLoginProxy(@PathVariable String userid) {
        try {
            UserProcess process = AuthTimeServiceManager.userRuntimeService();
            UserVO user = (UserVO)process.doView(userid);
            String token = Security.getToken((String)user.getId());
            Cookie cookie = new Cookie("accessToken", token);
            cookie.setPath("/");
            this.response.addCookie(cookie);
            String skin = PropertyUtil.getByPropName((String)"skin", (String)"homePage");
            return this.result("1", "\u767b\u9646\u6210\u529f", "returnUrl", "../signon/dispatcher.html?skin=" + skin, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.result("0", "\u767b\u9646\u5931\u8d25", "returnUrl", "", null, null);
        }
    }

    private JSON result(String resultCode, String msg, String dataName, Object data, String dataName2, Object data2) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resultCode", resultCode);
        map.put("msg", msg);
        if (dataName != null || data != null) {
            map.put(dataName, data);
        }
        if (dataName2 != null || data2 != null) {
            map.put(dataName2, data2);
        }
        JSONObject json = JSONObject.parseObject((String)JSON.toJSONString(map));
        return json;
    }

    private JSON result(String resultCode, String msg, String dataName, Object data, String dataName2, Object data2, String dataName3, Object data3) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resultCode", resultCode);
        map.put("msg", msg);
        if (dataName != null || data != null) {
            map.put(dataName, data);
        }
        if (dataName2 != null || data2 != null) {
            map.put(dataName2, data2);
        }
        if (dataName3 != null || data3 != null) {
            map.put(dataName3, data3);
        }
        JSONObject json = JSONObject.parseObject((String)JSON.toJSONString(map));
        return json;
    }

    private char[] generateCheckCode() {
        String chars = "0123456789abcdefghijkLmnopqrstuvwxyz";
        char[] rands = new char[4];
        for (int i = 0; i < 4; ++i) {
            int rand = new Random().nextInt(36);
            rands[i] = chars.charAt(rand);
        }
        return rands;
    }

    private void drawBackground(Graphics gd) {
        Random r = new Random();
        gd.setColor(Color.black);
        gd.clipRect(0, 0, WIDTH + 6, HEIGHT + 4);
        gd.setColor(Color.white);
        gd.fillRect(1, 1, WIDTH + 4, HEIGHT + 2);
        for (int i = 0; i < 30; ++i) {
            int x = r.nextInt(WIDTH) + 2;
            int y = r.nextInt(HEIGHT) + 3;
            int xl = r.nextInt(12);
            int yl = r.nextInt(12);
            int red = r.nextInt(255);
            int green = r.nextInt(255);
            int blue = r.nextInt(255);
            gd.setColor(new Color(red, green, blue));
            gd.drawLine(x, y, x + xl, y + yl);
        }
    }

    private void drawRands(Graphics g, char[] rands) {
        g.setColor(new Color(0x1F1F1F));
        Font font = new Font("Fixedsys", 0, HEIGHT);
        g.setFont(font);
        int xx = WIDTH / (rands.length + 1);
        int codeY = HEIGHT;
        for (int i = 0; i < rands.length; ++i) {
            g.drawString("" + rands[i], (i + 1) * xx, codeY);
        }
    }

    public String getCheckCodeImg() throws Exception {
        this.response.setContentType("image/jpg");
        this.response.setHeader("Pragma", "No-cache");
        this.response.setHeader("Cache-Control", "no-cache");
        this.response.setDateHeader("Expires", 0L);
        BufferedImage image = new BufferedImage(WIDTH + 6, HEIGHT + 4, 1);
        Graphics g = image.getGraphics();
        char[] rands = this.generateCheckCode();
        this.drawBackground(g);
        this.drawRands(g, rands);
        g.dispose();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "JPG", baos);
        byte[] bytes = baos.toByteArray();
        String png_base64 = Base64Util.encode((byte[])bytes);
        png_base64 = png_base64.replaceAll("\n", "").replaceAll("\r", "");
        this.request.getSession().setAttribute(this.CheckCode_Session, (Object)String.valueOf(rands));
        return png_base64;
    }

    @ResponseBody
    @GetMapping(path={"/api/debuglogin/getDomainList"})
    @ApiOperation(value="\u8c03\u8bd5\u767b\u5f55-\u83b7\u53d6\u4f01\u4e1a\u57df\u5217\u8868", notes="\u8c03\u8bd5\u767b\u5f55-\u83b7\u53d6\u4f01\u4e1a\u57df\u5217\u8868")
    public JSON getDomainList(HttpServletResponse response, HttpServletRequest request) throws Exception {
        try {
            Collection<String> domainList = this.getDomainNameList();
            return this.result("1", "\u6210\u529f", "domainList", domainList, null, null);
        }
        catch (Exception e) {
            return this.result("0", "\u5931\u8d25", "domainList", null, null, null);
        }
    }

    public Collection<String> getDomainNameList() {
        ArrayList<String> map = new ArrayList<String>();
        try {
            DomainProcess process = AuthTimeServiceManager.domainRuntimeService();
            Collection col = process.getDomainByStatus(1);
            for (DomainVO vo : col) {
                map.add(vo.getName());
            }
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return map;
        }
    }

    @ResponseBody
    @GetMapping(path={"/api/debuglogin/getUserList"})
    @ApiOperation(value="\u8c03\u8bd5\u767b\u5f55-\u83b7\u53d6\u7528\u6237\u5217\u8868", notes="\u8c03\u8bd5\u767b\u5f55-\u83b7\u53d6\u7528\u6237\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="domainName", value="\u4f01\u4e1a\u57df\u540d\u79f0", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="username", value="\u7528\u6237\u540d", required=true, paramType="query", dataType="string")})
    public JSON getUserList(@RequestParam(required=true) String domainName, @RequestParam(required=false) String username) {
        try {
            UserProcess process = AuthTimeServiceManager.userRuntimeService();
            Collection userVOS = process.getUserByLoginnoLikeAndDoaminName(domainName, username, 1, 10);
            ArrayList<String> map = new ArrayList<String>();
            for (UserVO vo : userVOS) {
                map.add(vo.getLoginno());
            }
            return this.result("1", "\u6210\u529f", "userList", map, null, null);
        }
        catch (Exception e) {
            return this.result("0", "\u5931\u8d25", "userList", null, null, null);
        }
    }

    @ResponseBody
    @GetMapping(path={"/api/debuglogin/getMultiLangWordList"})
    @ApiOperation(value="\u8c03\u8bd5\u767b\u5f55-\u83b7\u53d6\u767b\u9646\u9875\u9762\u6240\u9700\u7684\u591a\u8bed\u8a00\u5b57\u6bb5", notes="\u8c03\u8bd5\u767b\u5f55-\u83b7\u53d6\u767b\u9646\u9875\u9762\u6240\u9700\u7684\u591a\u8bed\u8a00\u5b57\u6bb5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="language", value="\u8bed\u8a00", required=true, paramType="query", dataType="string")})
    public JSON getMultiLangWordList(@RequestParam String language, HttpServletRequest request) {
        try {
            Map MultiLangWordMap = this.getLoginMultiLangWordList(language);
            Cookie cookie = new Cookie("USERLANGUAGE", language);
            cookie.setPath("/");
            cookie.setMaxAge(7200);
            this.response.addCookie(cookie);
            return this.result("1", "\u6210\u529f", "multiLangWordList", MultiLangWordMap, null, null);
        }
        catch (Exception e) {
            return this.result("0", "\u5931\u8d25", "multiLangWordList", null, null, null);
        }
    }

    @ResponseBody
    @PostMapping(value={"/api/debuglogin/loginWithCiphertext2"})
    @ApiOperation(value="\u8c03\u8bd5\u767b\u5f55-\u767b\u9646", notes="\u8c03\u8bd5\u767b\u5f55-\u767b\u9646")
    @ApiImplicitParams(value={@ApiImplicitParam(name="domainName", value="\u4f01\u4e1a\u57df\u540d\u79f0", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="username", value="\u7528\u6237\u540d", required=true, paramType="query", dataType="string")})
    public JSON login2(@RequestBody JSONObject jsonObj) throws Exception {
        String domainName = jsonObj.getString("domainName");
        String username = jsonObj.getString("username").split("\\(")[0];
        try {
            UserProcess up = AuthTimeServiceManager.userRuntimeService();
            UserVO userVO = up.getUserByLoginnoAndDoaminName(username, domainName);
            String token = Security.getToken((String)userVO.getId());
            String skin = PropertyUtil.getByPropName((String)"skin", (String)"homePage");
            Cookie cookie = new Cookie("debugToken", token);
            cookie.setPath("/");
            this.response.addCookie(cookie);
            if (this.isAgent((BaseUser)userVO)) {
                return this.result("1", "\u4ee3\u7406\u767b\u9646\u9875\u9762", "returnUrl", "../login/agent.html?id=" + userVO.getId(), null, null);
            }
            return this.result("1", "\u767b\u9646\u6210\u529f", "returnUrl", "../signon/dispatcher.html?skin=" + skin, "checkcodeImg", "");
        }
        catch (Exception e) {
            return this.result("0", "\u767b\u9646\u5931\u8d25", "returnUrl", "", "checkcodeImg", "");
        }
    }

    @ResponseBody
    @PostMapping(path={"/api/runtime/logout"})
    @ApiOperation(value="\u9000\u51fa\u767b\u5f55", notes="\u9000\u51fa\u767b\u5f55")
    public JSON logout() throws Exception {
        CookieUtil.clearCookie((String)"verify_login", (HttpServletResponse)this.response);
        CookieUtil.clearCookie((String)"autologin", (HttpServletResponse)this.response);
        CookieUtil.clearCookie((String)"accessToken", (HttpServletResponse)this.response);
        CookieUtil.clearCookie((String)"isFromLogin", (HttpServletResponse)this.response);
        HttpSession session = this.request.getSession();
        session.removeAttribute("SPRING_SECURITY_CONTEXT");
        return this.result("ok", "ok", "data", "/static/signon/index.html?yes=1", null, null);
    }

    @PostMapping(value={"/api/runtime/login/smsSend"})
    @ApiOperation(value="\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801", notes="\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801")
    public JSON doSmsSend(String userId, String content) {
        return this.result("ok", "\u53d1\u9001\u6210\u529f", "status", true, null, null);
    }

    public String getLogoutRedirect(HttpServletRequest request, HttpServletResponse response) {
        String url = "";
        url = "sso".equals(PropertyUtil.get((String)"authentication.type")) ? PropertyUtil.get((String)"sso.logout.redirect") : "/signon/";
        return url;
    }

    public String getDispatchURL(String url, ServletRequest req, ServletResponse res) {
        if (StringUtil.isBlank((String)url)) {
            return null;
        }
        if (url.indexOf("/portal/dispatch/") != -1) {
            HttpServletRequest hreq = (HttpServletRequest)req;
            HttpSession session = hreq.getSession();
            String skinType = (String)session.getAttribute("SKINTYPE");
            if (skinType == null) {
                skinType = "H5";
            }
            url = url.replace("dispatch", skinType);
        }
        return url;
    }

    @RequestMapping(value={"/api/runtime/login/getMenuList"})
    public AjaxResult getMenuList() throws Exception {
        return AjaxResult.success(null, (Object)this.getMenus());
    }

    @RequestMapping(value={"/api/runtime/login/getPoliceRoles"})
    public AjaxResult getPoliceRoles(String roleNo, String roleName, Map<String, String> menuIdMap) throws Exception {
        return AjaxResult.success(null, this.getPoliceRoleList(roleNo, roleName, menuIdMap));
    }

    public JSONArray getMenus() throws Exception {
        ApplicationDesignTimeService appService = DesignTimeServiceManager.applicationDesignTimeService();
        List list = appService.list("", null);
        JSONArray array = new JSONArray();
        ResourceDesignTimeService resourceDesignTimeService = DesignTimeServiceManager.resourceDesignTimeService();
        int index = 1;
        for (Application application : list) {
            List menusList;
            if (application.getName().contains("\u5e73\u53f0\u8fd0\u8425\u7ba1\u7406") || application.getName().contains("\u7ec4\u7ec7\u6743\u76ca") || (menusList = resourceDesignTimeService.deepQueryAll(application.getId(), "menu")) == null || menusList.size() == 0) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)application.getId());
            jsonObject.put("name", (Object)application.getName());
            jsonObject.put("seq", (Object)index++);
            array.add((Object)jsonObject);
            for (ResourceVO resourceVO : menusList) {
                JSONObject subObj = new JSONObject();
                subObj.put("id", (Object)resourceVO.getId());
                subObj.put("name", (Object)resourceVO.getName());
                subObj.put("parentId", (Object)resourceVO.getParentId());
                subObj.put("seq", (Object)resourceVO.getOrderno());
                array.add((Object)subObj);
                if (resourceVO.getChildren() == null || resourceVO.getChildren().size() <= 0) continue;
                this.getSubMenuList(array, resourceVO);
            }
        }
        return array;
    }

    public void getSubMenuList(JSONArray array, ResourceVO parentVo) throws Exception {
        for (ResourceVO resourceVO : parentVo.getChildren()) {
            JSONObject subObj = new JSONObject();
            subObj.put("id", (Object)resourceVO.getId());
            subObj.put("name", (Object)resourceVO.getName());
            subObj.put("parentId", (Object)resourceVO.getParentId());
            subObj.put("seq", (Object)resourceVO.getOrderno());
            array.add((Object)subObj);
            if (resourceVO.getChildren() == null || resourceVO.getChildren().size() <= 0) continue;
            this.getSubMenuList(array, resourceVO);
        }
    }

    public List<String> getPoliceRoleList(String roleNo, String roleName, Map<String, String> menuIdMap) throws Exception {
        RoleDesignTimeService roleDesignTimeService = AuthTimeServiceManager.roleRuntimeService();
        ArrayList<String> roleList = new ArrayList<String>();
        ApplicationDesignTimeService appService = DesignTimeServiceManager.applicationDesignTimeService();
        List list = appService.list("", null);
        if (list.size() == 0) {
            return roleList;
        }
        ArrayList<String> removeResIdList = new ArrayList<String>();
        ArrayList<Permission> permissionList = new ArrayList<Permission>();
        for (Application application : list) {
            if (2 == application.getType()) continue;
            Role role = roleDesignTimeService.findByRoleNo(roleNo, application.getId());
            if (role == null) {
                role = new Role();
                role.setRoleNo(roleNo);
                role.setStatus(Integer.valueOf(1));
                role.setName(roleName);
                role.setParentId(application.getId());
                role.setApplicationid(application.getId());
                role.setSortId(Sequence.getTimeSequence());
                role.setId(Sequence.getDesignTimeSequence());
                roleDesignTimeService.save((Object)role);
            }
            ResourceDesignTimeService resourceDesignTimeService = DesignTimeServiceManager.resourceDesignTimeService();
            List menusList = resourceDesignTimeService.deepQueryAll(application.getId(), "menu");
            for (ResourceVO resourceVO : menusList) {
                Permission permission;
                removeResIdList.add(resourceVO.getId());
                if ("public".equals(resourceVO.getPermissionType())) {
                    permission = PermissionUtil.createPermissionResource((String)role.getId(), (String)resourceVO.getId());
                    permissionList.add(permission);
                    continue;
                }
                if (menuIdMap.get(resourceVO.getId()) != null) {
                    permission = PermissionUtil.createPermissionResource((String)role.getId(), (String)resourceVO.getId());
                    permissionList.add(permission);
                }
                this.getSubMenuPermission(resourceDesignTimeService, role.getId(), menuIdMap, resourceVO.getId(), removeResIdList, permissionList);
            }
            PermissionUtil.removeAuth(removeResIdList, (Role)role);
            PermissionUtil.pushAuth(permissionList, (Role)role);
            roleDesignTimeService.update((Object)role);
            roleList.add(role.getId());
        }
        Environment.cleanPermissionMap();
        PermissionUtil.initPermissionMap();
        return roleList;
    }

    private void getSubMenuPermission(ResourceDesignTimeService resourceDesignTimeService, String roleId, Map<String, String> menuIdMap, String parentId, List<String> removeResIdList, List<Permission> permissionList) throws Exception {
        List menusList = resourceDesignTimeService.getChildsByParentId(parentId, "");
        if (menusList != null && menusList.size() > 0) {
            for (ResourceVO resourceVO : menusList) {
                Permission permission;
                removeResIdList.add(resourceVO.getId());
                if ("public".equals(resourceVO.getPermissionType())) {
                    permission = PermissionUtil.createPermissionResource((String)roleId, (String)resourceVO.getId());
                    permissionList.add(permission);
                    continue;
                }
                if (menuIdMap.get(resourceVO.getId()) != null) {
                    permission = PermissionUtil.createPermissionResource((String)roleId, (String)resourceVO.getId());
                    permissionList.add(permission);
                }
                this.getSubMenuPermission(resourceDesignTimeService, roleId, menuIdMap, resourceVO.getId(), removeResIdList, permissionList);
            }
        }
    }
}

