/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.log.aspect.instruction;

import cn.myapps.runtime.log.aspect.instruction.LogInstruction;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class LogInstructionExecutor {
    private static LogInstructionExecutor INSTANCE = null;
    private ThreadLocal<Queue<LogInstruction>> queueHolder = new ThreadLocal();
    private Queue<LogInstruction> queue = new ConcurrentLinkedQueue<LogInstruction>();
    private static Object LOCK = new Object();
    private boolean isWaitForJobs = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LogInstructionExecutor getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<LogInstructionExecutor> clazz = LogInstructionExecutor.class;
        synchronized (LogInstructionExecutor.class) {
            INSTANCE = new LogInstructionExecutor();
            INSTANCE.logSchedule();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void put(LogInstruction instruction) {
        this.kickThread();
        this.queue.add(instruction);
    }

    private Queue<LogInstruction> getQueue() {
        this.queue = this.queueHolder.get();
        if (this.queue == null) {
            this.queue = new ConcurrentLinkedQueue<LogInstruction>();
            this.queueHolder.set(this.queue);
        }
        return this.queue;
    }

    public void clear() {
        Queue<LogInstruction> queue = this.queueHolder.get();
        if (queue != null) {
            queue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void kickThread() {
        Object object = LOCK;
        synchronized (object) {
            LOCK.notifyAll();
        }
    }

    public void execute() throws Exception {
        LogInstruction instruction = null;
        while ((instruction = this.queue.poll()) != null) {
            instruction.run();
        }
    }

    private void logSchedule() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    Object object = LOCK;
                    synchronized (object) {
                        while (!LogInstructionExecutor.this.queue.isEmpty()) {
                            try {
                                LogInstructionExecutor.this.execute();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (LogInstructionExecutor.this.queue.isEmpty()) {
                            LogInstructionExecutor.this.isWaitForJobs = true;
                        } else {
                            LogInstructionExecutor.this.isWaitForJobs = false;
                        }
                    }
                    if (!LogInstructionExecutor.this.isWaitForJobs) continue;
                    object = LOCK;
                    synchronized (object) {
                        try {
                            LOCK.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }).start();
    }
}

