/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.log.aspect.instruction;

import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.authtime.department.service.DepartmentProcess;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.authtime.logger.model.LogVO;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.common.util.StringUtil;
import cn.myapps.runtime.logger.service.LogProcess;
import cn.myapps.util.ProcessFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.json.JSONObject;
import org.aspectj.lang.JoinPoint;

public class LogInstruction {
    private static final Map<String, String> METHON_MAP = new HashMap<String, String>();
    private static final Map<String, String> USER_INFO = new HashMap<String, String>();
    private static final Map<String, String> DEPT_INFO = new HashMap<String, String>();
    public static final int INSERT_RUNTIME_LOG = 1;
    public static final int INSERT_AUTHTIME_LOG = 2;
    private LogProcess process;
    private Object content;
    private int actionType;
    private WebUser user;
    private String ip;

    public LogInstruction(Object content, WebUser user, String ip, int actionType) {
        this.content = content;
        this.actionType = actionType;
        this.user = user;
        this.ip = ip;
        try {
            this.process = (LogProcess)ProcessFactory.createProcess(LogProcess.class);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void run() throws Exception {
        switch (this.actionType) {
            case 1: {
                this.process.doCreate((AuthtimeValueObject)((LogVO)this.content));
                break;
            }
            case 2: {
                LogVO vo = this.getLog((JoinPoint)this.content);
                if (vo == null) break;
                this.process.doCreate((AuthtimeValueObject)vo);
                break;
            }
        }
    }

    public LogVO getLog(JoinPoint point) throws Exception {
        String description = METHON_MAP.get(point.getSignature().getDeclaringTypeName() + "." + point.getSignature().getName());
        if (!StringUtil.isBlank((String)description)) {
            String domainid = LogInstruction.getDomainid(description, point);
            this.user.setDomainid(domainid);
            LogVO logVo = LogVO.valueOf((IUser)this.user, (String)"\u4f01\u4e1a\u57df", (String)LogInstruction.getDescription(description, point), (String)this.ip);
            return logVo;
        }
        return null;
    }

    public static String getDomainid(String description, JoinPoint point) throws Exception {
        switch (description) {
            case "\u5220\u9664\u4f01\u4e1a\u57df": {
                DomainProcess domainProcess = (DomainProcess)ProcessFactory.createProcess(DomainProcess.class);
                DomainVO vo = (DomainVO)domainProcess.doView((String)point.getArgs()[0]);
                return vo.getId();
            }
            case "\u5220\u9664\u90e8\u95e8": {
                DepartmentProcess deptProcess = (DepartmentProcess)ProcessFactory.createProcess(DepartmentProcess.class);
                DepartmentVO department = (DepartmentVO)deptProcess.doView((String)point.getArgs()[0]);
                return department.getDomainid();
            }
            case "\u5220\u9664\u7528\u6237": {
                UserProcess userProcess = (UserProcess)ProcessFactory.createProcess(UserProcess.class);
                UserVO user = (UserVO)userProcess.doView((String)point.getArgs()[0]);
                return user.getDomainid();
            }
        }
        String domainid = (String)point.getArgs()[0];
        return domainid;
    }

    public static String getDescription(String description, JoinPoint point) throws Exception {
        switch (description) {
            case "\u65b0\u5efa\u7528\u6237": {
                return LogInstruction.compareUser(point);
            }
            case "\u66f4\u65b0\u7528\u6237": {
                return LogInstruction.compareUser(point);
            }
            case "\u4fdd\u5b58\u90e8\u95e8": {
                return LogInstruction.compareDepartment(point);
            }
            case "\u66f4\u65b0\u90e8\u95e8": {
                return LogInstruction.compareDepartment(point);
            }
        }
        return description;
    }

    public static String compareUser(JoinPoint point) throws Exception {
        UserProcess userProcess = (UserProcess)ProcessFactory.createProcess(UserProcess.class);
        UserVO user = (UserVO)userProcess.doView((String)point.getArgs()[0]);
        ObjectMapper objectMapper = new ObjectMapper();
        if (user == null) {
            user = new UserVO();
        }
        JSONObject oldJson = JSONObject.fromObject((Object)objectMapper.writeValueAsString((Object)user));
        JSONObject newjson = JSONObject.fromObject((Object)((String)point.getArgs()[2]));
        Iterator<Map.Entry<String, String>> entrys = USER_INFO.entrySet().iterator();
        String result = "";
        while (entrys.hasNext()) {
            Map.Entry<String, String> entry = entrys.next();
            if ("_userRoleDepartmentJson".equals(entry.getKey())) {
                result = result + "[" + entry.getValue() + ":" + oldJson.get("roleDepartments") + "," + newjson.get(entry.getKey()) + "],";
                continue;
            }
            result = result + "[" + entry.getValue() + ":" + oldJson.get(entry.getKey()) + "," + newjson.get(entry.getKey()) + "],";
        }
        return result;
    }

    public static String compareDepartment(JoinPoint point) throws Exception {
        DepartmentProcess deptProcess = (DepartmentProcess)ProcessFactory.createProcess(DepartmentProcess.class);
        DepartmentVO department = (DepartmentVO)deptProcess.doView((String)point.getArgs()[1]);
        ObjectMapper objectMapper = new ObjectMapper();
        if (department == null) {
            department = new DepartmentVO();
        }
        JSONObject oldJson = JSONObject.fromObject((Object)objectMapper.writeValueAsString((Object)department));
        JSONObject newjson = JSONObject.fromObject((Object)((String)point.getArgs()[2]));
        Iterator<Map.Entry<String, String>> entrys = DEPT_INFO.entrySet().iterator();
        String result = "";
        while (entrys.hasNext()) {
            Map.Entry<String, String> entry = entrys.next();
            if ("superior".equals(entry.getKey())) {
                result = result + "[" + entry.getValue() + ":" + JSONObject.fromObject((Object)oldJson.get("superior")).get("name") + "," + JSONObject.fromObject((Object)newjson.get("superior")).get("name") + "],";
                continue;
            }
            result = result + "[" + entry.getValue() + ":" + oldJson.get(entry.getKey()) + "," + newjson.get(entry.getKey()) + "],";
        }
        return result;
    }

    static {
        METHON_MAP.put("cn.myapps.authtime.domain.controller.DomainAuthtimeController.doCreateDomain", "\u65b0\u5efa\u4f01\u4e1a\u57df");
        METHON_MAP.put("cn.myapps.authtime.domain.controller.DomainAuthtimeController.doUpdateDomain", "\u66f4\u65b0\u4f01\u4e1a\u57df");
        METHON_MAP.put("cn.myapps.authtime.domain.controller.DomainAuthtimeController.doDeleteDomain", "\u5220\u9664\u4f01\u4e1a\u57df");
        METHON_MAP.put("cn.myapps.authtime.department.controller.DepartmentAuthtimeController.doCreateDepartment", "\u65b0\u5efa\u90e8\u95e8");
        METHON_MAP.put("cn.myapps.authtime.department.controller.DepartmentAuthtimeController.doUpdateDepartment", "\u66f4\u65b0\u90e8\u95e8");
        METHON_MAP.put("cn.myapps.authtime.department.controller.DepartmentAuthtimeController.doDeleteDepartment", "\u5220\u9664\u90e8\u95e8");
        METHON_MAP.put("cn.myapps.authtime.user.controller.UserAuthtimeController.doCreateUser", "\u65b0\u5efa\u7528\u6237");
        METHON_MAP.put("cn.myapps.authtime.user.controller.UserAuthtimeController.doUpdateUser", "\u66f4\u65b0\u7528\u6237");
        METHON_MAP.put("cn.myapps.authtime.user.controller.UserAuthtimeController.doDeleteUser", "\u5220\u9664\u7528\u6237");
        METHON_MAP.put("cn.myapps.authtime.user.controller.UserAuthtimeController.batchAddUser", "\u6279\u91cf\u8bbe\u7f6e\u7528\u6237\u89d2\u8272");
        METHON_MAP.put("cn.myapps.authtime.application.controller.ApplicationAuthtimeController.removeApplications", "\u79fb\u9664\u8f6f\u4ef6");
        METHON_MAP.put("cn.myapps.authtime.application.controller.ApplicationAuthtimeController.addApplications", "\u6dfb\u52a0\u8f6f\u4ef6");
        METHON_MAP.put("cn.myapps.authtime.application.controller.ApplicationAuthtimeController.disable", "\u7981\u7528\u8f6f\u4ef6\u6a21\u5757");
        METHON_MAP.put("cn.myapps.authtime.application.controller.ApplicationAuthtimeController.enable", "\u542f\u7528\u8f6f\u4ef6\u6a21\u5757");
        METHON_MAP.put("cn.myapps.authtime.application.controller.ApplicationAuthtimeController.savekmconfig", "\u4fdd\u5b58km\u89d2\u8272\u914d\u7f6e");
        METHON_MAP.put("cn.myapps.authtime.application.controller.ApplicationAuthtimeController.exportRoleMenuAuthority", "\u5bfc\u51fa\u83dc\u5355\u89d2\u8272\u6743\u9650\u5173\u7cfb");
        METHON_MAP.put("cn.myapps.authtime.application.controller.ApplicationAuthtimeController.exportRoleUserAuthority", "\u5bfc\u51fa\u89d2\u8272\u7528\u6237\u6743\u9650\u5173\u7cfb");
        METHON_MAP.put("cn.myapps.authtime.wechat.controller.WechatAuthtimeController.saveWechatConfig", "\u4fdd\u5b58\u5fae\u4fe1\u914d\u7f6e");
        METHON_MAP.put("cn.myapps.authtime.wechat.controller.WechatAuthtimeController.synchFromWechat", "\u540c\u6b65\u5fae\u4fe1\u4f01\u4e1a\u53f7\u7ec4\u7ec7\u67b6\u6784\u5230\u4f01\u4e1a\u57df");
        METHON_MAP.put("cn.myapps.authtime.wechat.controller.WechatAuthtimeController.synch2Wechat", "\u540c\u6b65\u4f01\u4e1a\u57df\u7ec4\u7ec7\u67b6\u6784\u5230\u5fae\u4fe1\u4f01\u4e1a\u53f7");
        METHON_MAP.put("cn.myapps.authtime.dingding.controller.DingdingAuthtimeController.saveDingdingConfig", "\u4fdd\u5b58\u9489\u9489\u914d\u7f6e");
        METHON_MAP.put("cn.myapps.authtime.dingding.controller.DingdingAuthtimeController.synch2Dingding", "\u540c\u6b65\u4f01\u4e1a\u57df\u7ec4\u7ec7\u67b6\u6784\u5230\u9489\u9489");
        METHON_MAP.put("cn.myapps.authtime.dingding.controller.DingdingAuthtimeController.synchFromDingding", "\u540c\u6b65\u9489\u9489\u7ec4\u7ec7\u67b6\u6784\u5230\u4f01\u4e1a\u57df");
        METHON_MAP.put("cn.myapps.authtime.admin.controller.AdminAuthtimeController.addAdmins", "\u6dfb\u52a0\u7ba1\u7406\u5458");
        METHON_MAP.put("cn.myapps.authtime.admin.controller.AdminAuthtimeController.removeAdmins", "\u79fb\u9664\u7ba1\u7406\u5458");
        METHON_MAP.put("cn.myapps.authtime.workcalendar.controller.CalendarAuthtimeController.addCalendar", "\u65b0\u5efa\u5de5\u4f5c\u65e5\u5386");
        METHON_MAP.put("cn.myapps.authtime.workcalendar.controller.CalendarAuthtimeController.updateCalendar", "\u66f4\u65b0\u5de5\u4f5c\u65e5\u5386");
        METHON_MAP.put("cn.myapps.authtime.workcalendar.controller.CalendarAuthtimeController.deleteCalendar", "\u5220\u9664\u5de5\u4f5c\u65e5\u5386");
        METHON_MAP.put("cn.myapps.authtime.fieldextends.controller.FieldextendAuthtimeController.updateFieldextend", "\u66f4\u65b0\u5b57\u6bb5\u6269\u5c55");
        METHON_MAP.put("cn.myapps.authtime.workcalendar.controller.CalendarAuthtimeController.addFieldextends", "\u65b0\u5efa\u5b57\u6bb5\u6269\u5c55");
        METHON_MAP.put("cn.myapps.authtime.workcalendar.controller.CalendarAuthtimeController.deleteFieldextends", "\u5220\u9664\u5b57\u6bb5\u6269\u5c55");
        METHON_MAP.put("cn.myapps.authtime.flow.controller.FlowInterventionController.deleteFlowstatert", "\u5220\u9664\u6d41\u7a0b\u5b9e\u4f8b");
        METHON_MAP.put("cn.myapps.authtime.flow.controller.FlowInterventionController.doFlow", "\u5e72\u9884\u6d41\u7a0b");
        METHON_MAP.put("cn.myapps.authtime.email.controller.EmailAuthtimeController.updateEmailConfig", "\u4fdd\u5b58\u90ae\u4ef6\u914d\u7f6e");
        METHON_MAP.put("cn.myapps.authtime.superuser.controller.SuperuserController.saveSuperuser", "\u66f4\u65b0\u7279\u6743\u7528\u6237");
        METHON_MAP.put("cn.myapps.authtime.superuser.controller.SuperuserController.addSuperuser", "\u6dfb\u52a0\u7279\u6743\u7528\u6237");
        METHON_MAP.put("cn.myapps.authtime.superuser.controller.SuperuserController.deleteSuperuser", "\u5220\u9664\u7279\u6743\u7528\u6237");
        USER_INFO.put("name", "\u59d3\u540d");
        USER_INFO.put("loginno", "\u8d26\u53f7");
        USER_INFO.put("level", "\u7b49\u7ea7");
        USER_INFO.put("telephone", "\u624b\u673a1");
        USER_INFO.put("telephonePublic", "\u624b\u673a1\u516c\u5f00");
        USER_INFO.put("telephone2", "\u624b\u673a2");
        USER_INFO.put("email", "\u7535\u5b50\u4fe1\u7bb1");
        USER_INFO.put("emailPublic", "\u7535\u5b50\u4fe1\u606f\u516c\u5f00");
        USER_INFO.put("calendarType", "\u5de5\u4f5c\u65e5\u5386");
        USER_INFO.put("superiorid", "\u4e0a\u7ea7");
        USER_INFO.put("_proxyUser", "\u4ee3\u7406\u4eba\u7528\u6237");
        USER_INFO.put("remarks", "\u63cf\u8ff0");
        USER_INFO.put("startProxyTime", "\u4ee3\u7406\u5f00\u59cb\u65e5\u671f");
        USER_INFO.put("endProxyTime", "\u4ee3\u7406\u7ed3\u675f\u65e5\u671f");
        USER_INFO.put("superAdmin", "\u57df(\u79df\u6237)\u7ba1\u7406\u5458");
        USER_INFO.put("permissionType", "\u901a\u8baf\u5f55\u4e2d\u4e2a\u4eba\u4fe1\u606f");
        USER_INFO.put("allUsers", "\u90e8\u95e8\u63a5\u53e3\u4eba");
        USER_INFO.put("lockFlag", "\u767b\u5f55\u5f02\u5e38\u9501\u5b9a");
        USER_INFO.put("useIM", "\u4f7f\u7528\u5373\u65f6\u901a\u8baf");
        USER_INFO.put("status", "\u662f\u5426\u6fc0\u6d3b");
        USER_INFO.put("_userRoleDepartmentJson", "\u90e8\u95e8");
        USER_INFO.put("_userKMRoleJson", "KM\u7ba1\u7406");
        DEPT_INFO.put("name", "\u90e8\u95e8\u540d\u79f0");
        DEPT_INFO.put("superior", "\u4e0a\u7ea7\u90e8\u95e8");
        DEPT_INFO.put("code", "\u4ee3\u7801");
        DEPT_INFO.put("orderByNo", "\u6392\u5e8f\u53f7");
    }
}

