/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.log.aspect;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.logger.model.LogVO;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.model.activity.Activity;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.designtime.activity.service.ActivityDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.log.aspect.LogsAspect;
import cn.myapps.runtime.log.aspect.instruction.LogInstruction;
import cn.myapps.runtime.log.aspect.instruction.LogInstructionExecutor;
import cn.myapps.runtime.logger.service.LogHelper;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LogsAspectImpl
implements LogsAspect {
    @Autowired(required=false)
    protected HttpServletRequest request;

    protected WebUser getUser() throws Exception {
        WebUser user = null;
        WebUser frontUser = AuthTimeServiceManager.getWebUser((HttpServletRequest)this.request);
        user = frontUser == null ? this.getAnonymousUser() : frontUser;
        return user;
    }

    @Override
    @After(value="execution(* cn.myapps.runtime.activity.controller.ActivityController.runBeforeActionScript(..))")
    public void activityLogs(JoinPoint point) throws Exception {
        try {
            if (this.getUser().isRecordLog()) {
                String description = "";
                String ip = LogHelper.getRequestIp((HttpServletRequest)this.request);
                String type = this.request.getParameter("actType");
                String id = (String)point.getArgs()[0];
                ActivityDesignTimeService activityService = DesignTimeServiceManager.activityDesignTimeService();
                Activity act = (Activity)activityService.findById(id);
                if (act.getUri().contains(".view")) {
                    ViewDesignTimeService viewProcess = DesignTimeServiceManager.viewDesignTimeService();
                    String viewId = this.request.getParameter("viewId");
                    AbstractView view = viewProcess.doView(viewId);
                    description = "\u89c6\u56fe-" + view.getName();
                }
                if (act.getUri().contains(".form")) {
                    String formId = this.request.getParameter("formId");
                    FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
                    Form form = formService.doView(formId);
                    description = "\u8868\u5355-" + form.getName();
                }
                System.out.println("\u64cd\u4f5c\u4eba\uff1a" + this.getUser().getName() + "--\u7c7b\u578b:" + act.getName() + "--\u63cf\u8ff0:" + description + "--ip:" + ip);
                LogVO logVo = LogVO.valueOf((IUser)this.getUser(), (String)act.getName(), (String)description, (String)ip);
                LogInstructionExecutor.getInstance().put(new LogInstruction(logVo, this.getUser(), ip, 1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @Before(value="execution(* cn.myapps.authtime.*.controller.*.*(..))")
    public void authtimeLogs(JoinPoint point) throws Exception {
        try {
            WebUser adminUser = AuthTimeServiceManager.getAdminUser((HttpServletRequest)this.request);
            String ip = LogHelper.getRequestIp((HttpServletRequest)this.request);
            LogInstructionExecutor.getInstance().put(new LogInstruction(point, adminUser, ip, 2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private WebUser getAnonymousUser() throws Exception {
        UserVO vo = new UserVO();
        vo.getId();
        vo.setName("GUEST");
        vo.setLoginno("guest");
        vo.setLoginpwd("");
        vo.setRoles(null);
        vo.setEmail("");
        return new WebUser((IUser)vo);
    }
}

