/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.flowcenter.service;

import cn.myapps.authtime.user.model.UserDefined;
import cn.myapps.authtime.user.service.UserDefinedProcess;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.resource.ResourceVO;
import cn.myapps.common.model.resource.StartMenuNode;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.common.model.workflow.BillDefiVO;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.permission.PermissionUtil;
import cn.myapps.designtime.resource.service.ResourceDesignTimeService;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import cn.myapps.designtime.workflow.definition.service.BillDefiDesignTimeService;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.ejb.WorkVO;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.work.ejb.WorkProcess;
import cn.myapps.runtime.dynaform.work.ejb.WorkProcessBean;
import cn.myapps.runtime.flowcenter.service.FlowCenterRumTimeService;
import cn.myapps.util.ProcessFactory;
import cn.myapps.util.json.JsonTmpUtil;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class FlowCenterRunTimeServiceImpl
implements FlowCenterRumTimeService {
    @Override
    public List<StartMenuNode> getStartMenus(String applicationId, boolean isMobile, boolean isUsual, boolean isUsualList, IUser user) throws Exception {
        Object usualStartMenus;
        String[] roleids = user.getRolelist().replace("'", "").split(",");
        ArrayList<StartMenuNode> arr = new ArrayList<StartMenuNode>();
        ResourceDesignTimeService process = DesignTimeServiceManager.resourceDesignTimeService();
        List resources = new ArrayList();
        resources = isMobile ? process.list(applicationId, "mobilemenu", "mobilemenu", null) : process.list(applicationId, "menu", "menu", null);
        HashMap<String, List<ResourceVO>> treeMap = new HashMap<String, List<ResourceVO>>();
        for (ResourceVO resourceVO : resources) {
            String parentId = resourceVO.getParentId();
            List list = null;
            list = treeMap.containsKey(parentId) ? (List)treeMap.get(parentId) : new ArrayList();
            list.add(resourceVO);
            treeMap.put(parentId, list);
        }
        UserDefinedProcess userDefinedProcess = (UserDefinedProcess)ProcessFactory.createProcess(UserDefinedProcess.class);
        UserDefined userDefined = userDefinedProcess.doFindMyCustomUserDefined(user);
        ArrayList<String> usualStartMenuIds = new ArrayList<String>();
        JSONObject countJson = new JSONObject();
        if (userDefined != null && !StringUtil.isBlank((String)(usualStartMenus = userDefined.getUsualStartMenus()))) {
            JSONArray list = JsonTmpUtil.fromObject((Object)usualStartMenus);
            for (JSONObject json : list) {
                String menuId = (String)json.get("menuId");
                String count = (String)json.get("count");
                countJson.put((Object)menuId, (Object)count);
                usualStartMenuIds.add(menuId);
            }
        }
        for (ResourceVO resourceVO : resources) {
            boolean isAllow;
            if (resourceVO.getShowType() == 1 || 0 == resourceVO.getStatus() || resourceVO.getType() != null && !isMobile && resourceVO.getType().equals("100")) continue;
            if (!(ResourceVO.LinkType.FORM.getCode().equals(resourceVO.getLinkType()) || isUsual || isUsualList)) {
                String id = resourceVO.getId();
                List<ResourceVO> list = new ArrayList<ResourceVO>();
                if ((list = this.getAllChildrenResource(id, treeMap, list)) != null) {
                    ArrayList<ResourceVO> listTemp = new ArrayList<ResourceVO>();
                    listTemp.addAll(list);
                    for (ResourceVO resourceVO2 : listTemp) {
                        boolean isAllow2;
                        if (StringUtil.isBlank((String)resourceVO2.getLinkType()) || !resourceVO2.getLinkType().equals(ResourceVO.LinkType.FORM.getCode()) || resourceVO2.getShowType() == 1) {
                            if (isMobile) {
                                if (resourceVO2.getLinkType().equals(ResourceVO.LinkType.VIEW.getCode())) continue;
                                list.remove(resourceVO2);
                                continue;
                            }
                            list.remove(resourceVO2);
                            continue;
                        }
                        if (!"private".equals(resourceVO2.getPermissionType()) || (isAllow2 = PermissionUtil.check((String[])roleids, (String)resourceVO2.getId(), (String)resourceVO2.getId(), (int)1002))) continue;
                        list.remove(resourceVO2);
                    }
                }
                if (list == null || list.isEmpty()) continue;
            }
            if ("private".equals(resourceVO.getPermissionType()) && !(isAllow = PermissionUtil.check((String[])roleids, (String)resourceVO.getId(), (String)resourceVO.getId(), (int)1002))) continue;
            if (!StringUtil.isBlank((String)resourceVO.getMultiLanguageLabel())) {
                String multiLangTag = resourceVO.getName();
                String multiLanguageLabel = resourceVO.getMultiLanguageLabel();
                String labelHex = URLEncoder.encode(multiLanguageLabel);
                String nameHex = URLEncoder.encode(multiLangTag);
                multiLangTag = "{*[" + labelHex + "^" + nameHex + "^true]*}";
                resourceVO.setDescription(multiLangTag);
            }
            StartMenuNode startMenuNode = this.resourceAdapter(resourceVO);
            boolean isExist = false;
            if (!usualStartMenuIds.isEmpty()) {
                String count = (String)countJson.get(startMenuNode.getId());
                if (!StringUtil.isBlank((String)count)) {
                    startMenuNode.setOrderNo(count);
                    isExist = true;
                    startMenuNode.setUsual(isExist);
                }
            } else if (resourceVO.getIsUsual().equals("true")) {
                isExist = true;
            }
            if (isUsual) {
                if (!StringUtil.isBlank((String)resourceVO.getShowtotalrow()) && Boolean.valueOf(resourceVO.getShowtotalrow()).booleanValue()) {
                    startMenuNode.setTotalRow(this.getTotalRowByResource(resourceVO, new ParamsTable(), user));
                }
                if (!isExist) {
                    continue;
                }
            } else {
                startMenuNode.setUsual(isExist);
            }
            arr.add(startMenuNode);
        }
        if (isUsual) {
            MyCompartor2 mc = new MyCompartor2();
            Collections.sort(arr, mc);
        }
        return arr;
    }

    private List<ResourceVO> getAllChildrenResource(String parentId, Map<String, List<ResourceVO>> treeMap, List<ResourceVO> resourceVOs) throws Exception {
        List<ResourceVO> resourceTemps = treeMap.get(parentId);
        if (resourceTemps != null) {
            for (ResourceVO resourceVO : resourceTemps) {
                this.getAllChildrenResource(resourceVO.getId(), treeMap, resourceVOs);
                resourceVOs.add(resourceVO);
            }
        }
        return resourceVOs;
    }

    private StartMenuNode resourceAdapter(ResourceVO resourceVO) {
        StartMenuNode result = new StartMenuNode();
        String icoStr = resourceVO.getIco();
        JSONObject icoStrJson = new JSONObject();
        if (!StringUtil.isBlank((String)icoStr)) {
            icoStrJson = JSONObject.fromObject((Object)icoStr);
        }
        result.setId(resourceVO.getId());
        if (ResourceVO.LinkType.VIEW.getCode().equals(resourceVO.getLinkType())) {
            result.setViewId(resourceVO.getActionContent());
        } else {
            result.setFormId(resourceVO.getActionContent());
        }
        result.setParent(resourceVO.getParentId());
        result.setDescription(!StringUtil.isBlank((String)resourceVO.getDescription()) ? resourceVO.getDescription() : resourceVO.getName());
        result.setIco(icoStrJson);
        result.setQueryString(resourceVO.getQueryString());
        return result;
    }

    @Override
    public List<Map<String, Object>> getPendingNavs(String applicationId, IUser user) throws Exception {
        String domainId = user.getDomainid();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        ApplicationDesignTimeService appService = DesignTimeServiceManager.applicationDesignTimeService();
        BillDefiDesignTimeService bp = DesignTimeServiceManager.billDefiDesignTimeService();
        List apps = appService.getListByWebUser(user);
        if (StringUtil.isBlank((String)applicationId)) {
            for (Application applicationVO : apps) {
                HashMap<String, Object> applicationVOInfo = new HashMap<String, Object>();
                WorkProcessBean process = new WorkProcessBean(applicationVO.getId());
                Collection<Map<String, Object>> pendingFlowList = ((WorkProcess)process).getPendingFlowList(true, applicationVO.getId(), domainId, user);
                if (pendingFlowList.size() <= 1) continue;
                Collection flows = bp.getBillDefiByApplication(applicationId);
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                for (BillDefiVO billDefiVO : flows) {
                    map.put(billDefiVO.getId(), billDefiVO.getBilldefiNo());
                }
                for (Map map2 : pendingFlowList) {
                    String order = (String)map.get(map2.get("id"));
                    map2.put("order", order);
                }
                applicationVOInfo.put("name", applicationVO.getName());
                applicationVOInfo.put("id", applicationVO.getId());
                applicationVOInfo.put("pendingFlowList", pendingFlowList);
                result.add(applicationVOInfo);
            }
        } else {
            Application applicationVO = (Application)appService.findById(applicationId);
            if (applicationVO != null) {
                Collection flows = bp.getBillDefiByApplication(applicationId);
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                for (BillDefiVO bv : flows) {
                    map.put(bv.getId(), bv.getBilldefiNo());
                }
                HashMap<String, Object> applicationVOInfo = new HashMap<String, Object>();
                WorkProcessBean process = new WorkProcessBean(applicationId);
                Collection<Map<String, Object>> pendingFlowList = ((WorkProcess)process).getPendingFlowList(true, applicationId, domainId, user);
                applicationVOInfo.put("name", applicationVO.getName());
                applicationVOInfo.put("id", applicationVO.getId());
                for (Map<String, Object> objectMap : pendingFlowList) {
                    String string = (String)map.get(objectMap.get("id"));
                    objectMap.put("order", string);
                }
                applicationVOInfo.put("pendingFlowList", pendingFlowList);
                result.add(applicationVOInfo);
            }
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> getProcessedNavs(String applicationId, IUser user) throws Exception {
        String domainId = user.getDomainid();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        ApplicationDesignTimeService appService = DesignTimeServiceManager.applicationDesignTimeService();
        BillDefiDesignTimeService bp = DesignTimeServiceManager.billDefiDesignTimeService();
        List apps = appService.getListByWebUser(user);
        if (StringUtil.isBlank((String)applicationId)) {
            for (Application applicationVO : apps) {
                HashMap<String, Object> applicationVOInfo = new HashMap<String, Object>();
                WorkProcessBean process = new WorkProcessBean(applicationVO.getId());
                Collection<Map<String, Object>> processedFlowList = ((WorkProcess)process).getProcessedRunningFlowList(applicationVO.getId(), domainId, user);
                if (processedFlowList.size() <= 1) continue;
                Collection flows = bp.getBillDefiByApplication(applicationId);
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                for (BillDefiVO billDefiVO : flows) {
                    map.put(billDefiVO.getId(), billDefiVO.getBilldefiNo());
                }
                for (Map map2 : processedFlowList) {
                    String order = (String)map.get(map2.get("id"));
                    map2.put("order", order);
                }
                applicationVOInfo.put("name", applicationVO.getName());
                applicationVOInfo.put("id", applicationVO.getId());
                applicationVOInfo.put("processedFlowList", processedFlowList);
                result.add(applicationVOInfo);
            }
        } else {
            for (Application applicationVO : apps) {
                Collection flows = bp.getBillDefiByApplication(applicationId);
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                for (BillDefiVO bv : flows) {
                    map.put(bv.getId(), bv.getBilldefiNo());
                }
                HashMap<String, Object> applicationVOInfo = new HashMap<String, Object>();
                WorkProcessBean process = new WorkProcessBean(applicationId);
                Collection<Map<String, Object>> processedFlowList = ((WorkProcess)process).getProcessedRunningFlowList(applicationId, domainId, user);
                if (processedFlowList.size() <= 1) continue;
                applicationVOInfo.put("name", applicationVO.getName());
                applicationVOInfo.put("id", applicationVO.getId());
                for (Map<String, Object> map3 : processedFlowList) {
                    String order = (String)map.get(map3.get("id"));
                    map3.put("order", order);
                }
                applicationVOInfo.put("processedFlowList", processedFlowList);
                result.add(applicationVOInfo);
            }
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> getCarboncopyNavs(String applicationId, IUser user, boolean isRead) throws Exception {
        String domainId = user.getDomainid();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        ApplicationDesignTimeService appService = DesignTimeServiceManager.applicationDesignTimeService();
        List apps = appService.getListByWebUser(user);
        if (StringUtil.isBlank((String)applicationId)) {
            for (Application applicationVO : apps) {
                HashMap<String, Object> applicationVOInfo = new HashMap<String, Object>();
                WorkProcessBean process = new WorkProcessBean(applicationVO.getId());
                Collection<Map<String, Object>> processedFlowList = ((WorkProcess)process).getCarboncopyRunningFlowList(applicationVO.getId(), domainId, user, isRead);
                if (processedFlowList.size() <= 1) continue;
                applicationVOInfo.put("name", applicationVO.getName());
                applicationVOInfo.put("id", applicationVO.getId());
                applicationVOInfo.put("carboncopyFlowList", processedFlowList);
                result.add(applicationVOInfo);
            }
        } else {
            for (Application applicationVO : apps) {
                HashMap<String, Object> applicationVOInfo = new HashMap<String, Object>();
                WorkProcessBean process = new WorkProcessBean(applicationId);
                Collection<Map<String, Object>> processedFlowList = ((WorkProcess)process).getCarboncopyRunningFlowList(applicationId, domainId, user, isRead);
                if (processedFlowList.size() <= 1) continue;
                applicationVOInfo.put("name", applicationVO.getName());
                applicationVOInfo.put("id", applicationVO.getId());
                applicationVOInfo.put("carboncopyFlowList", processedFlowList);
                result.add(applicationVOInfo);
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> getPendings(String applicationId, String title, String flowId, String initiatorId, String flowname, Integer pageNo, Integer linesPerPage, IUser user, boolean isMobile) throws Exception {
        pageNo = pageNo == null || pageNo <= 0 ? 1 : pageNo;
        linesPerPage = linesPerPage == null || linesPerPage <= 0 ? 10 : linesPerPage;
        WorkProcessBean process = new WorkProcessBean(applicationId);
        DataPackage<WorkVO> pendingList = ((WorkProcess)process).getPendingList(title, initiatorId, flowId, true, applicationId, user.getDomainid(), flowname, pageNo, linesPerPage, user);
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList datasList = new ArrayList();
        FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
        for (WorkVO workVO : pendingList.datas) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String auditorList = workVO.getAuditorList();
            JSONArray auditorListJson = null;
            try {
                Form form;
                if (!StringUtil.isBlank((String)auditorList)) {
                    auditorListJson = JsonTmpUtil.fromObject((Object)auditorList);
                }
                if ((form = formService.doView(workVO.getFormId())) != null) {
                    if (!StringUtil.isBlank((String)form.getDescription())) {
                        map.put("formName", form.getDescription());
                    } else {
                        map.put("formName", form.getName());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            map.put("applicationId", workVO.getApplicationId());
            map.put("auditorList", auditorListJson);
            map.put("auditorNames", workVO.getAuditorNames());
            map.put("initiatorId", workVO.getInitiatorId());
            map.put("initiator", workVO.getInitiator());
            map.put("initiatorDeptId", workVO.getInitiatorDeptId());
            map.put("initiatorDept", workVO.getInitiatorDept());
            map.put("firstProcessTime", workVO.getFirstProcessTime());
            map.put("actionTime", workVO.getActionTime());
            map.put("lastProcessTime", workVO.getLastProcessTime());
            map.put("lastFlowOperation", workVO.getLastFlowOperation());
            map.put("formId", workVO.getFormId());
            map.put("flowName", workVO.getFlowName());
            map.put("flowId", workVO.getFlowId());
            map.put("docId", workVO.getDocId());
            map.put("read", workVO.getRead());
            map.put("stateLabel", workVO.getStateLabel());
            map.put("subject", workVO.getSubject());
            datasList.add(map);
        }
        result.put("datas", datasList);
        result.put("linesPerPage", pendingList.getLinesPerPage());
        result.put("pageCount", pendingList.getPageCount());
        result.put("pageNo", pendingList.getPageNo());
        result.put("rowCount", pendingList.getRowCount());
        return result;
    }

    @Override
    public Map<String, Object> getProcesseds(String applicationId, String title, String flowId, String initiatorId, boolean isMyWorkFlow, String status, String flowname, Integer pageNo, Integer linesPerPage, IUser user) throws Exception {
        status = "all".equals(status) ? null : status;
        pageNo = pageNo == null || pageNo <= 0 ? 1 : pageNo;
        linesPerPage = linesPerPage == null || linesPerPage <= 0 ? 10 : linesPerPage;
        WorkProcessBean process = new WorkProcessBean(applicationId);
        DataPackage<WorkVO> processedList = ((WorkProcess)process).getProcessedRunningList(title, initiatorId, flowId, applicationId, user.getDomainid(), isMyWorkFlow, status, flowname, pageNo, linesPerPage, user);
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList datasList = new ArrayList();
        FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
        for (WorkVO workVO : processedList.datas) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String auditorList = workVO.getAuditorList();
            JSONArray auditorListJson = null;
            try {
                Form form;
                if (!StringUtil.isBlank((String)auditorList)) {
                    auditorListJson = JsonTmpUtil.fromObject((Object)auditorList);
                }
                if ((form = formService.doView(workVO.getFormId())) != null) {
                    if (!StringUtil.isBlank((String)form.getDescription())) {
                        map.put("formName", form.getDescription());
                    } else {
                        map.put("formName", form.getName());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            map.put("applicationId", workVO.getApplicationId());
            map.put("auditorList", auditorListJson);
            map.put("auditorNames", workVO.getAuditorNames());
            map.put("initiatorId", workVO.getInitiatorId());
            map.put("initiator", workVO.getInitiator());
            map.put("initiatorDeptId", workVO.getInitiatorDeptId());
            map.put("initiatorDept", workVO.getInitiatorDept());
            map.put("firstProcessTime", workVO.getFirstProcessTime());
            map.put("lastProcessTime", workVO.getLastProcessTime());
            map.put("lastFlowOperation", workVO.getLastFlowOperation());
            map.put("formId", workVO.getFormId());
            map.put("flowName", workVO.getFlowName());
            map.put("flowId", workVO.getFlowId());
            map.put("docId", workVO.getDocId());
            map.put("stateLabel", workVO.getStateLabel());
            map.put("subject", workVO.getSubject());
            datasList.add(map);
        }
        result.put("datas", datasList);
        result.put("linesPerPage", processedList.getLinesPerPage());
        result.put("pageCount", processedList.getPageCount());
        result.put("pageNo", processedList.getPageNo());
        result.put("rowCount", processedList.getRowCount());
        return result;
    }

    @Override
    public Map<String, Object> carboncopy(String applicationId, String title, String flowId, String initiatorId, boolean platformMode, boolean isRead, String flowname, Integer pageNo, Integer linesPerPage, IUser user) throws Exception {
        pageNo = pageNo == null || pageNo <= 0 ? 1 : pageNo;
        linesPerPage = linesPerPage == null || linesPerPage <= 0 ? 10 : linesPerPage;
        WorkProcessBean process = new WorkProcessBean(applicationId);
        DataPackage<WorkVO> processedList = ((WorkProcess)process).carboncopy(title, initiatorId, flowId, applicationId, user.getDomainid(), platformMode, isRead, flowname, pageNo, linesPerPage, user);
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList datasList = new ArrayList();
        FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
        for (WorkVO workVO : processedList.datas) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String auditorList = workVO.getAuditorList();
            JSONArray auditorListJson = null;
            try {
                Form form;
                if (!StringUtil.isBlank((String)auditorList)) {
                    auditorListJson = JsonTmpUtil.fromObject((Object)auditorList);
                }
                if ((form = formService.doView(workVO.getFormId())) != null) {
                    if (!StringUtil.isBlank((String)form.getDescription())) {
                        map.put("formName", form.getDescription());
                    } else {
                        map.put("formName", form.getName());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            map.put("applicationId", workVO.getApplicationId());
            map.put("auditorList", auditorListJson);
            map.put("auditorNames", workVO.getAuditorNames());
            map.put("initiatorId", workVO.getInitiatorId());
            map.put("initiator", workVO.getInitiator());
            map.put("initiatorDeptId", workVO.getInitiatorDeptId());
            map.put("initiatorDept", workVO.getInitiatorDept());
            map.put("firstProcessTime", workVO.getFirstProcessTime());
            map.put("lastProcessTime", workVO.getLastProcessTime());
            map.put("lastFlowOperation", workVO.getLastFlowOperation());
            map.put("formId", workVO.getFormId());
            map.put("flowName", workVO.getFlowName());
            map.put("flowId", workVO.getFlowId());
            map.put("docId", workVO.getDocId());
            map.put("read", workVO.getRead());
            map.put("stateLabel", workVO.getStateLabel());
            map.put("subject", workVO.getSubject());
            datasList.add(map);
        }
        result.put("datas", datasList);
        result.put("linesPerPage", processedList.getLinesPerPage());
        result.put("pageCount", processedList.getPageCount());
        result.put("pageNo", processedList.getPageNo());
        result.put("rowCount", processedList.getRowCount());
        return result;
    }

    private String getTotalRowByResource(ResourceVO resource, ParamsTable params, IUser user) {
        try {
            if (resource.getLinkType().equals(ResourceVO.LinkType.VIEW.getCode())) {
                if (resource.getActionContent() == null || resource.getActionContent().equals("")) {
                    return "0";
                }
                ViewDesignTimeService vProcess = DesignTimeServiceManager.viewDesignTimeService();
                AbstractView view = vProcess.doView(resource.getActionContent());
                if (view != null) {
                    long count = view.getViewTypeImpl().countViewDatas(params, user, new Document());
                    return String.valueOf(count);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "0";
    }

    private class MyCompartor2
    implements Comparator {
        private MyCompartor2() {
        }

        public int compare(Object o1, Object o2) {
            StartMenuNode c1 = (StartMenuNode)o1;
            StartMenuNode c2 = (StartMenuNode)o2;
            return c2.getOrderNo().compareTo(c1.getOrderNo());
        }
    }
}

