/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.flowcenter.controller;

import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.authtime.user.model.UserDefined;
import cn.myapps.authtime.user.service.UserDefinedProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.resource.StartMenuNode;
import cn.myapps.common.util.StringUtil;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.runtime.flowcenter.service.FlowCenterRumTimeService;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowRuntimeServiceImpl;
import cn.myapps.util.ProcessFactory;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u6d41\u7a0b\u4e2d\u5fc3\u6267\u884c\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/runtime"}, produces={"application/json;charset=UTF-8"})
public class FlowCenterRunTimeController
extends AbstractRuntimeController {
    @Autowired
    private FlowCenterRumTimeService flowCenterService;

    @GetMapping(value={"/{applicationId}/flowcenters/startmenus"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u53d1\u8d77\u83dc\u5355", notes="\u83b7\u53d6\u53d1\u8d77\u83dc\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="isUsual", value="\u662f\u5426\u5e38\u7528", required=false, paramType="query", dataType="boolean"), @ApiImplicitParam(name="isUsualList", value="\u662f\u5426\u5e38\u7528\u7684\u6dfb\u52a0\u5217\u8868", required=false, paramType="query", dataType="boolean"), @ApiImplicitParam(name="isMobile", value="\u662f\u5426\u79fb\u52a8\u7aef", required=false, paramType="query", dataType="string")})
    public Resource getStartMenus(@PathVariable String applicationId, @RequestParam(required=false) boolean isUsual, @RequestParam(required=false) boolean isUsualList, @RequestParam(required=false) boolean isMobile) throws Exception {
        List<StartMenuNode> result = this.flowCenterService.getStartMenus(applicationId, isMobile, isUsual, isUsualList, (IUser)this.getUser());
        return this.success("ok", result);
    }

    @GetMapping(value={"/flowcenters/navs/pendings"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u5f85\u529e\u5bfc\u822a", notes="\u83b7\u53d6\u5f85\u529e\u5bfc\u822a")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=false, paramType="query", dataType="string")})
    public Resource getPendingNavs(@RequestParam(required=false) String applicationId) throws Exception {
        List<Map<String, Object>> result = this.flowCenterService.getPendingNavs(applicationId, (IUser)this.getUser());
        return this.success("ok", result);
    }

    @GetMapping(value={"/flowcenters/navs/processeds"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u7ecf\u529e\u5bfc\u822a", notes="\u83b7\u53d6\u7ecf\u529e\u5bfc\u822a")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=false, paramType="query", dataType="string")})
    public Resource getProcessedNavs(@RequestParam(required=false) String applicationId) throws Exception {
        List<Map<String, Object>> result = this.flowCenterService.getProcessedNavs(applicationId, (IUser)this.getUser());
        return this.success("ok", result);
    }

    @GetMapping(value={"/flowcenters/navs/carboncopy"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u6284\u9001\u5bfc\u822a", notes="\u83b7\u53d6\u6284\u9001\u5bfc\u822a")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=false, paramType="query", dataType="string")})
    public Resource getCarboncopyNavs(@RequestParam(required=false) String applicationId, @RequestParam(required=false) boolean isread) throws Exception {
        List<Map<String, Object>> result = this.flowCenterService.getCarboncopyNavs(applicationId, (IUser)this.getUser(), isread);
        return this.success("ok", result);
    }

    @GetMapping(value={"/{applicationId}/flowcenters/pendings"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u5f85\u529e\u6570\u636e", notes="\u83b7\u53d6\u5f85\u529e\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="title", value="\u4e3b\u9898\u5185\u5bb9", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="initiatorId", value="\u53d1\u8d77\u4ebaid", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="flowId", value="\u6d41\u7a0bid", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="flowname", value="\u6d41\u7a0b\u540d\u79f0", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="pageNo", value="\u5f53\u524d\u9875", required=false, paramType="query", dataType="int", defaultValue="1"), @ApiImplicitParam(name="linesPerPage", value="\u6bcf\u9875\u663e\u793a\u6761\u6570", required=false, paramType="query", dataType="int", defaultValue="5"), @ApiImplicitParam(name="isMobile", value="\u662f\u5426\u79fb\u52a8\u7aef", required=false, paramType="query", dataType="boolean")})
    public Resource getPendings(@PathVariable String applicationId, @RequestParam(required=false) String title, @RequestParam(required=false) String initiatorId, @RequestParam(required=false) String flowId, @RequestParam(required=false) String flowname, @RequestParam(required=false, defaultValue="1") Integer pageNo, @RequestParam(required=false, defaultValue="10") Integer linesPerPage, @RequestParam(required=false) boolean isMobile) throws Exception {
        if (!StringUtil.isBlank((String)title)) {
            title = title.replace("%", "&#37;");
        }
        Map<String, Object> result = this.flowCenterService.getPendings(applicationId, title, flowId, initiatorId, flowname, pageNo, linesPerPage, (IUser)this.getUser(), isMobile);
        return this.success("ok", result);
    }

    @GetMapping(value={"/flowcenters/pendings/allRead"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6807\u8bb0\u6240\u6709\u5f85\u529e\u4e3a\u5df2\u8bfb", notes="\u6807\u8bb0\u6240\u6709\u5f85\u529e\u4e3a\u5df2\u8bfb")
    @ApiImplicitParams(value={})
    public Resource allRead() throws Exception {
        try {
            WebUser user = this.getUser();
            DomainProcess domainProcess = (DomainProcess)ProcessFactory.createProcess(DomainProcess.class);
            DomainVO domain = (DomainVO)domainProcess.doView(user.getDomainid());
            Collection bindApplications = domain.getApplications();
            for (Application vo : bindApplications) {
                FlowRuntimeServiceImpl flowRuntimeService = new FlowRuntimeServiceImpl(vo.getId());
                flowRuntimeService.allRead(user.getId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
        return this.success("ok", "success");
    }

    @GetMapping(value={"/{applicationId}/flowcenters/processeds"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u7ecf\u529e\u6570\u636e", notes="\u83b7\u53d6\u7ecf\u529e\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="title", value="\u4e3b\u9898\u5185\u5bb9", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="flowId", value="\u6d41\u7a0bid", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="initiatorId", value="\u53d1\u8d77\u4ebaid", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="flowname", value="\u6d41\u7a0b\u540d\u79f0", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="isMyWorkFlow", value="\u662f\u5426\u6211\u5904\u7406", required=false, paramType="query", dataType="boolean"), @ApiImplicitParam(name="status", value="\u5b8c\u6210\u72b6\u6001", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="pageNo", value="\u5f53\u524d\u9875", required=false, paramType="query", dataType="int", defaultValue="1"), @ApiImplicitParam(name="linesPerPage", value="\u6bcf\u9875\u663e\u793a\u6761\u6570", required=false, paramType="query", dataType="int", defaultValue="5")})
    public Resource getProcesseds(@PathVariable String applicationId, @RequestParam(required=false) String title, @RequestParam(required=false) String flowId, @RequestParam(required=false) String initiatorId, @RequestParam(required=false) String flowname, @RequestParam(required=false) boolean isMyWorkFlow, @RequestParam(required=false) String status, @RequestParam(required=false, defaultValue="1") Integer pageNo, @RequestParam(required=false, defaultValue="10") Integer linesPerPage) throws Exception {
        if (!StringUtil.isBlank((String)title)) {
            title = title.replace("%", "&#37;");
        }
        Map<String, Object> result = this.flowCenterService.getProcesseds(applicationId, title, flowId, initiatorId, isMyWorkFlow, status, flowname, pageNo, linesPerPage, (IUser)this.getUser());
        return this.success("ok", result);
    }

    @GetMapping(value={"/{applicationId}/flowcenters/carboncopy"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u6284\u9001\u6570\u636e", notes="\u83b7\u53d6\u6284\u9001\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="title", value="\u4e3b\u9898\u5185\u5bb9", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="flowId", value="\u6d41\u7a0bid", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="initiatorId", value="\u53d1\u8d77\u4ebaid", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="flowname", value="\u6d41\u7a0b\u540d\u79f0", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="isMyWorkFlow", value="\u662f\u5426\u6211\u5904\u7406", required=false, paramType="query", dataType="boolean"), @ApiImplicitParam(name="isRead", value="\u662f\u5426\u5df2\u8bfb", required=false, paramType="query", dataType="boolean"), @ApiImplicitParam(name="pageNo", value="\u5f53\u524d\u9875", required=false, paramType="query", dataType="int", defaultValue="1"), @ApiImplicitParam(name="linesPerPage", value="\u6bcf\u9875\u663e\u793a\u6761\u6570", required=false, paramType="query", dataType="int", defaultValue="5")})
    public Resource getCarboncopy(@PathVariable String applicationId, @RequestParam(required=false) String title, @RequestParam(required=false) String flowId, @RequestParam(required=false) String initiatorId, @RequestParam(required=false) String flowname, @RequestParam(required=false) boolean isMyWorkFlow, @RequestParam(required=false) boolean isRead, @RequestParam(required=false, defaultValue="1") Integer pageNo, @RequestParam(required=false, defaultValue="10") Integer linesPerPage) throws Exception {
        if (!StringUtil.isBlank((String)title)) {
            title = title.replace("%", "&#37;");
        }
        Map<String, Object> result = this.flowCenterService.carboncopy(applicationId, title, flowId, initiatorId, false, isRead, flowname, pageNo, linesPerPage, (IUser)this.getUser());
        return this.success("ok", result);
    }

    @PostMapping(value={"/{applicationId}/flowcenters/startMenus/{id}/usual"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u65b0\u5efa\u5e38\u7528\u53d1\u8d77\u83dc\u5355", notes="\u65b0\u5efa\u5e38\u7528\u53d1\u8d77\u83dc\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="id", value="\u53d1\u8d77\u83dc\u5355id", required=true, paramType="path", dataType="string")})
    public Resource createUsualStartMenu(@PathVariable String applicationId, @PathVariable String id) throws Exception {
        WebUser user = this.getUser();
        UserDefinedProcess userDefinedProcess = (UserDefinedProcess)ProcessFactory.createProcess(UserDefinedProcess.class);
        UserDefined userDefined = userDefinedProcess.doFindMyCustomUserDefined((IUser)user);
        if (userDefined != null) {
            String usualStartMenus = userDefined.getUsualStartMenus();
            if (!StringUtil.isBlank((String)usualStartMenus)) {
                JSONArray list = JSONArray.parseArray((String)usualStartMenus);
                JSONObject json = new JSONObject();
                json.put("menuId", (Object)id);
                json.put("count", (Object)"1");
                list.add((Object)json);
                userDefined.setUsualStartMenus(list.toString());
                userDefinedProcess.doUpdate((AuthtimeValueObject)userDefined);
            } else {
                JSONArray list = new JSONArray();
                JSONObject json = new JSONObject();
                json.put("menuId", (Object)id);
                json.put("count", (Object)"1");
                list.add((Object)json);
                userDefined.setUsualStartMenus(list.toString());
                userDefinedProcess.doUpdate((AuthtimeValueObject)userDefined);
            }
        } else {
            userDefined = new UserDefined();
            userDefined.setApplicationid(applicationId);
            userDefined.setCreator(user.getName());
            userDefined.setDefineMode(Integer.valueOf(16));
            userDefined.setUserId(user.getId());
            userDefined.setPublished(true);
            userDefined.setUsedDefined(Integer.valueOf(0));
            JSONArray list = new JSONArray();
            JSONObject json = new JSONObject();
            json.put("menuId", (Object)id);
            json.put("count", (Object)"1");
            list.add((Object)json);
            userDefined.setUsualStartMenus(list.toString());
            userDefinedProcess.doCreate((AuthtimeValueObject)userDefined);
        }
        return this.success("ok", "\u6210\u529f");
    }

    @PutMapping(value={"/{applicationId}/flowcenters/startMenus/{id}/usual"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u65b0\u5e38\u7528\u53d1\u8d77\u83dc\u5355", notes="\u66f4\u65b0\u5e38\u7528\u53d1\u8d77\u83dc\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="id", value="\u53d1\u8d77\u83dc\u5355id", required=true, paramType="path", dataType="string")})
    public Resource updateUsualStartMenu(@PathVariable String applicationId, @PathVariable String id) throws Exception {
        WebUser user = this.getUser();
        UserDefinedProcess userDefinedProcess = (UserDefinedProcess)ProcessFactory.createProcess(UserDefinedProcess.class);
        UserDefined userDefined = userDefinedProcess.doFindMyCustomUserDefined((IUser)user);
        if (userDefined != null) {
            String usualStartMenus = userDefined.getUsualStartMenus();
            if (!StringUtil.isBlank((String)usualStartMenus)) {
                JSONArray list = JSONArray.parseArray((String)usualStartMenus);
                for (JSONObject json : list) {
                    String menuId = (String)json.get((Object)"menuId");
                    String count = (String)json.get((Object)"count");
                    int orderNo = Integer.valueOf(count);
                    if (!menuId.equals(id)) continue;
                    json.put("count", (Object)(++orderNo + ""));
                }
                userDefined.setUsualStartMenus(list.toString());
            } else {
                JSONArray list = new JSONArray();
                List<StartMenuNode> result = this.flowCenterService.getStartMenus(applicationId, true, true, true, (IUser)this.getUser());
                for (StartMenuNode startMenuNode : result) {
                    JSONObject json = new JSONObject();
                    json.put("menuId", (Object)startMenuNode.getId());
                    if (id.equals(startMenuNode.getId())) {
                        json.put("count", (Object)"1");
                    } else {
                        json.put("count", (Object)"0");
                    }
                    list.add((Object)json);
                }
                userDefined.setUsualStartMenus(list.toString());
            }
            userDefinedProcess.doUpdate((AuthtimeValueObject)userDefined);
        } else {
            userDefined = new UserDefined();
            userDefined.setApplicationid(applicationId);
            userDefined.setCreator(user.getName());
            userDefined.setDefineMode(Integer.valueOf(16));
            userDefined.setUserId(user.getId());
            userDefined.setPublished(true);
            userDefined.setUsedDefined(Integer.valueOf(0));
            JSONArray list = new JSONArray();
            List<StartMenuNode> result = this.flowCenterService.getStartMenus(applicationId, true, true, true, (IUser)this.getUser());
            for (StartMenuNode startMenuNode : result) {
                JSONObject json = new JSONObject();
                json.put("menuId", (Object)startMenuNode.getId());
                if (id.equals(startMenuNode.getId())) {
                    json.put("count", (Object)"1");
                } else {
                    json.put("count", (Object)"0");
                }
                list.add((Object)json);
            }
            userDefined.setUsualStartMenus(list.toString());
            userDefinedProcess.doCreate((AuthtimeValueObject)userDefined);
        }
        return this.success("ok", "\u6210\u529f");
    }

    @DeleteMapping(value={"/{applicationId}/flowcenters/startMenus/{id}/usual"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u5e38\u7528\u53d1\u8d77\u83dc\u5355", notes="\u5220\u9664\u5e38\u7528\u53d1\u8d77\u83dc\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="id", value="\u53d1\u8d77\u83dc\u5355id", required=true, paramType="path", dataType="string")})
    public Resource removeUsualStartMenuTimes(@PathVariable String applicationId, @PathVariable String id) throws Exception {
        WebUser user = this.getUser();
        UserDefinedProcess userDefinedProcess = (UserDefinedProcess)ProcessFactory.createProcess(UserDefinedProcess.class);
        UserDefined userDefined = userDefinedProcess.doFindMyCustomUserDefined((IUser)user);
        if (userDefined != null) {
            String usualStartMenus = userDefined.getUsualStartMenus();
            if (!StringUtil.isBlank((String)usualStartMenus)) {
                JSONArray list = JSONArray.parseArray((String)usualStartMenus);
                JSONArray result = new JSONArray();
                result.addAll((Collection)list);
                for (JSONObject json : list) {
                    String menuId = (String)json.get((Object)"menuId");
                    if (!menuId.equals(id)) continue;
                    result.remove((Object)json);
                }
                userDefined.setUsualStartMenus(result.toString());
            }
            userDefinedProcess.doUpdate((AuthtimeValueObject)userDefined);
        }
        return this.success("ok", "\u6210\u529f");
    }
}

