/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.excutor.async;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.datasource.DataSource;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.runtime.common.dao.WrapConnection;
import cn.myapps.runtime.excutor.async.RuntimeDaoCommand;
import cn.myapps.runtime.excutor.async.RuntimeDaoCommandGroup;
import com.bcxin.saas.core.exceptions.SaasNofoundException;
import com.jamonapi.proxy.MonProxyFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeDaoCommandExecutor {
    private Logger logger = LoggerFactory.getLogger(RuntimeDaoCommandExecutor.class);
    private RuntimeDaoCommandGroup commandGroup;

    public RuntimeDaoCommandExecutor(RuntimeDaoCommandGroup commandGroup) {
        this.commandGroup = commandGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execCommandGroup() throws SQLException {
        ConcurrentHashMap connMap = PersistenceUtils.getRuntimeDBConn().get();
        if (connMap == null) {
            connMap = new ConcurrentHashMap();
        }
        try {
            for (RuntimeDaoCommand command : this.commandGroup.getCommandList()) {
                this.execCommand(command);
            }
            for (WrapConnection conn : connMap.values()) {
                conn.commit();
                conn.setAutoCommit(true);
            }
        }
        catch (Exception e) {
            for (WrapConnection conn : connMap.values()) {
                try {
                    conn.commit();
                    conn.setAutoCommit(true);
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                finally {
                    if (conn == null || conn.isClosed()) continue;
                    conn.close();
                }
            }
        }
    }

    private void execCommand(RuntimeDaoCommand command) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, Exception {
        this.logger.debug("Command Exec Begin: " + command);
        String clazzName = command.getClazzName();
        Class<?> clazz = Class.forName(clazzName);
        Object obj = clazz.newInstance();
        Method connMethod = clazz.getMethod("setConnection", WrapConnection.class);
        connMethod.invoke(obj, this.getConnection(command.getApplicationId()));
        Method[] methods = clazz.getMethods();
        Method method = null;
        for (int i = 0; i < methods.length; ++i) {
            boolean flag;
            if (!methods[i].getName().equals(command.getMethodName())) continue;
            Class<?>[] pClazzs = methods[i].getParameterTypes();
            boolean bl = flag = pClazzs.length == command.getArgs().length;
            if (!flag) continue;
            for (int j = 0; j < pClazzs.length; ++j) {
                if (pClazzs[j].isAssignableFrom(command.getArgs()[j].getClass()) || pClazzs[j].equals(Integer.TYPE) && command.getArgs()[j].getClass().equals(Integer.class) || pClazzs[j].equals(Float.TYPE) && command.getArgs()[j].getClass().equals(Float.class) || pClazzs[j].equals(Double.TYPE) && command.getArgs()[j].getClass().equals(Double.class) || pClazzs[j].equals(Character.TYPE) && command.getArgs()[j].getClass().equals(Character.class) || pClazzs[j].equals(Boolean.TYPE) && command.getArgs()[j].getClass().equals(Boolean.class) || pClazzs[j].equals(Long.TYPE) && command.getArgs()[j].getClass().equals(Long.class) || pClazzs[j].equals(Short.TYPE) && command.getArgs()[j].getClass().equals(Short.class) || pClazzs[j].equals(Byte.TYPE) && command.getArgs()[j].getClass().equals(Byte.class)) continue;
                flag = false;
            }
            if (!flag) continue;
            this.logger.debug("Command Execing... : " + command);
            method = methods[i];
        }
        if (method != null) {
            method.invoke(obj, command.getArgs());
        }
        this.logger.debug("Command Exec Finished: " + command);
    }

    private WrapConnection getConnection(String applicationId) throws Exception {
        WrapConnection conn = null;
        ConcurrentHashMap<String, WrapConnection> connMap = PersistenceUtils.getRuntimeDBConn().get();
        try {
            if (connMap != null) {
                conn = (WrapConnection)connMap.get(applicationId);
            } else {
                connMap = new ConcurrentHashMap<String, WrapConnection>();
                PersistenceUtils.getRuntimeDBConn().set(connMap);
            }
            if (conn == null || conn.isClosed()) {
                javax.sql.DataSource ds = this.getDataSource(applicationId);
                if (ds == null) {
                    return null;
                }
                conn = new WrapConnection(ds, ds.getConnection(), null, applicationId);
                connMap.put(applicationId, conn);
                if (conn.getMetaData().getDriverName().equals("jTDS Type 4 JDBC Driver for MS SQL Server and Sybase")) {
                    conn.setTransactionIsolation(1);
                }
            }
            conn.setAutoCommit(false);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return (WrapConnection)MonProxyFactory.monitor((Connection)conn);
    }

    private javax.sql.DataSource getDataSource(String applicationId) throws Exception {
        ApplicationDesignTimeService service = DesignTimeServiceManager.applicationDesignTimeService();
        Application app = (Application)service.findById(applicationId);
        if (app == null) {
            throw new SaasNofoundException(String.format("6.\u83b7\u53d6\u6570\u636e\u6e90\u7684\u65f6\u5019, \u627e\u4e0d\u5230\u5e94\u7528(%s)", applicationId));
        }
        DataSource ds = app.getDataSourceDefine();
        javax.sql.DataSource dataSource = PersistenceUtils.getDataSource((DataSource)ds);
        return dataSource;
    }
}

