/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.excutor.async;

import cn.myapps.common.dao.IRuntimeDAO;
import cn.myapps.common.model.ValueObject;
import cn.myapps.common.util.cache.EhcacheProvider;
import cn.myapps.common.util.cache.IMyCache;
import cn.myapps.common.util.cache.IMyElement;
import cn.myapps.common.util.cache.MyCacheManager;
import cn.myapps.runtime.common.dao.WrapConnection;
import cn.myapps.runtime.excutor.async.RuntimeDaoCommand;
import cn.myapps.runtime.excutor.async.RuntimeDaoCommandDispatch;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RelationHISDAOAspect {
    private Logger logger = LoggerFactory.getLogger(RelationHISDAOAspect.class);
    private static final String CACHE_KEY = "RUNTIME_DAO_CACHE_KEY";
    @Autowired
    private RuntimeDaoCommandDispatch commandExecutor;

    @Pointcut(value="(execution(public * cn.myapps.runtime.workflow.storage.runtime.dao.AbstractRelationHISDAO.*(..)))")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint pjp) {
        try {
            String methodName = pjp.getSignature().getName();
            if (methodName.equals("getConnection") || methodName.equals("setConnection")) {
                return pjp.proceed();
            }
            Object[] args = pjp.getArgs();
            IRuntimeDAO thisObj = (IRuntimeDAO)pjp.getTarget();
            String typeName = thisObj.getClass().getName().split("[$][$]")[0];
            WrapConnection wconn = thisObj.getConnection();
            String signLongString = pjp.getSignature().toString();
            int pos = signLongString.lastIndexOf(".");
            String signString = signLongString.substring(pos + 1, signLongString.length());
            this.logger.debug("MethodInterceptor ARROUND $${}--{}", (Object)pjp.getSignature(), (Object)signString);
            EhcacheProvider provider = (EhcacheProvider)MyCacheManager.getProviderInstance();
            IMyCache iMyCache = provider.getCache(CACHE_KEY);
            if (iMyCache == null) {
                iMyCache = provider.createCache(CACHE_KEY, 50000, false, false, 86400L, 86400L);
            }
            Object o = null;
            ValueObject vo = null;
            String key = null;
            switch (signString) {
                case "create(ValueObject)": {
                    this.asyncExecMethod(pjp, methodName, args, typeName, wconn);
                    vo = (ValueObject)args[0];
                    iMyCache.put((Object)vo.getId(), (Object)vo);
                    break;
                }
                case "update(ValueObject)": {
                    this.asyncExecMethod(pjp, methodName, args, typeName, wconn);
                    vo = (ValueObject)args[0];
                    iMyCache.put((Object)vo.getId(), (Object)vo);
                }
                case "remove(String)": {
                    this.asyncExecMethod(pjp, methodName, args, typeName, wconn);
                    key = (String)args[0];
                    iMyCache.remove((Object)key);
                    break;
                }
                case "find(String)": {
                    key = (String)args[0];
                    IMyElement element = iMyCache.get((Object)key);
                    Object object = o = element == null ? null : element.getValue();
                    if (element != null) break;
                    o = pjp.proceed();
                    iMyCache.put((Object)key, o);
                    break;
                }
                case "removeByDocument(String)": {
                    this.asyncExecMethod(pjp, methodName, args, typeName, wconn);
                    key = (String)args[0];
                    iMyCache.remove((Object)key);
                    break;
                }
                default: {
                    o = pjp.proceed();
                }
            }
            return o;
        }
        catch (Throwable e) {
            this.logger.error(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private void asyncExecMethod(ProceedingJoinPoint pjp, String methodName, Object[] args, String typeName, WrapConnection wconn) throws Throwable {
        if (RuntimeDaoCommandDispatch.initialized()) {
            this.commandExecutor.addToExecGroup(new RuntimeDaoCommand(typeName, methodName, args, wconn.getApplicationId()));
        } else {
            pjp.proceed();
        }
    }
}

