/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.excutor.async;

import cn.myapps.runtime.common.dao.WrapConnection;
import cn.myapps.runtime.excutor.async.RedisUtil;
import cn.myapps.runtime.excutor.async.RuntimeDaoCommand;
import cn.myapps.runtime.excutor.async.RuntimeDaoCommandDispatch;
import cn.myapps.runtime.workflow.storage.runtime.dao.AbstractFlowStateRTDAO;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowStateRT;
import java.util.Set;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class FlowStateRTDAOAspect {
    private Logger logger = LoggerFactory.getLogger(FlowStateRTDAOAspect.class);
    private static final String CACHE_KEY = "RUNTIME_DAO_CACHE_KEY";
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private RuntimeDaoCommandDispatch commandExecutor;

    @Pointcut(value="(execution(public * cn.myapps.runtime.workflow.storage.runtime.dao.AbstractFlowStateRTDAO.*(..)))")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint pjp) {
        try {
            String methodName = pjp.getSignature().getName();
            if (methodName.equals("getConnection") || methodName.equals("setConnection")) {
                return pjp.proceed();
            }
            Object[] args = pjp.getArgs();
            AbstractFlowStateRTDAO thisObj = (AbstractFlowStateRTDAO)pjp.getTarget();
            String typeName = thisObj.getClass().getName().split("[$][$]")[0];
            WrapConnection wconn = thisObj.getConnection();
            String signLongString = pjp.getSignature().toString();
            int pos = signLongString.lastIndexOf(".");
            String signString = signLongString.substring(pos + 1, signLongString.length());
            this.logger.debug("MethodInterceptor ARROUND $${}", (Object)signString);
            Object o = null;
            switch (signString) {
                case "create(FlowStateRT)": {
                    this.asyncExecMethod(pjp, methodName, args, typeName, wconn);
                    FlowStateRT flowState = (FlowStateRT)args[0];
                    if (flowState == null) break;
                    String id = flowState.getId();
                    String key = "FlowStateRT:" + id.replace("-", ":");
                    this.redisUtil.set(key, flowState, 0L);
                    break;
                }
                case "update(FlowStateRT)": {
                    this.asyncExecMethod(pjp, methodName, args, typeName, wconn);
                    FlowStateRT flowState = (FlowStateRT)args[0];
                    if (flowState == null) break;
                    String id = flowState.getId();
                    String key = "FlowStateRT:" + id.replace("-", ":");
                    this.redisUtil.set(key, flowState, 0L);
                    break;
                }
                case "remove(String)": {
                    this.asyncExecMethod(pjp, methodName, args, typeName, wconn);
                    String id = (String)args[0];
                    String key = "FlowStateRT:" + id.replace("-", ":");
                    o = this.redisUtil.get(key);
                    if (o == null) break;
                    this.redisUtil.del(key);
                    Set<String> nkeys = this.redisUtil.keys("NodeRT:" + id + "*");
                    for (String nkey : nkeys) {
                        this.redisUtil.del(nkey);
                    }
                    Set<String> akeys = this.redisUtil.keys("ActorRT:" + id + "*");
                    for (String akey : akeys) {
                        this.redisUtil.del(akey);
                    }
                    break;
                }
                case "find(String)": {
                    String id = (String)args[0];
                    String key = "FlowStateRT:" + id.replace("-", ":");
                    o = this.redisUtil.get(key);
                    if (o != null || (o = pjp.proceed()) == null) break;
                    this.redisUtil.set(key, o, 0L);
                    break;
                }
                case "queryFlowStateRTByDocId(String)": {
                    o = pjp.proceed();
                    break;
                }
                default: {
                    o = pjp.proceed();
                }
            }
            return o;
        }
        catch (Throwable e) {
            this.logger.error(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private void asyncExecMethod(ProceedingJoinPoint pjp, String methodName, Object[] args, String typeName, WrapConnection wconn) throws Throwable {
        if (RuntimeDaoCommandDispatch.initialized()) {
            this.commandExecutor.addToExecGroup(new RuntimeDaoCommand(typeName, methodName, args, wconn.getApplicationId()));
        } else {
            pjp.proceed();
        }
    }
}

