/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.excutor.async;

import cn.myapps.common.model.ValueObject;
import cn.myapps.common.util.cache.EhcacheProvider;
import cn.myapps.common.util.cache.IMyCache;
import cn.myapps.common.util.cache.IMyElement;
import cn.myapps.common.util.cache.MyCacheManager;
import cn.myapps.runtime.common.dao.WrapConnection;
import cn.myapps.runtime.dynaform.document.dao.AbstractDocStaticTblDAO;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.excutor.async.RuntimeDaoCommand;
import cn.myapps.runtime.excutor.async.RuntimeDaoCommandDispatch;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DocumentDAOAspect {
    private Logger logger = LoggerFactory.getLogger(DocumentDAOAspect.class);
    private static final String CACHE_KEY = "RUNTIME_DAO_CACHE_KEY";
    @Autowired
    private RuntimeDaoCommandDispatch commandExecutor;

    @Pointcut(value="(execution(public * cn.myapps.runtime.dynaform.document.dao.AbstractDocStaticTblDAO.*(..)))")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint pjp) throws Exception {
        try {
            String methodName = pjp.getSignature().getName();
            if (methodName.equals("getConnection") || methodName.equals("setConnection")) {
                return pjp.proceed();
            }
            Object[] args = pjp.getArgs();
            AbstractDocStaticTblDAO thisObj = (AbstractDocStaticTblDAO)pjp.getTarget();
            String typeName = thisObj.getClass().getName().split("[$][$]")[0];
            WrapConnection wconn = thisObj.getConnection();
            String signLongString = pjp.getSignature().toString();
            int pos = signLongString.lastIndexOf(".");
            String signString = signLongString.substring(pos + 1, signLongString.length());
            EhcacheProvider provider = (EhcacheProvider)MyCacheManager.getProviderInstance();
            IMyCache iMyCache = provider.getCache(CACHE_KEY);
            if (iMyCache == null) {
                iMyCache = provider.createCache(CACHE_KEY, 50000, false, false, 86400L, 86400L);
            }
            Object o = null;
            ValueObject vo = null;
            String key = null;
            IMyElement element = null;
            switch (signString) {
                case "create(ValueObject)": {
                    o = pjp.proceed();
                    vo = (ValueObject)args[0];
                    iMyCache.put((Object)vo.getId(), (Object)vo);
                    break;
                }
                case "update(ValueObject)": {
                    o = pjp.proceed();
                    vo = (ValueObject)args[0];
                    iMyCache.put((Object)vo.getId(), (Object)vo);
                }
                case "remove(String)": {
                    o = pjp.proceed();
                    key = (String)args[0];
                    iMyCache.remove((Object)key);
                    break;
                }
                case "find(String)": {
                    key = (String)args[0];
                    element = iMyCache.get((Object)key);
                    Object object = o = element == null ? null : element.getValue();
                    if (element != null) break;
                    o = pjp.proceed();
                    iMyCache.put((Object)key, o);
                    break;
                }
                case "storeDocument(Document)": {
                    vo = (ValueObject)args[0];
                    iMyCache.put((Object)vo.getId(), (Object)vo);
                    o = pjp.proceed();
                    break;
                }
                case "removeDocument(IDocument)": {
                    key = ((IDocument)args[0]).getId();
                    iMyCache.remove((Object)key);
                    o = pjp.proceed();
                    break;
                }
                case "updateDocument(IDocument)": {
                    vo = (ValueObject)args[0];
                    iMyCache.put((Object)vo.getId(), null);
                    iMyCache.put((Object)vo.getId(), (Object)vo);
                    o = pjp.proceed();
                    break;
                }
                case "createDocument(IDocument)": {
                    vo = (ValueObject)args[0];
                    iMyCache.put((Object)vo.getId(), (Object)vo);
                    o = pjp.proceed();
                    break;
                }
                case "createDocument(IDocument,int)": {
                    int type = (Integer)args[1];
                    if (type == 1) {
                        vo = (ValueObject)args[0];
                        iMyCache.put((Object)vo.getId(), (Object)vo);
                    }
                    o = pjp.proceed();
                    break;
                }
                case "findVersions(String)": {
                    key = (String)args[0];
                    element = iMyCache.get((Object)key);
                    Object object = o = element == null ? null : element.getValue();
                    if (element == null) {
                        o = thisObj.find(key);
                        iMyCache.put((Object)key, o);
                    }
                    return ((IDocument)o).getVersions();
                }
                case "isExist(String)": {
                    key = (String)args[0];
                    element = iMyCache.get((Object)key);
                    Object object = o = element == null ? null : element.getValue();
                    if (element == null) {
                        o = thisObj.find(key);
                        iMyCache.put((Object)key, o);
                    }
                    return o != null;
                }
                case "createAuthDocWithCondition(String,String,Collection)": {
                    this.asyncExecMethod(pjp, methodName, args, typeName, wconn);
                    break;
                }
                case "createDocumentHead(IDocument)": {
                    this.asyncExecMethod(pjp, methodName, args, typeName, wconn);
                    break;
                }
                case "removeAuthByDoc(Document)": {
                    this.asyncExecMethod(pjp, methodName, args, typeName, wconn);
                    break;
                }
                case "updateWordField(String,String,String,String)": {
                    key = (String)args[3];
                    element = iMyCache.get((Object)key);
                    Object object = o = element == null ? null : element.getValue();
                    if (element == null) {
                        o = thisObj.find(key);
                        IDocument doc = (IDocument)o;
                        String content = (String)args[0];
                        String fieldname = (String)args[1];
                        doc.findItem(fieldname).setValue((Object)content);
                        iMyCache.put((Object)key, o);
                    }
                    this.asyncExecMethod(pjp, methodName, args, typeName, wconn);
                    break;
                }
                case "updateFileSorting(String,String,String,String)": {
                    key = (String)args[0];
                    element = iMyCache.get((Object)key);
                    Object object = o = element == null ? null : element.getValue();
                    if (element == null) {
                        o = thisObj.find(key);
                        IDocument doc = (IDocument)o;
                        String fieldname = (String)args[2];
                        String content = (String)args[3];
                        doc.findItem(fieldname).setValue((Object)content);
                        iMyCache.put((Object)key, o);
                    }
                    this.asyncExecMethod(pjp, methodName, args, typeName, wconn);
                    break;
                }
                default: {
                    o = pjp.proceed();
                }
            }
            return o;
        }
        catch (Throwable e) {
            throw new Exception(e.getMessage());
        }
    }

    private void asyncExecMethod(ProceedingJoinPoint pjp, String methodName, Object[] args, String typeName, WrapConnection wconn) throws Throwable {
        if (RuntimeDaoCommandDispatch.initialized()) {
            this.commandExecutor.addToExecGroup(new RuntimeDaoCommand(typeName, methodName, args, wconn.getApplicationId()));
        } else {
            pjp.proceed();
        }
    }
}

