/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.dynaform.view.controller;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.Environment;
import cn.myapps.common.RunnableMeta;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.activity.Activity;
import cn.myapps.common.model.activity.ActivityParent;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.common.model.view.Column;
import cn.myapps.common.model.view.TreeView;
import cn.myapps.common.model.view.type.TreeType;
import cn.myapps.common.util.StringUtil;
import cn.myapps.common.util.cache.MemoryCacheUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.permission.PermissionUtil;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.ejb.DocumentProcess;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.dynaform.form.ejb.DateField;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.form.ejb.FormField;
import cn.myapps.runtime.dynaform.form.ejb.SelectField;
import cn.myapps.runtime.dynaform.form.ejb.ValueStoreField;
import cn.myapps.runtime.dynaform.view.tree.DocumentTree;
import cn.myapps.runtime.logger.service.LogHelper;
import cn.myapps.runtime.macro.runner.IRunner;
import cn.myapps.runtime.macro.runner.JavaScriptFactory;
import cn.myapps.util.DateUtil;
import cn.myapps.util.property.MultiLanguageProperty;
import com.alibaba.fastjson.JSONArray;
import com.bcxin.components.TenantContext;
import com.bcxin.saas.core.exceptions.SaasNofoundException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u89c6\u56fe\u6267\u884c\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/runtime/{applicationId}"}, produces={"application/json;charset=UTF-8"})
public class ViewController
extends AbstractRuntimeController {
    @Autowired
    private ViewDesignTimeService viewService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(path={"/views/{id}/template"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u89c6\u56fe\u6a21\u677f", notes="\u83b7\u53d6\u89c6\u56fe\u6a21\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="id", value="\u89c6\u56feId", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="parentId", value="\u7236Id", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="isRelate", value="isRelate", required=false, paramType="query", dataType="string")})
    public Resource doGetView(@PathVariable String applicationId, @PathVariable String id, @RequestParam(required=false) String parentId, @RequestParam(required=false) String isRelate) throws Exception {
        ParamsTable params = this.getParams();
        if ("true".equals(isRelate)) {
            params.setParameter("parentid", (Object)parentId);
            params.setParameter("relateid", (Object)parentId);
        } else {
            params.setParameter("relateid", (Object)parentId);
        }
        ViewDesignTimeService vProcess = DesignTimeServiceManager.viewDesignTimeService();
        AbstractView tempView = vProcess.doView(id);
        if (tempView == null) {
            String error = String.format("doGetView\u627e\u4e0d\u5230(app=%s)\u89c6\u56fe:%s", applicationId, id);
            throw new SaasNofoundException(error);
        }
        AbstractView view = (AbstractView)BeanUtils.cloneBean((Object)tempView);
        TenantContext context = TenantContext.getInstance();
        try {
            List columns;
            context.setCurrentApplicationId(view.getApplicationid());
            if (view instanceof TreeView) {
                try {
                    params.setParameter("treedocid", (Object)parentId);
                    params.setParameter("parentNodeId", (Object)parentId);
                    TreeView.LinkVO link = ((TreeView)view).getLink();
                    if (link != null) {
                        ((TreeView)view).setLinkViewId(link.getActionContent());
                    }
                }
                catch (Exception link) {
                    // empty catch block
                }
            }
            DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
            Document tdoc = null;
            Document parent = null;
            tdoc = StringUtil.isBlank((String)parentId) ? new Document() : ((parent = (Document)dProcess.doView(parentId)) != null ? parent : new Document());
            IRunner runner = JavaScriptFactory.getInstance((String)this.getUser().getSessionid(), (String)applicationId);
            runner.initBSFManager((IDocument)tdoc, params, (IUser)this.getUser(), new ArrayList());
            List activitys = view.getActivities();
            if (activitys != null) {
                ArrayList<Activity> result = new ArrayList<Activity>();
                Iterator iterator = activitys.iterator();
                while (iterator.hasNext()) {
                    boolean hidden;
                    Activity act = Activity.clone((Activity)((Activity)iterator.next()));
                    String label = this.getActivityLabel(view.getFullName(), act, runner);
                    if (!StringUtil.isBlank((String)label)) {
                        act.setName(label);
                    }
                    if (!(hidden = act.isHidden(runner, (ActivityParent)view, tdoc, (IUser)this.getUser(), 0))) {
                        String multiLanguageLabel = act.getMultiLanguageLabel();
                        if (!StringUtil.isBlank((String)multiLanguageLabel)) {
                            String multiLangTag = act.getName();
                            String labelHex = URLEncoder.encode(multiLanguageLabel, "utf-8");
                            String nameHex = URLEncoder.encode(multiLangTag, "utf-8");
                            multiLangTag = "{*[" + labelHex + "^" + nameHex + "^true]*}";
                            act.setName(multiLangTag);
                        }
                        boolean readonly = act.isReadonly(runner, view.getFullName());
                        act.setReadonly(readonly);
                    }
                    if (parent != null) {
                        boolean isparentArchive = !StringUtil.isBlank((String)parent.getStateid()) && parent.getState() == null;
                        boolean isReadOperate = false;
                        if (act.getType() == 16 || act.getType() == 1 || act.getType() == 26 || act.getType() == 36) {
                            isReadOperate = true;
                        }
                        if ((hidden || isparentArchive) && (hidden || !isparentArchive || !isReadOperate)) continue;
                        result.add(act);
                        continue;
                    }
                    if (hidden) continue;
                    result.add(act);
                }
                view.setActivities(result);
            }
            if ((columns = view.getColumns()) != null) {
                ArrayList<Column> result = new ArrayList<Column>();
                Iterator iterator = columns.iterator();
                while (iterator.hasNext()) {
                    Column column = Column.clone((Column)((Column)iterator.next()));
                    boolean isHidden = false;
                    if (!StringUtil.isBlank((String)column.getHiddenScript())) {
                        isHidden = column.isHiddenColumn(runner);
                        column.setHiddenColumn(isHidden);
                    }
                    if (column.getFormField() != null) {
                        column.setColumnField(column.getFormField().getClass().getSimpleName());
                        column.setFieldId(column.getFormField().getId());
                    }
                    if (!isHidden) {
                        String iconMapping;
                        if (!StringUtil.isBlank((String)column.getMultiLanguageLabel())) {
                            String text = this.getPropertyByMultiLanguage(this.request, applicationId, column.getMultiLanguageLabel(), column.getName());
                            column.setName(text);
                        }
                        if (!(StringUtil.isBlank((String)(iconMapping = column.getIconMapping())) || iconMapping.contains("value") || iconMapping.contains("key"))) {
                            String[] icons = column.getIconMapping().split(";");
                            JSONArray jsonArray = new JSONArray();
                            for (String icon : icons) {
                                String[] iconKeyAndValue = icon.split(":");
                                com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
                                jsonObject.put("key", (Object)iconKeyAndValue[0]);
                                jsonObject.put("value", (Object)iconKeyAndValue[1]);
                                jsonArray.add((Object)jsonObject);
                            }
                            column.setIconMapping(jsonArray.toJSONString());
                        }
                    }
                    result.add(column);
                }
                view.setColumns(result);
            }
            if (view.getShowWaterMark().booleanValue()) {
                String waterMake = (String)runner.run((RunnableMeta)view, "view:" + view.getName() + "-" + view.getId() + ".waterMarkScript", view.getWaterMarkScript());
                view.setWaterMarkText(waterMake);
            }
            if (view.getOpenType() == 288 && view.getViewTypeImpl().intValue() == 1) {
                boolean editable = true;
                boolean readonly = true;
                if (!StringUtil.isBlank((String)view.getEditableScript())) {
                    editable = (Boolean)runner.run((RunnableMeta)view, "view:" + view.getName() + "-" + view.getId() + ".editableScript", view.getEditableScript());
                }
                if (!StringUtil.isBlank((String)view.getReadonlyScript())) {
                    readonly = (Boolean)runner.run((RunnableMeta)view, "view:" + view.getName() + "-" + view.getId() + ".readonlyScript", view.getReadonlyScript());
                }
                view.setEditAble(editable);
                view.setReadAble(readonly);
            }
            Resource resource = this.success("ok", view);
            return resource;
        }
        finally {
            context.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(path={"/views/{id}/documents"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u89c6\u56fe", notes="\u83b7\u53d6\u89c6\u56fe")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="id", value="\u89c6\u56feId", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="parentId", value="\u7236Id", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="startDate", value="\u65e5\u5386\u89c6\u56fe\u5f00\u59cb\u65f6\u95f4", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="endDate", value="\u65e5\u5386\u89c6\u56fe\u7ed3\u675f\u65f6\u95f4", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="sortCol", value="\u6392\u5e8f\u5217\u5b57\u6bb5", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="sortStatus", value="\u6392\u5e8f\u72b6\u6001(\u5347\u5e8fDESC\u6216\u964d\u5e8fASC)", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="parentParam", value="\u6298\u53e0\u89c6\u56fe\u7684\u4e0a\u7ea7\u53c2\u6570", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="lines", value="\u6bcf\u9875\u663e\u793a\u6570", required=false, paramType="query", dataType="string", defaultValue="5"), @ApiImplicitParam(name="isQueryButton", value="\u662f\u5426\u67e5\u8be2\u6309\u94ae", required=false, paramType="query", dataType="boolean"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=false, paramType="body", dataType="string")})
    public Resource doGetDocuments(@PathVariable String applicationId, @PathVariable String id, @RequestParam(required=false) String parentId, @RequestParam(required=false) String isRelate, @RequestParam(required=false) String startDate, @RequestParam(required=false) String endDate, @RequestParam(required=false) String sortCol, @RequestParam(required=false) String sortStatus, @RequestParam(required=false) String parentParam, @RequestParam(required=false, defaultValue="10") String lines, @RequestParam(required=false, defaultValue="false") boolean isQueryButton, @RequestBody(required=false) String content) throws Exception {
        ViewDesignTimeService vProcess = DesignTimeServiceManager.viewDesignTimeService();
        AbstractView view = vProcess.doView(id);
        if (view == null) {
            String error = String.format("doGetDocuments\u627e\u4e0d\u5230(app=%s)\u89c6\u56fe:%s", applicationId, id);
            throw new SaasNofoundException(error);
        }
        TenantContext context = TenantContext.getInstance();
        try {
            Resource resource;
            context.setCurrentApplicationId(view.getApplicationid());
            ParamsTable params = this.getParams();
            WebUser user = this.getUser();
            Document searchDocument = null;
            DataPackage dataPackage = null;
            Collection data = null;
            if (!StringUtil.isBlank((String)content)) {
                com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONObject.parseObject((String)content);
                for (Object entry : jsonObject.entrySet()) {
                    String string = (String)entry.getKey();
                    Object value = entry.getValue();
                    params.setParameter(string, value);
                }
            }
            if (view.getSearchForm() != null) {
                Form searchForm = view.getSearchForm();
                searchDocument = searchForm.createDocument(params, (IUser)user);
                IRunner runner = JavaScriptFactory.getInstance((String)this.session.getId(), (String)view.getApplicationid());
                runner.initBSFManager((IDocument)searchDocument, params, (IUser)user, new ArrayList());
                for (Map.Entry entry : searchDocument.getItemMap().entrySet()) {
                    FormField filed;
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (value instanceof Date) {
                        filed = searchForm.findFieldByName(key);
                        value = filed != null && filed instanceof DateField ? DateUtil.format((Date)((Date)value), (String)((DateField)filed).getDatePatternValue()) : DateUtil.format((Date)((Date)value), (String)"yyyy-MM-dd HH:mm:ss");
                    } else {
                        filed = searchForm.findFieldByName(key);
                        if ((value == null || value.equals("")) && filed != null && filed instanceof SelectField) {
                            ((SelectField)filed).getOptions(runner, searchDocument, (IUser)user);
                            value = searchDocument.getItemValueAsString(key);
                        }
                    }
                    if (value == null) continue;
                    params.setParameter(key, value);
                }
            } else {
                searchDocument = new Document();
            }
            if ("true".equals(isRelate)) {
                params.setParameter("parentid", (Object)parentId);
                params.setParameter("relateid", (Object)parentId);
            } else {
                params.removeParameter("parentId");
                params.removeParameter("parentid");
                params.setParameter("relateid", (Object)parentId);
            }
            params.setParameter("refreshparent", (Object)true);
            params.setParameter("isedit", (Object)false);
            params.setParameter("lines", (Object)lines);
            params.setParameter("startDate", (Object)startDate);
            params.setParameter("endDate", (Object)endDate);
            params.setParameter("_viewid", (Object)id);
            params.setParameter("isQueryButton", (Object)isQueryButton);
            if (!StringUtil.isBlank((String)sortCol)) {
                ArrayList<String> colFieldsList = new ArrayList<String>();
                String fieldName = view.getFormFieldNameByColsName(sortCol);
                if (!StringUtil.isBlank((String)fieldName)) {
                    colFieldsList.add(fieldName + " " + sortStatus);
                    params.setParameter("_sortCol", (Object)colFieldsList.toArray(new String[colFieldsList.size()]));
                }
            } else {
                params.setParameter("_sortCol", (Object)view.getDefaultOrderFieldArr());
            }
            if ("TreeView".equalsIgnoreCase(view.getSimpleClassName()) || "MapView".equalsIgnoreCase(view.getSimpleClassName())) {
                params.setParameter("lines", (Object)Integer.MAX_VALUE);
            }
            dataPackage = view.getViewTypeImpl().getViewDatas(params, (IUser)this.getUser(), searchDocument);
            data = dataPackage.getDatas();
            HashMap cache = new HashMap();
            List result = this.viewService.manipulationDocumentDatas2ViewDatas(data, view, params, (IUser)this.getUser(), parentParam, cache);
            int page = dataPackage.getPageNo();
            int n = dataPackage.getLinesPerPage();
            int row_count = dataPackage.getRowCount();
            if ("CollapsibleView".equalsIgnoreCase(view.getSimpleClassName())) {
                row_count = result.size();
                for (Map map : result) {
                    String parentName = (String)map.get("parentName") + "\\";
                    List subResult = this.viewService.manipulationDocumentDatas2ViewDatas(data, view, params, (IUser)this.getUser(), parentName, cache);
                    if (subResult.isEmpty()) {
                        map.put("hasChild", false);
                        continue;
                    }
                    map.put("hasChild", true);
                }
            }
            if (view.isSum()) {
                IRunner runner = null;
                if (runner == null) {
                    Document parent = (Document)this.request.getAttribute("parent");
                    Document tdoc = parent != null ? parent : new Document();
                    runner = JavaScriptFactory.getInstance((String)user.getSessionid(), (String)view.getApplicationid());
                    runner.initBSFManager((IDocument)tdoc, params, (IUser)user, new ArrayList());
                }
                HashMap sumItems = new HashMap();
                HashMap totalItems = new HashMap();
                int sumCount = 0;
                int totalCount = 0;
                for (Column column : view.getColumns()) {
                    HashMap<String, String> map;
                    StringBuffer sumSb = new StringBuffer();
                    StringBuffer totalSb = new StringBuffer();
                    if (column.isSum()) {
                        sumSb.append(column.getSumByDatas(dataPackage, runner, (IUser)user));
                        ++sumCount;
                        map = new HashMap<String, String>();
                        map.put("name", column.getName());
                        map.put("fieldtype", "VALUE_TYPE_SUM");
                        map.put("value", sumSb.toString());
                        sumItems.put(column.getId(), map);
                    }
                    if (!view.getEditMode().equals("00") && !view.getEditMode().equals("02") || !column.isTotal()) continue;
                    totalSb.append(column.getSumTotal((IUser)user, user.getDomainid(), params));
                    ++totalCount;
                    map = new HashMap();
                    map.put("name", column.getName());
                    map.put("fieldtype", "VALUE_TYPE_SUM");
                    map.put("value", totalSb.toString());
                    totalItems.put(column.getId(), map);
                }
                if (sumCount > 0) {
                    HashMap<String, Serializable> sumLine = new HashMap<String, Serializable>();
                    sumLine.put("isSum", Boolean.valueOf(true));
                    sumLine.put("items", sumItems);
                    result.add(sumLine);
                }
                if (totalCount > 0) {
                    HashMap<String, Serializable> totalLine = new HashMap<String, Serializable>();
                    totalLine.put("isTotal", Boolean.valueOf(true));
                    totalLine.put("items", totalItems);
                    result.add(totalLine);
                }
            }
            if (isQueryButton) {
                String description = view.getDescription();
                if (StringUtil.isBlank((String)description)) {
                    description = view.getFullName();
                }
                LogHelper.saveLogByDyAction((String)"\u5217\u8868\u67e5\u8be2", (String)("\u89c6\u56fe-" + description), (IUser)user, (HttpServletRequest)this.request);
            }
            Resource resource2 = resource = this.successWithPagination("ok", result, page, n, row_count);
            return resource2;
        }
        finally {
            context.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(path={"/treeviews/{id}/documents"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u6811\u5f62\u89c6\u56fe\u6570\u636e", notes="\u83b7\u53d6\u6811\u5f62\u89c6\u56fe\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="id", value="\u89c6\u56feId", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="parentId", value="\u7236id", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="name", value="\u672c\u8282\u70b9\u540d\u79f0", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string"), @ApiImplicitParam(name="isQueryButton", value="\u662f\u5426\u67e5\u8be2\u6309\u94ae", required=false, paramType="query", dataType="boolean")})
    public Resource doGetTreeDocuments(@PathVariable String applicationId, @PathVariable String id, @RequestParam(required=false) String parentId, @RequestParam(required=false) String name, @RequestBody String content, @RequestParam(required=false, defaultValue="false") boolean isQueryButton) throws Exception {
        ViewDesignTimeService vProcess = DesignTimeServiceManager.viewDesignTimeService();
        AbstractView view = vProcess.doView(id);
        if (view == null) {
            String error = String.format("doGetTreeDocuments\u627e\u4e0d\u5230(app=%s)\u89c6\u56fe:%s", applicationId, id);
            throw new SaasNofoundException(error);
        }
        TenantContext context = TenantContext.getInstance();
        try {
            String parentDocId;
            context.setCurrentApplicationId(view.getApplicationid());
            ParamsTable params = this.getParams();
            WebUser user = this.getUser();
            Document searchDocument = null;
            DataPackage dataPackage = null;
            Collection data = null;
            if (!StringUtil.isBlank((String)content)) {
                com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONObject.parseObject((String)content);
                for (Map.Entry entry : jsonObject.entrySet()) {
                    String key = (String)entry.getKey();
                    Object v = entry.getValue();
                    params.setParameter(key, v);
                }
            }
            if (!StringUtil.isBlank((String)(parentDocId = params.getParameterAsString("parentDocId")))) {
                params.setParameter("relateId", (Object)parentDocId);
            }
            if (view.getSearchForm() != null) {
                Form searchForm = view.getSearchForm();
                searchDocument = searchForm.createDocument(params, (IUser)user);
                IRunner runner = JavaScriptFactory.getInstance((String)this.session.getId(), (String)view.getApplicationid());
                runner.initBSFManager((IDocument)searchDocument, params, (IUser)user, new ArrayList());
                for (Map.Entry entry : searchDocument.getItemMap().entrySet()) {
                    FormField filed;
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (value instanceof Date) {
                        filed = searchForm.findFieldByName(key);
                        value = filed != null && filed instanceof DateField ? DateUtil.format((Date)((Date)value), (String)((DateField)filed).getDatePatternValue()) : DateUtil.format((Date)((Date)value), (String)"yyyy-MM-dd HH:mm:ss");
                    } else {
                        filed = searchForm.findFieldByName(key);
                        if ((value == null || value.equals("")) && filed != null && filed instanceof SelectField) {
                            ((SelectField)filed).getOptions(runner, searchDocument, (IUser)user);
                            value = searchDocument.getItemValueAsString(key);
                        }
                    }
                    if (value == null) continue;
                    params.setParameter(key, value);
                }
            } else {
                searchDocument = new Document();
            }
            params.setParameter("refreshparent", (Object)true);
            params.setParameter("isedit", (Object)false);
            params.setParameter("isRelate", (Object)true);
            params.setParameter("_docid", (Object)parentId);
            params.setParameter("_sortCol", (Object)view.getDefaultOrderFieldArr());
            if (StringUtil.isBlank((String)name)) {
                dataPackage = view.getViewTypeImpl().getViewDatas(params, (IUser)this.getUser(), searchDocument);
            } else {
                TreeType treeType = (TreeType)view.getViewTypeImpl();
                dataPackage = treeType.getViewDatasByName(params, name, (IUser)user, searchDocument);
            }
            data = dataPackage.getDatas();
            List result = this.viewService.manipulationDocumentDatas2ViewDatas(data, view, params, (IUser)this.getUser(), "", new HashMap());
            int page = dataPackage.getPageNo();
            int page_lines = dataPackage.getLinesPerPage();
            int n = dataPackage.getRowCount();
            if (isQueryButton) {
                String description = view.getDescription();
                if (StringUtil.isBlank((String)description)) {
                    description = view.getFullName();
                }
                LogHelper.saveLogByDyAction((String)"\u5217\u8868\u67e5\u8be2", (String)("\u89c6\u56fe-" + description), (IUser)user, (HttpServletRequest)this.request);
            }
            Resource resource = this.successWithPagination("ok", result, page, page_lines, n);
            return resource;
        }
        finally {
            context.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(path={"/views/{id}/searchformtemplate"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u67e5\u8be2\u8868\u5355\u6a21\u677f", notes="\u83b7\u53d6\u67e5\u8be2\u8868\u5355\u6a21\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="id", value="\u89c6\u56feId", required=true, paramType="path", dataType="string")})
    public Resource getSearchFormTemplate(@PathVariable String applicationId, @PathVariable String id) throws Exception {
        WebUser user = this.getUser();
        ParamsTable params = this.getParams();
        ViewDesignTimeService vProcess = DesignTimeServiceManager.viewDesignTimeService();
        AbstractView view = vProcess.doView(id);
        if (view == null) {
            String error = String.format("getSearchFormTemplate\u627e\u4e0d\u5230(app=%s)\u89c6\u56fe:%s", applicationId, id);
            throw new SaasNofoundException(error);
        }
        TenantContext context = TenantContext.getInstance();
        try {
            context.setCurrentApplicationId(view.getApplicationid());
            IRunner runner = JavaScriptFactory.getInstance((String)user.getSessionid(), (String)applicationId);
            Document searchDocument = null;
            searchDocument = view.getSearchForm() != null ? view.getSearchForm().createDocument(params, (IUser)this.getUser()) : new Document();
            HashMap<String, Object> map = new HashMap<String, Object>();
            StringBuilder buffer = new StringBuilder();
            StringBuilder template = new StringBuilder();
            Form form = searchDocument.getForm();
            String formId = form == null ? "" : form.getId();
            ArrayList<Map> data = new ArrayList<Map>();
            if (form != null) {
                template.append(form.getHtmlTemplate(searchDocument, runner, (IUser)user));
                buffer.append(template.toString());
                buffer.append("<input type=\"hidden\" id=\"dy_refreshObj\" formid=\"" + formId + "\"");
                buffer.append(" docid=\"" + searchDocument.getId() + "\" userid=\"" + user.getId() + "\"");
                buffer.append(" mapVal=\"");
                for (Object obj : form.getAllFields()) {
                    if (!(obj instanceof ValueStoreField)) continue;
                    FormField field = (FormField)obj;
                    buffer.append(field.getName() + ";");
                }
                if (buffer.lastIndexOf(";") != -1) {
                    buffer.deleteCharAt(buffer.lastIndexOf(";"));
                }
                Collection fields = form.getFields();
                for (FormField formField : fields) {
                    Map value = formField.toAttributes(searchDocument, runner, (IUser)this.getUser(), 2);
                    if (formField.getOtherPropsAsMap() != null && value != null && !value.isEmpty()) {
                        for (String propertyKey : formField.getOtherPropsAsMap().keySet()) {
                            if (value.get(propertyKey) != null) continue;
                            value.put(propertyKey, formField.getOtherPropsAsMap().get(propertyKey));
                        }
                    }
                    data.add(value);
                }
                buffer.append("\" />");
            }
            map.put("fields", data);
            map.put("document", searchDocument);
            map.put("template", buffer.toString());
            if (form != null && form.getStyle() != null) {
                map.put("style", form.getStyle());
            }
            Resource resource = this.success("ok", map);
            return resource;
        }
        finally {
            context.reset();
        }
    }

    @GetMapping(path={"/views/{id}/tree/search"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u67e5\u8be2\u6811\u5f62\u89c6\u56fe", notes="\u67e5\u8be2\u6811\u5f62\u89c6\u56fe")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="id", value="\u89c6\u56feId", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="keyword", value="\u5173\u952e\u5b57", required=false, paramType="query", dataType="string")})
    public Resource viewTreeSearch(@PathVariable String applicationId, @PathVariable String id, @RequestParam(required=false) String keyword) throws Exception {
        WebUser user = this.getUser();
        ParamsTable params = this.getParams();
        ViewDesignTimeService vProcess = DesignTimeServiceManager.viewDesignTimeService();
        AbstractView view = vProcess.doView(id);
        if (view == null) {
            String error = String.format("viewTreeSearch\u627e\u4e0d\u5230(app=%s)\u89c6\u56fe:%s", applicationId, id);
            throw new SaasNofoundException(error);
        }
        Document sDoc = view.getSearchForm() != null ? view.getSearchForm().createDocument(this.getParams(), (IUser)this.getUser()) : new Document();
        params.setParameter("application", (Object)applicationId);
        params.setParameter("_viewid", (Object)id);
        params.setParameter("bname", (Object)keyword);
        DocumentTree tree = new DocumentTree(view, params, (IUser)user, sDoc);
        tree.search();
        return this.success("ok", JSONArray.parseArray((String)tree.toSearchJSON()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/views/{viewId}/column/submit"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u89c6\u56fe\u5217\u7684\u63d0\u4ea4\u6309\u94ae", notes="\u89c6\u56fe\u5217\u7684\u63d0\u4ea4\u6309\u94ae")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="viewId", value="\u89c6\u56feid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="json", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource viewColumnApprove(@PathVariable String applicationId, @PathVariable String viewId, @RequestBody String json) throws Exception {
        com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONObject.parseObject((String)json);
        String docId = jsonObject.getString("docId");
        String limistStrList = jsonObject.getString("approveLimit");
        String attitude = jsonObject.getString("attitude");
        TenantContext context = TenantContext.getInstance();
        try {
            context.setCurrentApplicationId(applicationId);
            List<Object> limistList = new ArrayList();
            if (!StringUtil.isBlank((String)limistStrList)) {
                limistList = Arrays.asList(limistStrList.split(","));
            }
            ParamsTable params = this.getParams();
            params.setParameter("_attitude", (Object)attitude);
            params.setParameter("_viewid", (Object)viewId);
            DocumentProcess docProcess = RunTimeServiceManager.documentProcess((String)applicationId);
            JSONObject jsonOb = docProcess.doBatchApprove(new String[]{docId}, (IUser)this.getUser(), Environment.getInstance(), params, limistList);
            String result = jsonOb.getString("content");
            Resource resource = this.success("ok", result);
            return resource;
        }
        finally {
            context.reset();
        }
    }

    @GetMapping(path={"/views/{viewId}/openable"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5224\u65ad\u89c6\u56fe\u6253\u5f00\u6743\u9650", notes="\u5224\u65ad\u89c6\u56fe\u6253\u5f00\u6743\u9650")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="viewId", value="\u89c6\u56feid", required=true, paramType="path", dataType="string")})
    public Resource viewsOpenable(@PathVariable String applicationId, @PathVariable String viewId) throws Exception {
        ViewDesignTimeService viewService = DesignTimeServiceManager.viewDesignTimeService();
        AbstractView view = viewService.doView(viewId);
        if (view == null) {
            String error = String.format("\u627e\u4e0d\u5230(app=%s)\u89c6\u56fe:%s", applicationId, viewId);
            throw new SaasNofoundException(error);
        }
        boolean allow = true;
        if (!"public".equals(view.getPermissionType())) {
            WebUser user = this.getUser();
            String[] roleids = user.getRolelist(applicationId).split(",");
            allow = PermissionUtil.check((String[])roleids, (String)viewId, (String)viewId, (int)1032);
        }
        return this.success("ok", allow);
    }

    @PostMapping(path={"/views/{viewid}/documents/{docid}/refresh"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5237\u65b0\u4e00\u884c\u6570\u636e", notes="\u5237\u65b0\u4e00\u884c\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="viewid", value="\u89c6\u56feId", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docid", value="\u6587\u6863Id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5185\u5bb9", required=true, paramType="body", dataType="string")})
    public Resource rowRefresh(@PathVariable String applicationId, @PathVariable String viewid, @PathVariable String docid, @RequestBody String content) throws Exception {
        WebUser user = this.getUser();
        if (user == null) {
            throw new Exception("\u7528\u6237\u672a\u767b\u9646");
        }
        Document doc = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)docid, (IUser)user);
        JSONArray items = new JSONArray();
        doc = doc == null ? new Document() : doc;
        ViewDesignTimeService vProcess = DesignTimeServiceManager.viewDesignTimeService();
        AbstractView view = vProcess.doView(viewid);
        if (view == null) {
            String error = String.format("rowRefresh\u627e\u4e0d\u5230(app=%s)\u89c6\u56fe:%s", applicationId, viewid);
            throw new SaasNofoundException(error);
        }
        IRunner runner = JavaScriptFactory.getInstance((String)user.getSessionid(), (String)view.getApplicationid());
        runner.initBSFManager((IDocument)doc, this.getParams(), (IUser)this.getUser(), new ArrayList());
        for (Column column : view.getColumns()) {
            if (!"COLUMN_TYPE_SCRIPT".equals(column.getType())) continue;
            String script = column.getValueScript();
            Object result = runner.run((RunnableMeta)column, "rowRefresh.View[" + view.getName() + "].Column[" + column.getName() + "]", script);
            com.alibaba.fastjson.JSONObject item = new com.alibaba.fastjson.JSONObject();
            item.put("columnid", (Object)column.getId());
            item.put("value", result);
            items.add((Object)item);
        }
        HashMap<String, String> refresh = new HashMap<String, String>();
        refresh.put("docid", docid);
        refresh.put("viewid", viewid);
        refresh.put("items", (String)items);
        return this.success("ok", refresh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(path={"/views/{id}/filterColumns"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u89c6\u56fe\u5217\u7b5b\u9009\u6570\u636e", notes="\u83b7\u53d6\u89c6\u56fe\u5217\u7b5b\u9009\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="id", value="\u89c6\u56feId", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="parentId", value="\u7236Id", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="isRelate", value="\u662f\u5426\u7236\u5b50\u5173\u7cfb", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="fieldName", value="\u7b5b\u9009\u5b57\u6bb5\u540d\u79f0", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=false, paramType="body", dataType="string")})
    public Resource filterColumns(@PathVariable String applicationId, @PathVariable String id, @RequestParam(required=false) String parentId, String fieldName, @RequestParam(required=false) String isRelate, @RequestBody String content) throws Exception {
        ViewDesignTimeService vProcess = DesignTimeServiceManager.viewDesignTimeService();
        AbstractView view = vProcess.doView(id);
        if (view == null) {
            String error = String.format("filterColumns\u627e\u4e0d\u5230(app=%s)\u89c6\u56fe:%s", applicationId, id);
            throw new SaasNofoundException(error);
        }
        TenantContext context = TenantContext.getInstance();
        try {
            context.setCurrentApplicationId(applicationId);
            ParamsTable params = this.getParams();
            WebUser user = this.getUser();
            Document searchDocument = null;
            Object dataPackage = null;
            Object data = null;
            if (!StringUtil.isBlank((String)content)) {
                com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONObject.parseObject((String)content);
                for (Map.Entry entry : jsonObject.entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    params.setParameter(key, value);
                }
            }
            if (view.getSearchForm() != null) {
                Form searchForm = view.getSearchForm();
                searchDocument = searchForm.createDocument(params, (IUser)user);
                IRunner runner = JavaScriptFactory.getInstance((String)this.session.getId(), (String)view.getApplicationid());
                runner.initBSFManager((IDocument)searchDocument, params, (IUser)user, new ArrayList());
                for (Map.Entry entry : searchDocument.getItemMap().entrySet()) {
                    FormField filed;
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (value instanceof Date) {
                        filed = searchForm.findFieldByName(key);
                        value = filed != null && filed instanceof DateField ? DateUtil.format((Date)((Date)value), (String)((DateField)filed).getDatePatternValue()) : DateUtil.format((Date)((Date)value), (String)"yyyy-MM-dd HH:mm:ss");
                    } else {
                        filed = searchForm.findFieldByName(key);
                        if ((value == null || value.equals("")) && filed != null && filed instanceof SelectField) {
                            ((SelectField)filed).getOptions(runner, searchDocument, (IUser)user);
                            value = searchDocument.getItemValueAsString(key);
                        }
                    }
                    if (value == null) continue;
                    params.setParameter(key, value);
                }
            } else {
                searchDocument = new Document();
            }
            if ("true".equals(isRelate)) {
                params.setParameter("parentid", (Object)parentId);
                params.setParameter("relateid", (Object)parentId);
            } else {
                params.removeParameter("parentId");
                params.removeParameter("parentid");
                params.setParameter("relateid", (Object)parentId);
            }
            params.setParameter("lines", (Object)Integer.MAX_VALUE);
            List result = view.getViewTypeImpl().getFilterColumnDatas(fieldName, params, (IUser)user, searchDocument);
            result.sort(new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return 1;
                }
            });
            Resource resource = this.success("ok", result);
            return resource;
        }
        finally {
            context.reset();
        }
    }

    public String getPropertyByMultiLanguage(HttpServletRequest request, String applicationId, String multiLanguageLabel, String name) {
        String language = MultiLanguageProperty.getLanguageByRequestLocal((HttpServletRequest)request);
        String text = "";
        try {
            text = MultiLanguageProperty.getProperty((String)applicationId, (String)language, (String)multiLanguageLabel, (String)name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return text;
    }

    private String getActivityLabel(String viewName, Activity activity, IRunner runner) throws Exception {
        String labelScript = activity.getLabel();
        if (!StringUtil.isBlank((String)labelScript)) {
            StringBuffer label = new StringBuffer();
            label.append("ViewName:").append(viewName);
            label.append(" Activity(").append(activity.getId()).append(")." + activity.getName()).append(".labelScript");
            Object result = runner.run((RunnableMeta)activity, label.toString(), labelScript);
            if (result != null) {
                return String.valueOf(result);
            }
        }
        return "";
    }
}

