/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.dynaform.upload.servlet;

import cn.myapps.common.Environment;
import cn.myapps.common.util.StringUtil;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.dynaform.upload.ejb.UploadProcess;
import cn.myapps.runtime.dynaform.upload.ejb.UploadVO;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ShowImageServlet
extends HttpServlet {
    private static final long serialVersionUID = 4433214690967799970L;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String id = request.getParameter("id");
        String type = request.getParameter("type");
        String applicationid = request.getParameter("applicationid");
        if (id != null && id.length() > 0) {
            UploadProcess uploadProcess = RunTimeServiceManager.uploadProcess((String)applicationid);
            UploadVO uploadVO = (UploadVO)uploadProcess.doFindById(id);
            InputStream in = null;
            if (uploadVO != null) {
                in = uploadVO.getImgBinary();
            }
            if (in != null) {
                int bytesRead = 0;
                byte[] buffer = new byte[8192];
                OutputStream os = null;
                try {
                    if (!StringUtil.isBlank((String)type) && type.equals("image")) {
                        response.setContentType("image/jpeg");
                        int size = 0;
                        ServletOutputStream outs = response.getOutputStream();
                        while ((bytesRead = in.read(buffer)) != -1) {
                            size += bytesRead;
                            outs.write(buffer, 0, bytesRead);
                        }
                        response.setContentLength(size);
                        outs.flush();
                        outs.close();
                    } else if (!StringUtil.isBlank((String)type) && type.equals("file")) {
                        byte[] content = ShowImageServlet.readFile(in);
                        String encoding = Environment.getInstance().getEncoding();
                        response.setContentType("application/force-download; charset=" + encoding + "");
                        response.setHeader("Content-Disposition", "attachment;filename=\"" + URLEncoder.encode(uploadVO.getName(), encoding) + "\"");
                        os = response.getOutputStream();
                        os.write(content);
                        os.flush();
                    } else {
                        response.setContentType("application/octet-stream");
                        response.setContentLength(in.available());
                        int size = 0;
                        ServletOutputStream outs = response.getOutputStream();
                        while ((bytesRead = in.read(buffer, 0, 8192)) != -1) {
                            size = bytesRead;
                            outs.write(buffer, 0, bytesRead);
                        }
                        response.setContentLength(size);
                        outs.flush();
                        outs.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                    if (os != null) {
                        os.close();
                    }
                }
            }
        }
    }

    static byte[] readFile(InputStream in) throws Exception {
        int ch;
        ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
        while ((ch = in.read()) != -1) {
            bytestream.write(ch);
        }
        byte[] imgdata = bytestream.toByteArray();
        bytestream.close();
        return imgdata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean writeBytes(String filePath, byte[] content) throws IOException {
        File file;
        File file2 = file = new File(filePath);
        synchronized (file2) {
            BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(filePath));
            fos.write(content);
            fos.flush();
            fos.close();
        }
        return true;
    }
}

