/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.dynaform.upload.servlet;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.util.FileWriteUtil;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.StringUtil;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.dynaform.upload.ejb.UploadInfo;
import cn.myapps.runtime.dynaform.upload.ejb.UploadProcess;
import cn.myapps.runtime.dynaform.upload.ejb.UploadVO;
import cn.myapps.util.sequence.Sequence;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontFileAndImageUploadServlet
extends HttpServlet {
    private static final long serialVersionUID = 8751596990930951691L;
    private static final Logger Log = LoggerFactory.getLogger(FrontFileAndImageUploadServlet.class);
    private String path;
    private String fileSaveMode;
    private String fieldid;
    private String allowedTypes;
    private String applicationid;
    private String uploadContentType;
    private File saveFile;
    private String uploadFileName;
    private String uuid = "";
    private UploadInfo uploadInfo1;
    String[] excludeTypes = new String[0];

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String _excludeTypes = config.getInitParameter("excludeType");
        if (!StringUtil.isBlank((String)_excludeTypes)) {
            this.excludeTypes = _excludeTypes.split("\\|");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String userid;
            String uploadFileNameWithouSuffix = "";
            String data = request.getParameter("data");
            String[] dataArry = data.split(",");
            this.path = dataArry[0].split(":")[1].equals("null") ? "" : dataArry[0].split(":")[1];
            this.fileSaveMode = dataArry[1].split(":")[1].equals("null") ? "" : dataArry[1].split(":")[1];
            this.fieldid = dataArry[2].split(":")[1].equals("null") ? "" : dataArry[2].split(":")[1];
            this.allowedTypes = dataArry[3].split(":")[1].equals("null") ? "" : dataArry[3].split(":")[1];
            this.applicationid = dataArry[4].split(":")[1].equals("null") ? "" : dataArry[4].split(":")[1];
            String string = userid = AuthTimeServiceManager.getWebUser((HttpServletRequest)request) != null ? AuthTimeServiceManager.getWebUser((HttpServletRequest)request).getId() : null;
            if (this.path.indexOf("/") != -1) {
                this.path = this.path.substring(1);
            }
            String actionType = request.getParameter("actionType");
            String savePath = PropertyUtil.getPath();
            savePath = savePath + this.getUploadInfo().getFileDir();
            Calendar cal = Calendar.getInstance();
            int year = cal.get(1);
            File f1 = new File(savePath = savePath + File.separator + year);
            if (!f1.exists() && !f1.mkdirs()) {
                Log.warn("Failed to create folder (" + savePath + ")");
                throw new IOException("Failed to create folder (" + savePath + ")");
            }
            DiskFileItemFactory fac = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)fac);
            upload.setHeaderEncoding("utf-8");
            List fileList = null;
            request.setCharacterEncoding("UTF-8");
            fileList = upload.parseRequest(request);
            Iterator it = fileList.iterator();
            String fileName = "";
            String extName = "";
            long size = 0L;
            response.setContentType("text/html;charset=UTF-8");
            int fileCount = 0;
            JSONArray responseInfo = new JSONArray();
            while (it.hasNext()) {
                FileItem item = (FileItem)it.next();
                if (item.isFormField()) continue;
                ++fileCount;
                if (item.getName().indexOf(".") > -1) {
                    fileName = this.filter(item.getName().substring(0, item.getName().lastIndexOf(".")));
                    extName = item.getName().substring(item.getName().lastIndexOf(".")).toLowerCase();
                } else if (item.getName().toLowerCase().indexOf("image%") == 0) {
                    JSONObject result = this.getFileName4Android(item.getName());
                    fileName = result.getString("fileName");
                    extName = result.getString("extName").toLowerCase();
                } else {
                    fileName = this.filter(item.getName());
                    extName = "";
                }
                fileName = URLDecoder.decode(fileName, "UTF-8");
                if (fileName.indexOf("/") >= 0 || fileName.indexOf("\\") >= 0) {
                    response.setStatus(551);
                    throw new OBPMValidateException("\u4e0a\u4f20\u7684\u6587\u4ef6\u540d\u79f0\u4e0d\u5408\u6cd5\uff01");
                }
                if (this.isNotLegalFileExt(extName)) {
                    response.setStatus(552);
                    throw new OBPMValidateException("\u4e0a\u4f20\u7684\u6587\u4ef6\u7c7b\u578b\u4e0d\u5408\u6cd5\uff01");
                }
                size = item.getSize();
                if (item.getName() == null || item.getName().trim().equals("") || item.getName().trim().equals("null")) continue;
                if (item.getName().lastIndexOf(".") >= 0) {
                    this.uploadFileName = fileName + extName;
                    this.uploadContentType = this.allowedTypes + "/" + item.getName().substring(item.getName().lastIndexOf(".") + 1).toLowerCase();
                }
                this.uploadInfo1 = this.getUploadInfo();
                this.uuid = Sequence.getSequence();
                uploadFileNameWithouSuffix = this.uploadFileName.substring(0, this.uploadFileName.lastIndexOf("."));
                this.saveFile = new File(this.uploadInfo1.getFileRealDir() + year + File.separator + uploadFileNameWithouSuffix + this.uuid + extName);
                item.write(this.saveFile);
                if (this.applicationid != null && !this.applicationid.equals("")) {
                    UploadProcess uploadProcess = RunTimeServiceManager.uploadProcess((String)this.applicationid);
                    UploadVO uploadVO = new UploadVO();
                    uploadVO.setId(this.uuid);
                    uploadVO.setName(this.uploadInfo1.getFileName());
                    uploadVO.setFieldid(this.fieldid);
                    uploadVO.setType(extName);
                    uploadVO.setSize(size);
                    uploadVO.setModifyDate(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
                    uploadVO.setUserid(userid);
                    uploadVO.setPath(this.uploadInfo1.getFileDir() + year + "/" + this.uuid + extName);
                    uploadVO.setFolderPath(this.uploadInfo1.getFileDir());
                    uploadProcess.doCreate(uploadVO);
                    if (this.isTransferToPdf(extName) && !this.uploadInfo1.getPath().toLowerCase().contains("excel")) {
                        String rootPath = PropertyUtil.getPath();
                        FileWriteUtil.writeKmConvertTask((String)rootPath, (String)this.uuid, (String)this.saveFile.getPath());
                    }
                }
                JSONObject responseInfoItem = new JSONObject();
                responseInfoItem.put((Object)"name", (Object)this.uploadInfo1.getFileSaveName());
                responseInfoItem.put((Object)"path", (Object)(this.uploadInfo1.getFileDir() + year + "/" + uploadFileNameWithouSuffix + this.uuid + extName));
                responseInfo.add((Object)responseInfoItem);
            }
            if (fileCount > 1) {
                response.getWriter().print(responseInfo.toString());
            } else {
                response.getWriter().print(this.uploadInfo1.getFileSaveName() + "|" + this.uploadInfo1.getFileDir() + year + "/" + uploadFileNameWithouSuffix + this.uuid + extName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = e.getMessage();
            if (StringUtil.isBlank((String)msg)) {
                response.setStatus(555);
                msg = "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01";
            }
            response.getWriter().flush();
            response.getWriter().print(msg);
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private JSONObject getFileName4Android(String name) {
        JSONObject res = new JSONObject();
        name = name.replace("#", "_").replace(",", "_").replace("'", "_").replace(";", "_").replace("%", "_").replace("&", "_").replace("+", "%2B");
        res.put((Object)"fileName", (Object)name);
        res.put((Object)"extName", (Object)".jpg");
        this.uploadFileName = res.getString("fileName") + res.getString("extName");
        this.uploadContentType = "/jpg";
        return res;
    }

    protected String filter(String str) {
        StringBuffer sb = new StringBuffer();
        sb.append(str);
        if (sb.indexOf("_") != -1) {
            sb.deleteCharAt(sb.indexOf("_"));
            this.filter(sb.toString());
        }
        return sb.toString();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (FileUploadException fe) {
            Log.debug(fe.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (FileUploadException fe) {
            Log.debug(fe.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public UploadInfo getUploadInfo() {
        UploadInfo uploadInfo = new UploadInfo();
        uploadInfo.setAllowedTypes(this.allowedTypes);
        uploadInfo.setContentType(this.uploadContentType);
        uploadInfo.setFileName(this.uploadFileName);
        uploadInfo.setFileSaveMode(this.fileSaveMode);
        try {
            uploadInfo.setPath(this.path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return uploadInfo;
    }

    private boolean isNotLegalFileExt(String fileExt) throws Exception {
        if (StringUtil.isBlank((String)fileExt)) {
            return true;
        }
        String fileType = fileExt.substring(1);
        for (int i = 0; i < this.excludeTypes.length; ++i) {
            String excludeType = this.excludeTypes[i];
            if (StringUtil.isBlank((String)excludeType) || !fileType.equalsIgnoreCase(excludeType)) continue;
            return true;
        }
        return false;
    }

    private boolean isTransferToPdf(String name) {
        return (name = name.toLowerCase()).indexOf("png") < 0 && name.indexOf("ico") < 0 && name.indexOf(".gif") < 0 && name.indexOf(".jpg") < 0 && name.indexOf(".jpeg") < 0 && name.indexOf(".bmp") < 0 && name.indexOf("pdf") < 0;
    }
}

