/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.dynaform.upload.action;

import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.ejb.DocumentProcess;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.upload.ejb.UploadProcess;
import cn.myapps.runtime.dynaform.upload.ejb.UploadVO;
import java.io.File;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/api/portal/upload"})
public class UploadAct
extends AbstractRuntimeController {
    private static final long serialVersionUID = 6865609097678926341L;
    @Autowired
    private HttpServletRequest request;
    private String applicationid;
    private static final Logger Log = LoggerFactory.getLogger(UploadAct.class);
    private File upload;
    private String uploadContentType;
    private String uploadFileName;
    private String path;
    private String id;
    private String viewid;
    private String uploadList_;
    private String fieldValue;
    private String newUploadFileName;
    private String webPath;
    private String allowedTypes;
    private String[] fileName;
    private double perc;
    private String layer;
    private String fileSaveMode = "00";
    private File[] file;
    private String fileFullName;
    private int maximumSize = Integer.MAX_VALUE;
    private static final String[] IMAGE_TYPES = new String[]{"image/png", "image/gif", "image/jpeg", "image/pjpeg", "image/bmp", "application/pdf"};

    public String getFileFullName() {
        return this.fileFullName;
    }

    public void setFileFullName(String fileFullName) {
        this.fileFullName = fileFullName;
    }

    public String getUploadList_() {
        return this.uploadList_;
    }

    public void setUploadList_(String uploadList_) {
        this.uploadList_ = uploadList_;
    }

    public String getFieldValue() {
        return this.fieldValue;
    }

    public void setFieldValue(String fieldValue) {
        this.fieldValue = fieldValue;
    }

    public double getPerc() {
        return this.perc;
    }

    public void setPerc(double perc) {
        this.perc = perc;
    }

    public String getLayer() {
        return this.layer;
    }

    public void setLayer(String layer) {
        this.layer = layer;
    }

    public String getViewid() {
        return this.viewid;
    }

    public void setViewid(String viewid) {
        this.viewid = viewid;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(int maximumSize) {
        this.maximumSize = maximumSize;
    }

    public String getAllowedTypes() {
        return this.allowedTypes;
    }

    public void setAllowedTypes(String allowedTypes) {
        this.allowedTypes = allowedTypes;
    }

    public String getWebPath() {
        return this.webPath;
    }

    public void setWebPath(String webPath) {
        this.webPath = webPath;
    }

    public String getPath() throws Exception {
        return this.path;
    }

    public void setPath(String path) throws Exception {
        this.path = path;
    }

    public String getNewUploadFileName() {
        return this.newUploadFileName;
    }

    public void setNewUploadFileName(String newUploadFileName) {
        this.newUploadFileName = newUploadFileName;
    }

    public File getUpload() {
        return this.upload;
    }

    public void setUpload(File upload) {
        this.upload = upload;
    }

    public String getUploadContentType() {
        return this.uploadContentType;
    }

    public void setUploadContentType(String uploadContentType) {
        this.uploadContentType = uploadContentType;
    }

    public String getUploadFileName() {
        return this.uploadFileName;
    }

    public void setUploadFileName(String uploadFileName) {
        this.uploadFileName = uploadFileName;
    }

    public File[] getFile() {
        return this.file;
    }

    public void setFile(File[] file) {
        this.file = file;
    }

    public void setFileName(String[] fileName) {
        this.fileName = fileName;
    }

    public String[] getFileName() {
        return this.fileName;
    }

    public String getFileSaveMode() {
        return this.fileSaveMode;
    }

    public void setFileSaveMode(String fileSaveMode) {
        this.fileSaveMode = fileSaveMode;
    }

    public String getApplicationid() {
        return this.applicationid;
    }

    public void setApplicationid(String applicationid) {
        this.applicationid = applicationid;
    }

    public ParamsTable getParams(HttpServletRequest request) {
        ParamsTable pm = ParamsTable.convertHTTP((HttpServletRequest)request);
        if (this.getDomain() != null) {
            pm.setParameter("domainid", (Object)this.getDomain());
        }
        if (pm.getParameter("_pagelines") == null) {
            pm.setParameter("_pagelines", (Object)"10");
        }
        return pm;
    }

    protected Document rebuildDocument(Document doc, ParamsTable params) {
        String formid = params.getParameterAsString("_formid");
        try {
            if (!StringUtil.isBlank((String)doc.getId()) && !StringUtil.isBlank((String)formid)) {
                FormDesignTimeService formPross = DesignTimeServiceManager.formDesignTimeService();
                Form form = formPross.doView(formid);
                doc = form.createDocument(doc, params, (IUser)this.getUser());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    @RequestMapping(value={"/delete.action"})
    public String doDelete() {
        HttpServletRequest request = this.request;
        ParamsTable params = ParamsTable.convertHTTP((HttpServletRequest)request);
        String docid = params.getParameterAsString("_docid");
        try {
            if (!StringUtil.isBlank((String)this.fileFullName)) {
                this.fileFullName = URLDecoder.decode(this.fileFullName, "UTF-8");
                UploadProcess uploadProcess = RunTimeServiceManager.uploadProcess((String)this.applicationid);
                String[] fileFullNameArry = this.fileFullName.split(";");
                for (int i = 0; i < fileFullNameArry.length; ++i) {
                    Document doc;
                    String fileFullName = fileFullNameArry[i];
                    UploadVO uploadVO = null;
                    if (!StringUtil.isBlank((String)fileFullName) && fileFullName.indexOf("_/uploads") > 0) {
                        String fileId = fileFullName.substring(0, fileFullName.indexOf("_/uploads"));
                        uploadVO = (UploadVO)uploadProcess.doView(fileId);
                    } else {
                        uploadVO = uploadProcess.findByColumnName1("PATH", fileFullName);
                    }
                    if (uploadVO == null) continue;
                    String fileRealPath = request.getServletContext().getRealPath(uploadVO.getPath());
                    File file = new File(fileRealPath);
                    if (file.exists() && !file.delete()) {
                        Log.warn("File(" + fileRealPath + ") delete failed");
                        throw new OBPMValidateException("File(" + fileRealPath + ") delete failed");
                    }
                    uploadProcess.doRemove(uploadVO.getId());
                    if (StringUtil.isBlank((String)this.applicationid)) continue;
                    DocumentProcess docProcess = RunTimeServiceManager.documentProcess((String)this.applicationid);
                    if (StringUtil.isBlank((String)docid) || (doc = (Document)docProcess.doView(docid)) == null) continue;
                    doc = this.rebuildDocument(doc, params);
                    docProcess.doUpdate((IDocument)doc, false, false);
                }
            }
        }
        catch (Exception e) {
            request.setAttribute("ERROR_MESSAGE", (Object)e.getMessage());
            return "NONE";
        }
        return "forward:/core/upload/success.jsp";
    }

    @RequestMapping(value={"/deleteOne.action"})
    public String doDeleteOne() throws Exception {
        HttpServletRequest request = this.request;
        ParamsTable params = ParamsTable.convertHTTP((HttpServletRequest)request);
        String docid = params.getParameterAsString("_docid");
        if (!StringUtil.isBlank((String)this.fileFullName)) {
            this.fileFullName = URLDecoder.decode(this.fileFullName, "UTF-8");
            UploadProcess uploadProcess = RunTimeServiceManager.uploadProcess((String)this.applicationid);
            UploadVO uploadVO = null;
            if (!StringUtil.isBlank((String)this.fileFullName) && this.fileFullName.indexOf("_/uploads") > 0) {
                String fileId = this.fileFullName.substring(0, this.fileFullName.indexOf("_/uploads"));
                uploadVO = (UploadVO)uploadProcess.doView(fileId);
            } else {
                uploadVO = uploadProcess.findByColumnName1("PATH", this.fileFullName);
            }
            if (uploadVO != null) {
                String fileRealPath = request.getServletContext().getRealPath(uploadVO.getPath());
                File file = new File(fileRealPath);
                if (file.exists() && !file.delete()) {
                    Log.warn("File(" + fileRealPath + ") delete failed");
                    throw new OBPMValidateException("File(" + fileRealPath + ") delete failed");
                }
                uploadProcess.doRemove(uploadVO.getId());
                if (!StringUtil.isBlank((String)this.applicationid)) {
                    Document doc;
                    DocumentProcess docProcess = RunTimeServiceManager.documentProcess((String)this.applicationid);
                    if (!StringUtil.isBlank((String)docid) && (doc = (Document)docProcess.doView(docid)) != null) {
                        doc = this.rebuildDocument(doc, params);
                        docProcess.doUpdate((IDocument)doc, false, false);
                    }
                }
            }
        }
        return "";
    }
}

