/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.dynaform.form.controller;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.util.StringUtil;
import cn.myapps.common.util.cache.MemoryCacheUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.form.ejb.Options;
import cn.myapps.runtime.dynaform.form.ejb.SuggestField;
import cn.myapps.runtime.macro.runner.IRunner;
import cn.myapps.runtime.macro.runner.JavaScriptFactory;
import com.alibaba.fastjson.JSONArray;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u667a\u80fd\u641c\u7d22\u63d0\u793a\u6846\u6267\u884c\u6a21\u5757"})
@RequestMapping(value={"/api"})
@Component
public class SuggestFieldController
extends AbstractRuntimeController {
    @PostMapping(value={"/runtime/{applicationId}/forms/{formid}/documents/{docid}/querySuggest"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u670d\u52a1\u5668\u8fd4\u56de\u641c\u7d22\u63d0\u793a\u76f8\u5173\u7684\u4fe1\u606f", notes="\u670d\u52a1\u5668\u8fd4\u56de\u641c\u7d22\u63d0\u793a\u76f8\u5173\u7684\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="formid", value="\u8868\u5355id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docid", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource querySuggest(@PathVariable String applicationId, @PathVariable String formid, @PathVariable String docid, @RequestBody String content) throws Exception {
        Configuration configuration = Configuration.defaultConfiguration();
        configuration = configuration.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
        DocumentContext parse = JsonPath.parse((String)content, (Configuration)configuration);
        String parentId = (String)parse.read("$.parentId", new Predicate[0]);
        String formFieldId = (String)parse.read("$.formFieldId", new Predicate[0]);
        String keyword = (String)parse.read("$.keyword", new Predicate[0]);
        if (!StringUtil.isBlank((String)keyword)) {
            keyword = keyword.replace("'", "");
        }
        JSONArray json = null;
        Options options = null;
        ParamsTable params = this.getParams();
        WebUser user = this.getUser();
        if (docid != null && docid.equals(parentId)) {
            parentId = null;
            params.removeParameter(parentId);
        }
        FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
        Form form = formService.doView(formid);
        SuggestField field = (SuggestField)form.findField(formFieldId);
        Document doc = null;
        if (field.getOptionsScript() != null && field.getOptionsScript().trim().length() > 0) {
            if (!StringUtil.isBlank((String)docid)) {
                doc = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)docid, (IUser)user);
                if (doc != null) {
                    doc.setId(docid);
                }
            } else if (!StringUtil.isBlank((String)parentId)) {
                doc = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)parentId, (IUser)user);
            }
            doc = form.createDocument(doc, params, (IUser)user);
            params.setParameter("_keyword", (Object)keyword);
            IRunner runner = JavaScriptFactory.getInstance((String)user.getSessionid(), (String)applicationId);
            runner.initBSFManager((IDocument)doc, params, (IUser)user, new ArrayList());
            options = field.getOptions(runner);
            json = options.toJsonSuggest();
        }
        return this.success("ok", json);
    }
}

