/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.dynaform.form.controller;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.datasource.DataSource;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.runtime.common.dao.WrapConnection;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.form.ejb.FormTableProcessBean;
import cn.myapps.runtime.dynaform.form.service.FormRunTimeService;
import cn.myapps.util.RuntimeDaoManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.sql.Connection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/runtime"})
@Scope(value="prototype")
@Api(tags={"\u8868\u5355\u540c\u6b65\u6a21\u5757"})
public class FormSynController
extends AbstractRuntimeController {
    @Autowired
    private FormRunTimeService formRunTimeService;

    @PostMapping(value={"/synchronization/forms"})
    @ApiOperation(value="\u540c\u6b65\u6570\u636e\u8868\u5355", notes="\u540c\u6b65\u6570\u636e\u8868\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="query", dataType="string")})
    public Resource syncDataForm(final @RequestParam String applicationId) throws Exception {
        try {
            final StringBuffer synFormError = new StringBuffer();
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Thread.currentThread().setName("syncDataFormThread");
                    try {
                        ApplicationDesignTimeService applicationService = DesignTimeServiceManager.applicationDesignTimeService();
                        Application application = (Application)applicationService.findById(applicationId);
                        DataSource dataSourceDefine = application.getDataSourceDefine();
                        Connection conn = dataSourceDefine.getConnection();
                        RuntimeDaoManager.getApplicationInitDAO((WrapConnection)new WrapConnection(dataSourceDefine.getSqlDataSource(), conn, null, application.getApplicationid()), (String)dataSourceDefine.getDbTypeName()).initTables();
                        List forms = FormSynController.this.formRunTimeService.getFormsByApplication(application.getId());
                        FormTableProcessBean tableProcess = new FormTableProcessBean(application.getId());
                        for (Form form : forms) {
                            try {
                                tableProcess.createOrUpdateDynaTable(form, null);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                synFormError.append("\u540c\u6b65" + form.getName() + "\u8868\u65f6\u62a5\u9519" + e.getMessage() + ",");
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            PersistenceUtils.closeSessionAndConnection();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }).start();
            return this.success("ok", synFormError.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(value={"/synchronization/forms/status"})
    @ApiOperation(value="\u83b7\u53d6\u540c\u6b65\u8868\u5355\u72b6\u6001", notes="\u83b7\u53d6\u540c\u6b65\u8868\u5355\u72b6\u6001")
    public Resource getSyncFromStatus() throws Exception {
        try {
            Thread thread = this.getThreadByName("syncDataFormThread");
            String msg = "\u6b63\u5728\u540c\u6b65\u4e2d";
            if (thread == null) {
                msg = "\u540c\u6b65\u6210\u529f";
            }
            return this.success("ok", msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    public Thread getThreadByName(String threadName) {
        for (Thread t : Thread.getAllStackTraces().keySet()) {
            if (!t.getName().equals(threadName)) continue;
            System.out.println(t.getName());
            return t;
        }
        return null;
    }
}

