/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.dynaform.form.controller;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.controller.ResourceNotFoundException;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.cache.MemoryCacheUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.permission.PermissionUtil;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.ejb.DocumentProcess;
import cn.myapps.runtime.dynaform.form.FormDataPacket;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.form.service.FormRunTimeService;
import cn.myapps.util.StringUtil;
import com.bcxin.saas.core.exceptions.SaasNofoundException;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u8868\u5355\u6267\u884c\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/runtime/{applicationId}"}, produces={"application/json;charset=UTF-8"})
public class FormController
extends AbstractRuntimeController {
    @Autowired
    private FormRunTimeService formRunTimeService;

    @GetMapping(path={"/forms/{formid}/documents/{docid}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u4fe1\u606f", notes="\u83b7\u53d6\u8868\u5355\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="formid", value="\u8868\u5355Id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docid", value="\u6587\u6863Id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="isReadonly", value="\u662f\u5426\u53ea\u8bfb", required=false, paramType="query", dataType="boolean")})
    public Resource findFormDataPacket(@PathVariable String applicationId, @PathVariable String formid, @PathVariable String docid, @RequestParam(required=false) boolean isReadonly) throws Exception {
        FormDataPacket result = this.formRunTimeService.findFormDataPacket(applicationId, formid, docid, isReadonly, this.getParams(), (IUser)this.getUser());
        if (result != null) {
            MemoryCacheUtil.putToPrivateSpace((Object)result.getDocument().getId(), (Object)result.getDocument(), (IUser)this.getUser());
            return this.success("ok", result);
        }
        throw new ResourceNotFoundException("Not Found");
    }

    @GetMapping(path={"/forms/{formid}/documents/{docid}/openable"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5224\u65ad\u8868\u5355\u6253\u5f00\u6743\u9650", notes="\u5224\u65ad\u8868\u5355\u6253\u5f00\u6743\u9650")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="formid", value="\u8868\u5355Id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docid", value="\u6587\u6863Id", required=true, paramType="path", dataType="string")})
    public Resource documentOpenable(@PathVariable String applicationId, @PathVariable String formid, @PathVariable String docid) throws Exception {
        boolean openable = this.formRunTimeService.openable(applicationId, formid, docid, this.getParams(), (IUser)this.getUser());
        return this.success("ok", openable);
    }

    @GetMapping(path={"/forms/{formId}/openable"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5224\u65ad\u8868\u5355\u6253\u5f00\u6743\u9650", notes="\u5224\u65ad\u8868\u5355\u6253\u5f00\u6743\u9650")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="formId", value="\u8868\u5355Id", required=true, paramType="path", dataType="string")})
    public Resource documentOpenable(@PathVariable String applicationId, @PathVariable String formId) throws Exception {
        FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
        Form form = formService.doView(formId);
        if (form == null) {
            throw new SaasNofoundException(String.format("\u65e0\u6548\u8868(%s)\u5355\u4fe1\u606f", formId));
        }
        boolean allow = true;
        if (!"public".equals(form.getPermissionType())) {
            WebUser user = this.getUser();
            String[] roleids = user.getRolelist(applicationId).split(",");
            allow = PermissionUtil.check((String[])roleids, (String)formId, (String)formId, (int)1032);
        }
        return this.success("ok", allow);
    }

    @PostMapping(path={"/forms/{formid}/documents/{docid}/refresh"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5237\u65b0\u8868\u5355", notes="\u5237\u65b0\u8868\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="formid", value="\u8868\u5355Id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docid", value="\u6587\u6863Id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5185\u5bb9", required=true, paramType="body", dataType="string")})
    public Resource documentRefresh(@PathVariable String applicationId, @PathVariable String formid, @PathVariable String docid, @RequestBody String content) throws Exception {
        WebUser user = this.getUser();
        if (user == null) {
            throw new Exception("\u7528\u6237\u672a\u767b\u9646");
        }
        Configuration configuration = Configuration.defaultConfiguration();
        configuration = configuration.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
        DocumentContext parse = JsonPath.parse((String)content, (Configuration)configuration);
        String actField = (String)parse.read("$.actField", new Predicate[0]);
        String tabId = (String)parse.read("$.tabId", new Predicate[0]);
        Map items = (Map)parse.read("$.document.items", new Predicate[0]);
        ParamsTable params = this.getParams();
        String templateForm = (String)parse.read("$.document.templateForm", new Predicate[0]);
        params.setParameter("templateForm", (Object)templateForm);
        Map refresh = this.formRunTimeService.refresh(applicationId, formid, docid, actField, tabId, items, params, (IUser)user);
        return this.success("ok", refresh);
    }

    @GetMapping(path={"/forms/{formid}/empty"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u65b0\u5efa\u7a7a\u6587\u6863", notes="\u65b0\u5efa\u7a7a\u6587\u6863")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="formid", value="\u8868\u5355Id", required=true, paramType="path", dataType="string")})
    public Resource newDocument(@PathVariable String applicationId, @PathVariable String formid) throws Exception {
        ParamsTable params = this.getParams();
        params.setParameter("formId", (Object)formid);
        WebUser user = this.getUser();
        Document doc = this.formRunTimeService.newDocument(applicationId, params, (IUser)user);
        return this.success("ok", doc);
    }

    @GetMapping(value={"/getUploadFieldWaterMark"})
    @ResponseBody
    public String getUploadFieldWaterMark(@RequestParam String waterMarkSetting) {
        try {
            ParamsTable params = ParamsTable.convertHTTP((HttpServletRequest)this.request);
            WebUser user = this.getUser();
            if (!StringUtil.isBlank((String)waterMarkSetting)) {
                JSONObject setting = JSONObject.fromObject((Object)waterMarkSetting);
                String applicationid = setting.getString("applicationId");
                String docId = setting.getString("docId");
                String itemId = setting.getString("itemId");
                if (!StringUtil.isBlank((String)applicationid)) {
                    DocumentProcess docProcess = RunTimeServiceManager.documentProcess((String)applicationid);
                    String result = docProcess.getUploadFieldWaterMark(docId, itemId, (IUser)user, params);
                    return result;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ResponseBody
    @RequestMapping(value={"/fileDownloadWithWaterMark"})
    public String doFileDownloadWithWaterMark(@RequestParam String filename, @RequestParam String filepath, @RequestParam String waterMarkSetting) throws Exception {
        Object os = null;
        File file = null;
        InputStream ins = null;
        try {
            String encoding = "ISO-8859-1";
            filename = filename.substring(0, filename.lastIndexOf(".")) + ".pdf";
            if (!filepath.startsWith("/uploads/")) {
                String string = "none";
                return string;
            }
            filepath = URLDecoder.decode(filepath, encoding);
            String realPath = PropertyUtil.getPath();
            if (!StringUtil.isBlank((String)waterMarkSetting)) {
                JSONObject setting = JSONObject.fromObject((Object)waterMarkSetting);
                String applicationid = setting.getString("applicationId");
                String docId = setting.getString("docId");
                String itemId = setting.getString("itemId");
                DocumentProcess docProcess = RunTimeServiceManager.documentProcess((String)applicationid);
                file = docProcess.getPdfWithWaterMark(docId, itemId, realPath, filepath, filename, (IUser)this.getUser());
            }
            String string = file.getAbsolutePath();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return "none";
    }
}

