/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.dynaform.form.controller;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.ftp.Ftp;
import cn.hutool.extra.ftp.FtpMode;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.controller.ResourceNotFoundException;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.util.FileWriteUtil;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.StringUtil;
import cn.myapps.conf.FileModeConfig;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.ejb.DocumentProcess;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.upload.ejb.UploadInfo;
import cn.myapps.runtime.dynaform.upload.ejb.UploadProcess;
import cn.myapps.runtime.dynaform.upload.ejb.UploadVO;
import cn.myapps.util.ftp.FtpUtils;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u8868\u5355\u6587\u4ef6\u4e0a\u4f20\u6267\u884c\u6a21\u5757"})
@RequestMapping(value={"/api"})
@RestController
public class FileUploadController
extends AbstractRuntimeController {
    @GetMapping(value={"/runtime/file/{fileId}/pdf"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u901a\u8fc7\u6587\u4ef6\u8def\u52b2\u83b7\u53d6\u5bf9\u5e94\u7684pdf\u6587\u4ef6", notes="\u901a\u8fc7\u6587\u4ef6\u8def\u52b2\u83b7\u53d6\u5bf9\u5e94\u7684pdf\u6587\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fileId", value="\u6587\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="path", value="\u8def\u5f84", required=true, paramType="query", dataType="string")})
    public Resource getPdfFile(@PathVariable String fileId, @RequestParam(value="path") String path) throws Exception {
        if (StringUtil.isBlank((String)path)) {
            return this.resourceNotFound(new ResourceNotFoundException("\u8def\u5f84\u4e3a\u7a7a"));
        }
        String tmp = path;
        int index = tmp.indexOf(fileId);
        StringBuffer pdfPath = new StringBuffer();
        pdfPath.append(tmp.substring(0, index));
        pdfPath.append("swf");
        pdfPath.append("/").append(fileId).append(".pdf");
        String rootPath = PropertyUtil.getPath();
        String filePath = rootPath + pdfPath.toString();
        File file = new File(filePath);
        if (!file.exists()) {
            if (path.lastIndexOf(".pdf") > 0) {
                return this.success("ok", path);
            }
            return this.resourceNotFound(new ResourceNotFoundException("PDF\u8d44\u6e90\u672a\u627e\u5230"));
        }
        return this.success("ok", pdfPath);
    }

    @PostMapping(value={"/runtime/upload"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6587\u4ef6\u4e0a\u4f20", notes="\u6587\u4ef6\u4e0a\u4f20")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="allowedTypes", value="\u5141\u8bb8\u4e0a\u4f20\u7c7b\u578b", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="fieldId", value="\u8868\u5355\u5b57\u6bb5", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="fileSaveMode", value="\u6587\u4ef6\u4fdd\u5b58\u6a21\u5f0f", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="path", value="\u4e0a\u4f20\u6587\u4ef6\u4fdd\u5b58\u7684\u8def\u5f84", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="actionType", value="\u7c7b\u578b", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="multipartFiles", value="\u591a\u4e2a\u6587\u4ef6", required=true, paramType="query", dataType="string")})
    public Resource upload(@RequestParam(value="applicationId") String applicationId, @RequestParam(value="allowedTypes") String allowedTypes, @RequestParam(value="fieldId") String fieldId, @RequestParam(value="fileSaveMode") String fileSaveMode, @RequestParam(value="path") String path, @RequestParam(value="actionType") String actionType, @RequestParam(value="files") MultipartFile[] multipartFiles) throws Exception {
        JSONArray result = new JSONArray();
        if (multipartFiles.length > 0) {
            for (int i = 0; i < multipartFiles.length; ++i) {
                MultipartFile multipartFile = multipartFiles[i];
                String id = UUID.randomUUID().toString();
                String fileName = multipartFile.getOriginalFilename();
                Long size = multipartFile.getSize();
                String extName = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
                fileName = fileName.substring(0, fileName.lastIndexOf(".") + 1) + extName;
                String uploadContentType = allowedTypes + "/" + extName;
                if (path.indexOf("/") != -1) {
                    path = path.substring(1);
                }
                String savePath = PropertyUtil.getPath();
                savePath = savePath + this.getUploadInfo(allowedTypes, uploadContentType, fileName, fileSaveMode, path).getFileDir();
                Calendar cal = Calendar.getInstance();
                int year = cal.get(1);
                savePath = savePath + File.separator + year;
                UploadInfo upload = this.getUploadInfo(allowedTypes, uploadContentType, fileName, fileSaveMode, path);
                if (fileName.indexOf("/") >= 0 || fileName.indexOf("\\") >= 0) {
                    throw new OBPMValidateException("\u4e0a\u4f20\u7684\u6587\u4ef6\u540d\u79f0\u4e0d\u5408\u6cd5\uff01");
                }
                if (this.isNotLegalFileExt(extName)) {
                    return this.error(4001, "\u4e0a\u4f20\u7684\u6587\u4ef6\u7c7b\u578b\u4e0d\u5408\u6cd5\uff01", null);
                }
                if (FileModeConfig.getUseFtp().booleanValue() && savePath.indexOf("/uploads/lib/icon/") < 0) {
                    String uploadPath = upload.getFileDir() + year + "/";
                    Ftp ftp = new Ftp(FileModeConfig.getHost(), FileModeConfig.getPort(), FileModeConfig.getUserName(), FileModeConfig.getPassword());
                    ftp.setMode(FtpMode.Passive);
                    String destPath = (StrUtil.isEmpty((CharSequence)FileModeConfig.getFilePath()) ? "" : FileModeConfig.getFilePath()) + uploadPath;
                    boolean uploadResult = ftp.upload(destPath, id + "." + extName, multipartFile.getInputStream());
                    System.out.println(StrUtil.format((CharSequence)"\u8def\u5f84: {},{}", (Object[])new Object[]{destPath, fileName}));
                    IoUtil.close((Closeable)ftp);
                    if (!uploadResult) {
                        return this.error(new Exception("\u4e0a\u4f20\u5931\u8d25"));
                    }
                } else {
                    File dir = new File(savePath);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    File f = new File(savePath + "/" + id + "." + extName);
                    f.createNewFile();
                    multipartFile.transferTo(f);
                    if (applicationId != null && !applicationId.equals("")) {
                        UploadProcess uploadProcess = RunTimeServiceManager.uploadProcess((String)applicationId);
                        UploadVO uploadVO = new UploadVO();
                        uploadVO.setId(id);
                        uploadVO.setName(upload.getFileName());
                        uploadVO.setFieldid(fieldId);
                        uploadVO.setType("." + extName);
                        uploadVO.setSize(size.longValue());
                        uploadVO.setModifyDate(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
                        uploadVO.setUserid(this.getUser().getId());
                        uploadVO.setPath(upload.getFileDir() + year + "/" + id + "." + extName);
                        uploadVO.setFolderPath(upload.getFileDir());
                        uploadProcess.doCreate(uploadVO);
                        if (!"excelImport".equals(actionType) && this.isTransferToPdf(uploadVO.getType())) {
                            String rootPath = PropertyUtil.getPath();
                            FileWriteUtil.writeKmConvertTask((String)rootPath, (String)id, (String)f.getPath());
                        }
                    }
                }
                JSONObject responseInfoItem = new JSONObject();
                responseInfoItem.put((Object)"fileName", (Object)upload.getFileSaveName());
                responseInfoItem.put((Object)"filePath", (Object)(upload.getFileDir() + year + "/" + id + "." + extName));
                responseInfoItem.put((Object)"fileSize", (Object)size);
                responseInfoItem.put((Object)"fileType", (Object)("." + extName));
                result.add((Object)responseInfoItem);
            }
        }
        return this.success("ok", result);
    }

    @PostMapping(value={"/runtime/upload/ftp"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6587\u4ef6\u4e0a\u4f20", notes="\u6587\u4ef6\u4e0a\u4f20")
    public Resource upload(MultipartFile multipartFile) throws Exception {
        JSONArray result = new JSONArray();
        String id = UUID.randomUUID().toString();
        String fileName = multipartFile.getOriginalFilename();
        Long size = multipartFile.getSize();
        String extName = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
        fileName = fileName.substring(0, fileName.lastIndexOf(".") + 1) + extName;
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        if (fileName.indexOf("/") >= 0 || fileName.indexOf("\\") >= 0) {
            throw new OBPMValidateException("\u4e0a\u4f20\u7684\u6587\u4ef6\u540d\u79f0\u4e0d\u5408\u6cd5\uff01");
        }
        if (this.isNotLegalFileExt(extName)) {
            return this.error(4001, "\u4e0a\u4f20\u7684\u6587\u4ef6\u7c7b\u578b\u4e0d\u5408\u6cd5\uff01", null);
        }
        String uploadPath = "/uploads/item/" + year + "/" + id + "." + extName;
        FtpUtils.bcxUploadFile((String)FileModeConfig.getHost(), (String)FileModeConfig.getUserName(), (String)FileModeConfig.getPassword(), (int)FileModeConfig.getPort(), (String)((StrUtil.isEmpty((CharSequence)FileModeConfig.getFilePath()) ? "" : FileModeConfig.getFilePath()) + uploadPath), (InputStream)multipartFile.getInputStream());
        JSONObject responseInfoItem = new JSONObject();
        responseInfoItem.put((Object)"fileName", (Object)fileName);
        responseInfoItem.put((Object)"filePath", (Object)("/uploads/item/" + year + "/" + id + "." + extName));
        responseInfoItem.put((Object)"fileSize", (Object)size);
        responseInfoItem.put((Object)"fileType", (Object)("." + extName));
        result.add((Object)responseInfoItem);
        return this.success("ok", result);
    }

    public UploadInfo getUploadInfo(String allowedTypes, String uploadContentType, String fileName, String fileSaveMode, String path) {
        UploadInfo uploadInfo = new UploadInfo();
        uploadInfo.setAllowedTypes(allowedTypes);
        uploadInfo.setContentType(uploadContentType);
        uploadInfo.setFileName(fileName);
        uploadInfo.setFileSaveMode(fileSaveMode);
        try {
            uploadInfo.setPath(path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return uploadInfo;
    }

    private boolean isNotLegalFileExt(String fileExt) throws Exception {
        String[] excludeTypes = new String[]{"jsp", "class", "jspx"};
        if (StringUtil.isBlank((String)fileExt)) {
            return true;
        }
        String fileType = fileExt;
        for (int i = 0; i < excludeTypes.length; ++i) {
            String excludeType = excludeTypes[i];
            if (StringUtil.isBlank((String)excludeType) || !fileType.equalsIgnoreCase(excludeType)) continue;
            return true;
        }
        return false;
    }

    @PostMapping(value={"/runtime/files/sort"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6587\u4ef6\u6392\u5e8f", notes="\u6587\u4ef6\u6392\u5e8f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource fileSort(@RequestBody String content) throws Exception {
        Configuration configuration = Configuration.defaultConfiguration();
        configuration = configuration.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
        DocumentContext parse = JsonPath.parse((String)content, (Configuration)configuration);
        String applicationId = (String)parse.read("$.applicationId", new Predicate[0]);
        String formId = (String)parse.read("$.formId", new Predicate[0]);
        String docId = (String)parse.read("$.docId", new Predicate[0]);
        String itemName = (String)parse.read("$.itemName", new Predicate[0]);
        String itemVal = (String)parse.read("$.itemValue", new Predicate[0]);
        DocumentProcess docProcess = RunTimeServiceManager.documentProcess((String)applicationId);
        String resultStr = docProcess.updateFileSorting(docId, formId, itemName, itemVal);
        JSONObject jsonObject = JSONObject.fromObject((Object)resultStr);
        JSONArray json = jsonObject.getJSONArray("datas");
        return this.success("ok", json);
    }

    @DeleteMapping(value={"/runtime/files/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u6587\u4ef6", notes="\u5220\u9664\u6587\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="path", value="\u6587\u4ef6\u4fdd\u5b58\u8def\u5f84", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="formId", value="\u8868\u5355id", required=true, paramType="query", dataType="string")})
    public Resource deleteFile(String applicationId, String docId, String path, String formId) throws Exception {
        if (!StringUtil.isBlank((String)path)) {
            path = URLDecoder.decode(path, "UTF-8");
            UploadProcess uploadProcess = RunTimeServiceManager.uploadProcess((String)applicationId);
            UploadVO uploadVO = null;
            if (!StringUtil.isBlank((String)path) && path.indexOf("_/uploads") > 0) {
                String fileId = path.substring(0, path.indexOf("_/uploads"));
                uploadVO = (UploadVO)uploadProcess.doView(fileId);
            } else {
                uploadVO = uploadProcess.findByColumnName1("PATH", path);
            }
            if (uploadVO != null) {
                String fileRealPath = this.request.getServletContext().getRealPath(uploadVO.getPath());
                File file = new File(fileRealPath);
                if (file.exists() && !file.delete()) {
                    throw new OBPMValidateException("File(" + fileRealPath + ") delete failed");
                }
                uploadProcess.doRemove(uploadVO.getId());
                if (!StringUtil.isBlank((String)applicationId)) {
                    Document doc;
                    DocumentProcess docProcess = RunTimeServiceManager.documentProcess((String)applicationId);
                    if (!StringUtil.isBlank((String)docId) && (doc = (Document)docProcess.doView(docId)) != null) {
                        doc = this.rebuildDocument(doc, this.getParams(), formId);
                        docProcess.doUpdate((IDocument)doc, false, false);
                    }
                }
            }
        }
        return this.success("ok", "\u5220\u9664\u6210\u529f");
    }

    private Document rebuildDocument(Document doc, ParamsTable params, String formid) {
        try {
            if (!StringUtil.isBlank((String)doc.getId()) && !StringUtil.isBlank((String)formid)) {
                FormDesignTimeService formPross = DesignTimeServiceManager.formDesignTimeService();
                Form form = formPross.doView(formid);
                doc = form.createDocument(doc, params, (IUser)this.getUser());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    private boolean isTransferToPdf(String name) {
        return (name = name.toLowerCase()).indexOf("png") < 0 && name.indexOf("ico") < 0 && name.indexOf(".gif") < 0 && name.indexOf(".jpg") < 0 && name.indexOf(".jpeg") < 0 && name.indexOf(".bmp") < 0 && name.indexOf("pdf") < 0;
    }
}

