/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.dynaform.form.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.model.comment.CommentVO;
import cn.myapps.runtime.comment.CommentProcess;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Date;
import net.sf.json.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u8bc4\u8bba\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/runtime/{applicationId}"})
public class CommentController
extends AbstractRuntimeController {
    @GetMapping(path={"/flags/{flag}/comments/count"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u8bc4\u8bba\u7edf\u8ba1", notes="\u83b7\u53d6\u8bc4\u8bba\u7edf\u8ba1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="flag", value="\u8bc4\u8bba\u6807\u8bc6", required=true, paramType="path", dataType="string")})
    public Resource getCommentsCount(@PathVariable String applicationId, @PathVariable String flag) throws Exception {
        CommentProcess commentProcess = RunTimeServiceManager.commentProcess((String)applicationId);
        CommentVO comment = commentProcess.findByParentId(flag);
        if (comment == null) {
            comment = new CommentVO();
            WebUser user = this.getUser();
            comment.setApplicationid(applicationId);
            comment.setFlag(flag);
            comment.setDomainid(user.getDomainid());
            comment.setUserId(user.getId());
            comment.setUserName(user.getName());
            comment.setCreateDate(new Date());
            comment.setParentId(flag);
            commentProcess.doCreate(comment);
        }
        JSONObject result = new JSONObject();
        result.put((Object)"commentNum", (Object)commentProcess.countCommentsByFlagAndParentId(flag, ""));
        result.put((Object)"likeNum", (Object)comment.getLikeNum());
        result.put((Object)"id", (Object)comment.getId());
        return this.success("ok", result);
    }

    @GetMapping(path={"/flags/{flag}/comments"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u8bc4\u8bba\u5217\u8868", notes="\u83b7\u53d6\u8bc4\u8bba\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="flag", value="\u8bc4\u8bba\u6807\u8bc6", required=true, paramType="path", dataType="string")})
    public Resource getComments(@PathVariable String applicationId, @PathVariable String flag) throws Exception {
        CommentProcess commentProcess = RunTimeServiceManager.commentProcess((String)applicationId);
        Collection comments = commentProcess.getComments(flag);
        UserProcess userService = AuthTimeServiceManager.userRuntimeService();
        for (CommentVO comment : comments) {
            UserVO user = (UserVO)userService.doView(comment.getUserId());
            if (user == null) continue;
            comment.setAvatar(user.getAvatarUri());
        }
        return this.success("ok", comments);
    }

    @GetMapping(path={"/comments/{commentId}/answers"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u56de\u590d\u5217\u8868", notes="\u83b7\u53d6\u56de\u590d\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="commentId", value="\u8bc4\u8bbaid", required=true, paramType="path", dataType="string")})
    public Resource getAnswers(@PathVariable String applicationId, @PathVariable String commentId) throws Exception {
        CommentProcess commentProcess = RunTimeServiceManager.commentProcess((String)applicationId);
        Collection comments = commentProcess.getAnswers(commentId);
        UserProcess userService = AuthTimeServiceManager.userRuntimeService();
        for (CommentVO comment : comments) {
            UserVO user = (UserVO)userService.doView(comment.getUserId());
            if (user == null) continue;
            comment.setAvatar(user.getAvatarUri());
        }
        return this.success("ok", comments);
    }

    @PostMapping(path={"/flags/{flag}/comments"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u6587\u6863", notes="\u83b7\u53d6\u6587\u6863")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="flag", value="\u8bc4\u8bba\u6807\u8bc6", required=true, paramType="path", dataType="string")})
    public Resource createComment(@PathVariable String applicationId, @PathVariable String flag, @RequestBody CommentVO comment) throws Exception {
        CommentProcess commentProcess = RunTimeServiceManager.commentProcess((String)applicationId);
        WebUser user = this.getUser();
        comment.setApplicationid(applicationId);
        comment.setFlag(flag);
        comment.setDomainid(user.getDomainid());
        comment.setUserId(user.getId());
        comment.setUserName(user.getName());
        comment.setCreateDate(new Date());
        commentProcess.doCreate(comment);
        return this.success("ok", comment);
    }

    @PutMapping(path={"/comments/{commentId}/like"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u70b9\u8d5e", notes="\u70b9\u8d5e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="commentId", value="\u8bc4\u8bbaid", required=true, paramType="path", dataType="string")})
    public Resource likeComment(@PathVariable String applicationId, @PathVariable String commentId) throws Exception {
        CommentProcess commentProcess = RunTimeServiceManager.commentProcess((String)applicationId);
        CommentVO comment = commentProcess.find(commentId);
        comment.setLikeNum(comment.getLikeNum() + 1);
        commentProcess.doUpdate(comment);
        return this.success("ok", comment.getLikeNum());
    }

    @PutMapping(path={"/comments/{commentId}/unlike"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u89c9\u5f97\u4e0d\u884c", notes="\u89c9\u5f97\u4e0d\u884c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="commentId", value="\u8bc4\u8bbaid", required=true, paramType="path", dataType="string")})
    public Resource unlikeComment(@PathVariable String applicationId, @PathVariable String commentId) throws Exception {
        CommentProcess commentProcess = RunTimeServiceManager.commentProcess((String)applicationId);
        CommentVO comment = commentProcess.find(commentId);
        comment.setUnlikeNum(comment.getUnlikeNum() + 1);
        commentProcess.doUpdate(comment);
        return this.success("ok", comment.getUnlikeNum());
    }
}

