/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.dynaform.form;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.Environment;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.util.Security;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.form.ejb.QRCodeField;
import cn.myapps.runtime.macro.runner.IRunner;
import cn.myapps.runtime.macro.runner.JavaScriptFactory;
import cn.myapps.support.weixin.WeixinServiceProxy;
import cn.myapps.util.CreateProcessException;
import cn.myapps.util.StringUtil;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class QRCodeFiledScanEventReadyServlet
extends HttpServlet {
    private static final long serialVersionUID = -5644106523329927589L;
    private static final String weioa365_addr = "https://yun.weioa365.com/{site_id}";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String domainId = req.getParameter("domainId");
        String formId = req.getParameter("formId");
        String docId = req.getParameter("docId");
        String fieldId = req.getParameter("fieldId");
        String applicationId = req.getParameter("applicationId");
        String _randomCode = req.getParameter("_randomCode");
        String accessToken = Security.getTokenFromRequest((HttpServletRequest)req);
        if (StringUtil.isBlank((String)accessToken)) {
            accessToken = req.getParameter("access_token");
        }
        try {
            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
            FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
            if (this.isFromWeixin(req)) {
                DomainVO domain = (DomainVO)domainProcess.doView(domainId);
                Form form = formService.doView(formId);
                QRCodeField qrcodeField = (QRCodeField)form.findField(fieldId);
                String redirect = null;
                if ("link".equals(qrcodeField.getHandleType())) {
                    if ("local".equals(domain.getWeixinProxyType()) || "EnterpriseWeChat".equals(domain.getWeixinProxyType())) {
                        redirect = domain.getServerHost() + "/mobile/index.html?application=" + applicationId + "#/open?linkType=00&actionContent=" + formId;
                    } else if ("cloud".equals(domain.getWeixinProxyType())) {
                        redirect = weioa365_addr.replace("{site_id}", Environment.getMACAddress()) + "/portal/phone/main.jsp?application=" + applicationId + "&jumpToUrl=" + Environment.getInstance().getContextPath() + "/portal/dynaform/document/view.action?_formid=" + formId + "&_docid=" + docId + "&application=" + applicationId + "&openType=from_weixin_message&_backURL=" + Environment.getInstance().getContextPath() + "/portal/index.html";
                    }
                } else if ("callback_event".equals(qrcodeField.getHandleType())) {
                    if ("local".equals(domain.getWeixinProxyType()) || "EnterpriseWeChat".equals(domain.getWeixinProxyType())) {
                        redirect = domain.getServerHost() + "/portal/document/qrcodefield/handle?action=excute&domainId=" + domain.getId() + "&formId=" + formId + "&formId=" + formId + "&docId=" + docId + "&fieldId=" + fieldId + "&applicationId=" + applicationId + "&application=" + applicationId + "&_randomCode=" + _randomCode;
                    } else if ("cloud".equals(domain.getWeixinProxyType())) {
                        redirect = weioa365_addr.replace("{site_id}", Environment.getMACAddress()) + "/portal/document/qrcodefield/handle?action=excute&domainId=" + domain.getId() + "&formId=" + formId + "&formId=" + formId + "&docId=" + docId + "&fieldId=" + fieldId + "&applicationId=" + applicationId + "&_randomCode=" + _randomCode;
                    }
                }
                redirect = URLEncoder.encode(redirect, "utf-8");
                String redirect_uri = null;
                if ("link".equals(qrcodeField.getHandleType())) {
                    redirect_uri = redirect;
                } else if ("callback_event".equals(qrcodeField.getHandleType())) {
                    if ("local".equals(domain.getWeixinProxyType()) || "EnterpriseWeChat".equals(domain.getWeixinProxyType())) {
                        redirect_uri = domain.getServerHost() + "/mobile/index.html?#/qrcodeCallback";
                    } else if ("cloud".equals(domain.getWeixinProxyType())) {
                        redirect_uri = weioa365_addr.replace("{site_id}", Environment.getMACAddress()) + "/portal/phone/resource/component/qrcodeFiled/callback-confirm.jsp";
                    }
                    IRunner runner = JavaScriptFactory.getInstance((String)"", (String)applicationId);
                    runner.initBSFManager((IDocument)new Document(), new ParamsTable(), (IUser)new WebUser(), new ArrayList());
                    redirect_uri = redirect_uri + "?application=" + applicationId + "&redirect=" + redirect + "&title=" + qrcodeField.getName() + "&discript=" + qrcodeField.getDiscript(runner);
                    redirect_uri = URLEncoder.encode(redirect_uri, "utf-8");
                }
                String url = this.getWeiXinOAuthUrl(domain, redirect_uri);
                resp.sendRedirect(url);
                return;
            }
            if (this.isFromDingDing(req)) {
                DomainVO domain = (DomainVO)domainProcess.doView(domainId);
                String dingdingCorpId = domain.getDingdingCorpID();
                String dingdingUrl = "/static/dingding.html?domainid=" + domain.getId() + "&corpid=" + dingdingCorpId + "&appid=" + applicationId + "&actionContent=" + formId + "&docid=" + docId + "&formid=" + formId;
                resp.sendRedirect(dingdingUrl);
                return;
            }
            Form form = formService.doView(formId);
            QRCodeField qrcodeField = (QRCodeField)form.findField(fieldId);
            String redirect = null;
            if ("link".equals(qrcodeField.getHandleType())) {
                redirect = "/static/mobile/index.html?application=" + applicationId + "#/open?linkType=00&actionContent=" + formId + "&docid=" + docId + "&accessToken=" + accessToken;
            } else if ("callback_event".equals(qrcodeField.getHandleType())) {
                redirect = req.getContextPath() + "/portal/document/qrcodefield/handle?action=excute&domainId=" + domainId + "&formId=" + formId + "&formId=" + formId + "&docId=" + docId + "&fieldId=" + fieldId + "&applicationId=" + applicationId + "&application=" + applicationId + "&_randomCode=" + _randomCode + "&accessToken=" + accessToken;
            }
            resp.sendRedirect(redirect);
            return;
        }
        catch (CreateProcessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPost(req, resp);
    }

    private String getWeiXinOAuthUrl(DomainVO domain, String redirect_uri) {
        StringBuilder url = new StringBuilder();
        if ("local".equals(domain.getWeixinProxyType()) || "EnterpriseWeChat".equals(domain.getWeixinProxyType())) {
            url.append("https://open.weixin.qq.com/connect/oauth2/authorize?appid=").append(domain.getWeixinCorpID()).append("&redirect_uri=").append(redirect_uri).append("&response_type=code&scope=snsapi_base&state=").append(domain.getId()).append("#wechat_redirect");
        } else if ("cloud".equals(domain.getWeixinProxyType())) {
            String corpId = null;
            try {
                Environment.getInstance();
                corpId = WeixinServiceProxy.getCorpId((String)Environment.getMACAddress(), (String)domain.getId());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            url.append("https://open.weixin.qq.com/connect/oauth2/authorize?appid=").append(corpId).append("&redirect_uri=").append(redirect_uri).append("&response_type=code&scope=snsapi_base&state=").append(domain.getId()).append("#wechat_redirect");
        }
        return url.toString();
    }

    private boolean isFromWeixin(HttpServletRequest request) {
        String userAgent = request.getHeader("user-agent");
        return userAgent.contains("MicroMessenger");
    }

    private boolean isFromDingDing(HttpServletRequest request) {
        String userAgent = request.getHeader("user-agent");
        return userAgent.contains("DingTalk");
    }
}

