/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.dynaform.document.controller;

import cn.hutool.core.util.StrUtil;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.Environment;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.controller.ResourceNotFoundException;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.ValueObject;
import cn.myapps.common.model.workflow.BillDefiVO;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.cache.MemoryCacheUtil;
import cn.myapps.conf.FileModeConfig;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.ejb.DocumentProcess;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.dynaform.form.ejb.ButtonField;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.form.ejb.FormField;
import cn.myapps.runtime.dynaform.form.ejb.TabField;
import cn.myapps.runtime.form.service.FormHelperRunTimeService;
import cn.myapps.runtime.macro.runner.IRunner;
import cn.myapps.runtime.macro.runner.JavaScriptFactory;
import cn.myapps.runtime.workflow.element.FlowDiagram;
import cn.myapps.runtime.workflow.element.Node;
import cn.myapps.runtime.workflow.engine.StateMachine;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowStateRT;
import cn.myapps.runtime.workflow.storage.runtime.ejb.NodeRT;
import cn.myapps.util.StringUtil;
import cn.myapps.util.ftp.FtpUtils;
import cn.myapps.util.json.JsonTmpUtil;
import com.alibaba.fastjson.JSON;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.pdf.ElectronicSignatureByKey;
import com.kinggrid.pdf.KGExecute;
import com.kinggrid.pdf.KGPdfHummer;
import com.kinggrid.pdf.executes.PdfElectronicSeal4KG;
import com.kinggrid.pdf.executes.electronicseal.KGPdfElectronicExecute;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u8868\u5355\u5de5\u5177\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/runtime"}, produces={"application/json;charset=UTF-8"})
public class FormHelperController
extends AbstractRuntimeController {
    private static final Logger logger = LoggerFactory.getLogger(FormHelperController.class);
    @Autowired
    private FormHelperRunTimeService service;

    @GetMapping(value={"/files/preview/environment"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5224\u65ad\u662f\u5426\u5b58\u5728\u9884\u89c8\u73af\u5883(\u7528\u4e8e\u5728\u7ebf\u9884\u89c8)", notes="\u5224\u65ad\u662f\u5426\u5b58\u5728\u9884\u89c8\u73af\u5883(\u7528\u4e8e\u5728\u7ebf\u9884\u89c8)")
    public Resource previewEnabled() throws Exception {
        return this.success("ok", true);
    }

    @GetMapping(value={"/files/hasPdf"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5224\u65ad\u8be5\u6587\u4ef6\u662f\u5426\u5b58\u5728pdf\u6587\u4ef6", notes="\u5224\u65ad\u8be5\u6587\u4ef6\u662f\u5426\u5b58\u5728pdf\u6587\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", value="\u8def\u5f84", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="fileRealName", value="\u771f\u5b9e\u540d\u79f0", required=true, paramType="query", dataType="string")})
    public Resource hasPdfFile(@RequestParam String path, @RequestParam String fileRealName) throws Exception {
        return this.success("ok", true);
    }

    private void getFtpFile(String path) {
        try {
            String fullPath = Environment.getInstance().getRealPath(path);
            File file = new File(fullPath);
            if (file.exists() && file.length() > 0L) {
                return;
            }
            String filePath = path.substring(0, path.lastIndexOf("/") + 1);
            String fileName = path.substring(path.lastIndexOf("/") + 1);
            FtpUtils.downloadFile((String)FileModeConfig.getHost(), (String)FileModeConfig.getUserName(), (String)FileModeConfig.getPassword(), (int)FileModeConfig.getPort(), (String)((StrUtil.isEmpty((CharSequence)FileModeConfig.getFilePath()) ? "" : FileModeConfig.getFilePath()) + filePath), (String)fullPath.substring(0, fullPath.lastIndexOf("/") + 1), (String)fileName);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @PostMapping(value={"/{applicationId}/documents/{docId}/files/watermark/print"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6c34\u5370\u6587\u4ef6\u6253\u5370", notes="\u6c34\u5370\u6587\u4ef6\u6253\u5370")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doFilePrintWithWaterMark(@PathVariable String applicationId, @PathVariable String docId, @RequestBody String content) throws Exception {
        com.alibaba.fastjson.JSONObject json = JSON.parseObject((String)content);
        String path = (String)json.get((Object)"path");
        if (!path.startsWith("/uploads/")) {
            throw new ResourceNotFoundException("Error: file illegal!");
        }
        String fileName = (String)json.get((Object)"fileName");
        String itemId = (String)json.get((Object)"itemId");
        String realPath = this.request.getSession().getServletContext().getRealPath("/");
        String result = this.service.doFilePrintWithWaterMark(applicationId, docId, itemId, realPath, path, fileName, (IUser)this.getUser());
        return this.success("ok", result);
    }

    @GetMapping(value={"/{applicationId}/documents/{docId}/formhelper/inputlog"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u63a7\u4ef6\u4fee\u6539\u5386\u53f2", notes="\u83b7\u53d6\u63a7\u4ef6\u4fee\u6539\u5386\u53f2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="fieldName", value="\u6587\u4ef6\u540d", required=true, paramType="query", dataType="string")})
    public Resource getFieldModifiedLog(@PathVariable String applicationId, @PathVariable String docId, @RequestParam String fieldName) throws Exception {
        JSONArray result = this.service.getFieldModifiedLog(docId, applicationId, fieldName, this.getParams(), (IUser)this.getUser());
        return this.success("ok", result);
    }

    @PostMapping(value={"/{applicationId}/documents/{docId}/htmlsignature"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u4fdd\u5b58\u91d1\u683cHTML\u7535\u5b50\u7b7e\u7ae0", notes="\u4fdd\u5b58\u91d1\u683cHTML\u7535\u5b50\u7b7e\u7ae0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource saveHTMLSignature(@PathVariable String applicationId, @PathVariable String docId, @RequestBody String content) throws Exception {
        DocumentProcess process = RunTimeServiceManager.documentProcess((String)applicationId);
        Document doc = (Document)process.doView(docId);
        if (doc != null) {
            JSONObject kinggridSignature;
            JSONObject signature = JSONObject.fromObject((Object)content);
            FlowStateRT instance = doc.getState();
            if (instance != null) {
                BillDefiVO flowVO = instance.getFlowVO();
                String currNodeId = null;
                FlowDiagram fd = null;
                if (flowVO != null) {
                    NodeRT nodert = null;
                    fd = flowVO.toFlowDiagram();
                    if (instance.isTemp()) {
                        nodert = (NodeRT)((List)instance.getNoderts()).get(0);
                        currNodeId = nodert.getNodeid();
                    }
                    if (currNodeId == null && nodert == null && (nodert = StateMachine.getCurrUserNodeRT((IDocument)doc, (IUser)this.getUser(), currNodeId)) != null) {
                        currNodeId = nodert.getNodeid();
                    }
                }
                Node currnode = null;
                if (currNodeId != null) {
                    currnode = (Node)fd.getElementByID(currNodeId);
                }
                if (currnode != null) {
                    signature.put((Object)"nodeId", (Object)currnode.getId());
                    signature.put((Object)"stateLabel", (Object)currnode.getStatelabel());
                }
            }
            if (!StringUtil.isBlank((String)doc.getKinggridSignature())) {
                JSONArray jsonArr;
                kinggridSignature = JSONObject.fromObject((Object)doc.getKinggridSignature());
                Object htmlSignature = kinggridSignature.get("htmlSignature");
                if (htmlSignature != null) {
                    jsonArr = (JSONArray)htmlSignature;
                    jsonArr.add((Object)signature);
                } else {
                    jsonArr = new JSONArray();
                    jsonArr.add((Object)signature);
                    kinggridSignature.put((Object)"htmlSignature", (Object)jsonArr);
                }
                doc.setKinggridSignature(kinggridSignature.toString());
            } else {
                kinggridSignature = new JSONObject();
                JSONArray jsonArr = new JSONArray();
                jsonArr.add((Object)signature);
                kinggridSignature.put((Object)"htmlSignature", (Object)jsonArr);
                doc.setKinggridSignature(kinggridSignature.toString());
            }
            process.doUpdate((ValueObject)doc);
            Document document = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)docId, (IUser)this.getUser());
            document.setKinggridSignature(doc.getKinggridSignature());
            MemoryCacheUtil.putToPrivateSpace((Object)docId, (Object)document, (IUser)this.getUser());
            return this.success("ok", null);
        }
        return this.error(4001, "\u8bf7\u5148\u4fdd\u5b58\u8868\u5355!", null);
    }

    @GetMapping(value={"/{applicationId}/documents/{docId}/htmlsignature"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u91d1\u683cHTML\u7535\u5b50\u7b7e\u7ae0", notes="\u83b7\u53d6\u91d1\u683cHTML\u7535\u5b50\u7b7e\u7ae0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863id", required=true, paramType="path", dataType="string")})
    public Resource getHTMLSignature(@PathVariable String applicationId, @PathVariable String docId) throws Exception {
        JSONObject kinggridSignature;
        Object htmlSignature;
        DocumentProcess process = RunTimeServiceManager.documentProcess((String)applicationId);
        Document doc = (Document)process.doView(docId);
        if (doc != null && !StringUtil.isBlank((String)doc.getKinggridSignature()) && (htmlSignature = (kinggridSignature = JSONObject.fromObject((Object)doc.getKinggridSignature())).get("htmlSignature")) != null) {
            JSONArray result = (JSONArray)htmlSignature;
            return this.success("ok", result);
        }
        return this.success("ok", null);
    }

    @PutMapping(value={"/{applicationId}/documents/{docId}/htmlsignature"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u65b0\u91d1\u683cHTML\u7535\u5b50\u7b7e\u7ae0", notes="\u66f4\u65b0\u91d1\u683cHTML\u7535\u5b50\u7b7e\u7ae0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u7b7e\u7ae0id\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource updateHTMLSignature(@PathVariable String applicationId, @PathVariable String docId, @RequestBody String content) throws Exception {
        DocumentProcess process = RunTimeServiceManager.documentProcess((String)applicationId);
        Document doc = (Document)process.doView(docId);
        if (doc != null && !StringUtil.isBlank((String)doc.getKinggridSignature())) {
            JSONObject kinggridSignature;
            Object htmlSignature;
            JSONArray ids = JsonTmpUtil.fromObject((Object)content);
            if (!StringUtil.isBlank((String)doc.getKinggridSignature()) && (htmlSignature = (kinggridSignature = JSONObject.fromObject((Object)doc.getKinggridSignature())).get("htmlSignature")) != null) {
                JSONArray htmlSignatureArr = (JSONArray)htmlSignature;
                if (ids.isEmpty()) {
                    JSONArray jsonArr = new JSONArray();
                    kinggridSignature.put((Object)"htmlSignature", (Object)jsonArr);
                } else {
                    Iterator iterator = htmlSignatureArr.iterator();
                    while (iterator.hasNext()) {
                        JSONObject json = (JSONObject)iterator.next();
                        String signatureId = json.getString("signatureId");
                        JSONObject oldeSignatureData = (JSONObject)json.get("signatureData");
                        boolean flag = true;
                        for (JSONObject next : ids) {
                            String id = next.getString("signatureId");
                            if (!signatureId.equals(id)) continue;
                            flag = false;
                            JSONObject newPosition = (JSONObject)next.get("position");
                            oldeSignatureData.put((Object)"position", (Object)newPosition);
                        }
                        if (!flag) continue;
                        iterator.remove();
                    }
                    kinggridSignature.put((Object)"htmlSignature", (Object)htmlSignatureArr);
                }
                doc.setKinggridSignature(kinggridSignature.toString());
            }
            process.doUpdate((ValueObject)doc);
            Document document = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)docId, (IUser)this.getUser());
            document.setKinggridSignature(doc.getKinggridSignature());
            MemoryCacheUtil.putToPrivateSpace((Object)docId, (Object)document, (IUser)this.getUser());
        }
        return this.success("ok", null);
    }

    @GetMapping(path={"/{applicationId}/documents/{docId}/signatureButtonFields"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u914d\u7f6e\u7684\u7b7e\u7ae0\u6309\u94ae", notes="\u83b7\u53d6\u8868\u5355\u914d\u7f6e\u7684\u7b7e\u7ae0\u6309\u94ae")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863Id", required=true, paramType="path", dataType="string")})
    public Resource getFormSignatureButtonFields(@PathVariable String applicationId, @PathVariable String docId) throws Exception {
        WebUser user = this.getUser();
        ParamsTable params = this.getParams();
        DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
        Document doc = (Document)dProcess.doView(docId);
        if (doc != null) {
            Form form = doc.getForm();
            doc = form.recalculateDocument(doc, params, (IUser)user);
            IRunner runner = JavaScriptFactory.getInstance((String)user.getSessionid(), (String)applicationId);
            runner.initBSFManager((IDocument)doc, params, (IUser)user, new ArrayList());
            ArrayList<Map> data = new ArrayList<Map>();
            Collection fields = form.getFields();
            for (FormField formField : fields) {
                Map value;
                if (formField instanceof TabField) {
                    value = formField.toAttributes(doc, runner, (IUser)user, 2);
                    ArrayList tabs = (ArrayList)value.get("tabs");
                    for (com.alibaba.fastjson.JSONObject tab : tabs) {
                        Object tabFieldsObj = tab.get((Object)"fields");
                        if (tabFieldsObj == null) continue;
                        ArrayList tabFields = (ArrayList)tab.get((Object)"fields");
                        for (HashMap fieldJson : tabFields) {
                            if (!"ButtonField".equals(String.valueOf(fieldJson.get("formField"))) || (Integer)fieldJson.get("activityType") != 28 || (Integer)fieldJson.get("displayType") == 3) continue;
                            data.add(fieldJson);
                        }
                    }
                }
                if (!(formField instanceof ButtonField) || ((ButtonField)formField).getActType() != 28) continue;
                value = formField.toAttributes(doc, runner, (IUser)user, 2);
                if (formField.getOtherPropsAsMap() != null && value != null && !value.isEmpty()) {
                    for (String propertyKey : formField.getOtherPropsAsMap().keySet()) {
                        if (value.get(propertyKey) != null) continue;
                        value.put(propertyKey, formField.getOtherPropsAsMap().get(propertyKey));
                    }
                }
                if ((Integer)value.get("displayType") == 3) continue;
                data.add(value);
            }
            return this.success("ok", data);
        }
        return this.success("ok", null);
    }

    @PutMapping(value={"/{applicationId}/documents/{docId}/pdfsignature"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u65b0\u91d1\u683cpdf\u7535\u5b50\u7b7e\u7ae0", notes="\u66f4\u65b0\u91d1\u683cpdf\u7535\u5b50\u7b7e\u7ae0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="flowDocId", value="\u6d41\u7a0b\u6587\u6863id", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="content", value="\u7b7e\u7ae0\u4fe1\u606f\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource updatePdfSignature(@PathVariable String applicationId, @PathVariable String docId, @RequestParam(required=false) String flowDocId, @RequestBody String content) throws Exception {
        DocumentProcess process = RunTimeServiceManager.documentProcess((String)applicationId);
        Document doc = (Document)process.doView(docId);
        if (doc != null) {
            JSONObject signatureData = JSONObject.fromObject((Object)content);
            signatureData.put((Object)"userId", (Object)this.getUser().getId());
            signatureData.put((Object)"signatureNum", (Object)1);
            if (!StringUtil.isBlank((String)flowDocId)) {
                FlowStateRT instance;
                Document flowDoc = (Document)process.doView(flowDocId);
                if (flowDoc != null && (instance = flowDoc.getState()) != null) {
                    BillDefiVO flowVO = instance.getFlowVO();
                    String currNodeId = null;
                    FlowDiagram fd = null;
                    if (flowVO != null) {
                        NodeRT nodert = null;
                        fd = flowVO.toFlowDiagram();
                        if (instance.isTemp()) {
                            nodert = (NodeRT)((List)instance.getNoderts()).get(0);
                            currNodeId = nodert.getNodeid();
                        }
                        if (currNodeId == null && nodert == null && (nodert = StateMachine.getCurrUserNodeRT((IDocument)flowDoc, (IUser)this.getUser(), currNodeId)) != null) {
                            currNodeId = nodert.getNodeid();
                        }
                    }
                    Node currnode = null;
                    if (currNodeId != null) {
                        currnode = (Node)fd.getElementByID(currNodeId);
                        signatureData.put((Object)"nodeId", (Object)currnode.id);
                        signatureData.put((Object)"statelabel", (Object)currnode.statelabel);
                    }
                }
            } else {
                FlowStateRT instance = doc.getState();
                if (instance != null) {
                    BillDefiVO flowVO = instance.getFlowVO();
                    String currNodeId = null;
                    FlowDiagram fd = null;
                    if (flowVO != null) {
                        NodeRT nodert = null;
                        fd = flowVO.toFlowDiagram();
                        if (instance.isTemp()) {
                            nodert = (NodeRT)((List)instance.getNoderts()).get(0);
                            currNodeId = nodert.getNodeid();
                        }
                        if (currNodeId == null && nodert == null && (nodert = StateMachine.getCurrUserNodeRT((IDocument)doc, (IUser)this.getUser(), currNodeId)) != null) {
                            currNodeId = nodert.getNodeid();
                        }
                    }
                    Node currnode = null;
                    if (currNodeId != null) {
                        currnode = (Node)fd.getElementByID(currNodeId);
                        signatureData.put((Object)"nodeId", (Object)currnode.id);
                        signatureData.put((Object)"statelabel", (Object)currnode.statelabel);
                    }
                }
            }
            if (!StringUtil.isBlank((String)doc.getKinggridSignature())) {
                JSONObject pdfSignatureJson;
                JSONObject kinggridSignature = JSONObject.fromObject((Object)doc.getKinggridSignature());
                Object versionObj = kinggridSignature.get("version");
                if (versionObj != null) {
                    int version = (Integer)versionObj;
                    kinggridSignature.put((Object)"version", (Object)(++version));
                } else {
                    kinggridSignature.put((Object)"version", (Object)1);
                }
                Object pdfSignature = kinggridSignature.get("pdfSignature");
                if (pdfSignature != null) {
                    JSONObject signaturesJson;
                    pdfSignatureJson = (JSONObject)pdfSignature;
                    Object signatures = pdfSignatureJson.get("signatures");
                    if (signatures != null) {
                        signaturesJson = (JSONObject)signatures;
                        Object data = signaturesJson.get("data");
                        if (data != null) {
                            JSONArray dataArr = (JSONArray)data;
                            signatureData.put((Object)"signatureNum", (Object)(dataArr.size() + 1));
                            dataArr.add((Object)signatureData);
                            signaturesJson.put((Object)"data", (Object)dataArr);
                        } else {
                            JSONArray dataArr = new JSONArray();
                            dataArr.add((Object)signatureData);
                            signaturesJson.put((Object)"data", (Object)dataArr);
                        }
                        pdfSignatureJson.put((Object)"signatures", (Object)signaturesJson);
                    } else {
                        signaturesJson = new JSONObject();
                        JSONArray dataArr = new JSONArray();
                        dataArr.add((Object)signatureData);
                        signaturesJson.put((Object)"data", (Object)dataArr);
                        pdfSignatureJson.put((Object)"signatures", (Object)signaturesJson);
                    }
                    kinggridSignature.put((Object)"pdfSignature", (Object)pdfSignatureJson);
                } else {
                    pdfSignatureJson = new JSONObject();
                    JSONObject signaturesJson = new JSONObject();
                    JSONArray dataArr = new JSONArray();
                    dataArr.add((Object)signatureData);
                    signaturesJson.put((Object)"data", (Object)dataArr);
                    pdfSignatureJson.put((Object)"signatures", (Object)signaturesJson);
                    kinggridSignature.put((Object)"pdfSignature", (Object)pdfSignatureJson);
                }
                doc.setKinggridSignature(kinggridSignature.toString());
            }
            process.doUpdate((ValueObject)doc);
            Document document = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)docId, (IUser)this.getUser());
            document.setKinggridSignature(doc.getKinggridSignature());
            MemoryCacheUtil.putToPrivateSpace((Object)docId, (Object)document, (IUser)this.getUser());
            return this.success("ok", null);
        }
        return this.success("ok", null);
    }

    @GetMapping(value={"/{applicationId}/documents/{docId}/deletedpdfsignature"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u9700\u8981\u5220\u9664\u7684\u91d1\u683cpdf\u7535\u5b50\u7b7e\u7ae0\u6570\u91cf\u7edf\u8ba1", notes="\u83b7\u53d6\u9700\u8981\u5220\u9664\u7684\u91d1\u683cpdf\u7535\u5b50\u7b7e\u7ae0\u6570\u91cf\u7edf\u8ba1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863id", required=true, paramType="path", dataType="string")})
    public Resource getDeleteSignatures(@PathVariable String applicationId, @PathVariable String docId) throws Exception {
        DocumentProcess process = RunTimeServiceManager.documentProcess((String)applicationId);
        Document doc = (Document)process.doView(docId);
        if (doc != null) {
            JSONObject signaturesJson;
            Object data;
            JSONObject pdfSignatureJson;
            Object signatures;
            JSONObject kinggridSignature;
            Object pdfSignature;
            if (!StringUtil.isBlank((String)doc.getKinggridSignature()) && (pdfSignature = (kinggridSignature = JSONObject.fromObject((Object)doc.getKinggridSignature())).get("pdfSignature")) != null && (signatures = (pdfSignatureJson = (JSONObject)pdfSignature).get("signatures")) != null && (data = (signaturesJson = (JSONObject)signatures).get("data")) != null) {
                JSONArray dataArr = (JSONArray)data;
                int count = 0;
                for (JSONObject signature : dataArr) {
                    Object isSignatureObj = signature.get("isSignature");
                    if (isSignatureObj != null) {
                        boolean isSignature = signature.getBoolean("isSignature");
                        if (!isSignature) continue;
                        ++count;
                        continue;
                    }
                    ++count;
                }
                return this.success("ok", count);
            }
            return this.success("ok", null);
        }
        return this.success("ok", null);
    }

    @DeleteMapping(value={"/{applicationId}/documents/{docId}/pdfsignature"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u91d1\u683cpdf\u7535\u5b50\u7b7e\u7ae0\u4fe1\u606f", notes="\u5220\u9664\u91d1\u683cpdf\u7535\u5b50\u7b7e\u7ae0\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863id", required=true, paramType="path", dataType="string")})
    public Resource deleteSignatures(@PathVariable String applicationId, @PathVariable String docId) throws Exception {
        DocumentProcess process = RunTimeServiceManager.documentProcess((String)applicationId);
        Document doc = (Document)process.doView(docId);
        if (doc != null) {
            JSONObject signaturesJson;
            Object data;
            JSONObject pdfSignatureJson;
            Object signatures;
            JSONObject kinggridSignature;
            Object pdfSignature;
            if (!StringUtil.isBlank((String)doc.getKinggridSignature()) && (pdfSignature = (kinggridSignature = JSONObject.fromObject((Object)doc.getKinggridSignature())).get("pdfSignature")) != null && (signatures = (pdfSignatureJson = (JSONObject)pdfSignature).get("signatures")) != null && (data = (signaturesJson = (JSONObject)signatures).get("data")) != null) {
                JSONArray dataArr = (JSONArray)data;
                int count = 0;
                for (JSONObject signature : dataArr) {
                    Object isSignatureObj = signature.get("isSignature");
                    int signatureNum = signature.getInt("signatureNum");
                    if (isSignatureObj != null) {
                        boolean isSignature = signature.getBoolean("isSignature");
                        if (!isSignature || signatureNum <= count) continue;
                        count = signatureNum;
                        continue;
                    }
                    if (signatureNum <= count) continue;
                    count = signatureNum;
                }
                Iterator iterator = dataArr.iterator();
                while (iterator.hasNext()) {
                    JSONObject signature;
                    signature = (JSONObject)iterator.next();
                    int signatureNum = signature.getInt("signatureNum");
                    if (signatureNum < count) continue;
                    iterator.remove();
                }
                signaturesJson.put((Object)"data", (Object)dataArr);
                pdfSignatureJson.put((Object)"signatures", (Object)signaturesJson);
                kinggridSignature.put((Object)"pdfSignature", (Object)pdfSignatureJson);
                doc.setKinggridSignature(kinggridSignature.toString());
                process.doUpdate((ValueObject)doc);
                Document document = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)docId, (IUser)this.getUser());
                document.setKinggridSignature(doc.getKinggridSignature());
                MemoryCacheUtil.putToPrivateSpace((Object)docId, (Object)document, (IUser)this.getUser());
                return this.success("ok", "\u5220\u9664\u6210\u529f\uff01");
            }
            return this.success("ok", null);
        }
        return this.success("ok", null);
    }

    @PostMapping(value={"/{applicationId}/documents/pdfsignatures"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6PDF\u7b7e\u7ae0\u7684\u76f8\u5173\u4fe1\u606f\uff0cpdfUrl\u548c\u6309\u94ae", notes="\u83b7\u53d6PDF\u7b7e\u7ae0\u7684\u76f8\u5173\u4fe1\u606f\uff0cpdfUrl\u548c\u6309\u94ae")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource getSignatureDatas(@PathVariable String applicationId, @RequestBody String content) throws Exception {
        DocumentProcess process = RunTimeServiceManager.documentProcess((String)applicationId);
        ParamsTable params = this.getParams();
        WebUser user = this.getUser();
        HashMap result = new HashMap();
        ArrayList<String> pdfUrls = new ArrayList<String>();
        ArrayList<Map> acts = new ArrayList<Map>();
        JSONObject actJson = new JSONObject();
        JSONArray ids = JsonTmpUtil.fromObject((Object)content);
        for (String id : ids) {
            JSONObject kinggridSignatureJson;
            Object pdfSignature;
            Document doc = (Document)process.doView(id);
            if (doc == null) continue;
            Form form = doc.getForm();
            doc = form.recalculateDocument(doc, params, (IUser)user);
            IRunner runner = JavaScriptFactory.getInstance((String)user.getSessionid(), (String)applicationId);
            runner.initBSFManager((IDocument)doc, params, (IUser)user, new ArrayList());
            Collection fields = form.getFields();
            for (FormField formField : fields) {
                Map value;
                if (formField instanceof TabField) {
                    value = formField.toAttributes(doc, runner, (IUser)user, 2);
                    com.alibaba.fastjson.JSONObject allTabFieldJson = new com.alibaba.fastjson.JSONObject();
                    ArrayList tabs = (ArrayList)value.get("tabs");
                    for (com.alibaba.fastjson.JSONObject tab : tabs) {
                        Object tabFieldsObj = tab.get((Object)"fields");
                        if (tabFieldsObj == null) continue;
                        ArrayList tabFields = (ArrayList)tab.get((Object)"fields");
                        for (HashMap fieldJson : tabFields) {
                            if (!"ButtonField".equals(String.valueOf(fieldJson.get("formField"))) || (Integer)fieldJson.get("activityType") != 28 || (Integer)fieldJson.get("displayType") == 3) continue;
                            String actNmae = (String)fieldJson.get("title");
                            String signatureAction = (String)fieldJson.get("signatureAction");
                            Object signatureActionObj = actJson.get(actNmae);
                            if (signatureActionObj != null) {
                                if (signatureAction.equals((String)signatureActionObj)) continue;
                                actJson.put((Object)actNmae, (Object)signatureAction);
                                acts.add(fieldJson);
                                continue;
                            }
                            actJson.put((Object)actNmae, (Object)signatureAction);
                            acts.add(fieldJson);
                        }
                    }
                }
                if (!(formField instanceof ButtonField) || ((ButtonField)formField).getActType() != 28) continue;
                value = formField.toAttributes(doc, runner, (IUser)user, 2);
                if (formField.getOtherPropsAsMap() != null && value != null && !value.isEmpty()) {
                    for (String propertyKey : formField.getOtherPropsAsMap().keySet()) {
                        if (value.get(propertyKey) != null) continue;
                        value.put(propertyKey, formField.getOtherPropsAsMap().get(propertyKey));
                    }
                }
                if ((Integer)value.get("displayType") == 3) continue;
                String actNmae = (String)value.get("title");
                String signatureAction = (String)value.get("signatureAction");
                Object signatureActionObj = actJson.get(actNmae);
                if (signatureActionObj != null) {
                    if (signatureAction.equals((String)signatureActionObj)) continue;
                    acts.add(value);
                    actJson.put((Object)actNmae, (Object)signatureAction);
                    continue;
                }
                acts.add(value);
                actJson.put((Object)actNmae, (Object)signatureAction);
            }
            String kinggridSignature = doc.getKinggridSignature();
            if (StringUtil.isBlank((String)kinggridSignature) || (pdfSignature = (kinggridSignatureJson = JSONObject.fromObject((Object)kinggridSignature)).get("pdfSignature")) == null) continue;
            JSONObject pdfSignatureJson = (JSONObject)pdfSignature;
            String pdfUrl = pdfSignatureJson.getString("pdfUrl");
            pdfUrls.add(pdfUrl);
        }
        result.put("pdfUrls", pdfUrls);
        result.put("acts", acts);
        return this.success("ok", result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PutMapping(value={"/{applicationId}/documents/pdfsignatures/batch"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6279\u91cf\u91d1\u683cPDF\u7535\u5b50\u7b7e\u7ae0", notes="\u6279\u91cf\u91d1\u683cPDF\u7535\u5b50\u7b7e\u7ae0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource batchSignature(@PathVariable String applicationId, @RequestBody String content) throws Exception {
        ParamsTable params = this.getParams();
        WebUser user = this.getUser();
        JSONObject json = JSONObject.fromObject((Object)content);
        String option = json.getString("option");
        String path = PropertyUtil.getPath();
        String resouces = path + File.separator + "resouces";
        String result = path + File.separator + "result";
        if ("calculateHash".equals(option)) {
            String keysn = json.getString("keysn");
            String orgname = json.getString("orgname");
            JSONArray ids = json.getJSONArray("ids");
            String position = json.getString("position");
            JSONObject sealObj = json.getJSONObject("seal");
            String imgdata = sealObj.getString("imgdata");
            double width = sealObj.getDouble("width");
            double height = sealObj.getDouble("height");
            String imgext = sealObj.getString("imgext");
            String signsn = sealObj.getString("signsn");
            String signname = sealObj.getString("signname");
            String username = sealObj.getString("username");
            KGBase64 bas64 = new KGBase64();
            bas64.setBase64Table(signsn);
            byte[] imgb = bas64.decode(imgdata.substring(65));
            File resoucesFile = new File(resouces);
            String[] fileNames = resoucesFile.list();
            JSONArray array = new JSONArray();
            DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
            for (String id : ids) {
                JSONObject pdfSignatureJson;
                Object pdfUrlObj;
                JSONObject kinggridSignature;
                Object pdfSignature;
                Document doc = (Document)dProcess.doView(id);
                Form form = doc.getForm();
                if (StringUtil.isBlank((String)(doc = form.recalculateDocument(doc, params, (IUser)user)).getKinggridSignature()) || (pdfSignature = (kinggridSignature = JSONObject.fromObject((Object)doc.getKinggridSignature())).get("pdfSignature")) == null || (pdfUrlObj = (pdfSignatureJson = (JSONObject)pdfSignature).get("pdfUrl")) == null) continue;
                boolean isSignature = false;
                IRunner runner = JavaScriptFactory.getInstance((String)user.getSessionid(), (String)applicationId);
                runner.initBSFManager((IDocument)doc, params, (IUser)user, new ArrayList());
                Collection fields = form.getFields();
                for (FormField formField : fields) {
                    Map value;
                    if (formField instanceof TabField) {
                        value = formField.toAttributes(doc, runner, (IUser)user, 2);
                        com.alibaba.fastjson.JSONObject allTabFieldJson = new com.alibaba.fastjson.JSONObject();
                        ArrayList tabs = (ArrayList)value.get("tabs");
                        block26: for (com.alibaba.fastjson.JSONObject tab : tabs) {
                            Object tabFieldsObj = tab.get((Object)"fields");
                            if (tabFieldsObj == null) continue;
                            ArrayList tabFields = (ArrayList)tab.get((Object)"fields");
                            for (HashMap fieldJson : tabFields) {
                                if (!"ButtonField".equals(String.valueOf(fieldJson.get("formField"))) || (Integer)fieldJson.get("activityType") != 28 || (Integer)fieldJson.get("displayType") == 3) continue;
                                String actNmae = (String)fieldJson.get("title");
                                String signatureAction = (String)fieldJson.get("signatureAction");
                                if (!position.equals(actNmae)) continue;
                                isSignature = true;
                                continue block26;
                            }
                        }
                    }
                    if (!(formField instanceof ButtonField) || ((ButtonField)formField).getActType() != 28) continue;
                    value = formField.toAttributes(doc, runner, (IUser)user, 2);
                    if (formField.getOtherPropsAsMap() != null && value != null && !value.isEmpty()) {
                        for (String propertyKey : formField.getOtherPropsAsMap().keySet()) {
                            if (value.get(propertyKey) != null) continue;
                            value.put(propertyKey, formField.getOtherPropsAsMap().get(propertyKey));
                        }
                    }
                    if ((Integer)value.get("displayType") == 3) continue;
                    String actNmae = (String)value.get("title");
                    String signatureAction = (String)value.get("signatureAction");
                    if (!position.equals(actNmae)) continue;
                    isSignature = true;
                    break;
                }
                if (!isSignature) continue;
                String pdfUrl = (String)pdfUrlObj;
                KGPdfHummer hummer = null;
                FileOutputStream fileOutputStream = null;
                String fileName = pdfUrl.substring(pdfUrl.lastIndexOf("/") + 1);
                String newFileName = "temp_" + fileName;
                String newPdfUrl = pdfUrl.replace(fileName, newFileName);
                try {
                    fileOutputStream = new FileOutputStream(path + newPdfUrl);
                    hummer = KGPdfHummer.createInstance((String)(path + pdfUrl), null, (boolean)true, (OutputStream)fileOutputStream, (boolean)true);
                    PdfElectronicSeal4KG pdfElectronicSeal4KG = new PdfElectronicSeal4KG(null, 0, null);
                    pdfElectronicSeal4KG.setImage(imgb, imgext.substring(1), (int)(width * 7200.0 / 254.0), (int)(height * 7200.0 / 254.0));
                    pdfElectronicSeal4KG.setSealMsg(keysn, orgname, username, signsn, signname);
                    pdfElectronicSeal4KG.setPagen(0);
                    pdfElectronicSeal4KG.setText(position, false);
                    ElectronicSignatureByKey electronicSignatureByKey = new ElectronicSignatureByKey();
                    pdfElectronicSeal4KG.addExtraExecute((KGPdfElectronicExecute)electronicSignatureByKey);
                    hummer.addExecute((KGExecute)pdfElectronicSeal4KG);
                    hummer.doExecute();
                    String needSigMessage = electronicSignatureByKey.getHash();
                    String sigKeepData = electronicSignatureByKey.getKeepData();
                    JSONObject obj = new JSONObject();
                    obj.put((Object)"needSigMessage", (Object)needSigMessage);
                    obj.put((Object)"sigKeepData", (Object)sigKeepData);
                    obj.put((Object)"fileName", (Object)pdfUrl);
                    array.add((Object)obj);
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (hummer != null) {
                        hummer.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException e) {}
                    if (hummer != null) {
                        hummer.close();
                    }
                }
                File oldFile = new File(path + pdfUrl);
                oldFile.delete();
                File newFile = new File(path + newPdfUrl);
                newFile.renameTo(oldFile);
                this.updateSignatureData(position, doc, user, dProcess);
            }
            return this.success("ok", array);
        }
        if ("rewriteSigned".equals(option)) {
            String certContext = json.getString("certContext");
            JSONArray array = json.getJSONArray("data");
            for (int i = 0; i < array.size(); ++i) {
                JSONObject obj = array.getJSONObject(i);
                String fileName = obj.getString("fileName");
                String sigKeepData = obj.getString("sigKeepData");
                String certSignMsg = obj.getString("certSignMsg");
                KGPdfHummer hummer = null;
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(result + File.separator + fileName);
                    hummer = KGPdfHummer.createInstance((String)(result + File.separator + "tmp_" + fileName), null, (boolean)true, (OutputStream)fileOutputStream, (boolean)true);
                    ElectronicSignatureByKey electronicSignatureByKey = new ElectronicSignatureByKey();
                    electronicSignatureByKey.setKeepData(sigKeepData);
                    hummer.addExecute((KGExecute)electronicSignatureByKey.getRewriteSig());
                    hummer.doExecute();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Resource resource = this.error(40001, e.getMessage(), null);
                    return resource;
                }
                finally {
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    if (hummer != null) {
                        hummer.close();
                    }
                    new File(result + File.separator + "tmp_" + fileName).delete();
                }
            }
            return this.success("ok", array);
        }
        return this.success("ok", "\u7b7e\u540d\u6210\u529f\uff01");
    }

    @GetMapping(value={"/{applicationId}/documents/{docId}/pdfsignature/version"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u91d1\u683cpdf\u7535\u5b50\u7b7e\u7ae0\u7684\u7248\u672c\u53f7", notes="\u83b7\u53d6\u91d1\u683cpdf\u7535\u5b50\u7b7e\u7ae0\u7684\u7248\u672c\u53f7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863id", required=true, paramType="path", dataType="string")})
    public Resource getSignatureVersion(@PathVariable String applicationId, @PathVariable String docId) throws Exception {
        DocumentProcess process = RunTimeServiceManager.documentProcess((String)applicationId);
        Document doc = (Document)process.doView(docId);
        if (doc != null) {
            if (!StringUtil.isBlank((String)doc.getKinggridSignature())) {
                JSONObject kinggridSignature = JSONObject.fromObject((Object)doc.getKinggridSignature());
                Object version = kinggridSignature.get("version");
                return this.success("ok", version);
            }
            return this.success("ok", null);
        }
        return this.success("ok", null);
    }

    private void updateSignatureData(String position, Document doc, WebUser user, DocumentProcess process) throws Exception {
        JSONObject kinggridSignature;
        JSONObject signatureData = new JSONObject();
        signatureData.put((Object)"position", (Object)position);
        signatureData.put((Object)"userId", (Object)user.getId());
        signatureData.put((Object)"signatureNum", (Object)1);
        FlowStateRT instance = doc.getState();
        if (instance != null) {
            BillDefiVO flowVO = instance.getFlowVO();
            String currNodeId = null;
            FlowDiagram fd = null;
            if (flowVO != null) {
                NodeRT nodert = null;
                fd = flowVO.toFlowDiagram();
                if (instance.isTemp()) {
                    nodert = (NodeRT)((List)instance.getNoderts()).get(0);
                    currNodeId = nodert.getNodeid();
                }
                if (currNodeId == null && nodert == null && (nodert = StateMachine.getCurrUserNodeRT((IDocument)doc, (IUser)user, currNodeId)) != null) {
                    currNodeId = nodert.getNodeid();
                }
            }
            Node currnode = null;
            if (currNodeId != null) {
                currnode = (Node)fd.getElementByID(currNodeId);
                signatureData.put((Object)"nodeId", (Object)currnode.id);
                signatureData.put((Object)"statelabel", (Object)currnode.statelabel);
            }
        }
        if (!StringUtil.isBlank((String)doc.getKinggridSignature())) {
            JSONObject pdfSignatureJson;
            kinggridSignature = JSONObject.fromObject((Object)doc.getKinggridSignature());
            Object pdfSignature = kinggridSignature.get("pdfSignature");
            if (pdfSignature != null) {
                pdfSignatureJson = (JSONObject)pdfSignature;
                Object signatures = pdfSignatureJson.get("signatures");
                if (signatures != null) {
                    JSONObject signaturesJson = (JSONObject)signatures;
                    Object data = signaturesJson.get("data");
                    if (data != null) {
                        JSONArray dataArr = (JSONArray)data;
                        signatureData.put((Object)"signatureNum", (Object)(dataArr.size() + 1));
                        dataArr.add((Object)signatureData);
                        signaturesJson.put((Object)"data", (Object)dataArr);
                    } else {
                        JSONArray dataArr = new JSONArray();
                        dataArr.add((Object)signatureData);
                        signaturesJson.put((Object)"data", (Object)dataArr);
                    }
                    pdfSignatureJson.put((Object)"signatures", (Object)signaturesJson);
                } else {
                    JSONObject signaturesJson = new JSONObject();
                    JSONArray dataArr = new JSONArray();
                    dataArr.add((Object)signatureData);
                    signaturesJson.put((Object)"data", (Object)dataArr);
                    pdfSignatureJson.put((Object)"signatures", (Object)signaturesJson);
                }
                kinggridSignature.put((Object)"pdfSignature", (Object)pdfSignatureJson);
            } else {
                pdfSignatureJson = new JSONObject();
                JSONObject signaturesJson = new JSONObject();
                JSONArray dataArr = new JSONArray();
                dataArr.add((Object)signatureData);
                signaturesJson.put((Object)"data", (Object)dataArr);
                pdfSignatureJson.put((Object)"signatures", (Object)signaturesJson);
                kinggridSignature.put((Object)"pdfSignature", (Object)pdfSignatureJson);
            }
            doc.setKinggridSignature(kinggridSignature.toString());
        } else {
            kinggridSignature = new JSONObject();
            JSONObject pdfSignatureJson = new JSONObject();
            JSONObject signaturesJson = new JSONObject();
            JSONArray dataArr = new JSONArray();
            dataArr.add((Object)signatureData);
            signaturesJson.put((Object)"data", (Object)dataArr);
            pdfSignatureJson.put((Object)"signatures", (Object)signaturesJson);
            kinggridSignature.put((Object)"pdfSignature", (Object)pdfSignatureJson);
            doc.setKinggridSignature(kinggridSignature.toString());
        }
        process.doUpdate((ValueObject)doc);
        Document document = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)doc.getId(), (IUser)user);
        document.setKinggridSignature(doc.getKinggridSignature());
        MemoryCacheUtil.putToPrivateSpace((Object)doc.getId(), (Object)document, (IUser)user);
    }
}

