/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.dynaform.document.controller;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.RunnableMeta;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.ErrorMessage;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.controller.ResourceNotFoundException;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.ValueObject;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.common.util.StringUtil;
import cn.myapps.common.util.cache.MemoryCacheUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.ejb.DocumentProcess;
import cn.myapps.runtime.dynaform.document.ejb.Item;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.dynaform.form.ejb.ValidateMessage;
import cn.myapps.runtime.macro.runner.IRunner;
import cn.myapps.runtime.macro.runner.JavaScriptFactory;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowRuntimeServiceImpl;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowStateRT;
import com.bcxin.runtime.domain.imports.components.DataImportComponentProvider;
import com.bcxin.runtime.domain.imports.dtos.WebUserDto;
import com.bcxin.saas.core.exceptions.SaasBadException;
import com.bcxin.saas.core.exceptions.SaasNofoundException;
import com.bcxin.saas.core.utils.SqlUtil;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u6587\u6863\u6267\u884c\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/runtime/{applicationId}"}, produces={"application/json;charset=UTF-8"})
public class DocumentController
extends AbstractRuntimeController
implements DataImportComponentProvider {
    @GetMapping(path={"/documents/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u6587\u6863", notes="\u83b7\u53d6\u6587\u6863")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="id", value="\u6587\u6863id", required=true, paramType="path", dataType="string")})
    public Resource doGetDocument(@PathVariable String applicationId, @PathVariable String id) throws Exception {
        DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
        Document doc = (Document)dProcess.doView(id);
        if (doc != null) {
            return this.success("ok", doc);
        }
        throw new ResourceNotFoundException("Not Found");
    }

    @PostMapping(path={"/documents"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u521b\u5efa\u6587\u6863(\u5e26\u6821\u9a8c)", notes="\u521b\u5efa\u6587\u6863(\u5e26\u6821\u9a8c)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doCreateDocument(@PathVariable String applicationId, @RequestBody String content) throws Exception {
        try {
            ParamsTable params = this.getParams();
            Document doc = this.getDocumentFromBeforeAction(params.getDocId(), (IUser)this.getUser());
            Collection subDocuments = doc.getFrontSubDocuments();
            Collection<ErrorMessage> errors = this.validateDocument(params, doc, applicationId, (IUser)this.getUser());
            if (errors.isEmpty()) {
                doc.setStateid("");
                DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
                if (subDocuments != null) {
                    ArrayList copySubDocuments = new ArrayList();
                    copySubDocuments.addAll(doc.getSubDocuments());
                    for (Document document : copySubDocuments) {
                        if (document.isDelete()) {
                            dProcess.doRemove(document.getId());
                            doc.removeSubDocument(document.getId());
                            continue;
                        }
                        if (!document.isEdit()) continue;
                        Collection<ErrorMessage> subErrors = this.validateDocument(params, document, applicationId, (IUser)this.getUser());
                        if (!subErrors.isEmpty()) {
                            return this.error(4001, "\u5b50\u8868\u5355\u6821\u9a8c\u4e0d\u901a\u8fc7", subErrors);
                        }
                        dProcess.doCreateOrUpdate((IDocument)document, (IUser)this.getUser());
                    }
                    doc = doc.getForm().recalculateDocument(doc, params, (IUser)this.getUser());
                }
                dProcess.doCreate((ValueObject)doc);
                MemoryCacheUtil.putToPrivateSpace((Object)doc.getId(), (Object)doc, (IUser)this.getUser());
                return this.success("\u4fdd\u5b58\u6210\u529f", doc);
            }
            return this.error(4001, "\u8868\u5355\u6821\u9a8c\u4e0d\u901a\u8fc7", errors);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/documents/withoutValid"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u521b\u5efa\u6587\u6863", notes="\u521b\u5efa\u6587\u6863")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doCreateDocumentWithoutValid(@PathVariable String applicationId, @RequestBody String content) throws Exception {
        try {
            ParamsTable params = this.getParams();
            Document doc = this.getDocumentFromBeforeAction(params.getDocId(), (IUser)this.getUser());
            doc.setStateid("");
            DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
            Collection subDocuments = doc.getFrontSubDocuments();
            if (subDocuments != null) {
                ArrayList copySubDocuments = new ArrayList();
                copySubDocuments.addAll(doc.getSubDocuments());
                for (Document document : copySubDocuments) {
                    if (document.isDelete()) {
                        dProcess.doRemove(document.getId());
                        doc.removeSubDocument(document.getId());
                        continue;
                    }
                    if (!document.isEdit()) continue;
                    dProcess.doCreateOrUpdate((IDocument)document, (IUser)this.getUser());
                }
                doc = doc.getForm().recalculateDocument(doc, params, (IUser)this.getUser());
            }
            dProcess.doCreate((ValueObject)doc);
            MemoryCacheUtil.putToPrivateSpace((Object)doc.getId(), (Object)doc, (IUser)this.getUser());
            return this.success("\u4fdd\u5b58\u6210\u529f", doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(path={"/documents/{id}/withoutValid"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u65b0\u6587\u6863", notes="\u66f4\u65b0\u6587\u6863")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="id", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doUpdateDocumentWithoutValid(@PathVariable String applicationId, @PathVariable String id, @RequestBody String content) throws Exception {
        try {
            FlowRuntimeServiceImpl stateProcess;
            FlowStateRT instance;
            ParamsTable params = this.getParams();
            Document doc = this.getDocumentFromBeforeAction(params.getDocId(), (IUser)this.getUser());
            DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
            Collection subDocuments = doc.getFrontSubDocuments();
            if (subDocuments != null) {
                ArrayList copySubDocuments = new ArrayList();
                copySubDocuments.addAll(doc.getSubDocuments());
                for (Document document : copySubDocuments) {
                    if (document.isDelete()) {
                        dProcess.doRemove(document.getId());
                        doc.removeSubDocument(document.getId());
                        continue;
                    }
                    if (!document.isEdit()) continue;
                    dProcess.doCreateOrUpdate((IDocument)document, (IUser)this.getUser());
                }
                doc = doc.getForm().recalculateDocument(doc, params, (IUser)this.getUser());
            }
            if ((instance = (stateProcess = new FlowRuntimeServiceImpl(applicationId)).findFlowStateRT(doc.getStateid())) == null) {
                doc.setStateid("");
            }
            dProcess.doCreateOrUpdate((IDocument)doc, (IUser)this.getUser());
            MemoryCacheUtil.putToPrivateSpace((Object)doc.getId(), (Object)doc, (IUser)this.getUser());
            return this.success("\u4fdd\u5b58\u6210\u529f", doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = "";
            message = e instanceof OBPMValidateException ? ((OBPMValidateException)((Object)e)).getValidateMessage() : (e.getMessage().contains("Data too long for column") ? e.getMessage().replace("Data truncation: Data too long for column", "").replace("at row 1", "\u6587\u672c\u5185\u5bb9\u8d85\u51fa\u9650\u5236") : e.getMessage());
            ArrayList<ErrorMessage> errmsgs = new ArrayList<ErrorMessage>();
            ErrorMessage msg = new ErrorMessage();
            msg.setErrcode(40001);
            msg.setErrmsg(message);
            msg.setField("");
            errmsgs.add(msg);
            e.printStackTrace();
            return this.error(4001, "\u6587\u6863\u6821\u9a8c\u4e0d\u901a\u8fc7", errmsgs);
        }
    }

    @PutMapping(path={"/documents/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u65b0\u6587\u6863(\u5e26\u6821\u9a8c)", notes="\u66f4\u65b0\u6587\u6863(\u5e26\u6821\u9a8c)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="id", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doUpdateDocument(@PathVariable String applicationId, @PathVariable String id, @RequestBody String content) throws Exception {
        try {
            ParamsTable params = this.getParams();
            Configuration configuration = Configuration.defaultConfiguration();
            configuration = configuration.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
            DocumentContext parse = JsonPath.parse((String)content, (Configuration)configuration);
            Map items = (Map)parse.read("$.items", new Predicate[0]);
            if (items != null) {
                for (Map.Entry entry : items.entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    params.setParameter(key, value);
                }
            }
            Document doc = this.getDocumentFromBeforeAction(params.getDocId(), (IUser)this.getUser());
            DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
            Collection subDocuments = doc.getFrontSubDocuments();
            Collection<ErrorMessage> errors = this.validateDocument(params, doc, applicationId, (IUser)this.getUser());
            if (errors.isEmpty()) {
                FlowStateRT instance;
                if (subDocuments != null) {
                    ArrayList copySubDocuments = new ArrayList();
                    copySubDocuments.addAll(doc.getSubDocuments());
                    for (Document document : copySubDocuments) {
                        if (document.isDelete()) {
                            dProcess.doRemove(document.getId());
                            doc.removeSubDocument(document.getId());
                            continue;
                        }
                        if (!document.isEdit()) continue;
                        Collection<ErrorMessage> subErrors = this.validateDocument(params, document, applicationId, (IUser)this.getUser());
                        if (!subErrors.isEmpty()) {
                            return this.error(4001, "\u5b50\u8868\u5355\u6821\u9a8c\u4e0d\u901a\u8fc7", subErrors);
                        }
                        dProcess.doCreateOrUpdate((IDocument)document, (IUser)this.getUser());
                    }
                    doc = doc.getForm().recalculateDocument(doc, params, (IUser)this.getUser());
                }
                FlowRuntimeServiceImpl stateProcess = new FlowRuntimeServiceImpl(applicationId);
                if (!StringUtil.isBlank((String)doc.getStateid()) && (instance = stateProcess.findFlowStateRT(doc.getStateid())) == null) {
                    doc.setStateid("");
                }
                dProcess.doCreateOrUpdate((IDocument)doc, (IUser)this.getUser());
                MemoryCacheUtil.putToPrivateSpace((Object)doc.getId(), (Object)doc, (IUser)this.getUser());
                return this.success("\u4fdd\u5b58\u6210\u529f", doc);
            }
            return this.error(4001, "\u8868\u5355\u6821\u9a8c\u4e0d\u901a\u8fc7", errors);
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = "";
            message = e instanceof OBPMValidateException ? ((OBPMValidateException)((Object)e)).getValidateMessage() : (e.getMessage().contains("Data too long for column") ? e.getMessage().replace("Data truncation: Data too long for column", "").replace("at row 1", "\u6587\u672c\u5185\u5bb9\u8d85\u51fa\u9650\u5236") : e.getMessage());
            ArrayList<ErrorMessage> errmsgs = new ArrayList<ErrorMessage>();
            ErrorMessage msg = new ErrorMessage();
            msg.setErrcode(40001);
            msg.setErrmsg(message);
            msg.setField("");
            errmsgs.add(msg);
            e.printStackTrace();
            return this.error(4001, "\u6587\u6863\u6821\u9a8c\u4e0d\u901a\u8fc7", errmsgs);
        }
    }

    @PostMapping(path={"/documents/batch"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6279\u91cf\u66f4\u65b0\u6587\u6863(\u5e26\u6821\u9a8c)", notes="\u6279\u91cf\u66f4\u65b0\u6587\u6863(\u5e26\u6821\u9a8c)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doBatchUpdateDocument(@PathVariable String applicationId, @RequestBody String content) throws Exception {
        ParamsTable params = this.getParams();
        WebUser user = this.getUser();
        ArrayList<Document> resultDocs = new ArrayList<Document>();
        DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
        List<Document> docs = this.prepareDocuments(content, applicationId, "$.data[?(@.edit)]");
        List deleteIds = (List)JsonPath.parse((String)content).read("$.data[?(@.delete)].id", new Predicate[0]);
        try {
            dProcess.beginTransaction();
            for (String deleteId : deleteIds) {
                Document doc = (Document)dProcess.doView(deleteId);
                if (doc == null) continue;
                dProcess.doRemove(deleteId);
                MemoryCacheUtil.removeFromPrivateSpace((Object)deleteId, (IUser)user);
            }
            for (Document doc : docs) {
                Collection<ErrorMessage> errors = this.validateDocument(params, doc, applicationId, (IUser)user);
                if (errors.isEmpty()) {
                    dProcess.doCreateOrUpdate((IDocument)doc, (IUser)user);
                    MemoryCacheUtil.putToPrivateSpace((Object)doc.getId(), (Object)doc, (IUser)user);
                    resultDocs.add(doc);
                    continue;
                }
                return this.error(4001, "\u8868\u5355\u6821\u9a8c\u4e0d\u901a\u8fc7", errors);
            }
            dProcess.commitTransaction();
            return this.success("\u4fdd\u5b58\u6210\u529f", resultDocs);
        }
        catch (Exception e) {
            e.printStackTrace();
            dProcess.rollbackTransaction();
            return this.error(500, e.getMessage(), null);
        }
    }

    private Collection<ErrorMessage> validateDocument(ParamsTable params, Document doc, String applicationId, IUser webUser) throws Exception {
        ArrayList<ErrorMessage> errmsgs = new ArrayList<ErrorMessage>();
        doc.setDomainid(this.getDomain());
        DocumentProcess proxy = RunTimeServiceManager.documentProcess((String)applicationId);
        Collection errors = proxy.doValidate(doc, params, webUser);
        if (errors != null && errors.size() > 0) {
            for (ValidateMessage err : errors) {
                ErrorMessage msg = new ErrorMessage();
                msg.setErrcode(40001);
                msg.setErrmsg(err.getErrmessage());
                msg.setField(err.getFieldname());
                errmsgs.add(msg);
            }
        }
        return errmsgs;
    }

    @PatchMapping(path={"/documents/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5c40\u90e8\u66f4\u65b0\u6587\u6863", notes="\u5c40\u90e8\u66f4\u65b0\u6587\u6863")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="id", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doUpdatePartDocument(@PathVariable String applicationId, @PathVariable String id, @RequestBody String content) throws Exception {
        try {
            Map items = (Map)JsonPath.parse((String)content).read("$.items", new Predicate[0]);
            DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
            Document doc = (Document)dProcess.doView(id);
            for (Map.Entry entry : items.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                Item item = doc.findItem(key);
                if (item == null) continue;
                item.setValue(value);
            }
            dProcess.doUpdate((ValueObject)doc);
            return this.success("\u4fdd\u5b58\u6210\u529f", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(path={"/documents/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u6587\u6863", notes="\u5220\u9664\u6587\u6863")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="id", value="\u6587\u6863id", required=true, paramType="path", dataType="string")})
    public Resource doDeleteDocument(@PathVariable String applicationId, @PathVariable String id) throws Exception {
        DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
        dProcess.doRemove(id);
        MemoryCacheUtil.removeFromPrivateSpace((Object)id, (IUser)this.getUser());
        return this.success("ok", null);
    }

    @GetMapping(path={"/documents"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u6587\u6863\u96c6\u5408", notes="\u83b7\u53d6\u6587\u6863\u96c6\u5408")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string"), @ApiImplicitParam(name="sortby", value="\u6839\u636e\u6392\u5e8f\u7684\u5b57\u6bb5", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="order", value="\u5347\u5e8f/\u964d\u5e8f", required=true, paramType="query", dataType="string")})
    public Resource doGetDocuments(@PathVariable String applicationId, @RequestBody(required=false) String content, String sortby, String order) throws Exception {
        content = SqlUtil.encode((String)content);
        Map filter = null;
        if (StringUtils.isNotBlank((String)content)) {
            filter = (Map)JsonPath.parse((String)content).read("$", new Predicate[0]);
        }
        DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
        DataPackage dataPackage = dProcess.queryDocuments(this.getParams(), filter, (IUser)this.getUser());
        Collection data = dataPackage.getDatas();
        int page = dataPackage.getPageNo();
        int page_lines = dataPackage.getLinesPerPage();
        int row_count = dataPackage.getRowCount();
        return this.successWithPagination("ok", data, page, page_lines, row_count);
    }

    @DeleteMapping(path={"/documents"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6587\u6863", notes="\u6279\u91cf\u5220\u9664\u6587\u6863")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doBatchDeleteDocument(@PathVariable String applicationId, @RequestBody String content) throws Exception {
        List ids = (List)JsonPath.parse((String)content).json();
        String[] idArray = new String[]{};
        idArray = ids.toArray(idArray);
        DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
        dProcess.doRemove(idArray);
        for (String id : ids) {
            MemoryCacheUtil.removeFromPrivateSpace((Object)id, (IUser)this.getUser());
        }
        return this.success("ok", null);
    }

    @PostMapping(path={"/views/{viewId}/documents/{parentId}/childs"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u65b0\u7f13\u5b58\u4e2d\u5b50\u8868\u6570\u636e", notes="\u66f4\u65b0\u7f13\u5b58\u4e2d\u5b50\u8868\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="viewId", value="\u89c6\u56feid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="parentId", value="\u4e3b\u8868\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource saveSubDocumentsToCache(@PathVariable String applicationId, @PathVariable String viewId, @PathVariable String parentId, @RequestBody String content) throws Exception {
        ParamsTable params = this.getParams();
        WebUser user = this.getUser();
        Document subDocument = this.prepareDocument(content, applicationId, "$", params);
        Collection<ErrorMessage> subErrors = this.validateDocument(params, subDocument, applicationId, (IUser)this.getUser());
        if (!subErrors.isEmpty()) {
            return this.error(4001, "\u6821\u9a8c\u4e0d\u901a\u8fc7", subErrors);
        }
        ViewDesignTimeService vProcess = DesignTimeServiceManager.viewDesignTimeService();
        AbstractView view = vProcess.doView(viewId);
        IRunner runner = JavaScriptFactory.getInstance((String)user.getSessionid(), (String)applicationId);
        runner.initBSFManager((IDocument)subDocument, params, (IUser)user, new ArrayList());
        String confirmActivityScript = view.getConfirmActivityScript();
        if (!StringUtil.isBlank((String)confirmActivityScript)) {
            runner.run((RunnableMeta)view, "VIEW(" + view.getName() + "." + view.getId() + ").confirmActivityScript", confirmActivityScript);
        }
        DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
        Document doc = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)parentId, (IUser)this.getUser());
        if (doc == null) {
            doc = (Document)dProcess.doView(parentId);
        }
        if (doc != null) {
            doc.addSubDocument(subDocument);
            MemoryCacheUtil.putToPrivateSpace((Object)doc.getId(), (Object)doc, (IUser)this.getUser());
        }
        MemoryCacheUtil.putToPrivateSpace((Object)subDocument.getId(), (Object)subDocument, (IUser)this.getUser());
        return this.success("ok", null);
    }

    @DeleteMapping(path={"/views/{viewId}/documents/{parentId}/childs/{childId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u7f13\u5b58\u4e2d\u5b50\u8868\u6570\u636e", notes="\u5220\u9664\u7f13\u5b58\u4e2d\u5b50\u8868\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="viewId", value="\u89c6\u56feid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="parentId", value="\u4e3b\u8868\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="childId", value="\u5b50\u8868\u6587\u6863id", required=true, paramType="path", dataType="string")})
    public Resource removeSubDocumentsToCache(@PathVariable String applicationId, @PathVariable String viewId, @PathVariable String parentId, @PathVariable String childId) throws Exception {
        Document doc;
        DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
        ParamsTable params = this.getParams();
        WebUser user = this.getUser();
        Document subDocument = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)childId, (IUser)user);
        if (subDocument == null) {
            subDocument = (Document)dProcess.doView(childId);
        }
        ViewDesignTimeService vProcess = DesignTimeServiceManager.viewDesignTimeService();
        AbstractView view = vProcess.doView(viewId);
        IRunner runner = JavaScriptFactory.getInstance((String)user.getSessionid(), (String)applicationId);
        runner.initBSFManager((IDocument)subDocument, params, (IUser)user, new ArrayList());
        String removeActivityScript = view.getRemoveActivityScript();
        if (!StringUtil.isBlank((String)removeActivityScript)) {
            runner.run((RunnableMeta)view, "VIEW(" + view.getName() + "." + view.getId() + ").removeActivityScript", removeActivityScript);
        }
        if ((doc = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)parentId, (IUser)user)) == null) {
            doc = (Document)dProcess.doView(parentId);
        }
        if (doc != null) {
            doc.removeSubDocument(childId);
            MemoryCacheUtil.putToPrivateSpace((Object)doc.getId(), (Object)doc, (IUser)user);
        }
        MemoryCacheUtil.removeFromPrivateSpace((Object)childId, (IUser)user);
        return this.success("ok", null);
    }

    @PostMapping(value={"/documents/validate"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6821\u9a8c\u65b9\u6cd5", notes="\u6821\u9a8c\u65b9\u6cd5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource validate(@PathVariable String applicationId, @RequestBody String content) throws Exception {
        ParamsTable params = this.getParams();
        Document doc = this.prepareDocument(content, applicationId, "$", params);
        ArrayList<ErrorMessage> result = new ArrayList<ErrorMessage>();
        DocumentProcess proxy = RunTimeServiceManager.documentProcess((String)applicationId);
        Collection errors = proxy.doValidate(doc, params, (IUser)this.getUser());
        if (errors != null && errors.size() > 0) {
            for (ValidateMessage err : errors) {
                ErrorMessage msg = new ErrorMessage();
                msg.setErrcode(40001);
                msg.setErrmsg(err.getErrmessage().replace("'", ""));
                msg.setField(err.getFieldname());
                result.add(msg);
            }
        }
        if (result.isEmpty()) {
            return this.success("ok", null);
        }
        return this.error(4001, "\u8868\u5355\u6821\u9a8c\u4e0d\u901a\u8fc7", result);
    }

    public void saveWithoutValid(String domainId, String userId, String appId, String content) throws Exception {
    }

    public WebUserDto getCurrentUser() {
        try {
            return WebUserDto.create((String)this.getUser().getId(), (String)this.getUser().getDomainid());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SaasBadException("\u5f53\u524d\u7528\u6237\u65e0\u6548");
        }
    }

    private Document getDocumentFromBeforeAction(String docId, IUser user) {
        Document doc = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)docId, (IUser)user);
        if (doc == null) {
            throw new SaasNofoundException("\u975e\u9884\u671f\u8bf7\u6c42, \u65e0\u6cd5\u4ece\u6267\u884c\u524d\u4e2d\u83b7\u53d6\u6587\u6863\u4fe1\u606f");
        }
        return doc;
    }
}

