/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.dynaform.document;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.Environment;
import cn.myapps.common.RunnableMeta;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.activity.Activity;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.common.util.DefaultProperty;
import cn.myapps.common.util.StringUtil;
import cn.myapps.common.util.cache.MemoryCacheUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.ejb.DocumentProcess;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.form.ejb.ValidateMessage;
import cn.myapps.runtime.macro.runner.IRunner;
import cn.myapps.runtime.macro.runner.JavaScriptFactory;
import cn.myapps.runtime.macro.runner.JsMessage;
import cn.myapps.util.json.JsonUtil;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class DocumentUtil {
    public String doNew(String activityId, Map<String, Object> parameters, HttpServletRequest request) {
        try {
            FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
            WebUser webUser = AuthTimeServiceManager.getWebUser((HttpServletRequest)request);
            ParamsTable params = ParamsTable.convertHTTP((HttpServletRequest)request);
            params.putAll(parameters);
            AbstractView view = this.getView(params);
            Activity act = view.findActivity(activityId);
            IRunner runner = this.getRunner(view, params, webUser);
            this.doBeforeScript(act, runner);
            String formId = view.getRelatedForm();
            Form form = formService.doView(formId);
            Document doc = form.createDocument(params, (IUser)webUser);
            String refreshScript = view.getRowCreateScript(doc, runner, (IUser)webUser);
            this.doAfterScript(act, runner);
            MemoryCacheUtil.putToPrivateSpace((Object)doc.getId(), (Object)doc, (IUser)webUser);
            return refreshScript;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "showError('" + e.getMessage() + "');";
        }
    }

    public void doBeforeScript(Activity act, IRunner runner) throws Exception {
        if (act == null) {
            return;
        }
        StringBuffer label = new StringBuffer();
        label.append("Activity Action(").append(act.getId()).append(")." + act.getName()).append("beforeActionScript");
        Object result = runner.run((RunnableMeta)act, label.toString(), act.getBeforeActionScript());
        if (result instanceof String && !StringUtil.isBlank((String)((String)result))) {
            throw new OBPMValidateException((String)result);
        }
    }

    public void doAfterScript(Activity act, IRunner runner) throws Exception {
        if (act == null) {
            return;
        }
        StringBuffer label = new StringBuffer();
        label.append("Activity Action(").append(act.getId()).append(")." + act.getName()).append("afterActionScript");
        Object result = runner.run((RunnableMeta)act, label.toString(), act.getAfterActionScript());
        if (result instanceof String && !StringUtil.isBlank((String)((String)result))) {
            result = new JsMessage(16, (String)result);
        }
        if (result instanceof JsMessage) {
            throw new OBPMValidateException("{\"funName\":\"" + ((JsMessage)result).getTypeName() + "\",\"content\":\"" + ((JsMessage)result).getContent() + "\"}");
        }
    }

    public String doRemove(String activityId, String[] selects, Map<String, Object> parameters, HttpServletRequest request) {
        try {
            WebUser webUser = AuthTimeServiceManager.getWebUser((HttpServletRequest)request);
            ParamsTable params = ParamsTable.convertHTTP((HttpServletRequest)request);
            params.putAll(parameters);
            params.setParameter("_selects", (Object)selects);
            AbstractView view = this.getView(params);
            DocumentProcess dp = RunTimeServiceManager.documentProcess((String)view.getApplicationid());
            Activity act = view.findActivity(activityId);
            IRunner runner = this.getRunner(view, params, webUser);
            dp.doRemove(selects);
            this.doAfterScript(act, runner);
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return "";
    }

    private IRunner getRunner(AbstractView view, ParamsTable params, WebUser webUser) throws Exception {
        Form sForm = view.getSearchForm();
        Document sfDoc = new Document();
        if (sForm != null) {
            sForm.createDocument(params, (IUser)webUser);
        }
        IRunner runner = JavaScriptFactory.getInstance((String)webUser.getSessionid(), (String)view.getApplicationid());
        runner.initBSFManager((IDocument)sfDoc, params, (IUser)webUser, new ArrayList());
        return runner;
    }

    private AbstractView getView(ParamsTable params) throws Exception {
        ViewDesignTimeService viewService = DesignTimeServiceManager.viewDesignTimeService();
        AbstractView view = viewService.doView(params.getParameterAsString("_viewid"));
        return view;
    }

    public String doSingleRemove(String id, String application) {
        try {
            DocumentProcess dp = RunTimeServiceManager.documentProcess((String)application);
            Document doc = (Document)dp.doView(id);
            if (doc != null) {
                dp.doRemove(id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "showError('" + e.getMessage() + "');";
        }
        return "";
    }

    public String doRefresh(String dataJSON, Map<String, Object> parameters, HttpServletRequest request) {
        try {
            WebUser webUser = AuthTimeServiceManager.getWebUser((HttpServletRequest)request);
            FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
            ParamsTable params = ParamsTable.convertHTTP((HttpServletRequest)request);
            params.putAll(parameters);
            if (dataJSON != null) {
                params.putAll(JsonUtil.toMap((String)dataJSON));
            }
            AbstractView view = this.getView(params);
            DocumentProcess dp = RunTimeServiceManager.documentProcess((String)view.getApplicationid());
            String formId = view.getRelatedForm();
            Form form = formService.doView(formId);
            String id = params.getParameterAsString("id");
            Document doc = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)id, (IUser)webUser);
            if (doc == null) {
                doc = (Document)dp.doView(id);
            }
            form.addItems(doc, params);
            form.recalculateDocument(doc, params, false, (IUser)webUser);
            IRunner runner = JavaScriptFactory.getInstance((String)webUser.getSessionid(), (String)view.getApplicationid());
            runner.initBSFManager((IDocument)doc, params, (IUser)webUser, new ArrayList());
            String refreshScript = view.getRowRefreshScript(doc, runner, (IUser)webUser);
            return refreshScript;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "obpm:" + e.getMessage();
        }
    }

    public String doRefreshRow4subGridView(String docid, Map<String, Object> parameters, HttpServletRequest request) {
        String rowScript = "";
        try {
            ParamsTable params = ParamsTable.convertHTTP((HttpServletRequest)request);
            params.putAll(parameters);
            ViewDesignTimeService viewService = DesignTimeServiceManager.viewDesignTimeService();
            AbstractView view = viewService.doView(params.getParameterAsString("_viewid"));
            String applicationid = view.getApplicationid();
            DocumentProcess process = RunTimeServiceManager.documentProcess((String)applicationid);
            Document doc = (Document)process.doView(docid);
            Form form = doc.getForm();
            WebUser webUser = AuthTimeServiceManager.getWebUser((HttpServletRequest)request);
            form.recalculateDocument(doc, params, (IUser)webUser);
            IRunner runner = this.getRunner(view, params, webUser);
            rowScript = view.getRowCreateScript(doc, runner, (IUser)webUser);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rowScript;
    }

    public String doSave(String activityId, String datasJSON, Map<String, Object> parameters, HttpServletRequest request) {
        try {
            WebUser webUser = AuthTimeServiceManager.getWebUser((HttpServletRequest)request);
            FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
            ParamsTable params = ParamsTable.convertHTTP((HttpServletRequest)request);
            params.putAll(parameters);
            AbstractView view = this.getView(params);
            DocumentProcess process = RunTimeServiceManager.documentProcess((String)view.getApplicationid());
            String formId = view.getRelatedForm();
            Form form = formService.doView(formId);
            Activity act = view.findActivity(activityId);
            Collection datas = JsonUtil.toCollection((String)datasJSON);
            try {
                process.beginTransaction();
                for (Map data : datas) {
                    params.putAll(data);
                    String id = params.getParameterAsString("id");
                    Document doc = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)id, (IUser)webUser);
                    if (doc == null) {
                        doc = (Document)process.doView(id);
                    }
                    if (doc != null) {
                        doc.setLastmodifier(webUser.getId());
                        doc = form.createDocument(doc, params, (IUser)webUser);
                    } else {
                        doc = form.createDocument(params, (IUser)webUser);
                    }
                    IRunner runner = JavaScriptFactory.getInstance((String)webUser.getSessionid(), (String)view.getApplicationid());
                    runner.initBSFManager((IDocument)doc, params, (IUser)webUser, new ArrayList());
                    this.doBeforeScript(act, runner);
                    Collection errors = process.doValidate(doc, params, (IUser)webUser);
                    StringBuffer error = new StringBuffer();
                    if (errors != null && errors.size() > 0) {
                        for (ValidateMessage err : errors) {
                            error.append(err.getErrmessage());
                            error.append(";");
                        }
                        error.deleteCharAt(error.lastIndexOf(";"));
                        throw new OBPMValidateException(error.toString());
                    }
                    process.doStartFlowOrUpdate((IDocument)doc, params, (IUser)webUser);
                    this.doAfterScript(act, runner);
                }
                process.commitTransaction();
            }
            catch (Exception e) {
                process.rollbackTransaction();
                throw e;
            }
            return "";
        }
        catch (OBPMValidateException e) {
            e.printStackTrace();
            return "obpm:" + e.getValidateMessage();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "obpm:" + e.getMessage();
        }
    }

    public Map<String, String> getFileList(int index, HttpServletRequest request) throws Exception {
        String filePath;
        String fileName;
        WebUser webUser = AuthTimeServiceManager.getWebUser((HttpServletRequest)request);
        String[] path = new String[]{"SECSIGN_PATH", "REDHEAD_DOCPATH", "TEMPLATE_DOCPATH"};
        String[] defaultOption = new String[]{"\u8bf7\u9009\u62e9\u670d\u52a1\u5668\u5370\u7ae0", "\u8bf7\u9009\u62e9\u6a21\u677f\u5957\u7ea2", "\u8bf7\u9009\u62e9\u6a21\u677f\u6253\u5f00"};
        String dir = DefaultProperty.getProperty((String)path[index]);
        String domainDir = DefaultProperty.getProperty((String)path[index]) + webUser.getDomainid() + "/";
        Environment evt = Environment.getInstance();
        evt.setContextPath(request.getContextPath());
        String realPath = evt.getRealPath(dir);
        String realDomainPath = evt.getRealPath(domainDir);
        File files = new File(realPath);
        File domainFiles = new File(realDomainPath);
        if (!files.exists() && !files.mkdir()) {
            throw new OBPMValidateException("Folder create failure");
        }
        if (!domainFiles.exists() && !domainFiles.mkdir()) {
            throw new OBPMValidateException("Folder create failure");
        }
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        options.put("", defaultOption[index]);
        for (File file : files.listFiles()) {
            if (file.isDirectory()) continue;
            fileName = file.getName();
            filePath = dir + fileName;
            options.put(filePath, fileName);
        }
        for (File file : domainFiles.listFiles()) {
            if (file.isDirectory()) continue;
            fileName = file.getName();
            filePath = domainDir + fileName;
            options.put(filePath, fileName);
        }
        return options;
    }

    public ArrayList<ArrayList<String>> getSecFileList(HttpServletRequest request) throws Exception {
        String dir = DefaultProperty.getProperty((String)"SECSIGN_PATH");
        Environment evt = Environment.getInstance();
        evt.setContextPath(request.getContextPath());
        String realPath = evt.getRealPath(dir);
        File file = new File(realPath);
        if (!file.exists() && !file.mkdir()) {
            throw new OBPMValidateException("Folder create failure");
        }
        File[] fileList = file.listFiles();
        ArrayList<ArrayList<String>> table = new ArrayList<ArrayList<String>>();
        if (fileList.length > 0) {
            for (int i = 0; i < fileList.length; ++i) {
                ArrayList<String> tr = new ArrayList<String>();
                tr.add(fileList[i].getName());
                tr.add(new SimpleDateFormat().format(new Date(fileList[i].lastModified())));
                tr.add(String.valueOf(fileList[i].length()));
                table.add(tr);
            }
        }
        return table;
    }

    public String updateWordField(String content, String fieldname, String formId, String docid, String applicationid) throws Exception {
        DocumentProcess dp = RunTimeServiceManager.documentProcess((String)applicationid);
        boolean isSuccess = dp.updateWordField(content, fieldname, formId, docid);
        if (isSuccess) {
            return content;
        }
        return "false";
    }

    public String getInformationfeedbackInfo(String docid, String fieldname, String application) throws Exception {
        try {
            DocumentProcess dp = RunTimeServiceManager.documentProcess((String)application);
            Document doc = (Document)dp.doView(docid);
            if (doc != null) {
                String info = doc.getItemValueAsString(fieldname);
                return null == info ? "" : info;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "showError('" + e.getMessage() + "');";
        }
        return "";
    }

    public String doUpdateInformationfeedbackInfo(String docid, String fieldname, String fieldValue, String application) throws Exception {
        try {
            DocumentProcess dp = RunTimeServiceManager.documentProcess((String)application);
            Document doc = (Document)dp.doView(docid);
            if (doc != null) {
                doc.addTextItem(fieldname, fieldValue);
                dp.doUpdate((IDocument)doc, true, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "showError('" + e.getMessage() + "');";
        }
        return "";
    }
}

