/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.domain.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u4f01\u4e1a\u57df\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/runtime", "/api/portal/domain"}, produces={"application/json;charset=UTF-8"})
public class DomainController
extends AbstractRuntimeController {
    @GetMapping(value={"/domains"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u4f01\u4e1a\u57df\u5217\u8868", notes="\u83b7\u53d6\u4f01\u4e1a\u57df\u5217\u8868")
    public Resource getDomianList() throws Exception {
        DomainVO domainVO = this.getUser().getDomain();
        ArrayList result = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", domainVO.getId());
        map.put("name", domainVO.getName());
        result.add(map);
        return this.success("ok", result);
    }

    @GetMapping(path={"/domains/realmAndTeam"}, produces={"application/json;charset=UTF-8"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u73af\u4fe1\u914d\u7f6e\u4fe1\u606f", notes="\u83b7\u53d6\u73af\u4fe1\u914d\u7f6e\u4fe1\u606f")
    public Map doGetKMTeamAndRealm() {
        HashMap<String, Boolean> maps = new HashMap<String, Boolean>();
        try {
            WebUser user = this.getUser();
            String domainId = user.getDomainid();
            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
            DomainVO domain = (DomainVO)domainProcess.doView(domainId);
            if (domain.isEnable("kmTeam")) {
                maps.put("kmTeam", true);
            } else {
                maps.put("kmTeam", false);
            }
            if (domain.isEnable("kmRealm")) {
                maps.put("kmRealm", true);
            } else {
                maps.put("kmRealm", false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return maps;
    }

    @GetMapping(value={"/{domainId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6839\u636e\u4f01\u4e1a\u57dfid\u83b7\u53d6\u4f01\u4e1a\u57df\u4fe1\u606f", notes="\u6839\u636e\u4f01\u4e1a\u57dfid\u83b7\u53d6\u4f01\u4e1a\u57df\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="domainId", value="\u4f01\u4e1a\u57dfid", required=true, paramType="path", dataType="string")})
    public DomainVO getDoamin(@PathVariable String domainId) throws Exception {
        DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
        DomainVO domainVO = (DomainVO)domainProcess.doView(domainId);
        DomainVO domain = (DomainVO)BeanUtils.cloneBean((Object)domainVO);
        if (!StringUtil.isBlank((String)domain.getLogoUrl())) {
            String logoUrl = domain.getLogoUrl();
            logoUrl = logoUrl.indexOf("/upload/") > -1 ? "/upload" + logoUrl.substring(logoUrl.lastIndexOf("/"), logoUrl.length()) : logoUrl.substring(logoUrl.lastIndexOf("/"), logoUrl.length());
            domain.setLogoUrl(logoUrl);
        }
        return domain;
    }
}

