/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.detail.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.util.Security;
import cn.myapps.common.util.StringUtil;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.util.sequence.Sequence;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7cfb\u7edf\u8bbe\u7f6e\u6a21\u5757"})
@RestController
@RequestMapping(value={"/api"}, produces={"application/json;charset=UTF-8"})
public class DetailController
extends AbstractRuntimeController {
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private HttpServletResponse response;

    @GetMapping(value={"/runtime/{userid}/detail"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u7cfb\u7edf\u8bbe\u7f6e\u8df3\u8f6c", notes="\u7cfb\u7edf\u8bbe\u7f6e\u8df3\u8f6c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userid", value="\u7528\u6237id", required=true, paramType="path", dataType="string")})
    public Resource sendDetailUrl(@PathVariable String userid) throws Exception {
        WebUser user = AuthTimeServiceManager.getWebUser((HttpServletRequest)this.request);
        if (user.isDepartmentUser()) {
            AuthTimeServiceManager.setAdminUser((WebUser)user, (HttpSession)this.request.getSession());
            String token = Security.getToken((String)user.getId());
            Cookie cookie = new Cookie("adminToken", token);
            cookie.setPath("/");
            this.response.addCookie(cookie);
        }
        String url = this.request.getContextPath() + "/domain/index.html#/main";
        return this.success("ok", url);
    }

    @GetMapping(value={"/runtime/sequence"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value=" \u83b7\u53d6\u4e00\u4e2a\u65b0\u6570\u5217", notes=" \u83b7\u53d6\u4e00\u4e2a\u65b0\u6570\u5217")
    public Resource getSequence() throws Exception {
        String result = Sequence.getUUID();
        return this.success("ok", result);
    }

    @GetMapping(value={"/runtime/secrets/{secret}/accessToken"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value=" \u83b7\u53d6\u524d\u53f0\u7528\u6237accessToken", notes=" \u83b7\u53d6\u524d\u53f0\u7528\u6237accessToken")
    @ApiImplicitParams(value={@ApiImplicitParam(name="secret", value="secret key", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="loginNo", value="\u7528\u6237\u8d26\u53f7", required=true, paramType="query", dataType="string")})
    public Resource getAccessToken(@PathVariable String secret, @RequestParam String loginNo) throws Exception {
        UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
        DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
        Collection domains = domainProcess.getAllDomain();
        for (DomainVO domainVO : domains) {
            UserVO userVO;
            if (StringUtil.isBlank((String)domainVO.getSecret()) || !domainVO.getSecret().equals(secret) || (userVO = userProcess.getUserByLoginno(loginNo, domainVO.getId())) == null) continue;
            String accessToken = Security.getToken((String)userVO.getId());
            return this.success("ok", accessToken);
        }
        return this.error(500, "\u83b7\u53d6\u5931\u8d25", null);
    }
}

