/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.department.service;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.authtime.department.service.DepartmentProcess;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.tree.DepartmentNode;
import cn.myapps.common.data.tree.Node;
import cn.myapps.common.data.tree.UserNode;
import cn.myapps.common.util.StringUtil;
import cn.myapps.runtime.common.utils.Pager;
import cn.myapps.runtime.department.service.DepartmentRunTimeService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DepartmentRunTimeServiceImpl
implements DepartmentRunTimeService {
    @Override
    public List<Node> getDepartmentListTree(IUser webUser, String parentId, String applicationId, int level, boolean belong) throws Exception {
        ArrayList<Node> avatars = new ArrayList<Node>();
        DepartmentProcess process = AuthTimeServiceManager.departmentRuntimeService();
        if (StringUtil.isBlank((String)parentId)) {
            if (level < 0) {
                Collection userDepartmentList;
                Iterator iterator;
                if (belong && (iterator = (userDepartmentList = process.queryByUser(webUser.getId())).iterator()).hasNext()) {
                    DepartmentVO departmentVO = (DepartmentVO)iterator.next();
                    DepartmentNode d = new DepartmentNode();
                    d.setId(departmentVO.getId());
                    d.setName(departmentVO.getName());
                    d.setCode(departmentVO.getCode());
                    d.setLevel(departmentVO.getLevel());
                    avatars.add((Node)d);
                    return avatars;
                }
                DepartmentVO departmentVO = process.getRootDepartmentByDomainId(webUser.getDomainid());
                DepartmentNode d = new DepartmentNode();
                d.setId(departmentVO.getId());
                d.setName(departmentVO.getName());
                d.setCode(departmentVO.getCode());
                d.setLevel(departmentVO.getLevel());
                avatars.add((Node)d);
                return avatars;
            }
            return null;
        }
        if (level < 0) {
            List departments = (List)process.getDatasByParent(parentId);
            for (DepartmentVO departmentVO : departments) {
                DepartmentNode d = new DepartmentNode();
                d.setId(departmentVO.getId());
                d.setName(departmentVO.getName());
                d.setCode(departmentVO.getCode());
                d.setLevel(departmentVO.getLevel());
                avatars.add((Node)d);
            }
            return avatars;
        }
        List departments = (List)process.getDatasByParent(parentId);
        for (DepartmentVO departmentVO : departments) {
            DepartmentNode d = new DepartmentNode();
            d.setId(departmentVO.getId());
            d.setName(departmentVO.getName());
            d.setCode(departmentVO.getCode());
            d.setLevel(departmentVO.getLevel());
            if (level != departmentVO.getLevel()) continue;
            avatars.add((Node)d);
        }
        return avatars;
    }

    @Override
    public Map<String, Object> getDepartmentAndUsers(String applicationId, String deptId, IUser user, boolean isFromMail, Integer pageSize, Integer pageNum) throws Exception {
        ArrayList<Object> avatars = new ArrayList<Object>();
        DepartmentProcess process = AuthTimeServiceManager.departmentRuntimeService();
        if (StringUtil.isBlank((String)deptId)) {
            List departments = (List)process.queryByDomain(user.getDomainid());
            for (DepartmentVO departmentVO : departments) {
                DepartmentNode d = new DepartmentNode();
                d.setId(departmentVO.getId());
                d.setName(departmentVO.getName());
                d.setCode(departmentVO.getCode());
                d.setLevel(departmentVO.getLevel());
                avatars.add(d);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("datas", avatars);
            return map;
        }
        UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
        DepartmentVO parent = (DepartmentVO)process.doView(deptId);
        List users = (List)userProcess.queryByDepartment(deptId);
        for (UserVO userVO : users) {
            if (isFromMail && StringUtil.isBlank((String)userVO.getEmail())) continue;
            UserNode u = new UserNode();
            u.setId(userVO.getId());
            u.setName(userVO.getName());
            u.setMobile(userVO.getTelephone());
            u.setMobile2(userVO.getTelephone2());
            u.setEmail(userVO.getEmail());
            u.setLoginNo(userVO.getLoginno());
            u.setAvatar(userVO.getAvatarUri());
            u.setDeptId(parent.getId());
            u.setDept(parent.getName());
            u.setDomainId(userVO.getDomainid());
            avatars.add(u);
        }
        Pager pager = Pager.create(avatars, (int)pageSize);
        List datas = pager.getPagedList(pageNum.intValue());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("datas", datas);
        map.put("pageCount", pager.getPageCount());
        map.put("linesPerPage", pageSize);
        map.put("rowCount", avatars.size());
        map.put("pageNum", pageNum);
        return map;
    }

    @Override
    public List<Node> searchDeptTree(String applicationId, String domainId, String keyword, IUser user) throws Exception {
        ArrayList<Node> avatars = new ArrayList<Node>();
        DepartmentProcess process = AuthTimeServiceManager.departmentRuntimeService();
        Collection departments = process.doQueryByDomainLikeName(domainId, keyword);
        for (DepartmentVO dept : departments) {
            DepartmentNode d = new DepartmentNode();
            d.setId(dept.getId());
            d.setName(dept.getName());
            d.setCode(dept.getCode());
            d.setLevel(dept.getLevel());
            if (dept.getSuperior() != null) {
                d.setParentid(dept.getSuperior().getId());
            }
            avatars.add((Node)d);
        }
        return avatars;
    }
}

