/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.department.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.authtime.department.service.DepartmentProcess;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.tree.DepartmentNode;
import cn.myapps.common.data.tree.Node;
import cn.myapps.common.util.StringUtil;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.runtime.department.service.DepartmentRunTimeService;
import com.bcxin.saas.domains.entities.DepartmentEntity;
import com.bcxin.saas.domains.readers.DepartmentDbReader;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u90e8\u95e8\u6267\u884c\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/runtime/{applicationId}/departments/selectbox"}, produces={"application/json;charset=UTF-8"})
public class DepartmentSelectboxController
extends AbstractRuntimeController {
    @Autowired
    private DepartmentRunTimeService deptService;
    @Autowired
    private DepartmentDbReader departmentDbReader;

    @GetMapping(value={"/department"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u90e8\u95e8\u6811\u5f62\u96c6\u5408", notes="\u83b7\u53d6\u90e8\u95e8\u6811\u5f62\u96c6\u5408")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deptId", value="\u90e8\u95e8id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="level", value="\u663e\u793a\u90e8\u95e8\u7ea7\u522b(-1:\u6240\u6709,0:\u4e00\u7ea7,1:\u4e8c\u7ea7,2:\u4e09\u7ea7)", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="belong", value="\u662f\u5426\u53ea\u663e\u793a\u5f53\u524d\u7528\u6237\u53ca\u4e0b\u5c5e\u90e8\u95e8(true|false)", required=false, paramType="query", dataType="boolean")})
    public Resource getDepartmentListTree(String deptId, @PathVariable String applicationId, @RequestParam(required=false) int level, @RequestParam(required=false) boolean belong) throws Exception {
        List<Node> result = this.deptService.getDepartmentListTree((IUser)this.getUser(), deptId, applicationId, level, belong);
        return this.success("ok", result);
    }

    @GetMapping(value={"/user"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6839\u636e\u7236\u7ea7\u90e8\u95e8id\u83b7\u53d6\u90e8\u95e8\u7528\u6237\u96c6\u5408", notes="\u6839\u636e\u7236\u7ea7\u90e8\u95e8id\u83b7\u53d6\u90e8\u95e8\u7528\u6237\u96c6\u5408")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deptId", value="\u90e8\u95e8id", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u663e\u793a\u6570\u636e\u6570", required=false, paramType="query", dataType="string", defaultValue="5"), @ApiImplicitParam(name="pageNum", value="\u5f53\u524d\u9875", required=false, paramType="query", dataType="string", defaultValue="1"), @ApiImplicitParam(name="isFromMail", value="\u662f\u5426\u90ae\u4ef6\u8c03\u7528", required=false, paramType="query", dataType="string")})
    public Resource getDepartmentAndUsers(@RequestParam(required=false) String deptId, @PathVariable String applicationId, @RequestParam(required=false, defaultValue="5") String pageSize, @RequestParam(required=false, defaultValue="1") String pageNum, @RequestParam(required=false) boolean isFromMail) throws Exception {
        if (pageSize == null || "".equals(pageSize) || "null".equals(pageSize)) {
            pageSize = "5";
        }
        if (pageNum == null || "".equals(pageNum) || "null".equals(pageNum)) {
            pageNum = "1";
        }
        int newPageSize = Integer.parseInt(pageSize);
        int newPageNum = Integer.parseInt(pageNum);
        Map<String, Object> result = this.deptService.getDepartmentAndUsers(applicationId, deptId, (IUser)this.getUser(), isFromMail, newPageSize, newPageNum);
        return this.success("ok", result);
    }

    @GetMapping(value={"/search"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u90e8\u95e8\u641c\u7d22", notes="\u90e8\u95e8\u641c\u7d22")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="keyword", value="\u5173\u952e\u5b57", required=false, paramType="query", dataType="string")})
    public Resource searchDeptTree(@PathVariable String applicationId, @RequestParam(required=false) String keyword) throws Exception {
        if (StringUtil.isBlank((String)keyword)) {
            ArrayList<DepartmentNode> list = new ArrayList<DepartmentNode>();
            DepartmentProcess process = AuthTimeServiceManager.departmentRuntimeService();
            DepartmentVO dept = process.getRootDepartmentByDomainId(this.getUser().getDomainid());
            DepartmentNode d = new DepartmentNode();
            d.setId(dept.getId());
            d.setName(dept.getName());
            d.setCode(dept.getCode());
            d.setLevel(dept.getLevel());
            list.add(d);
            return this.success("ok", list);
        }
        String domainId = this.getUser().getDomainid();
        List<Node> result = this.deptService.searchDeptTree(applicationId, domainId, keyword, (IUser)this.getUser());
        return this.success("ok", result);
    }

    @GetMapping(value={"/childs"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6839\u636e\u7236\u7ea7\u83b7\u53d6\u90e8\u95e8\u96c6\u5408", notes="\u6839\u636e\u7236\u7ea7\u83b7\u53d6\u90e8\u95e8\u96c6\u5408")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="parentId", value="\u7236\u7ea7id", required=false, paramType="query", dataType="string")})
    public Resource getDeptByParent(@PathVariable String applicationId, @RequestParam(required=false) String parentId) throws Exception {
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        if (StringUtil.isBlank((String)parentId)) {
            DepartmentEntity departmentVO = this.departmentDbReader.getRootDepartmentByDomainId(this.getUser().getDomainid());
            JSONObject d = new JSONObject();
            d.put((Object)"id", (Object)departmentVO.getId());
            d.put((Object)"name", (Object)departmentVO.getName());
            d.put((Object)"userCount", (Object)departmentVO.getTotalMember());
            Collection childs = this.departmentDbReader.getDepartmentByParentId(departmentVO.getId());
            if (childs == null || childs.isEmpty()) {
                d.put((Object)"hasChilds", (Object)false);
            } else {
                d.put((Object)"hasChilds", (Object)true);
            }
            list.add(d);
        } else {
            Collection depts = this.departmentDbReader.getDepartmentByParentId(parentId);
            for (DepartmentEntity departmentVO : depts) {
                JSONObject d = new JSONObject();
                d.put((Object)"id", (Object)departmentVO.getId());
                d.put((Object)"name", (Object)departmentVO.getName());
                d.put((Object)"userCount", (Object)departmentVO.getTotalMember());
                Collection childs = this.departmentDbReader.getDepartmentByParentId(departmentVO.getId());
                if (childs == null || childs.isEmpty()) {
                    d.put((Object)"hasChilds", (Object)false);
                } else {
                    d.put((Object)"hasChilds", (Object)true);
                }
                list.add(d);
            }
        }
        return this.success("ok", list);
    }
}

