/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.common.utils;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.OBPMRuntimeException;
import cn.myapps.common.RunnableMeta;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.activity.ActionContent;
import cn.myapps.common.model.activity.Activity;
import cn.myapps.common.model.activity.ActivityResult;
import cn.myapps.common.model.activity.ActivityType;
import cn.myapps.common.model.activity.ValidationWrap;
import cn.myapps.common.model.stylerepository.StyleRepositoryVO;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.common.util.cache.MemoryCacheUtil;
import cn.myapps.conf.FeignConfig;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.runtime.common.feign.service.KmsFeignService;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.ejb.DocumentProcessBean;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.macro.runner.IRunner;
import cn.myapps.runtime.macro.runner.JavaScriptFactory;
import cn.myapps.util.StringUtil;
import cn.myapps.util.file.FileOperate;
import cn.myapps.util.json.JsonTmpUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class ExportToPdf
extends ActivityType {
    private static final long serialVersionUID = 1L;

    public ExportToPdf(Activity act) {
        super(act);
    }

    public String getAfterAction() {
        return "/";
    }

    public String getBackAction() {
        return "/";
    }

    public String getBeforeAction() {
        return "/";
    }

    public String getButtonId() {
        return "button_act";
    }

    public String getDefaultClass() {
        return "button-document";
    }

    public String getDefaultOnClass() {
        return "button-onchange";
    }

    public String getOnClickFunction() {
        return "Activity.doExecute('" + this.act.getId() + "'," + this.act.getType() + ")";
    }

    public ActivityResult doExecute(ActionContent actionContent, Document doc, WebUser user) throws Exception {
        ActivityResult activityResult = new ActivityResult();
        return activityResult;
    }

    public ActivityResult doProcess(ActionContent action, Document doc, WebUser user, String htmlBody) throws Exception {
        ActivityResult activityResult = new ActivityResult();
        ValidationWrap validationWrap = new ValidationWrap();
        String pdfPath = "";
        try {
            HttpServletRequest request = action.getRequest();
            HttpServletResponse response = action.getResponse();
            ParamsTable params = action.getParams();
            String formid = params.getParameterAsString("_formid");
            if (StringUtil.isBlank((String)formid)) {
                formid = (String)request.getAttribute("formId");
            }
            FormDesignTimeService fp = DesignTimeServiceManager.formDesignTimeService();
            Form form = fp.doView(formid);
            List acts = form.getActivities();
            Iterator it = acts.iterator();
            String afterActionScript = "";
            String actId = "";
            while (it.hasNext()) {
                Activity act = (Activity)it.next();
                if (25 != act.getType()) continue;
                actId = act.getId();
                afterActionScript = act.getAfterActionScript();
            }
            String id = params.getParameterAsString("content.id");
            if (StringUtil.isBlank((String)id)) {
                id = (String)request.getAttribute("docId");
            }
            DocumentProcessBean docProcess = new DocumentProcessBean(form.getApplicationid());
            doc = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)id, (IUser)user);
            if (doc == null) {
                doc = (Document)docProcess.doView(id);
            }
            IRunner runner = JavaScriptFactory.getInstance((String)user.getSessionid(), (String)form.getApplicationid());
            runner.initBSFManager((IDocument)doc, params, (IUser)user, new ArrayList());
            String fileName = "";
            fileName = !StringUtil.isBlank((String)form.getDescription()) ? form.getDescription() : form.getName();
            String folderPath = PropertyUtil.getPath() + File.separator + "uploads" + File.separator + "exportPdf" + File.separator;
            File folder = new File(folderPath);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            String filePath = folderPath + "temp.html";
            FileOutputStream fos = new FileOutputStream(filePath);
            File file = new File("obpm-demo");
            String imgpath = file.getAbsolutePath().replace("\\", "/");
            fos.write("<html><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" >".getBytes());
            fos.write(htmlBody.replaceAll("/obpm/", imgpath).getBytes());
            if (!StringUtil.isBlank((String)doc.getSign())) {
                JSONArray signs = JsonTmpUtil.fromObject((Object)doc.getSign());
                for (JSONObject json : signs) {
                    String marginLeft = json.getString("left");
                    String marginTop = json.getString("top");
                    String realPath = PropertyUtil.getPath() + json.getString("img");
                    float left = Float.parseFloat(marginLeft);
                    float top = Float.parseFloat(marginTop);
                    String imgHtml = "<img src=\"" + realPath + "\" style=\"position:absolute;left:" + left + "px;top:" + top + "px;width:100px\">";
                    fos.write(imgHtml.getBytes());
                }
            }
            fos.write("</html>".getBytes());
            fos.close();
            FeignConfig.ACCESS_TOKEN = user.getACCESS_TOKEN(request);
            String outputPDF = folderPath + fileName + ".pdf";
            pdfPath = File.separator + "uploads" + File.separator + "exportPdf" + File.separator + fileName + ".pdf";
            KmsFeignService kmsFeignService = (KmsFeignService)SpringApplicationContextUtil.getBean(KmsFeignService.class);
            kmsFeignService.htmlConvertPdf(filePath, outputPDF);
            if (afterActionScript != null && !afterActionScript.equals("")) {
                StringBuffer afterLabel = new StringBuffer();
                afterLabel.append("Activity Action:").append(actId).append(" afterActionScript");
                runner.run((RunnableMeta)this.act, afterLabel.toString(), afterActionScript);
            }
        }
        catch (IOException e) {
            activityResult.setRuntimeException(new OBPMRuntimeException(e.getMessage(), (Throwable)e));
            e.printStackTrace();
        }
        catch (OBPMValidateException e) {
            validationWrap.addFieldError("1", e.getValidateMessage());
            e.printStackTrace();
        }
        catch (RuntimeException re) {
            activityResult.setRuntimeException(new OBPMRuntimeException(re.getMessage(), (Throwable)re));
            re.printStackTrace();
        }
        catch (Exception e) {
            activityResult.setRuntimeException(new OBPMRuntimeException(e.getMessage(), (Throwable)e));
            e.printStackTrace();
        }
        activityResult.setResultType("none");
        activityResult.setValidationWrap(validationWrap);
        activityResult.setResultData((Object)pdfPath);
        return activityResult;
    }

    private String getCssContent(String url, HttpServletRequest request, HttpServletResponse response, Document doc) throws Exception {
        StringBuffer content = new StringBuffer();
        content.append("<style>\n");
        String filePath = url;
        content.append(FileOperate.getFileContentAsString((String)filePath));
        String styleContent = "";
        StyleRepositoryVO style = doc.getForm().getStyle();
        if (style != null) {
            styleContent = style.getContent();
        }
        if (!StringUtil.isBlank((String)styleContent)) {
            content.append(styleContent);
            content.append("\n");
        }
        content.append("</style>\n");
        return content.toString();
    }
}

