/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.common.filter;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.util.StringUtil;
import cn.myapps.util.http.CookieUtil;
import cn.myapps.util.property.MultiLanguageProperty;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;

class MultiLanguageServletOutputStream
extends ServletOutputStream {
    int flag;
    int count;
    int[] buf;
    int size;
    String domain;
    String application;
    String language;
    OutputStream outStream;
    HttpServletRequest request;

    public MultiLanguageServletOutputStream(ServletRequest inRequ, ServletResponse inResp) throws IOException {
        inResp.setCharacterEncoding("UTF-8");
        this.outStream = inResp.getOutputStream();
        this.buf = new int[512];
        HttpServletRequest request = (HttpServletRequest)inRequ;
        if (request.getRequestURI().indexOf("/logout") > 0) {
            return;
        }
        WebUser webUser = null;
        if (request.getRequestURI().indexOf("dwr") < 0) {
            webUser = AuthTimeServiceManager.getWebUser((HttpServletRequest)request);
        }
        this.language = CookieUtil.getMultiLanguage((HttpServletRequest)request);
        if (StringUtil.isBlank((String)this.language)) {
            Locale loc = request.getLocale();
            if (loc.equals(Locale.CHINA) || loc.equals(Locale.PRC) || loc.toString().contains("CN")) {
                this.language = "CN";
            } else if (loc.equals(Locale.TAIWAN)) {
                this.language = "TW";
            } else {
                this.language = loc.getLanguage().toUpperCase();
                if (MultiLanguageProperty.getType((String)this.language) == 0) {
                    this.language = "EN";
                }
            }
        }
        if (webUser != null) {
            this.domain = webUser.getDomainid();
            this.application = webUser.getDefaultApplication();
        } else {
            this.domain = null;
            this.application = null;
        }
    }

    private void writeToBuf(int b) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            int[] newbuf = new int[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        this.buf[this.count] = b;
        this.count = newcount;
    }

    private void clearBuf() throws IOException {
        for (int i = 0; i < this.count; ++i) {
            this.outStream.write(this.buf[i]);
            ++this.size;
        }
        this.count = 0;
        this.flag = 0;
    }

    public void write(int i) throws IOException {
        switch (i) {
            case 123: {
                if (this.flag == 0) {
                    this.flag = 1;
                    this.writeToBuf(i);
                    break;
                }
                this.clearBuf();
                this.outStream.write(i);
                ++this.size;
                break;
            }
            case 42: {
                if (this.flag == 1) {
                    this.flag = 2;
                    this.writeToBuf(i);
                    break;
                }
                if (this.flag == 4) {
                    this.flag = 5;
                    this.writeToBuf(i);
                    break;
                }
                this.clearBuf();
                this.outStream.write(i);
                ++this.size;
                break;
            }
            case 91: {
                if (this.flag == 2) {
                    this.flag = 3;
                    this.writeToBuf(i);
                    break;
                }
                this.clearBuf();
                this.outStream.write(i);
                ++this.size;
                break;
            }
            case 93: {
                if (this.flag == 3) {
                    this.flag = 4;
                    this.writeToBuf(i);
                    break;
                }
                this.clearBuf();
                this.outStream.write(i);
                ++this.size;
                break;
            }
            case 125: {
                if (this.flag == 5) {
                    this.writeToBuf(i);
                    String origText = StringUtil.toString((int[])this.buf, (int)3, (int)(this.count - 6));
                    try {
                        String newText = MultiLanguageProperty.replaceText((String)this.application, (String)this.language, (String)origText);
                        byte[] data = newText.getBytes("UTF-8");
                        this.outStream.write(data);
                        this.size += data.length;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.count = 0;
                    this.flag = 0;
                    break;
                }
                this.clearBuf();
                this.outStream.write(i);
                ++this.size;
                break;
            }
            default: {
                if (this.flag == 3) {
                    this.writeToBuf(i);
                    break;
                }
                if (this.count > 0) {
                    this.clearBuf();
                }
                this.outStream.write(i);
                ++this.size;
            }
        }
    }

    public void close() throws IOException {
        if (this.count > 0) {
            this.clearBuf();
        }
        this.outStream.close();
    }

    public void flush() throws IOException {
        if (this.count > 0) {
            this.clearBuf();
        }
        this.outStream.flush();
    }

    public int getSize() {
        return this.size;
    }

    public boolean isReady() {
        return false;
    }

    public void setWriteListener(WriteListener writeListener) {
    }
}

