/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.common.filter;

import cn.myapps.runtime.common.filter.MultiLanguageHttpServletResponse;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.ContentCachingRequestWrapper;

public final class MultiLanguageFilter
extends HttpServlet
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(MultiLanguageFilter.class);
    private static final long serialVersionUID = 4540909316344106991L;

    public void doFilter(ServletRequest rq, ServletResponse rs, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest hreq = (HttpServletRequest)rq;
        HttpServletResponse response = (HttpServletResponse)rs;
        response.setCharacterEncoding("UTF-8");
        MultiLanguageHttpServletResponse mResponse = new MultiLanguageHttpServletResponse((ServletRequest)hreq, (ServletResponse)response);
        try {
            ContentCachingRequestWrapper wrappedRequest = new ContentCachingRequestWrapper(hreq);
            chain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)mResponse);
            mResponse.setContentLength(mResponse.getSize());
            mResponse.flushBuffer();
        }
        catch (Exception e) {
            logger.error("doFilter(url={})\u53c2\u6570\u53d1\u751f\u5f02\u5e38", (Object)hreq.getRequestURI(), (Object)e);
        }
    }

    public void init(FilterConfig arg0) throws ServletException {
    }
}

