/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.common.controller;

import cn.myapps.common.RunnableMeta;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.controller.ResourceNotFoundException;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.api.ApiConfig;
import cn.myapps.designtime.api.service.ApiDesignTimeService;
import cn.myapps.designtime.common.cache.DesignTimeSerializableCache;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.storages.DesignTimeObjectWrapper;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.macro.runner.IRunner;
import cn.myapps.runtime.macro.runner.JavaScriptFactory;
import cn.myapps.util.json.JsonTmpUtil;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.core.exceptions.SaasBadException;
import com.bcxin.saas.core.utils.SqlUtil;
import de.odysseus.staxon.json.JsonXMLConfig;
import de.odysseus.staxon.json.JsonXMLConfigBuilder;
import de.odysseus.staxon.json.JsonXMLInputFactory;
import de.odysseus.staxon.xml.util.PrettyXMLEventWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Supplier;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.mozilla.javascript.Undefined;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Component
public class MagicApiController
extends AbstractRuntimeController {
    private static Logger logger = LoggerFactory.getLogger(MagicApiController.class);
    private final JsonProvider jsonProvider;

    public MagicApiController(JsonProvider jsonProvider) {
        this.jsonProvider = jsonProvider;
    }

    @RequestMapping(value={"/magic-api/**"})
    public void execute(@RequestBody(required=false) String content, HttpServletResponse response) {
        block80: {
            content = SqlUtil.encode((String)content);
            StringBuilder sb = new StringBuilder();
            try {
                ParamsTable params = this.getParams();
                String requestURI = this.request.getRequestURI();
                String contextPath = this.request.getContextPath();
                String apiUrl = requestURI.replace(contextPath + "/magic-api", "");
                ApiConfig apiConfig = null;
                Supplier<ApiConfig> extractMatchedApiConfig = () -> {
                    try {
                        ApiDesignTimeService service = DesignTimeServiceManager.apiDesignTimeService();
                        DataPackage apiConfigs = service.query("", "", 1, Integer.MAX_VALUE);
                        AntPathMatcher matcher = new AntPathMatcher();
                        for (ApiConfig api : apiConfigs.getDatas()) {
                            String url = api.getRequestUrl().replaceAll("\\{[^\\}]+\\}", "**");
                            if (!matcher.match(url, apiUrl) || MagicApiController.count(apiUrl, "/") != MagicApiController.count(url, "/")) continue;
                            return api;
                        }
                        sb.append(String.format("====================================end=============================================", new Object[0]));
                        logger.error(sb.toString());
                    }
                    catch (Exception ex) {
                        throw new SaasBadException(String.format("\u5339\u914dMagicAPi=%s\u53d1\u751f\u5f02\u5e38", apiUrl), ex);
                    }
                    return null;
                };
                if (DesignTimeSerializableCache.isReady()) {
                    DesignTimeObjectWrapper modelWrapper = DesignTimeSerializableCache.getDesignModelWrapper((String)DesignTimeSerializableCache.getSecondWrapperKey((String)apiUrl), () -> DesignTimeObjectWrapper.create(extractMatchedApiConfig.get()), (Integer)Integer.MAX_VALUE, (boolean)false);
                    if (modelWrapper != null) {
                        apiConfig = (ApiConfig)modelWrapper.getInstance();
                    }
                } else {
                    apiConfig = extractMatchedApiConfig.get();
                }
                if (apiConfig == null) {
                    throw new ResourceNotFoundException("Api Not Found");
                }
                String applicationId = apiConfig.getApplicationid();
                this.setParams(apiConfig.getRequestUrl(), apiUrl, params);
                params.setParameter("application", (Object)applicationId);
                params.setParameter("_content", (Object)content);
                IRunner runner = JavaScriptFactory.getInstance((String)this.session.getId(), (String)applicationId);
                runner.initBSFManager((IDocument)new Document(), params, (IUser)this.getUser(), new ArrayList());
                String apiLabel = "Api(" + apiConfig.getId() + ")." + apiConfig.getName();
                if (!StringUtils.hasLength((String)apiConfig.getResponseScript())) {
                    throw new ResourceNotFoundException(String.format("\u5f53\u524d\u7684API\u5185\u5bb9\u65e0\u6548:%s", this.jsonProvider.getJson((Object)apiConfig)));
                }
                response.setCharacterEncoding("UTF-8");
                response.setContentType("application/json; charset=utf-8");
                Object result = runner.run((RunnableMeta)apiConfig, apiLabel, apiConfig.getResponseScript());
                try {
                    if (result != null && !(result instanceof Undefined)) {
                        if ("json".equals(apiConfig.getResponseType())) {
                            response.setCharacterEncoding("UTF-8");
                            response.setContentType("application/json; charset=utf-8");
                            String str = null;
                            if (result instanceof Collection || result instanceof JSONArray) {
                                JSONArray jsonArray = JsonTmpUtil.fromObject((Object)result);
                                str = jsonArray.toString();
                            } else if (result instanceof String) {
                                str = (String)result;
                            } else {
                                JSONObject json = JSONObject.fromObject((Object)result);
                                str = json.toString();
                            }
                            try (PrintWriter out = response.getWriter();){
                                out.append(str);
                                break block80;
                            }
                        }
                        if ("xml".equals(apiConfig.getResponseType())) {
                            response.setCharacterEncoding("UTF-8");
                            response.setContentType("application/xml; charset=utf-8");
                            JSONObject json = JSONObject.fromObject((Object)result);
                            String xml = MagicApiController.json2xml(json.toString());
                            String simpleName = result.getClass().getSimpleName();
                            xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><" + simpleName + ">" + xml + "</" + simpleName + ">";
                            try (PrintWriter out = response.getWriter();){
                                out.append(xml);
                                break block80;
                            }
                        }
                        if ("binary".equals(apiConfig.getResponseType())) {
                            response.setContentType("application/x-download; charset=utf-8");
                            File file = (File)result;
                            response.setHeader("Content-Disposition", "attachment;filename=\"" + URLEncoder.encode(file.getName(), "utf-8") + "\"");
                            FileInputStream inputStream = new FileInputStream(file);
                            ServletOutputStream fileOutputStream = response.getOutputStream();
                            byte[] bytes = new byte[0x100000];
                            int length = 0;
                            while ((length = ((InputStream)inputStream).read(bytes)) != -1) {
                                fileOutputStream.write(bytes, 0, length);
                            }
                            fileOutputStream.write(bytes, 0, length);
                            fileOutputStream.close();
                            break block80;
                        }
                        try (PrintWriter out = response.getWriter();){
                            out.append((String)result);
                            break block80;
                        }
                    }
                    HashMap<String, Object> bodyMap = new HashMap<String, Object>();
                    bodyMap.put("msg", "API\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
                    bodyMap.put("result", result == null ? "NULL" : result);
                    bodyMap.put("getId", apiConfig.getId());
                    bodyMap.put("getPath", apiConfig.getPath());
                    try (PrintWriter out = response.getWriter();){
                        out.append(this.jsonProvider.getJson(bodyMap));
                    }
                }
                catch (Exception ex) {
                    logger.error("{}-\u54cd\u5e94API(\u6570\u636e={})\u53d1\u751f\u5f02\u5e38", new Object[]{this.request.getRequestURI(), result, ex});
                    throw ex;
                }
            }
            catch (Exception e) {
                logger.error("API\u8bf7\u6c42\u5f02\u5e38:{}-{}", new Object[]{this.request.getRequestURI(), sb, e});
                response.setStatus(400);
                JSONObject json = JSONObject.fromObject((Object)Resource.error((int)500, (String)String.format("\u5f02\u5e38:%s", e.getMessage()), null));
                try (PrintWriter out = response.getWriter();){
                    out.append(json.toString());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String json2xml(String json) {
        StringReader input = new StringReader(json);
        StringWriter output = new StringWriter();
        JsonXMLConfig config = new JsonXMLConfigBuilder().multiplePI(false).repairingNamespaces(false).build();
        try {
            XMLEventReader reader = new JsonXMLInputFactory(config).createXMLEventReader((Reader)input);
            XMLEventWriter writer = XMLOutputFactory.newInstance().createXMLEventWriter(output);
            writer = new PrettyXMLEventWriter(writer);
            writer.add(reader);
            reader.close();
            writer.close();
        }
        catch (Exception e) {
            logger.error("json2xml \u53d1\u751f\u5f02\u5e38:{}", (Object)json, (Object)e);
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (output.toString().length() >= 38) {
            return output.toString().substring(39);
        }
        return output.toString();
    }

    private static int count(String content, String target) {
        int count = 0;
        int index = 0;
        try {
            while ((index = content.indexOf(target, index + 1)) > 0) {
                ++count;
            }
        }
        catch (Exception e) {
            logger.error("count \u53d1\u751f\u5f02\u5e38:content={}, target={}", new Object[]{content, target, e});
        }
        return count;
    }

    private void setParams(String before, String latest, ParamsTable params) {
        if (!before.equals(latest)) {
            String[] s1 = before.split("/");
            String[] s2 = latest.split("/");
            for (int i = 0; i < s1.length; ++i) {
                String key = s1[i];
                String val = s2[i];
                if (key.equals(val)) continue;
                params.setParameter(key.substring(1, key.length() - 1), (Object)val);
            }
        }
    }
}

