/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.common.controller;

import cn.hutool.core.util.StrUtil;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.conf.FileModeConfig;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.util.FileEncryptAndDecrypt;
import cn.myapps.util.StringUtil;
import cn.myapps.util.ftp.FtpUtils;
import com.itextpdf.kernel.color.Color;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.WriterProperties;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.property.TextAlignment;
import com.itextpdf.layout.property.VerticalAlignment;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.mail.internet.MimeUtility;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Api(tags={"\u4e0b\u8f7d\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/runtime"}, produces={"application/json;charset=UTF-8"})
public class DownloadController
extends AbstractRuntimeController {
    private static final Logger logger = LoggerFactory.getLogger(DownloadController.class);
    @Autowired
    private HttpServletResponse httpResponse;

    @GetMapping(value={"/file/isFileExisted"})
    @ApiOperation(value="\u6821\u9a8c\u6587\u4ef6", notes="\u6821\u9a8c\u6587\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="filename", value="\u6587\u4ef6\u540d", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="filepath", value="\u6587\u4ef6\u76f8\u5bf9\u8def\u5f84", required=true, paramType="query", dataType="string")})
    public Resource isFileExisted() {
        File file;
        ParamsTable params = this.getParams();
        HttpServletResponse response = this.httpResponse;
        String encoding = "ISO-8859-1";
        String filename = params.getParameterAsString("filename");
        String filepath = params.getParameterAsString("filepath");
        if (!filepath.startsWith("/uploads/")) {
            return new Resource(500, "\u6587\u4ef6\u7c7b\u578b\u4e0d\u5408\u6cd5\uff01", null);
        }
        try {
            filepath = URLDecoder.decode(filepath, encoding);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return new Resource(500, "\u7f16\u7801\u7c7b\u578b\u9519\u8bef\uff01", null);
        }
        String realPath = PropertyUtil.getPath();
        String realFilePath = realPath + filepath;
        if (FileEncryptAndDecrypt.isEncrypt((String)realFilePath)) {
            realFilePath = FileEncryptAndDecrypt.encrypt((String)realFilePath);
        }
        if (!(file = new File(realFilePath)).exists()) {
            return new Resource(500, "\u6587\u4ef6\u4e0d\u5b58\u5728\uff01", null);
        }
        return new Resource(200, "\u6587\u4ef6\u5b58\u5728\uff01", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/file/download"})
    @ApiOperation(value="\u6587\u4ef6\u4e0b\u8f7d", notes="\u6587\u4ef6\u4e0b\u8f7d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="filename", value="\u6587\u4ef6\u540d", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="filepath", value="\u6587\u4ef6\u76f8\u5bf9\u8def\u5f84", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="watermarkStr", value="\u6c34\u5370\u540d", required=true, paramType="query", dataType="string")})
    public void doFileDownload() {
        ServletOutputStream os = null;
        BufferedInputStream reader = null;
        try {
            File file;
            String pdfRealPath;
            File tempFile = null;
            boolean isTemp = false;
            ParamsTable params = this.getParams();
            HttpServletResponse response = this.httpResponse;
            String encoding = "ISO-8859-1";
            String filename = params.getParameterAsString("filename");
            String filepath = params.getParameterAsString("filepath");
            String watermarkStr = params.getParameterAsString("watermarkStr");
            if (!filepath.startsWith("/uploads/")) {
                response.getWriter().print("Error: file illegal!");
            }
            filepath = URLDecoder.decode(filepath, encoding);
            String realPath = PropertyUtil.getPath();
            String realFilePath = realPath + filepath;
            if (FileModeConfig.getUseFtp().booleanValue() && filepath.indexOf("/uploads/lib/icon/") < 0 && filepath.indexOf("/uploads/temp/") < 0) {
                try {
                    String filePath = filepath.substring(0, filepath.lastIndexOf("/") + 1);
                    String fileName = filepath.substring(filepath.lastIndexOf("/") + 1);
                    String tempPath = PropertyUtil.getPath() + "/uploads/temp/";
                    tempFile = FtpUtils.downloadFile((String)FileModeConfig.getHost(), (String)FileModeConfig.getUserName(), (String)FileModeConfig.getPassword(), (int)FileModeConfig.getPort(), (String)((StrUtil.isEmpty((CharSequence)FileModeConfig.getFilePath()) ? "" : FileModeConfig.getFilePath()) + filePath), (String)tempPath, (String)fileName);
                    realFilePath = tempFile.getPath();
                }
                catch (Exception e) {
                    logger.error("\u8c03\u7528FTP\u6587\u4ef6\u5f02\u5e38:{}", (Object)filepath, (Object)e);
                }
            }
            realFilePath = realFilePath.replaceAll("\\\\", "/").replace("\\", "/");
            if (!StringUtil.isBlank((String)watermarkStr) && (pdfRealPath = this.generatedWatermarkPdf(realFilePath, watermarkStr)) != null) {
                isTemp = true;
                realFilePath = pdfRealPath;
                String fileNameWithoutType = filename.substring(0, filename.indexOf("."));
                filename = fileNameWithoutType + ".pdf";
            }
            if (FileEncryptAndDecrypt.isEncrypt((String)realFilePath)) {
                realFilePath = FileEncryptAndDecrypt.encrypt((String)realFilePath);
            }
            if (!(file = new File(realFilePath)).exists()) {
                response.getWriter().print("\u627e\u4e0d\u5230\u6307\u5b9a\u6587\u4ef6");
                response.getWriter().close();
            }
            String agent = this.request.getHeader("USER-AGENT");
            response.setContentType("application/force-download");
            if (null != agent) {
                if (-1 != agent.indexOf("Firefox")) {
                    response.setHeader("Content-Disposition", "attachment;filename=\"" + MimeUtility.encodeText((String)filename, (String)encoding, (String)"B") + "\"");
                } else if (-1 != agent.indexOf("Trident") || -1 != agent.indexOf("MSIE")) {
                    filename = URLEncoder.encode(filename, "UTF8");
                    response.setHeader("Content-Disposition", "attachment;filename=\"" + filename + "\"");
                } else if (agent.toUpperCase().indexOf("EDGE") > 0) {
                    response.setHeader("Content-Disposition", "attachment;filename=\"" + URLEncoder.encode(filename, "UTF-8"));
                } else {
                    response.setHeader("Content-Disposition", "attachment;filename=\"" + new String(filename.getBytes("UTF-8"), "iso-8859-1") + "\"");
                }
            } else {
                response.setHeader("Content-Disposition", "attachment;filename=\"" + new String(filename.getBytes("UTF-8"), "iso-8859-1") + "\"");
            }
            os = response.getOutputStream();
            reader = new BufferedInputStream(new FileInputStream(file));
            IOUtils.copy((InputStream)reader, (OutputStream)os);
            tempFile.deleteOnExit();
            if (isTemp) {
                file.deleteOnExit();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (os != null) {
                    reader.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String generatedWatermarkPdf(String realFilePath, String waterMarkStr) throws Exception {
        String file = realFilePath.substring(realFilePath.lastIndexOf("/"), realFilePath.length());
        String fileName = file.substring(1, file.lastIndexOf("."));
        String pdfFileName = "/swf/" + fileName + ".pdf";
        String pdfFilePath = realFilePath.replace(file, pdfFileName);
        if (!new File(pdfFilePath).exists()) {
            return null;
        }
        File pdfFile = new File(pdfFilePath);
        File pdfFileWithWaterMark = null;
        String swfPath = pdfFilePath.substring(0, pdfFilePath.lastIndexOf("/")) + File.separator + "watermark" + File.separator;
        File saveFile = new File(swfPath);
        if (!saveFile.exists()) {
            saveFile.mkdirs();
        }
        String pdfNameWithWaterMark = fileName + ".pdf";
        String pdfPathWithWaterMark = null;
        pdfPathWithWaterMark = swfPath + pdfNameWithWaterMark;
        pdfFileWithWaterMark = new File(pdfPathWithWaterMark);
        if (pdfFileWithWaterMark.exists()) {
            return pdfPathWithWaterMark;
        }
        ByteArrayOutputStream baos = null;
        baos = new ByteArrayOutputStream();
        WriterProperties props = new WriterProperties().setStandardEncryption(null, null, 2052, 10);
        PdfReader reader = new PdfReader(pdfFilePath);
        PdfWriter writer = new PdfWriter((OutputStream)baos, props);
        PdfDocument pdfDoc = new PdfDocument(reader, writer);
        Document doc = new Document(pdfDoc);
        Paragraph p = null;
        if (!StringUtil.isBlank((String)waterMarkStr)) {
            PdfFont font = null;
            font = PdfFontFactory.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            p = (Paragraph)((Paragraph)((Paragraph)((Paragraph)new Paragraph(waterMarkStr).setFont(font)).setFontSize(30.0f)).setFontColor(Color.GRAY)).setOpacity(new Float(0.4));
        }
        int n = pdfDoc.getNumberOfPages();
        PdfExtGState gs1 = new PdfExtGState();
        for (int i = 1; i <= n; ++i) {
            PdfPage pdfPage = pdfDoc.getPage(i);
            Rectangle pagesize = pdfPage.getPageSizeWithRotation();
            pdfPage.setIgnorePageRotationForContent(true);
            int xCount = 3;
            int yCount = 4;
            float x = pagesize.getLeft() + pagesize.getRight();
            float y = pagesize.getTop() + pagesize.getBottom();
            int line = (int)y / yCount;
            int cloumn = (int)x / xCount;
            for (int lineTemp = 1; lineTemp < yCount; ++lineTemp) {
                for (int cloumnTemp = 1; cloumnTemp < xCount; ++cloumnTemp) {
                    this.addWatermarkPlace(doc, p, gs1, pagesize, i, pdfPage, cloumn * cloumnTemp, line * lineTemp);
                }
            }
        }
        doc.close();
        FileOutputStream fos2 = new FileOutputStream(pdfFileWithWaterMark);
        if (baos != null) {
            baos.writeTo(fos2);
            baos.flush();
            baos.close();
            fos2.flush();
            fos2.close();
        }
        return pdfPathWithWaterMark;
    }

    private void addWatermarkPlace(Document doc, Paragraph p, PdfExtGState gs1, Rectangle pagesize, int i, PdfPage pdfPage, int xAxie, int yAxie) {
        float x = xAxie;
        float y = yAxie;
        PdfCanvas over = new PdfCanvas(pdfPage.newContentStreamBefore(), pdfPage.getResources(), pdfPage.getDocument());
        over.saveState();
        over.setExtGState(gs1);
        if (p != null) {
            doc.showTextAligned(p, x, y, i, TextAlignment.CENTER, VerticalAlignment.TOP, 0.3f);
        }
        over.restoreState();
    }
}

