/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.common.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.ErrorMessage;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.controller.ResourceNotFoundException;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.activity.Activity;
import cn.myapps.common.util.Security;
import cn.myapps.common.util.StringUtil;
import cn.myapps.common.util.cache.MemoryCacheUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.ejb.DocumentProcess;
import cn.myapps.runtime.dynaform.document.ejb.Item;
import cn.myapps.runtime.dynaform.form.FormDataPacket;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.form.ejb.FormField;
import com.bcxin.saas.core.utils.DocumentIdExtractUtil;
import com.bcxin.saas.core.utils.ExceptionUtils;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@RestController
public abstract class AbstractRuntimeController {
    @Autowired
    protected HttpServletRequest request;
    @Autowired
    protected HttpSession session;
    private String domain;
    private Resource resourceValue;

    protected WebUser getUser() throws Exception {
        WebUser user = null;
        WebUser frontUser = AuthTimeServiceManager.getWebUser((HttpServletRequest)this.request);
        user = frontUser == null ? this.getAnonymousUser() : frontUser;
        return user;
    }

    public ParamsTable getParams() {
        String isRelate;
        String parentid;
        String parentId;
        ParamsTable pm = ParamsTable.convertHTTP((HttpServletRequest)this.request);
        String domainId = this.getDomain();
        if (domainId != null) {
            pm.setParameter("domainid", (Object)domainId);
        }
        pm.setParameter("tenant-user-id", (Object)Security.extractBearerUserId((HttpServletRequest)this.request));
        if (pm.getParameter("_pagelines") == null) {
            pm.setParameter("_pagelines", (Object)"10");
        }
        if (!StringUtil.isBlank((String)(parentId = pm.getParameterAsString("parentId")))) {
            pm.setParameter("relateid", (Object)parentId);
            pm.setParameter("parentid", (Object)parentId);
        }
        if (!StringUtil.isBlank((String)(parentid = pm.getParameterAsString("parentid")))) {
            pm.setParameter("relateid", (Object)parentid);
            pm.setParameter("parentId", (Object)parentid);
        }
        if (StringUtil.isBlank((String)(isRelate = pm.getParameterAsString("isRelate"))) || !"true".equals(isRelate)) {
            pm.removeParameter("parentId");
            pm.removeParameter("parentid");
        }
        return pm;
    }

    public String getDomain() {
        if (StringUtils.isNotBlank((String)this.domain)) {
            return this.domain;
        }
        try {
            return this.getUser().getDomainid();
        }
        catch (Exception exception) {
            return "";
        }
    }

    protected Resource success(String errmsg, Object data) {
        if (data instanceof FormDataPacket) {
            FormDataPacket formatedData = (FormDataPacket)data;
            if (!CollectionUtils.isEmpty((Collection)formatedData.getActivities())) {
                for (Activity activity : formatedData.getActivities()) {
                    activity.setActionScript(null);
                    activity.setBeforeActionScript(null);
                    activity.setAfterActionScript(null);
                }
            }
            return new Resource(0, errmsg, (Object)formatedData, null);
        }
        return new Resource(0, errmsg, data, null);
    }

    protected Resource successWithPagination(String errmsg, Object data, int page, int page_lines, int row_count) {
        com.alibaba.fastjson.JSONObject json = new com.alibaba.fastjson.JSONObject();
        json.put("data", data);
        json.put("page", (Object)page);
        json.put("page_lines", (Object)page_lines);
        json.put("row_count", (Object)row_count);
        this.resourceValue = new Resource(0, errmsg, (Object)json, null);
        return this.resourceValue;
    }

    protected Resource error(int errcode, String errmsg, Collection<ErrorMessage> errors) {
        return new Resource(errcode, String.format("\u5f02\u5e38:%s", errmsg), null, errors);
    }

    public Resource getResourceValue() {
        return this.resourceValue;
    }

    public void setResourceValue(Resource resourceValue) {
        this.resourceValue = resourceValue;
    }

    private WebUser getAnonymousUser() throws Exception {
        UserVO vo = new UserVO();
        vo.getId();
        vo.setName("GUEST");
        vo.setLoginno("guest");
        vo.setLoginpwd("");
        vo.setRoles(null);
        vo.setEmail("");
        return new WebUser((IUser)vo);
    }

    @ExceptionHandler(value={ResourceNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public Resource resourceNotFound(ResourceNotFoundException e) {
        return this.error(404, "Not Found", null);
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Resource error(RuntimeException e) {
        return this.error(500, ExceptionUtils.getStackMessage((Throwable)e), null);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Resource error(Exception e) {
        return this.error(500, ExceptionUtils.getStackMessage((Throwable)e), null);
    }

    @ExceptionHandler(value={OBPMValidateException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Resource serverError(OBPMValidateException e) {
        return this.error(500, ExceptionUtils.getStackMessage((Throwable)e), null);
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    @ResponseStatus(value=HttpStatus.NOT_ACCEPTABLE)
    public Resource resourceNotFound(MethodArgumentTypeMismatchException e) {
        return this.error(40035, "\u4e0d\u5408\u6cd5\u7684\u53c2\u6570", null);
    }

    @ExceptionHandler(value={PathNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_ACCEPTABLE)
    public Resource requestbodyError(PathNotFoundException e) {
        e.printStackTrace();
        return this.error(406, "\u8bf7\u6c42\u5305\u4f53\u53c2\u6570\u51fa\u9519", null);
    }

    public Document prepareDocument(String jsonContent, String applicationId, String baseJsonPath, ParamsTable params) throws Exception {
        Document temp;
        Configuration configuration = Configuration.defaultConfiguration();
        configuration = configuration.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
        DocumentContext parse = JsonPath.parse((String)jsonContent, (Configuration)configuration);
        String formid = (String)parse.read(baseJsonPath + ".formId", new Predicate[0]);
        String viewid = (String)parse.read(baseJsonPath + ".viewId", new Predicate[0]);
        String stateid = (String)parse.read(baseJsonPath + ".stateId", new Predicate[0]);
        String parentid = (String)parse.read(baseJsonPath + ".parentId", new Predicate[0]);
        String sign = (String)parse.read(baseJsonPath + ".sign", new Predicate[0]);
        String docId = params.getDocId();
        if (StringUtil.isBlank((String)docId)) {
            docId = (String)parse.read(baseJsonPath + ".id", new Predicate[0]);
        }
        if (!StringUtil.isBlank((String)docId) && docId.contains("--")) {
            DocumentIdExtractUtil.IdValue idValue = DocumentIdExtractUtil.extract((String)docId);
            formid = idValue.getFormId();
        }
        String isRelate = (String)parse.read(baseJsonPath + ".isRelate", new Predicate[0]);
        List subDocuments = (List)parse.read(baseJsonPath + ".subDocuments", new Predicate[0]);
        Map items = (Map)parse.read(baseJsonPath + ".items", new Predicate[0]);
        Object delete = parse.read(baseJsonPath + ".delete", new Predicate[0]);
        Object edit = parse.read(baseJsonPath + ".edit", new Predicate[0]);
        Object isFromRefresh = params.getParameter("isFromRefresh");
        Object exparams = parse.read(baseJsonPath + ".exparams", new Predicate[0]);
        if (exparams != null) {
            Map exparamsMap = (Map)exparams;
            for (Map.Entry entry : exparamsMap.entrySet()) {
                String key = entry.getKey().toString();
                Object value = entry.getValue();
                params.setParameter(key, value);
            }
        }
        if (isRelate != null && isRelate.equals("true")) {
            params.setParameter("isRelate", (Object)"true");
            if (!StringUtil.isBlank((String)parentid)) {
                params.setParameter("relateid", (Object)parentid);
            }
        } else {
            if (!StringUtil.isBlank((String)parentid)) {
                params.setParameter("relateid", (Object)parentid);
            }
            parentid = "";
        }
        if (parentid != null && !parentid.isEmpty()) {
            params.setParameter("parentid", (Object)parentid);
        }
        if (viewid != null && !viewid.isEmpty()) {
            params.setParameter("viewid", (Object)viewid);
        }
        DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
        Form form = null;
        WebUser user = this.getUser();
        Document doc = null;
        if (items != null) {
            temp = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)docId, (IUser)user);
            if (temp == null) {
                temp = (Document)dProcess.doView(docId);
            }
            if (temp == null || !StringUtil.isBlank((String)formid) && !formid.equalsIgnoreCase(temp.getFormid())) {
                form = DesignTimeServiceManager.formDesignTimeService().doView(formid);
                temp = dProcess.doNew(form, (IUser)user, params);
                temp.setId(docId);
            }
            for (Map.Entry entry : items.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                Item item = temp.findItem(key);
                if (item == null && !StringUtil.isBlank((String)key) && key.lastIndexOf("_show") > -1) {
                    item = temp.findItem(key.substring(0, key.lastIndexOf("_show")));
                }
                if (item == null) continue;
                params.setParameter(key, value);
            }
        } else {
            return new Document();
        }
        doc = temp;
        if (!items.isEmpty() && isFromRefresh == null) {
            if (form == null) {
                form = DesignTimeServiceManager.formDesignTimeService().doView(formid);
            }
            doc = form.createDocument(doc, params, (IUser)user);
        }
        if (!StringUtil.isBlank((String)parentid)) {
            doc.setParent(parentid);
        }
        if (!StringUtil.isBlank((String)stateid)) {
            doc.setState(stateid);
        }
        if (!StringUtil.isBlank((String)sign)) {
            doc.setSign(sign);
        }
        if (StringUtil.isBlank((String)doc.getFormid()) && !StringUtil.isBlank((String)formid)) {
            doc.setFormid(formid);
        }
        if (StringUtil.isBlank((String)doc.getApplicationid()) && !StringUtil.isBlank((String)applicationId)) {
            doc.setApplicationid(applicationId);
        }
        ArrayList<Document> subDocumentList = new ArrayList<Document>();
        if (subDocuments != null) {
            for (Map map : subDocuments) {
                ParamsTable newParams = params.copyContextParams();
                for (Map.Entry entry : map.entrySet()) {
                    String name = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (value instanceof String[]) {
                        if (((String[])value).length > 1) {
                            newParams.setParameter(name, value);
                            continue;
                        }
                        newParams.setParameter(name, (Object)((String[])value)[0]);
                        continue;
                    }
                    newParams.setParameter(name, value);
                }
                Document subDoc = this.prepareDocument(JSONObject.fromObject((Object)map).toString(), applicationId, "$", newParams);
                subDocumentList.add(subDoc);
            }
        }
        doc.setSubDocuments(subDocumentList.isEmpty() ? null : subDocumentList);
        if (delete != null) {
            doc.setDelete(true);
        }
        if (edit != null) {
            doc.setEdit(true);
        }
        MemoryCacheUtil.putToPrivateSpace((Object)doc.getId(), (Object)doc, (IUser)this.getUser());
        return doc;
    }

    public List<Document> prepareDocuments(String jsonContent, String applicationId, String baseJsonPath) throws Exception {
        Configuration configuration = Configuration.defaultConfiguration();
        configuration = configuration.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
        DocumentContext parse = JsonPath.parse((String)jsonContent, (Configuration)configuration);
        List maps = (List)JsonPath.parse((String)jsonContent).read(baseJsonPath, new Predicate[0]);
        ArrayList<Document> docs = new ArrayList<Document>();
        for (Map map : maps) {
            Document doc;
            ParamsTable params = new ParamsTable();
            String formid = (String)map.get("formId");
            String viewid = (String)map.get("viewId");
            String stateid = (String)map.get("stateId");
            String parentid = (String)map.get("parentId");
            String sign = (String)map.get("sign");
            String docId = (String)map.get("id");
            String isRelate = (String)map.get("isRelate");
            Map items = (Map)map.get("items");
            if (isRelate != null && isRelate.equals("true")) {
                params.setParameter("isRelate", (Object)"true");
                if (!StringUtil.isBlank((String)parentid)) {
                    params.setParameter("relateid", (Object)parentid);
                }
            } else {
                if (!StringUtil.isBlank((String)parentid)) {
                    params.setParameter("relateid", (Object)parentid);
                }
                parentid = "";
            }
            if (parentid != null && !parentid.isEmpty()) {
                params.setParameter("parentid", (Object)parentid);
            }
            if (parentid != null && !parentid.isEmpty()) {
                params.setParameter("viewid", (Object)viewid);
            }
            DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
            FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
            Form form = formService.doView(formid);
            if (items != null) {
                Document temp = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)docId, (IUser)this.getUser());
                for (Map.Entry entry : items.entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    FormField field = form.findFieldByName(key);
                    if (field == null) continue;
                    params.setParameter(key, value);
                }
            } else {
                docs.add(new Document());
                continue;
            }
            WebUser user = this.getUser();
            Document po = (Document)dProcess.doView(docId);
            Object object = doc = po != null ? po : null;
            if (StringUtil.isBlank((String)docId)) {
                Document newDoc = dProcess.doNew(form, (IUser)user, params);
                docId = newDoc.getId();
            }
            if (!StringUtil.isBlank((String)docId)) {
                if (doc == null) {
                    doc = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)docId, (IUser)user);
                }
                if (doc == null) {
                    doc = form.createDocument(params, (IUser)user);
                    if (doc != null) {
                        for (Map.Entry entry : items.entrySet()) {
                            String key = (String)entry.getKey();
                            Object value = entry.getValue();
                            Item item = doc.findItem(key);
                            if (item == null) continue;
                            params.setParameter(key, value);
                        }
                    }
                    doc = form.recalculateDocument(doc, params, true, (IUser)user);
                } else if (!items.isEmpty()) {
                    doc = form.createDocument(doc, params, (IUser)user);
                }
            } else if (!StringUtil.isBlank((String)parentid)) {
                doc = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)docId, (IUser)user);
            }
            if (!StringUtil.isBlank((String)parentid)) {
                doc.setParent(parentid);
            }
            if (!StringUtil.isBlank((String)stateid)) {
                doc.setState(stateid);
            }
            if (!StringUtil.isBlank((String)sign)) {
                doc.setSign(sign);
            }
            if (!StringUtil.isBlank((String)formid)) {
                doc.setFormid(formid);
            }
            if (!StringUtil.isBlank((String)applicationId)) {
                doc.setApplicationid(applicationId);
            }
            MemoryCacheUtil.putToPrivateSpace((Object)doc.getId(), (Object)doc, (IUser)this.getUser());
            docs.add(doc);
        }
        return docs;
    }
}

