/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.chart.controller;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.RunnableMeta;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.chart.Chart;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.chart.service.ChartDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.form.ejb.FormField;
import cn.myapps.runtime.dynaform.form.ejb.ValueStoreField;
import cn.myapps.runtime.macro.runner.IRunner;
import cn.myapps.runtime.macro.runner.JavaScriptFactory;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.saas.core.utils.SqlUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u7edf\u8ba1\u56fe\u6267\u884c\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/runtime"}, produces={"application/json;charset=UTF-8"})
public class ChartController
extends AbstractRuntimeController {
    @PostMapping(value={"/chart/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u7edf\u8ba1\u56fe\u7684\u6570\u636e\u5185\u5bb9", notes="\u83b7\u53d6\u7edf\u8ba1\u56fe\u7684\u6570\u636e\u5185\u5bb9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u7edf\u8ba1\u56feid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=false, paramType="body", dataType="string")})
    public Resource doGetChartData(@PathVariable String id, @RequestBody(required=false) String content) throws Exception {
        content = SqlUtil.encode((String)content);
        Object result = "";
        HashMap<String, String> data = new HashMap<String, String>();
        ChartDesignTimeService chartservice = DesignTimeServiceManager.chartDesignTimeService();
        Chart chart = chartservice.doView(id);
        ParamsTable params = this.getParams();
        if (chart != null) {
            Document searchDocument;
            if (!StringUtil.isBlank((String)content)) {
                JSONObject jsonObject = JSONObject.parseObject((String)content);
                for (Map.Entry entry : jsonObject.entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    params.setParameter(key, value);
                }
            }
            if (!StringUtil.isBlank((String)chart.getSearchFormId())) {
                FormDesignTimeService fs = DesignTimeServiceManager.formDesignTimeService();
                Form searchForm = fs.doView(chart.getSearchFormId());
                searchDocument = searchForm.createDocument(params, (IUser)this.getUser());
            } else {
                searchDocument = new Document();
            }
            result = this.buildEChartOption(chart, this.getParams(), this.getUser(), (IDocument)searchDocument);
        }
        String viewId = chart.getViewId();
        AbstractView view = null;
        if (!StringUtil.isBlank((String)viewId)) {
            ViewDesignTimeService viewDesignTimeService = DesignTimeServiceManager.viewDesignTimeService();
            view = viewDesignTimeService.doView(viewId);
        }
        data.put("result", (String)result);
        data.put("view", (String)view);
        data.put("appId", chart.getApplicationid());
        return this.success("ok", data);
    }

    private Object buildEChartOption(Chart chart, ParamsTable params, WebUser user, IDocument doc) throws Exception {
        Object optionText = "";
        if (!StringUtil.isBlank((String)chart.getScripttext())) {
            IRunner runner = JavaScriptFactory.getInstance((String)user.getSessionid(), (String)chart.getApplicationid());
            runner.initBSFManager(doc, params, (IUser)user, new ArrayList());
            try {
                Object result;
                String scriptText = chart.getScripttext();
                scriptText = "JSON.stringify(" + scriptText + ")";
                optionText = result = runner.run((RunnableMeta)chart, "Chart[" + chart.getName() + "]-" + chart.getId(), scriptText);
            }
            catch (Exception e) {
                e.printStackTrace();
                optionText = e.getMessage();
            }
        }
        return optionText;
    }

    @GetMapping(path={"/chart/{id}/searchformtemplate/{applicationId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u67e5\u8be2\u8868\u5355\u6a21\u677f", notes="\u83b7\u53d6\u67e5\u8be2\u8868\u5355\u6a21\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="id", value="\u7edf\u8ba1\u56feid", required=true, paramType="path", dataType="string")})
    public Resource getSearchFormTemplate(@PathVariable String applicationId, @PathVariable String id) throws Exception {
        WebUser user = this.getUser();
        ParamsTable params = this.getParams();
        ChartDesignTimeService chartService = DesignTimeServiceManager.chartDesignTimeService();
        Chart chart = chartService.doView(id);
        IRunner runner = JavaScriptFactory.getInstance((String)user.getSessionid(), (String)applicationId);
        Document searchDocument = null;
        if (!StringUtil.isBlank((String)chart.getSearchFormId())) {
            FormDesignTimeService fs = DesignTimeServiceManager.formDesignTimeService();
            Form searchForm = fs.doView(chart.getSearchFormId());
            searchDocument = searchForm.createDocument(params, (IUser)this.getUser());
        } else {
            searchDocument = new Document();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        StringBuilder buffer = new StringBuilder();
        StringBuilder template = new StringBuilder();
        Form form = searchDocument.getForm();
        String formId = form == null ? "" : form.getId();
        ArrayList<Map> data = new ArrayList<Map>();
        if (form != null) {
            template.append(form.getHtmlTemplate(searchDocument, runner, (IUser)user));
            buffer.append(template.toString());
            buffer.append("<input type=\"hidden\" id=\"dy_refreshObj\" formid=\"" + formId + "\"");
            buffer.append(" docid=\"" + searchDocument.getId() + "\" userid=\"" + user.getId() + "\"");
            buffer.append(" mapVal=\"");
            for (Object obj : form.getAllFields()) {
                if (!(obj instanceof ValueStoreField)) continue;
                FormField field = (FormField)obj;
                buffer.append(field.getName() + ";");
            }
            if (buffer.lastIndexOf(";") != -1) {
                buffer.deleteCharAt(buffer.lastIndexOf(";"));
            }
            Collection fields = form.getFields();
            for (FormField formField : fields) {
                Map value = formField.toAttributes(searchDocument, runner, (IUser)this.getUser(), 2);
                if (formField.getOtherPropsAsMap() != null && value != null && !value.isEmpty()) {
                    for (String propertyKey : formField.getOtherPropsAsMap().keySet()) {
                        if (value.get(propertyKey) != null) continue;
                        value.put(propertyKey, formField.getOtherPropsAsMap().get(propertyKey));
                    }
                }
                data.add(value);
            }
            buffer.append("\" />");
        }
        map.put("fields", data);
        map.put("document", searchDocument);
        map.put("template", buffer.toString());
        if (form != null && form.getStyle() != null) {
            map.put("style", form.getStyle());
        }
        return this.success("ok", map);
    }
}

