/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.application.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.model.application.Application;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.cache.DesignTimeSerializableCache;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.requests.RefreshDesignRequest;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Api(tags={"\u8f6f\u4ef6\u6267\u884c\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/runtime"}, produces={"application/json;charset=UTF-8"})
public class ApplicationController
extends AbstractRuntimeController {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationController.class);
    private ApplicationDesignTimeService service = null;

    public ApplicationController() {
        try {
            this.service = DesignTimeServiceManager.applicationDesignTimeService();
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
    }

    @GetMapping(value={"/applications"})
    @ApiOperation(value="\u83b7\u53d6\u8f6f\u4ef6\u5217\u8868", notes="\u83b7\u53d6\u8f6f\u4ef6\u5217\u8868")
    public Resource doGetApplications() throws Exception {
        try {
            Application app;
            JSONObject result = new JSONObject();
            WebUser webUser = this.getUser();
            List list = this.service.getListByWebUser((IUser)webUser);
            String domainId = webUser.getDomainid();
            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
            DomainVO domain = (DomainVO)domainProcess.doView(domainId);
            List kmRoleIds = AuthTimeServiceManager.userRuntimeService().listKmRoleIdsByUserId(webUser.getId());
            if (domain.isEnable(Application.KM_APPLICATION_ID) && kmRoleIds.size() != 0 && (kmRoleIds.contains("KMSUPERADMINROLEID") || kmRoleIds.contains("KMDEPTADMINROLEID") || kmRoleIds.contains("KMCOMMITTEEADMINROLEID") || kmRoleIds.contains("KMNORMALROLEID"))) {
                app = new Application();
                app.setId("km");
                app.setName("\u77e5\u8bc6\u6587\u6863\u7ba1\u7406");
                list.add(app);
            }
            if (domain.isEnable(Application.QM_APPLICATION_ID)) {
                app = new Application();
                app.setId("qm");
                app.setName("\u8c03\u67e5\u95ee\u5377");
                list.add(app);
            }
            result.put("applications", (Object)list);
            result.put("flowCenter", (Object)domain.isEnable(Application.FC_APPLICATION_ID));
            return this.success("ok", result);
        }
        catch (Exception ex) {
            return this.error(ex);
        }
    }

    @GetMapping(value={"/applications/sysapplications"})
    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u8f6f\u4ef6\u5217\u8868", notes="\u83b7\u53d6\u7cfb\u7edf\u8f6f\u4ef6\u5217\u8868")
    public Resource doGetSysApplications() {
        ArrayList list = new ArrayList();
        try {
            String domainId = this.getUser().getDomainid();
            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
            DomainVO domain = (DomainVO)domainProcess.doView(domainId);
            if (domain.isEnable(Application.KM_APPLICATION_ID)) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", "km");
                map.put("name", "\u77e5\u8bc6\u6587\u6863\u7ba1\u7406");
                list.add(map);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        return this.success("ok", list);
    }

    @PutMapping(value={"/applications/{id}/components/do-refresh"})
    @ApiOperation(value="\u66f4\u65b0\u7ec4\u4ef6\u7684\u5237\u65b0", notes="\u66f4\u65b0\u7ec4\u4ef6\u7684\u5237\u65b0")
    public Resource doUpdateAppComponents(@PathVariable String id, @RequestBody RefreshDesignRequest request) {
        boolean result = DesignTimeSerializableCache.doRefreshWrapperObject((String)id, (RefreshDesignRequest)request);
        return Resource.ok((Object)result);
    }
}

