/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.activity.controller;

import cn.myapps.authtime.logger.model.LogVO;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.Environment;
import cn.myapps.common.RunnableMeta;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.ErrorMessage;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.common.model.activity.ActionContent;
import cn.myapps.common.model.activity.Activity;
import cn.myapps.common.model.activity.ActivityResult;
import cn.myapps.common.model.resource.ResourceVO;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.StringUtil;
import cn.myapps.common.util.cache.MemoryCacheUtil;
import cn.myapps.designtime.activity.service.ActivityDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.resource.service.ResourceDesignTimeService;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import cn.myapps.runtime.activity.service.ActivityRunTimeService;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.common.utils.ExportToPdf;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.ejb.DocumentProcess;
import cn.myapps.runtime.dynaform.document.ejb.Item;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.dynaform.form.FormDataPacket;
import cn.myapps.runtime.dynaform.form.ejb.ButtonField;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.form.ejb.FormField;
import cn.myapps.runtime.dynaform.form.ejb.ValidateMessage;
import cn.myapps.runtime.logger.service.LogHelper;
import cn.myapps.runtime.logger.service.LogProcess;
import cn.myapps.runtime.macro.runner.IRunner;
import cn.myapps.runtime.macro.runner.JavaScriptFactory;
import cn.myapps.util.DocumentRequestUtil;
import cn.myapps.util.ParamsTableUtil;
import cn.myapps.util.ProcessFactory;
import cn.myapps.util.sequence.Sequence;
import com.alibaba.fastjson.JSONArray;
import com.bcxin.saas.core.exceptions.SaasBadException;
import com.bcxin.saas.core.utils.ExceptionUtils;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u64cd\u4f5c\u6267\u884c\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/runtime"}, produces={"application/json;charset=UTF-8"})
public class ActivityController
extends AbstractRuntimeController {
    @Autowired
    private ActivityRunTimeService activityRuntimeService;
    @Autowired
    private HttpServletResponse response;

    @PostMapping(value={"/{applicationId}/activities/{id}/runbeforeactionscript"})
    @ApiOperation(value="\u8fd0\u884c\u6267\u884c\u524d\u811a\u672c", notes="\u8fd0\u884c\u6267\u884c\u524d\u811a\u672c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u64cd\u4f5cid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource runBeforeActionScript(@PathVariable String id, @PathVariable String applicationId, @RequestBody String content) throws Exception {
        ParamsTable params = this.getParams();
        params = ParamsTableUtil.parseAndMergeActionB_A(params, id, content, true);
        Document doc = this.prepareDocument(content, applicationId, "$.document", params);
        com.alibaba.fastjson.JSONObject result = this.activityRuntimeService.runbeforeactionscript(applicationId, id, doc, params, (IUser)this.getUser());
        return this.success("ok", result);
    }

    @PostMapping(value={"/{applicationId}/activities/{id}/runafteractionscript"})
    @ApiOperation(value="\u6267\u884c\u540e\u811a\u672c", notes="\u6267\u884c\u540e\u811a\u672c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="id", value="\u64cd\u4f5cid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource runAfterActionScript(@PathVariable String id, @PathVariable String applicationId, @RequestBody String content) throws Exception {
        ParamsTable params = this.getParams();
        params = ParamsTableUtil.parseAndMergeActionB_A(params, id, content, false);
        com.alibaba.fastjson.JSONObject result = this.activityRuntimeService.runafteractionscript(id, applicationId, content, params, (IUser)this.getUser());
        return this.success("ok", result);
    }

    @GetMapping(value={"/{applicationId}/activities/{id}/runScript"})
    @ResponseBody
    @ApiOperation(value="\u6267\u884c\u6309\u94ae\u7684\u67d0\u4e2a\u5b57\u6bb5\u811a\u672c", notes="\u6267\u884c\u6309\u94ae\u7684\u67d0\u4e2a\u5b57\u6bb5\u811a\u672c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="id", value="\u64cd\u4f5cid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docid", value="\u6587\u6863id", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", required=false, paramType="query", dataType="string")})
    public Resource doRunScript(@PathVariable String id, @PathVariable String applicationId, @RequestParam String docId, @RequestParam String fieldName) {
        String stringResult = "";
        try {
            fieldName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1, fieldName.length());
            stringResult = this.runActivityScript(id, applicationId, docId, fieldName);
        }
        catch (Exception e) {
            return this.error(403, "\u5b57\u6bb5\u540d\u4e0d\u5b58\u6216\u8005\u811a\u672c\u62a5\u9519" + ExceptionUtils.getStackMessage((Throwable)e), null);
        }
        return this.success("ok", stringResult);
    }

    private String runActivityScript(String id, String applicationId, String docId, String fieldName) throws Exception {
        DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
        ActivityDesignTimeService actService = DesignTimeServiceManager.activityDesignTimeService();
        FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
        Document doc = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)docId, (IUser)this.getUser());
        if (doc == null) {
            doc = (Document)dProcess.doView(docId);
        }
        Activity act = (Activity)actService.findById(id);
        ButtonField buttonField = null;
        String dispatcherUrl = "";
        String name = "";
        Activity control = null;
        if (act != null) {
            Method method = act.getClass().getMethod(fieldName, new Class[0]);
            Object result = method.invoke((Object)act, new Object[0]);
            if (result != null) {
                dispatcherUrl = result.toString();
            }
            name = act.getName();
            control = act;
        } else {
            Form form = formService.doView(doc.getFormid());
            Map map = form.getAllFieldMap();
            FormField formField = (FormField)map.get(id);
            if (formField instanceof ButtonField) {
                buttonField = (ButtonField)formField;
            }
            if (buttonField == null) {
                throw new SaasBadException(String.format("\u7cfb\u7edf\u5f02\u5e38, \u8868\u5355(%s)\u5185\u90e8\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6309\u94ae(id=%s)", form.getUri(), id));
            }
            dispatcherUrl = buttonField.getDispatcherUrl();
            name = buttonField.getName();
            control = buttonField;
        }
        Object result = null;
        WebUser user = this.getUser();
        IRunner runner = JavaScriptFactory.getInstance((String)user.getSessionid(), (String)applicationId);
        runner.initBSFManager((IDocument)doc, this.getParams(), (IUser)user, new ArrayList());
        StringBuffer label = new StringBuffer();
        if (doc != null) {
            label.append("FormName:").append(doc.getFormname());
        }
        label.append(" Activity(").append(id).append(")." + name).append(".").append(fieldName);
        result = runner.run((RunnableMeta)control, label.toString(), StringUtil.dencodeHTML((String)dispatcherUrl));
        return (String)result;
    }

    @PutMapping(value={"/{applicationId}/activities/{id}/execute"})
    @ApiOperation(value="\u6267\u884c\u52a8\u4f5c", notes="\u6267\u884c\u52a8\u4f5c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="id", value="\u64cd\u4f5cid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource execute(@PathVariable String applicationId, @PathVariable String id, @RequestBody String content) throws Exception {
        ParamsTable params = DocumentRequestUtil.parseRequestParams(this.request, this.getDomain(), id, content, false);
        com.alibaba.fastjson.JSONObject result = this.activityRuntimeService.execute(applicationId, id, content, params, (IUser)this.getUser());
        return this.success("ok", result);
    }

    @GetMapping(value={"/{applicationId}/documents/{docId}/activities/archive"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5f52\u6863\u6309\u94ae", notes="\u5f52\u6863\u6309\u94ae")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863id", required=true, paramType="path", dataType="string")})
    public Resource archive(@PathVariable String applicationId, @PathVariable String docId) throws Exception {
        String result = this.activityRuntimeService.archive(applicationId, docId, (IUser)this.getUser(), this.getParams());
        return this.success("ok", result);
    }

    @PostMapping(value={"/{applicationId}/documents/activities/saveStartWorkFlow"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u4fdd\u5b58\u6587\u6863\u5e76\u542f\u52a8\u6d41\u7a0b\u6309\u94ae", notes="\u4fdd\u5b58\u6587\u6863\u5e76\u542f\u52a8\u6d41\u7a0b\u6309\u94ae")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource saveStartWorkFlow(@PathVariable String applicationId, @RequestBody String content) throws Exception {
        ParamsTable params = this.getParams();
        Document doc = this.prepareDocument(content, applicationId, "$.document", params);
        DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
        WebUser webUser = this.getUser();
        Collection subDocuments = doc.getFrontSubDocuments();
        List<ErrorMessage> errors = this.validateDocument(params, doc, applicationId, (IUser)webUser);
        if (errors.isEmpty()) {
            if (subDocuments != null) {
                ArrayList copySubDocuments = new ArrayList();
                copySubDocuments.addAll(doc.getSubDocuments());
                for (Document document : copySubDocuments) {
                    if (document.isDelete()) {
                        dProcess.doRemove(document.getId());
                        doc.removeSubDocument(document.getId());
                        continue;
                    }
                    if (!document.isEdit()) continue;
                    List<ErrorMessage> subErrors = this.validateDocument(params, document, applicationId, (IUser)webUser);
                    if (!subErrors.isEmpty()) {
                        return this.error(4001, "\u5b50\u8868\u5355\u6821\u9a8c\u4e0d\u901a\u8fc7", subErrors);
                    }
                    document.setVersions(-1);
                    dProcess.doCreateOrUpdate((IDocument)document, (IUser)webUser);
                }
                doc = doc.getForm().recalculateDocument(doc, params, (IUser)webUser);
            }
            Document result = this.activityRuntimeService.saveStartWorkFlow(applicationId, doc, (IUser)webUser, params);
            return this.success("ok", result);
        }
        return this.error(4001, "\u8868\u5355\u6821\u9a8c\u4e0d\u901a\u8fc7", errors);
    }

    @PostMapping(value={"/{applicationId}/documents/{docId}/activities/copy"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u590d\u5236\u6587\u6863\u6309\u94ae", notes="\u590d\u5236\u6587\u6863\u6309\u94ae")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource copy(@PathVariable String applicationId, @PathVariable String docId, @RequestBody String content) throws Exception {
        Configuration configuration = Configuration.defaultConfiguration();
        configuration = configuration.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
        DocumentContext parse = JsonPath.parse((String)content, (Configuration)configuration);
        Map items = (Map)parse.read("$.document.items", new Predicate[0]);
        DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
        Document doc = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)docId, (IUser)this.getUser());
        if (doc == null) {
            doc = (Document)dProcess.doView(docId);
        }
        ParamsTable params = this.getParams();
        for (Map.Entry entry : items.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Item item = doc.findItem(key);
            if (item == null) continue;
            params.setParameter(key, value);
        }
        WebUser user = this.getUser();
        doc.setId(Sequence.getSequence());
        List<ErrorMessage> errors = this.validateDocument(params, doc, applicationId, (IUser)user);
        if (!errors.isEmpty()) {
            ErrorMessage error = new ErrorMessage();
            error.setErrcode(40001);
            error.setErrmsg("\u590d\u5236\u8868\u5355\u6821\u9a8c\u4e0d\u901a\u8fc7");
            errors.add(0, error);
            return this.error(4001, "\u590d\u5236\u8868\u5355\u6821\u9a8c\u4e0d\u901a\u8fc7", errors);
        }
        Document result = this.activityRuntimeService.copy(applicationId, doc, (IUser)user, params);
        return this.success("ok", result);
    }

    @DeleteMapping(value={"/{applicationId}/forms/{formId}/activities/clear"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6e05\u9664\u6240\u6709\u6570\u636e", notes="\u6e05\u9664\u6240\u6709\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="formId", value="\u8868\u5355id", required=true, paramType="path", dataType="string")})
    public Resource clear(@PathVariable String applicationId, @PathVariable String formId) throws Exception {
        this.activityRuntimeService.clear(applicationId, (IUser)this.getUser(), formId);
        return this.success("ok", "\u6e05\u9664\u6210\u529f");
    }

    @PostMapping(value={"/{applicationId}/documents/{docId}/activities/sign"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u7b7e\u7ae0", notes="\u7b7e\u7ae0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource sign(@PathVariable String applicationId, @PathVariable String docId, @RequestBody String content) throws Exception {
        Configuration configuration = Configuration.defaultConfiguration();
        configuration = configuration.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
        DocumentContext parse = JsonPath.parse((String)content, (Configuration)configuration);
        String sign = (String)parse.read("$.document.sign", new Predicate[0]);
        Map items = (Map)parse.read("$.document.items", new Predicate[0]);
        DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
        Document doc = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)docId, (IUser)this.getUser());
        if (doc == null) {
            doc = (Document)dProcess.doView(docId);
        }
        ParamsTable params = this.getParams();
        for (Map.Entry entry : items.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Item item = doc.findItem(key);
            if (item == null) {
                throw new Exception(key + " \u503c\u4e0d\u5b58\u5728");
            }
            item.setValue(value);
            params.setParameter(key, value);
        }
        doc.setSign(sign);
        dProcess.doCreateOrUpdate((IDocument)doc, (IUser)this.getUser());
        return this.success("ok", "\u7b7e\u7ae0\u6210\u529f");
    }

    @PostMapping(value={"/{applicationId}/activities/{id}/download"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6587\u4ef6\u4e0b\u8f7d\u6309\u94ae", notes="\u6587\u4ef6\u4e0b\u8f7d\u6309\u94ae")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863id", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="id", value="\u6309\u94aeid", required=true, paramType="path", dataType="string")})
    public Resource downloadFile(@PathVariable String applicationId, @RequestParam(required=false) String docId, @PathVariable String id) throws Exception {
        Document doc = new Document();
        if (!StringUtil.isBlank((String)docId)) {
            DocumentProcess proxy = (DocumentProcess)ProcessFactory.createRuntimeProcess(DocumentProcess.class, (String)applicationId);
            doc = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)docId, (IUser)this.getUser());
            if (doc == null) {
                doc = (Document)proxy.doView(docId);
            }
        }
        IRunner runner = JavaScriptFactory.getInstance((String)this.getUser().getSessionid(), (String)applicationId);
        runner.initBSFManager((IDocument)doc, this.getParams(), (IUser)this.getUser(), new ArrayList());
        ActivityDesignTimeService activityService = DesignTimeServiceManager.activityDesignTimeService();
        Activity act = (Activity)activityService.findById(id);
        if (act == null) {
            FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
            Form actParent = doc.getForm();
            act = actParent.findActivity(id);
        }
        String result = "";
        if (!StringUtil.isBlank((String)act.getFileNameScript())) {
            StringBuffer label = new StringBuffer();
            label.append("Activity(").append(act.getId()).append(")." + act.getName()).append("fileNameScript");
            result = (String)runner.run((RunnableMeta)act, label.toString(), act.getFileNameScript());
        }
        if (!StringUtil.isBlank((String)result)) {
            String filePath;
            if (result.contains("https://") || result.contains("http://")) {
                return this.success("ok", result);
            }
            String path = result;
            if (result.indexOf("?") > -1) {
                path = result.substring(0, result.indexOf("?"));
            }
            if (!new File(filePath = PropertyUtil.getPath() + path).isFile()) {
                return this.error(40001, "\u6587\u4ef6\u4e0d\u5b58\u5728", null);
            }
        } else {
            return this.error(40001, "\u6587\u4ef6\u4e0d\u5b58\u5728", null);
        }
        return this.success("ok", result);
    }

    @PostMapping(value={"/{applicationId}/views/{viewId}/activities/exportExcel"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5bfc\u51faExcel\u64cd\u4f5c", notes="\u5bfc\u51faExcel\u64cd\u4f5c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="viewId", value="\u89c6\u56feid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="actId", value="\u6309\u94aeid", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="filename", value="\u6587\u4ef6\u540d", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public void exportExcel(HttpServletResponse response, HttpServletRequest request, @PathVariable String applicationId, @PathVariable String viewId, String actId, String filename, @RequestBody String content) throws Exception {
        WebUser user = this.getUser();
        MemoryCacheUtil.putToPrivateSpace((Object)"excelExportCount", (Object)0, (IUser)user);
        MemoryCacheUtil.putToPrivateSpace((Object)"excelRowCount", (Object)0, (IUser)user);
        MemoryCacheUtil.removeFromPrivateSpace((Object)"exportExcelResult", (IUser)user);
        if (StringUtil.isBlank((String)filename)) {
            filename = String.format("\u5bfc\u51fa\u6587\u4ef6-%s", Instant.now().getEpochSecond());
        }
        ParamsTable params = this.getParams();
        filename = URLDecoder.decode(filename, "utf-8");
        params.setParameter("filename", (Object)filename);
        String agent = request.getHeader("USER-AGENT");
        String fileNameExcel = filename + ".xlsx";
        String encoding = Environment.getInstance().getEncoding();
        response.setContentType("application/x-download; charset=" + encoding + "");
        if (null != agent && -1 != agent.indexOf("Firefox")) {
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileNameExcel.getBytes("UTF-8"), "iso-8859-1"));
        } else {
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileNameExcel.getBytes("UTF-8"), "iso-8859-1"));
        }
        com.alibaba.fastjson.JSONObject json = com.alibaba.fastjson.JSONObject.parseObject((String)content);
        String selectColumns = json.getString("selectColumns");
        params.setParameter("selectColumns", (Object)selectColumns);
        JSONArray jsonArray = json.getJSONArray("selectDocIds");
        String[] docIds = (String[])jsonArray.toArray((Object[])new String[0]);
        Object items = json.get((Object)"items");
        if (items != null) {
            com.alibaba.fastjson.JSONObject jsonObject = (com.alibaba.fastjson.JSONObject)items;
            for (Map.Entry entry : jsonObject.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value == null || "".equals(String.valueOf(value))) continue;
                params.setParameter(key, value);
            }
        }
        String result = this.activityRuntimeService.exportExcel(viewId, actId, (IUser)this.getUser(), params, (OutputStream)response.getOutputStream(), docIds);
        MemoryCacheUtil.putToPrivateSpace((Object)"exportExcelResult", (Object)result, (IUser)user);
    }

    @GetMapping(value={"/exportExcel/readProcess"})
    public Resource exportExcelProcess() {
        com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
        try {
            WebUser user = this.getUser();
            jsonObject.put("excelExportCount", MemoryCacheUtil.getFromPrivateSpace((Object)"excelExportCount", (IUser)user));
            jsonObject.put("excelRowCount", MemoryCacheUtil.getFromPrivateSpace((Object)"excelRowCount", (IUser)user));
            jsonObject.put("exportExcelResult", MemoryCacheUtil.getFromPrivateSpace((Object)"exportExcelResult", (IUser)user));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.success("ok", jsonObject);
    }

    @PostMapping(value={"/{applicationId}/documents/{docId}/activities/share"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u901a\u8fc7\u90ae\u4ef6\u6216\u624b\u673a\u77ed\u4fe1\u5206\u4eab\u6309\u94ae", notes="\u901a\u8fc7\u90ae\u4ef6\u6216\u624b\u673a\u77ed\u4fe1\u5206\u4eab\u6309\u94ae")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource share(@PathVariable String applicationId, @PathVariable String docId, @RequestBody String content) throws Exception {
        Configuration configuration = Configuration.defaultConfiguration();
        configuration = configuration.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
        DocumentContext parse = JsonPath.parse((String)content, (Configuration)configuration);
        String transpond = (String)parse.read("$.transpond", new Predicate[0]);
        String handleUrl = (String)parse.read("$.handleUrl", new Predicate[0]);
        String receiverid = (String)parse.read("$.receiverid", new Predicate[0]);
        Boolean email = (Boolean)parse.read("$.email", new Predicate[0]);
        Boolean msm = (Boolean)parse.read("$.msm", new Predicate[0]);
        String result = this.activityRuntimeService.share(applicationId, docId, (IUser)this.getUser(), this.getParams(), transpond, handleUrl, receiverid, email, msm);
        return this.success("ok", result);
    }

    @PostMapping(value={"/{applicationId}/forms/activities/batchApprove"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6279\u91cf\u63d0\u4ea4\u64cd\u4f5c", notes="\u6279\u91cf\u63d0\u4ea4\u64cd\u4f5c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource batchApprove(@PathVariable String applicationId, @RequestBody String content) throws Exception {
        WebUser user = this.getUser();
        MemoryCacheUtil.putToPrivateSpace((Object)"handledCount", (Object)0, (IUser)user);
        MemoryCacheUtil.putToPrivateSpace((Object)"batchApproveCount", (Object)0, (IUser)user);
        MemoryCacheUtil.removeFromPrivateSpace((Object)"batchApproveResult", (IUser)user);
        Configuration configuration = Configuration.defaultConfiguration();
        configuration = configuration.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
        DocumentContext parse = JsonPath.parse((String)content, (Configuration)configuration);
        String limistStrList = (String)parse.read("$.limistStrList", new Predicate[0]);
        List docIdsList = (List)parse.read("$.docIds", new Predicate[0]);
        String[] docIds = docIdsList.toArray(new String[0]);
        String actId = (String)parse.read("$.actId", new Predicate[0]);
        String attitude = (String)parse.read("$.attitude", new Predicate[0]);
        String remark = (String)parse.read("$.remark", new Predicate[0]);
        JSONObject result = this.activityRuntimeService.batchApprove(applicationId, limistStrList, docIds, actId, attitude, remark, this.getParams(), (IUser)user);
        MemoryCacheUtil.putToPrivateSpace((Object)"batchApproveResult", (Object)result, (IUser)user);
        return this.success("ok", result);
    }

    @GetMapping(value={"/batchApprove/readProcess"})
    public Resource batchApproveProcess() {
        com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
        try {
            WebUser user = this.getUser();
            jsonObject.put("handledCount", MemoryCacheUtil.getFromPrivateSpace((Object)"handledCount", (IUser)user));
            jsonObject.put("batchApproveCount", MemoryCacheUtil.getFromPrivateSpace((Object)"batchApproveCount", (IUser)user));
            jsonObject.put("batchApproveResult", MemoryCacheUtil.getFromPrivateSpace((Object)"batchApproveResult", (IUser)user));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.success("ok", jsonObject);
    }

    @PostMapping(value={"/{applicationId}/forms/{formId}/documents/{docId}/activities/exportPdf"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="pdf\u5bfc\u51fa\u64cd\u4f5c", notes="pdf\u5bfc\u51fa\u64cd\u4f5c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="formId", value="\u8868\u5355id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863id", required=true, paramType="path", dataType="string")})
    public Resource exportPdf(@PathVariable String formId, @PathVariable String applicationId, @PathVariable String docId, @RequestBody String content, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExportToPdf exportToPdf = new ExportToPdf(new Activity());
        request.setAttribute("formId", (Object)formId);
        request.setAttribute("docId", (Object)docId);
        com.alibaba.fastjson.JSONObject json = com.alibaba.fastjson.JSONObject.parseObject((String)content);
        String htmlBody = json.getString("htmlBody");
        ActionContent action = new ActionContent(request, response);
        DocumentProcess proxy = RunTimeServiceManager.documentProcess((String)applicationId);
        Document doc = (Document)proxy.doView(docId);
        ActivityResult activityResult = exportToPdf.doProcess(action, doc, this.getUser(), htmlBody);
        return this.success("ok", activityResult.getResultData());
    }

    @GetMapping(value={"/{applicationId}/forms/{formId}/documents/{docId}/activities/print"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u7f51\u9875\u6253\u5370\u64cd\u4f5c", notes="\u7f51\u9875\u6253\u5370\u64cd\u4f5c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="formId", value="\u8868\u5355id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863id", required=true, paramType="path", dataType="string")})
    public Resource print(@PathVariable String applicationId, @PathVariable String formId, @PathVariable String docId) throws Exception {
        FormDataPacket result = this.activityRuntimeService.print(applicationId, formId, docId, this.getParams(), (IUser)this.getUser());
        return this.success("ok", result);
    }

    @PostMapping(value={"/{applicationId}/views/{viewId}/activities/importExcel"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5bfc\u5165excel\u64cd\u4f5c", notes="\u5bfc\u5165excel\u64cd\u4f5c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="viewId", value="\u89c6\u56feid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource importExcel(@PathVariable String applicationId, @PathVariable String viewId, @RequestBody String content) throws Exception {
        WebUser user = this.getUser();
        try {
            String result;
            MemoryCacheUtil.putToPrivateSpace((Object)"excelImportCount", (Object)0, (IUser)user);
            MemoryCacheUtil.putToPrivateSpace((Object)"excelImportRowCount", (Object)0, (IUser)user);
            MemoryCacheUtil.removeFromPrivateSpace((Object)"importExcelResult", (IUser)user);
            Configuration configuration = Configuration.defaultConfiguration();
            configuration = configuration.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
            DocumentContext parse = JsonPath.parse((String)content, (Configuration)configuration);
            String impmappingconfigid = (String)parse.read("$.impmappingconfigid", new Predicate[0]);
            String path = (String)parse.read("$.path", new Predicate[0]);
            String actId = (String)parse.read("$.actId", new Predicate[0]);
            String parentId = (String)parse.read("$.parentId", new Predicate[0]);
            String isRelate = (String)parse.read("$.isRelate", new Predicate[0]);
            Map exparams = (Map)parse.read("$.exparams", new Predicate[0]);
            ParamsTable params = this.getParams();
            if (exparams != null) {
                for (Map.Entry obj : exparams.entrySet()) {
                    Object value = obj.getValue();
                    String key = (String)obj.getKey();
                    params.setParameter(key, value);
                }
            }
            if (!StringUtil.isBlank((String)parentId)) {
                params.setParameter("parentid", (Object)parentId);
            }
            if (!StringUtil.isBlank((String)isRelate)) {
                params.setParameter("isRelate", (Object)isRelate);
            }
            if ((result = this.activityRuntimeService.improtExcel(applicationId, impmappingconfigid, path, (IUser)user, params, actId, viewId)).indexOf("cn.myapps.runtime.dynaform.dts.excelimport.success.total.imported") > -1) {
                Resource success = this.success("ok", result);
                MemoryCacheUtil.putToPrivateSpace((Object)"importExcelResult", (Object)success, (IUser)user);
                return success;
            }
            String[] msg = result.split("\\$\\$");
            Resource error = new Resource(4001, "\u5bfc\u5165\u51fa\u9519", (Object)msg, null);
            MemoryCacheUtil.putToPrivateSpace((Object)"importExcelResult", (Object)error, (IUser)user);
            return error;
        }
        catch (Exception e) {
            e.printStackTrace();
            Resource error = new Resource(5000, e.getMessage(), null);
            MemoryCacheUtil.putToPrivateSpace((Object)"importExcelResult", (Object)error, (IUser)user);
            return error;
        }
    }

    @PostMapping(value={"/{applicationId}/views/{viewId}/activities/validationExcel"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5bfc\u5165excel\u64cd\u4f5c", notes="\u5bfc\u5165excel\u64cd\u4f5c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="viewId", value="\u89c6\u56feid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource validationExcel(@PathVariable String applicationId, @PathVariable String viewId, @RequestBody String content) throws Exception {
        WebUser user = this.getUser();
        try {
            String result;
            MemoryCacheUtil.putToPrivateSpace((Object)"excelImportCount", (Object)0, (IUser)user);
            MemoryCacheUtil.putToPrivateSpace((Object)"excelImportRowCount", (Object)0, (IUser)user);
            MemoryCacheUtil.removeFromPrivateSpace((Object)"importExcelResult", (IUser)user);
            Configuration configuration = Configuration.defaultConfiguration();
            configuration = configuration.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
            DocumentContext parse = JsonPath.parse((String)content, (Configuration)configuration);
            String impmappingconfigid = (String)parse.read("$.impmappingconfigid", new Predicate[0]);
            String path = (String)parse.read("$.path", new Predicate[0]);
            String actId = (String)parse.read("$.actId", new Predicate[0]);
            String parentId = (String)parse.read("$.parentId", new Predicate[0]);
            String isRelate = (String)parse.read("$.isRelate", new Predicate[0]);
            Map exparams = (Map)parse.read("$.exparams", new Predicate[0]);
            ParamsTable params = this.getParams();
            if (exparams != null) {
                for (Map.Entry obj : exparams.entrySet()) {
                    Object value = obj.getValue();
                    String key = (String)obj.getKey();
                    params.setParameter(key, value);
                }
            }
            if (!StringUtil.isBlank((String)parentId)) {
                params.setParameter("parentid", (Object)parentId);
            }
            if (!StringUtil.isBlank((String)isRelate)) {
                params.setParameter("isRelate", (Object)isRelate);
            }
            if ((result = this.activityRuntimeService.validationExcel(applicationId, impmappingconfigid, path, (IUser)user, params, actId, viewId)).indexOf("cn.myapps.runtime.dynaform.dts.excelimport.success.total.imported") > -1) {
                Resource success = this.success("ok", result);
                MemoryCacheUtil.putToPrivateSpace((Object)"importExcelResult", (Object)success, (IUser)user);
                return success;
            }
            String[] msg = result.split("\\$\\$");
            Resource error = new Resource(4001, "\u6821\u9a8c\u51fa\u9519", (Object)msg, null);
            MemoryCacheUtil.putToPrivateSpace((Object)"importExcelResult", (Object)error, (IUser)user);
            return error;
        }
        catch (Exception e) {
            e.printStackTrace();
            Resource error = new Resource(5000, e.getMessage(), null);
            MemoryCacheUtil.putToPrivateSpace((Object)"importExcelResult", (Object)error, (IUser)user);
            return error;
        }
    }

    @GetMapping(value={"/importExcel/readProcess"})
    public Resource readProcess() {
        String result = "success";
        com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
        try {
            WebUser user = this.getUser();
            jsonObject.put("excelImportCount", MemoryCacheUtil.getFromPrivateSpace((Object)"excelImportCount", (IUser)user));
            jsonObject.put("excelRowCount", MemoryCacheUtil.getFromPrivateSpace((Object)"excelImportRowCount", (IUser)user));
            jsonObject.put("importExcelResult", MemoryCacheUtil.getFromPrivateSpace((Object)"importExcelResult", (IUser)user));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.success("ok", jsonObject);
    }

    @PutMapping(value={"/{applicationId}/activities/{actId}/executeAddress"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6267\u884c\u5730\u5740\u811a\u672c", notes="\u6267\u884c\u5730\u5740\u811a\u672c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863id", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="actId", value="\u6309\u94aeid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource executeAddress(@PathVariable String applicationId, @RequestParam(required=false) String docId, @PathVariable String actId, @RequestBody String content) throws Exception {
        List selects;
        Configuration configuration = Configuration.defaultConfiguration();
        configuration = configuration.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
        DocumentContext parse = JsonPath.parse((String)content, (Configuration)configuration);
        ParamsTable params = this.getParams();
        Map items = (Map)parse.read("$.document", new Predicate[0]);
        if (items != null) {
            for (Map.Entry entry : items.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                params.setParameter(key, value);
            }
        }
        if ((selects = (List)parse.read("$._selects", new Predicate[0])) != null) {
            params.setParameter("_selects", (Object)StringUtil.unite((Object[])selects.toArray()));
        }
        com.alibaba.fastjson.JSONObject result = this.activityRuntimeService.executeAddress(applicationId, actId, params, (IUser)this.getUser(), docId);
        return this.success("ok", result);
    }

    @PostMapping(value={"/activities/recordHandleLog"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u8bb0\u5f55\u64cd\u4f5c\u65e5\u5fd7", notes="\u8bb0\u5f55\u64cd\u4f5c\u65e5\u5fd7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="formId", value="\u8868\u5355id", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="viewId", value="\u89c6\u56feid", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="actType", value="\u64cd\u4f5c\u7c7b\u578b", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="menuId", value="\u83dc\u5355id", required=false, paramType="query", dataType="String")})
    public Resource recordHandleLog(@RequestParam(required=false) String formId, @RequestParam(required=false) String viewId, @RequestParam String actType, @RequestParam(required=false) String menuId) throws Exception {
        ResourceDesignTimeService resourceService;
        ResourceVO menu;
        String description = "";
        if (!StringUtil.isBlank((String)formId)) {
            FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
            Form form = formService.doView(formId);
            description = "{*[" + form.getSimpleClassName() + "]*}-" + form.getName();
        }
        if (!StringUtil.isBlank((String)viewId)) {
            ViewDesignTimeService viewProcess = DesignTimeServiceManager.viewDesignTimeService();
            AbstractView view = viewProcess.doView(viewId);
            description = "{*[" + view.getSimpleClassName() + "]*}-" + view.getName();
        }
        if (!StringUtil.isBlank((String)menuId) && (menu = (resourceService = DesignTimeServiceManager.resourceDesignTimeService()).doView(menuId)) != null) {
            description = "\u83dc\u5355-" + this.getHierarchyResourceName(resourceService, menu.getSuperior(), menu.getName());
            actType = "\u8fdb\u5165\u83dc\u5355";
        }
        String ip = LogHelper.getRequestIp((HttpServletRequest)this.request);
        LogVO logVo = LogVO.valueOf((IUser)this.getUser(), (String)actType, (String)description, (String)ip);
        LogProcess logProcess = (LogProcess)ProcessFactory.createProcess(LogProcess.class);
        logProcess.doCreate((AuthtimeValueObject)logVo);
        return this.success("ok", null);
    }

    private List<ErrorMessage> validateDocument(ParamsTable params, Document doc, String applicationId, IUser webUser) throws Exception {
        ArrayList<ErrorMessage> errmsgs = new ArrayList<ErrorMessage>();
        doc.setDomainid(this.getDomain());
        DocumentProcess proxy = RunTimeServiceManager.documentProcess((String)applicationId);
        Collection errors = proxy.doValidate(doc, params, webUser);
        if (errors != null && errors.size() > 0) {
            for (ValidateMessage err : errors) {
                ErrorMessage msg = new ErrorMessage();
                msg.setErrcode(40001);
                msg.setErrmsg(err.getErrmessage());
                msg.setField(err.getFieldname());
                errmsgs.add(msg);
            }
        }
        return errmsgs;
    }

    private String getHierarchyResourceName(ResourceDesignTimeService resourceService, String superior, String rootResourceName) {
        try {
            if (!StringUtil.isBlank((String)superior)) {
                ResourceVO resourceVO = resourceService.doView(superior);
                rootResourceName = resourceVO.getName() + "/" + rootResourceName;
                return this.getHierarchyResourceName(resourceService, resourceVO.getSuperior(), rootResourceName);
            }
            return rootResourceName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }
}

