/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.tableofcontents;

import cn.myapps.report.examples.Templates;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class TableOfContentsReport1 {
    public TableOfContentsReport1() {
        this.build();
    }

    public static void main(String[] args) {
        new TableOfContentsReport1();
    }

    private void build() {
        TextColumnBuilder countryColumn = DynamicReports.col.column("Country", "country", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder itemColumn = DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType());
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).tableOfContents()).columns(new ColumnBuilder[]{countryColumn, itemColumn, DynamicReports.col.column("Order date", "orderdate", (DRIDataType)DynamicReports.type.dateType()), DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType()), DynamicReports.col.column("Unit price", "unitprice", (DRIDataType)DynamicReports.type.bigDecimalType())})).groupBy(new ValueColumnBuilder[]{countryColumn, itemColumn})).title(new ComponentBuilder[]{Templates.createTitleComponent("TableOfContents1")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        String[] countries = new String[]{"USA", "Canada", "Mexico"};
        String[] items = new String[]{"Book", "Notebook", "PDA"};
        DRDataSource dataSource = new DRDataSource(new String[]{"country", "item", "orderdate", "quantity", "unitprice"});
        for (String country : countries) {
            for (String item : items) {
                for (int i = 0; i < 8; ++i) {
                    dataSource.add(new Object[]{country, item, this.toDate(2010, 1, (int)(Math.random() * 10.0) + 1), (int)(Math.random() * 10.0) + 1, new BigDecimal(Math.random() * 100.0 + 1.0)});
                }
            }
        }
        return dataSource;
    }

    private Date toDate(int year, int month, int day) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month - 1);
        c.set(5, day);
        return c.getTime();
    }
}

