/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.subtotal;

import cn.myapps.report.examples.Templates;
import java.math.BigDecimal;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.group.ColumnGroupBuilder;
import net.sf.dynamicreports.report.builder.group.GroupBuilder;
import net.sf.dynamicreports.report.builder.subtotal.SubtotalBuilder;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class GroupSubtotalReport {
    public GroupSubtotalReport() {
        this.build();
    }

    public static void main(String[] args) {
        new GroupSubtotalReport();
    }

    private void build() {
        TextColumnBuilder countryColumn = DynamicReports.col.column("Country", "country", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder itemColumn = DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder quantityColumn = DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType());
        TextColumnBuilder priceColumn = DynamicReports.col.column("Price", "price", (DRIDataType)DynamicReports.type.bigDecimalType());
        ColumnGroupBuilder countryGroup = DynamicReports.grp.group((ValueColumnBuilder)countryColumn);
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).columns(new ColumnBuilder[]{countryColumn, itemColumn, quantityColumn, priceColumn})).groupBy(new GroupBuilder[]{countryGroup})).subtotalsAtFirstGroupFooter(new SubtotalBuilder[]{DynamicReports.sbt.sum((ValueColumnBuilder)quantityColumn)})).subtotalsAtGroupFooter((GroupBuilder)countryGroup, new SubtotalBuilder[]{DynamicReports.sbt.sum((ValueColumnBuilder)priceColumn)})).subtotalsAtSummary(new SubtotalBuilder[]{DynamicReports.sbt.text("Total", (ColumnBuilder)itemColumn), DynamicReports.sbt.sum((ValueColumnBuilder)quantityColumn), DynamicReports.sbt.sum((ValueColumnBuilder)priceColumn)})).title(new ComponentBuilder[]{Templates.createTitleComponent("GroupSubtotal")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"country", "item", "quantity", "price"});
        dataSource.add(new Object[]{"USA", "Tablet", 4, new BigDecimal(150)});
        dataSource.add(new Object[]{"USA", "Tablet", 3, new BigDecimal(190)});
        dataSource.add(new Object[]{"USA", "Laptop", 2, new BigDecimal(250)});
        dataSource.add(new Object[]{"USA", "Laptop", 1, new BigDecimal(420)});
        dataSource.add(new Object[]{"Canada", "Tablet", 6, new BigDecimal(120)});
        dataSource.add(new Object[]{"Canada", "Tablet", 2, new BigDecimal(180)});
        dataSource.add(new Object[]{"Canada", "Laptop", 3, new BigDecimal(300)});
        dataSource.add(new Object[]{"Canada", "Laptop", 2, new BigDecimal(390)});
        return dataSource;
    }
}

