/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.subtotal;

import cn.myapps.report.examples.Templates;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.subtotal.AggregationSubtotalBuilder;
import net.sf.dynamicreports.report.builder.subtotal.SubtotalBuilder;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class FieldSubtotalReport {
    public FieldSubtotalReport() {
        this.build();
    }

    public static void main(String[] args) {
        new FieldSubtotalReport();
    }

    private void build() {
        TextColumnBuilder itemColumn = DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder orderDateColumn = DynamicReports.col.column("Order Date", "orderdate", (DRIDataType)DynamicReports.type.dateType());
        AggregationSubtotalBuilder quantitySum = (AggregationSubtotalBuilder)DynamicReports.sbt.sum("quantity", Integer.class, (ColumnBuilder)itemColumn).setLabel("quantity sum");
        AggregationSubtotalBuilder unitPriceSum = (AggregationSubtotalBuilder)DynamicReports.sbt.sum("unitprice", BigDecimal.class, (ColumnBuilder)itemColumn).setLabel("unitPrice sum");
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).columns(new ColumnBuilder[]{itemColumn, orderDateColumn})).subtotalsAtSummary(new SubtotalBuilder[]{quantitySum, unitPriceSum})).title(new ComponentBuilder[]{Templates.createTitleComponent("FieldSubtotal")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "orderdate", "quantity", "unitprice"});
        dataSource.add(new Object[]{"Tablet", this.toDate(2010, 1, 1), 3, new BigDecimal(110)});
        dataSource.add(new Object[]{"Tablet", this.toDate(2010, 2, 1), 1, new BigDecimal(150)});
        dataSource.add(new Object[]{"Laptop", this.toDate(2010, 2, 1), 3, new BigDecimal(300)});
        dataSource.add(new Object[]{"Smartphone", this.toDate(2010, 4, 1), 8, new BigDecimal(90)});
        dataSource.add(new Object[]{"Smartphone", this.toDate(2010, 5, 1), 6, new BigDecimal(120)});
        return dataSource;
    }

    private Date toDate(int year, int month, int day) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month - 1);
        c.set(5, day);
        return c.getTime();
    }
}

