/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.subtotal;

import cn.myapps.report.examples.Templates;
import java.math.BigDecimal;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.VariableBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.component.TextFieldBuilder;
import net.sf.dynamicreports.report.builder.group.ColumnGroupBuilder;
import net.sf.dynamicreports.report.builder.group.GroupBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.style.StyleBuilder;
import net.sf.dynamicreports.report.constant.Calculation;
import net.sf.dynamicreports.report.constant.Evaluation;
import net.sf.dynamicreports.report.constant.HorizontalTextAlignment;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class CustomTextSubtotalReport {
    public CustomTextSubtotalReport() {
        this.build();
    }

    public static void main(String[] args) {
        new CustomTextSubtotalReport();
    }

    private void build() {
        TextColumnBuilder countryColumn = DynamicReports.col.column("Country", "country", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder itemColumn = DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder quantityColumn = DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType());
        TextColumnBuilder priceColumn = DynamicReports.col.column("Price", "price", (DRIDataType)DynamicReports.type.bigDecimalType());
        ColumnGroupBuilder countryGroup = DynamicReports.grp.group((ValueColumnBuilder)countryColumn);
        VariableBuilder quantitySum = DynamicReports.variable((ValueColumnBuilder)quantityColumn, (Calculation)Calculation.SUM);
        VariableBuilder priceSum = DynamicReports.variable((ValueColumnBuilder)priceColumn, (Calculation)Calculation.SUM);
        VariableBuilder quantityGrpSum = DynamicReports.variable((ValueColumnBuilder)quantityColumn, (Calculation)Calculation.SUM);
        quantityGrpSum.setResetGroup((GroupBuilder)countryGroup);
        VariableBuilder priceGrpSum = DynamicReports.variable((ValueColumnBuilder)priceColumn, (Calculation)Calculation.SUM);
        priceGrpSum.setResetType(Evaluation.FIRST_GROUP);
        StyleBuilder subtotalStyle = (StyleBuilder)((StyleBuilder)((StyleBuilder)DynamicReports.stl.style().bold()).setTopBorder(DynamicReports.stl.pen1Point())).setHorizontalTextAlignment(HorizontalTextAlignment.CENTER);
        TextFieldBuilder summarySbt = (TextFieldBuilder)DynamicReports.cmp.text((DRIExpression)new CustomTextSubtotal((VariableBuilder<Integer>)quantitySum, (VariableBuilder<BigDecimal>)priceSum)).setStyle((ReportStyleBuilder)subtotalStyle);
        TextFieldBuilder groupSbt = (TextFieldBuilder)DynamicReports.cmp.text((DRIExpression)new CustomTextSubtotal((VariableBuilder<Integer>)quantityGrpSum, (VariableBuilder<BigDecimal>)priceGrpSum)).setStyle((ReportStyleBuilder)subtotalStyle);
        countryGroup.footer(new ComponentBuilder[]{groupSbt});
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).variables(new VariableBuilder[]{quantitySum, priceSum, quantityGrpSum, priceGrpSum})).columns(new ColumnBuilder[]{countryColumn, itemColumn, quantityColumn, priceColumn})).groupBy(new GroupBuilder[]{countryGroup})).summary(new ComponentBuilder[]{summarySbt})).title(new ComponentBuilder[]{Templates.createTitleComponent("CustomTextSubtotal")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"country", "item", "quantity", "price"});
        dataSource.add(new Object[]{"USA", "Tablet", 4, new BigDecimal(600)});
        dataSource.add(new Object[]{"USA", "Tablet", 3, new BigDecimal(570)});
        dataSource.add(new Object[]{"USA", "Laptop", 2, new BigDecimal(500)});
        dataSource.add(new Object[]{"USA", "Laptop", 1, new BigDecimal(420)});
        dataSource.add(new Object[]{"Canada", "Tablet", 6, new BigDecimal(720)});
        dataSource.add(new Object[]{"Canada", "Tablet", 2, new BigDecimal(360)});
        dataSource.add(new Object[]{"Canada", "Laptop", 3, new BigDecimal(900)});
        dataSource.add(new Object[]{"Canada", "Laptop", 2, new BigDecimal(780)});
        return dataSource;
    }

    private class CustomTextSubtotal
    extends AbstractSimpleExpression<String> {
        private static final long serialVersionUID = 1L;
        private VariableBuilder<Integer> quantitySum;
        private VariableBuilder<BigDecimal> priceSum;

        public CustomTextSubtotal(VariableBuilder<Integer> quantitySum, VariableBuilder<BigDecimal> priceSum) {
            this.quantitySum = quantitySum;
            this.priceSum = priceSum;
        }

        public String evaluate(ReportParameters reportParameters) {
            Integer quantitySumValue = (Integer)reportParameters.getValue(this.quantitySum);
            BigDecimal priceSumValue = (BigDecimal)reportParameters.getValue(this.priceSum);
            BigDecimal unitPriceSbt = priceSumValue.divide(new BigDecimal(quantitySumValue), 2, 4);
            return "sum(quantity) = " + DynamicReports.type.integerType().valueToString(this.quantitySum, reportParameters) + ", sum(price) = " + DynamicReports.type.bigDecimalType().valueToString(this.priceSum, reportParameters) + ", sum(price) / sum(quantity) = " + DynamicReports.type.bigDecimalType().valueToString((Number)unitPriceSbt, reportParameters.getLocale());
        }
    }
}

