/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.subtotal;

import cn.myapps.report.examples.Templates;
import java.math.BigDecimal;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.subtotal.AggregationSubtotalBuilder;
import net.sf.dynamicreports.report.builder.subtotal.CustomSubtotalBuilder;
import net.sf.dynamicreports.report.builder.subtotal.SubtotalBuilder;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.DRIValue;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class CustomSubtotalReport {
    private AggregationSubtotalBuilder<Integer> quantitySum;
    private AggregationSubtotalBuilder<BigDecimal> priceSum;

    public CustomSubtotalReport() {
        this.build();
    }

    public static void main(String[] args) {
        new CustomSubtotalReport();
    }

    private void build() {
        TextColumnBuilder itemColumn = DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder quantityColumn = DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType());
        TextColumnBuilder priceColumn = DynamicReports.col.column("Price", "price", (DRIDataType)DynamicReports.type.bigDecimalType());
        TextColumnBuilder unitPriceColumn = (TextColumnBuilder)priceColumn.divide(2, quantityColumn).setTitle("Price / Quantity");
        this.quantitySum = (AggregationSubtotalBuilder)DynamicReports.sbt.sum((ValueColumnBuilder)quantityColumn).setLabel("sum");
        this.priceSum = (AggregationSubtotalBuilder)DynamicReports.sbt.sum((ValueColumnBuilder)priceColumn).setLabel("sum");
        CustomSubtotalBuilder unitPriceSbt = (CustomSubtotalBuilder)((CustomSubtotalBuilder)DynamicReports.sbt.customValue((DRIExpression)new UnitPriceSubtotal(), (ColumnBuilder)unitPriceColumn).setLabel("sum(price) / sum(quantity)")).setDataType((DRIDataType)DynamicReports.type.bigDecimalType());
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).columns(new ColumnBuilder[]{itemColumn, quantityColumn, priceColumn, unitPriceColumn})).subtotalsAtSummary(new SubtotalBuilder[]{this.quantitySum, this.priceSum, unitPriceSbt})).title(new ComponentBuilder[]{Templates.createTitleComponent("CustomSubtotal")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "quantity", "price"});
        dataSource.add(new Object[]{"Tablet", 3, new BigDecimal(330)});
        dataSource.add(new Object[]{"Tablet", 1, new BigDecimal(150)});
        dataSource.add(new Object[]{"Laptop", 3, new BigDecimal(900)});
        dataSource.add(new Object[]{"Smartphone", 8, new BigDecimal(720)});
        dataSource.add(new Object[]{"Smartphone", 6, new BigDecimal(720)});
        return dataSource;
    }

    private class UnitPriceSubtotal
    extends AbstractSimpleExpression<BigDecimal> {
        private static final long serialVersionUID = 1L;

        private UnitPriceSubtotal() {
        }

        public BigDecimal evaluate(ReportParameters reportParameters) {
            Integer quantitySumValue = (Integer)reportParameters.getValue((DRIValue)CustomSubtotalReport.this.quantitySum);
            BigDecimal priceSumValue = (BigDecimal)reportParameters.getValue((DRIValue)CustomSubtotalReport.this.priceSum);
            return priceSumValue.divide(new BigDecimal(quantitySumValue), 2, 4);
        }
    }
}

