/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.style;

import cn.myapps.report.examples.Templates;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.ReportTemplateBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.style.StyleBuilder;
import net.sf.dynamicreports.report.constant.HorizontalTextAlignment;
import net.sf.dynamicreports.report.constant.VerticalTextAlignment;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class TemplateStyleReport {
    public TemplateStyleReport() {
        this.build();
    }

    public static void main(String[] args) {
        new TemplateStyleReport();
    }

    private void build() {
        StyleBuilder style1 = (StyleBuilder)DynamicReports.stl.style().setName("style1").bold();
        StyleBuilder style2 = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)style1).setName("style2").italic();
        StyleBuilder columnStyle = (StyleBuilder)DynamicReports.stl.style().setName("columnStyle").setVerticalTextAlignment(VerticalTextAlignment.MIDDLE);
        StyleBuilder columnTitleStyle = (StyleBuilder)((StyleBuilder)((StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)columnStyle).setName("columnTitleStyle").setBorder(DynamicReports.stl.pen1Point())).setHorizontalTextAlignment(HorizontalTextAlignment.CENTER)).setBackgroundColor(Color.LIGHT_GRAY);
        ReportTemplateBuilder template = DynamicReports.template().templateStyles(new StyleBuilder[]{style1, style2, columnStyle, columnTitleStyle});
        TextColumnBuilder itemColumn = (TextColumnBuilder)DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType()).setStyle((ReportStyleBuilder)DynamicReports.stl.templateStyle("style1"));
        TextColumnBuilder orderDateColumn = (TextColumnBuilder)DynamicReports.col.column("Order date", "orderdate", (DRIDataType)DynamicReports.type.dateType()).setStyle((ReportStyleBuilder)DynamicReports.stl.templateStyle("style2"));
        TextColumnBuilder quantityColumn = DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType());
        TextColumnBuilder unitPriceColumn = DynamicReports.col.column("Unit price", "unitprice", (DRIDataType)DynamicReports.type.bigDecimalType());
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(template)).setColumnStyle((ReportStyleBuilder)DynamicReports.stl.templateStyle("columnStyle"))).setColumnTitleStyle((ReportStyleBuilder)DynamicReports.stl.templateStyle("columnTitleStyle"))).columns(new ColumnBuilder[]{itemColumn, orderDateColumn, quantityColumn, unitPriceColumn})).title(new ComponentBuilder[]{Templates.createTitleComponent("TemplateStyle")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "orderdate", "quantity", "unitprice"});
        dataSource.add(new Object[]{"DVD", this.toDate(2010, 1, 1), 5, new BigDecimal(30)});
        dataSource.add(new Object[]{"DVD", this.toDate(2010, 1, 3), 1, new BigDecimal(28)});
        dataSource.add(new Object[]{"DVD", this.toDate(2010, 1, 19), 5, new BigDecimal(32)});
        dataSource.add(new Object[]{"Book", this.toDate(2010, 1, 5), 3, new BigDecimal(11)});
        dataSource.add(new Object[]{"Book", this.toDate(2010, 1, 11), 1, new BigDecimal(15)});
        dataSource.add(new Object[]{"Book", this.toDate(2010, 1, 15), 5, new BigDecimal(10)});
        dataSource.add(new Object[]{"Book", this.toDate(2010, 1, 20), 8, new BigDecimal(9)});
        return dataSource;
    }

    private Date toDate(int year, int month, int day) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month - 1);
        c.set(5, day);
        return c.getTime();
    }
}

