/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.style;

import cn.myapps.report.examples.Templates;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.style.ConditionalStyleBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.style.StyleBuilder;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.DRIValue;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class ConditionalStyleReport {
    public ConditionalStyleReport() {
        this.build();
    }

    public static void main(String[] args) {
        new ConditionalStyleReport();
    }

    private void build() {
        TextColumnBuilder itemColumn = DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder orderDateColumn = DynamicReports.col.column("Order date", "orderdate", (DRIDataType)DynamicReports.type.dateType());
        TextColumnBuilder quantityColumn = DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType());
        TextColumnBuilder unitPriceColumn = DynamicReports.col.column("Unit price", "unitprice", (DRIDataType)DynamicReports.type.bigDecimalType());
        ConditionalStyleBuilder condition1 = (ConditionalStyleBuilder)DynamicReports.stl.conditionalStyle((DRIExpression)new OrderDateConditionExpression()).setBackgroundColor(new Color(255, 210, 210));
        ConditionalStyleBuilder condition2 = (ConditionalStyleBuilder)DynamicReports.stl.conditionalStyle((DRIExpression)DynamicReports.cnd.greater((DRIValue)unitPriceColumn, (Number)20)).setBackgroundColor(new Color(210, 255, 210));
        StyleBuilder orderDateStyle = DynamicReports.stl.style().conditionalStyles(new ConditionalStyleBuilder[]{condition1});
        orderDateColumn.setStyle((ReportStyleBuilder)orderDateStyle);
        StyleBuilder unitPriceStyle = DynamicReports.stl.style().conditionalStyles(new ConditionalStyleBuilder[]{condition2});
        unitPriceColumn.setStyle((ReportStyleBuilder)unitPriceStyle);
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).columns(new ColumnBuilder[]{itemColumn, orderDateColumn, quantityColumn, unitPriceColumn})).title(new ComponentBuilder[]{Templates.createTitleComponent("ConditionalStyle")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "orderdate", "quantity", "unitprice"});
        dataSource.add(new Object[]{"DVD", this.toDate(2010, 1, 1), 5, new BigDecimal(30)});
        dataSource.add(new Object[]{"DVD", this.toDate(2010, 1, 3), 1, new BigDecimal(28)});
        dataSource.add(new Object[]{"DVD", this.toDate(2010, 1, 19), 5, new BigDecimal(32)});
        dataSource.add(new Object[]{"Book", this.toDate(2010, 1, 5), 3, new BigDecimal(11)});
        dataSource.add(new Object[]{"Book", this.toDate(2010, 1, 11), 1, new BigDecimal(15)});
        dataSource.add(new Object[]{"Book", this.toDate(2010, 1, 15), 5, new BigDecimal(10)});
        dataSource.add(new Object[]{"Book", this.toDate(2010, 1, 20), 8, new BigDecimal(9)});
        return dataSource;
    }

    private Date toDate(int year, int month, int day) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month - 1);
        c.set(5, day);
        return c.getTime();
    }

    private class OrderDateConditionExpression
    extends AbstractSimpleExpression<Boolean> {
        private static final long serialVersionUID = 1L;

        private OrderDateConditionExpression() {
        }

        public Boolean evaluate(ReportParameters reportParameters) {
            Date orderDate = (Date)reportParameters.getValue("orderdate");
            Integer quantity = (Integer)reportParameters.getValue("quantity");
            return orderDate.after(ConditionalStyleReport.this.toDate(2010, 1, 10)) && quantity > 1;
        }
    }
}

