/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.openflashchart;

import cn.myapps.report.examples.openflashchart.ChartGenerator;
import net.sf.jasperreports.engine.JRRuntimeException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PieChart
implements ChartGenerator {
    private String title;
    private String backgroundColor = "ffffff";
    private String[] valueColors = new String[]{"fadf12", "ed262a", "006f3c", "fa6112", "409dcf", "e5018c", "eaab35"};
    private JSONArray values = new JSONArray();

    @Override
    public String generateChart() {
        try {
            JSONObject chart = new JSONObject();
            if (this.backgroundColor != null) {
                chart.put("bg_colour", (Object)this.backgroundColor);
            }
            if (this.title != null) {
                chart.put("title", (Object)new JSONObject().put("text", (Object)this.title));
            }
            JSONObject pie = new JSONObject();
            pie.put("type", (Object)"pie");
            pie.put("animate", true);
            pie.put("tip", (Object)"#val# of #total#<br>#percent#");
            pie.put("start-angle", 35);
            pie.put("border", 2);
            pie.put("alpha", 0.6);
            if (this.valueColors != null) {
                JSONArray colors = new JSONArray();
                for (int i = 0; i < this.valueColors.length; ++i) {
                    colors.put((Object)this.valueColors[i]);
                }
                pie.put("colours", (Object)colors);
            }
            pie.put("values", (Object)this.values);
            JSONArray elements = new JSONArray();
            elements.put((Object)pie);
            chart.put("elements", (Object)elements);
            return chart.toString();
        }
        catch (JSONException e) {
            throw new JRRuntimeException((Throwable)e);
        }
    }

    public void addValue(String label, Number value) {
        JSONObject pieValue = new JSONObject();
        try {
            pieValue.put("value", (Object)value);
            pieValue.put("label", (Object)label);
        }
        catch (JSONException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        this.values.put((Object)pieValue);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setValueColors(String[] valueColors) {
        this.valueColors = valueColors;
    }
}

