/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.openflashchart;

import cn.myapps.report.examples.Templates;
import cn.myapps.report.examples.openflashchart.PieChart;
import java.math.BigDecimal;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperHtmlExporterBuilder;
import net.sf.dynamicreports.report.base.AbstractScriptlet;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.component.GenericElementBuilder;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.DRIScriptlet;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class OpenFlashChartReport {
    private PieChart pieChart1;
    private PieChart pieChart2;

    public OpenFlashChartReport() {
        this.build();
    }

    private void build() {
        this.pieChart1 = new PieChart();
        this.pieChart1.setTitle("Quantity");
        GenericElementBuilder chart1 = ((GenericElementBuilder)DynamicReports.cmp.genericElement("http://www.report.org/openflashchart", "openflashchart").setHeight(Integer.valueOf(200))).addParameter("CHARTGENERATOR", (Object)this.pieChart1);
        this.pieChart2 = new PieChart();
        this.pieChart2.setTitle("Unit price");
        GenericElementBuilder chart2 = ((GenericElementBuilder)DynamicReports.cmp.genericElement("http://www.report.org/openflashchart", "openflashchart").setHeight(Integer.valueOf(200))).addParameter("CHARTGENERATOR", (Object)this.pieChart2);
        try {
            JasperHtmlExporterBuilder htmlExporter = DynamicReports.export.htmlExporter("c:/report.html").setImagesDirName("c:/images").setOutputImagesToDir(Boolean.valueOf(true));
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).scriptlets(new DRIScriptlet[]{new ReportScriptlet()})).columns(new ColumnBuilder[]{DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType()), DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType()), DynamicReports.col.column("Unit price", "unitprice", (DRIDataType)DynamicReports.type.bigDecimalType())})).title(new ComponentBuilder[]{Templates.createTitleComponent("OpenFlashChart")})).summary(new ComponentBuilder[]{DynamicReports.cmp.horizontalList(new ComponentBuilder[]{chart1, chart2})})).setDataSource(this.createDataSource()).toHtml(htmlExporter);
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    protected JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "quantity", "unitprice"});
        dataSource.add(new Object[]{"Book", 60, new BigDecimal(150)});
        dataSource.add(new Object[]{"Camera", 40, new BigDecimal(400)});
        dataSource.add(new Object[]{"PDA", 50, new BigDecimal(250)});
        return dataSource;
    }

    public static void main(String[] args) {
        new OpenFlashChartReport();
    }

    private class ReportScriptlet
    extends AbstractScriptlet {
        private ReportScriptlet() {
        }

        public void afterDetailEval(ReportParameters reportParameters) {
            super.afterDetailEval(reportParameters);
            String item = (String)reportParameters.getValue("item");
            Integer quantity = (Integer)reportParameters.getValue("quantity");
            BigDecimal unitPrice = (BigDecimal)reportParameters.getValue("unitprice");
            OpenFlashChartReport.this.pieChart1.addValue(item, quantity);
            OpenFlashChartReport.this.pieChart2.addValue(item, unitPrice);
        }
    }
}

