/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.miscellaneous;

import cn.myapps.report.examples.Templates;
import java.math.BigDecimal;
import java.util.List;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.component.TextFieldBuilder;
import net.sf.dynamicreports.report.builder.expression.AbstractComplexExpression;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.constant.Calculation;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class ResourceBundleReport {
    public ResourceBundleReport() {
        this.build();
    }

    public static void main(String[] args) {
        new ResourceBundleReport();
    }

    private void build() {
        try {
            TextColumnBuilder itemColumn = (TextColumnBuilder)DynamicReports.col.column("item", (DRIDataType)DynamicReports.type.stringType()).setTitle((DRIExpression)DynamicReports.exp.message("item_title"));
            TextColumnBuilder quantityColumn = (TextColumnBuilder)DynamicReports.col.column("quantity", (DRIDataType)DynamicReports.type.integerType()).setTitle((DRIExpression)DynamicReports.exp.message("quantity_title"));
            TextColumnBuilder priceColumn = (TextColumnBuilder)DynamicReports.col.column("unitprice", (DRIDataType)DynamicReports.type.bigDecimalType()).setTitle((DRIExpression)DynamicReports.exp.message("unitprice_title"));
            TextFieldBuilder title = (TextFieldBuilder)DynamicReports.cmp.text((DRIExpression)DynamicReports.exp.message("report_title")).setStyle((ReportStyleBuilder)Templates.bold12CenteredStyle);
            TextFieldBuilder subtitle = (TextFieldBuilder)DynamicReports.cmp.text((DRIExpression)new SubtitleExpression()).setStyle((ReportStyleBuilder)Templates.bold12CenteredStyle);
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).setResourceBundle(ResourceBundleReport.class.getName())).columns(new ColumnBuilder[]{itemColumn, quantityColumn, priceColumn})).title(new ComponentBuilder[]{Templates.createTitleComponent("ResourceBundle"), title, subtitle})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "quantity", "unitprice"});
        for (int i = 0; i < 10; ++i) {
            dataSource.add(new Object[]{"Book", (int)(Math.random() * 10.0) + 1, new BigDecimal(Math.random() * 100.0 + 1.0)});
        }
        return dataSource;
    }

    public class SubtitleExpression
    extends AbstractComplexExpression<String> {
        private static final long serialVersionUID = 10000L;

        public SubtitleExpression() {
            this.addExpression(DynamicReports.variable((String)"quantity", Integer.class, (Calculation)Calculation.LOWEST));
            this.addExpression(DynamicReports.variable((String)"quantity", Integer.class, (Calculation)Calculation.HIGHEST));
        }

        public String evaluate(List<?> values, ReportParameters reportParameters) {
            return reportParameters.getMessage("report_subtitle", new Object[]{values.get(0), values.get(1)});
        }
    }
}

