/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.miscellaneous;

import cn.myapps.report.examples.Templates;
import java.math.BigDecimal;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.jasper.builder.export.Exporters;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.subtotal.SubtotalBuilder;
import net.sf.dynamicreports.report.constant.PageOrientation;
import net.sf.dynamicreports.report.constant.PageType;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class InheritanceReport {
    public InheritanceReport() {
        this.build();
    }

    public static void main(String[] args) {
        new InheritanceReport();
    }

    private void build() {
        try {
            DynamicReports.concatenatedReport().concatenate(new JasperReportBuilder[]{(InheritanceReport)this.new ReportA().report, (InheritanceReport)this.new ReportB().report}).toPdf(Exporters.pdfExporter((String)"c:/report.pdf"));
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "quantity", "unitprice"});
        for (int i = 0; i < 10; ++i) {
            dataSource.add(new Object[]{"Book", (int)(Math.random() * 10.0) + 1, new BigDecimal(Math.random() * 100.0 + 1.0)});
        }
        return dataSource;
    }

    private class ReportB
    extends ReportA {
        private ReportB() {
        }

        @Override
        protected void configure() {
            super.configure();
            TextColumnBuilder unitPriceColumn = DynamicReports.col.column("Unit price", "unitprice", (DRIDataType)DynamicReports.type.bigDecimalType());
            ((JasperReportBuilder)((JasperReportBuilder)this.report.setPageFormat(PageType.A5, PageOrientation.LANDSCAPE)).addColumn(new ColumnBuilder[]{unitPriceColumn})).subtotalsAtSummary(new SubtotalBuilder[]{DynamicReports.sbt.sum((ValueColumnBuilder)unitPriceColumn)});
        }

        @Override
        protected String getTitle() {
            return "Report B extends A";
        }
    }

    private class ReportA {
        protected JasperReportBuilder report = DynamicReports.report();

        private ReportA() {
            this.configure();
        }

        protected void configure() {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)this.report.setTemplate(Templates.reportTemplate)).setPageFormat(PageType.A5)).columns(new ColumnBuilder[]{DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType()), DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType())})).title(new ComponentBuilder[]{Templates.createTitleComponent(this.getTitle())})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(InheritanceReport.this.createDataSource());
        }

        protected String getTitle() {
            return "Report A";
        }
    }
}

